/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.migration.guardrails.ExamplesFactory;
import com.atlassian.jira.migration.guardrails.model.DailyUsageMetricsDto;
import com.atlassian.jira.migration.guardrails.repository.DailyUsageMetrics;
import com.atlassian.jira.migration.guardrails.repository.DailyUsageMetricsFileRecord;
import com.atlassian.jira.migration.guardrails.repository.DailyUsageMetricsRepository;
import com.atlassian.jira.migration.guardrails.repository.DailyUsageMetricsRepositoryKt;
import com.atlassian.jira.migration.guardrails.repository.InstAnalysisCtrl;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ%\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0018J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0006\u0010\u001c\u001a\u00020\u0018J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/guardrails/DailyUsageMetricsService;", "", "jiraHome", "Lcom/atlassian/jira/config/util/JiraHome;", "dailyUsageMetricsRepository", "Lcom/atlassian/jira/migration/guardrails/repository/DailyUsageMetricsRepository;", "examplesFactory", "Lcom/atlassian/jira/migration/guardrails/ExamplesFactory;", "(Lcom/atlassian/jira/config/util/JiraHome;Lcom/atlassian/jira/migration/guardrails/repository/DailyUsageMetricsRepository;Lcom/atlassian/jira/migration/guardrails/ExamplesFactory;)V", "findDailyUsageMetrics", "", "Lcom/atlassian/jira/migration/guardrails/model/DailyUsageMetricsDto;", "date", "Ljava/util/Date;", "instAnalysisCtrlId", "", "(Ljava/util/Date;I)[Lcom/atlassian/jira/migration/guardrails/model/DailyUsageMetricsDto;", "findDailyUsageMetricsForCSV", "", "Lcom/atlassian/jira/migration/guardrails/repository/DailyUsageMetricsFileRecord;", "findOrCreateUsageMetrics", "instAnalysisCtrl", "Lcom/atlassian/jira/migration/guardrails/repository/InstAnalysisCtrl;", "getDailyTrafficByHourFilePath", "", "Ljava/time/LocalDate;", "nodeId", "getExampleDailyUsageMetricsForCSV", "getUsageMetricsParentFolder", "recordDailyUsageMetrics", "Lcom/atlassian/jira/migration/guardrails/repository/DailyUsageMetrics;", "dailyUsageMetricsDto", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDailyUsageMetricsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DailyUsageMetricsService.kt\ncom/atlassian/jira/migration/guardrails/DailyUsageMetricsService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,96:1\n11065#2:97\n11400#2,3:98\n37#3,2:101\n*S KotlinDebug\n*F\n+ 1 DailyUsageMetricsService.kt\ncom/atlassian/jira/migration/guardrails/DailyUsageMetricsService\n*L\n46#1:97\n46#1:98,3\n56#1:101,2\n*E\n"})
public final class DailyUsageMetricsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraHome jiraHome;
    @NotNull
    private final DailyUsageMetricsRepository dailyUsageMetricsRepository;
    @NotNull
    private final ExamplesFactory examplesFactory;
    @NotNull
    private static final Logger log;

    @Inject
    public DailyUsageMetricsService(@NotNull JiraHome jiraHome, @NotNull DailyUsageMetricsRepository dailyUsageMetricsRepository, @NotNull ExamplesFactory examplesFactory) {
        Intrinsics.checkNotNullParameter((Object)jiraHome, (String)"jiraHome");
        Intrinsics.checkNotNullParameter((Object)dailyUsageMetricsRepository, (String)"dailyUsageMetricsRepository");
        Intrinsics.checkNotNullParameter((Object)examplesFactory, (String)"examplesFactory");
        this.jiraHome = jiraHome;
        this.dailyUsageMetricsRepository = dailyUsageMetricsRepository;
        this.examplesFactory = examplesFactory;
    }

    @Nullable
    public final DailyUsageMetrics recordDailyUsageMetrics(@NotNull DailyUsageMetricsDto dailyUsageMetricsDto) {
        Intrinsics.checkNotNullParameter((Object)dailyUsageMetricsDto, (String)"dailyUsageMetricsDto");
        return this.dailyUsageMetricsRepository.saveDailyUsageMetrics(dailyUsageMetricsDto);
    }

    @NotNull
    public final String getUsageMetricsParentFolder() {
        return this.jiraHome.getHomePath() + File.separator + "usage-metrics";
    }

    @NotNull
    public final String getDailyTrafficByHourFilePath(@NotNull LocalDate date, @NotNull String nodeId) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
        String formattedDate = date.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        return this.getUsageMetricsParentFolder() + File.separator + nodeId + File.separator + "daily-traffic-per-hour-" + formattedDate + ".csv";
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DailyUsageMetricsDto[] findDailyUsageMetrics(@NotNull Date date, int instAnalysisCtrlId) {
        DailyUsageMetricsDto[] dailyUsageMetricsDtoArray;
        DailyUsageMetrics[] usageMetrics;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (usageMetrics != null) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Object $this$map$iv = usageMetrics = this.dailyUsageMetricsRepository.findDailyUsageMetrics(date, instAnalysisCtrlId);
            boolean $i$f$map = false;
            DailyUsageMetrics[] dailyUsageMetricsArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((DailyUsageMetrics[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var12_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new DailyUsageMetricsDto(it.getID(), it.getInstAnalysisCtrl().getID(), it.getMetricsDate(), it.getDailyActiveUsers(), it.getPeakHourlyUsersByDay(), it.getPeakHourlyRequestsByDay(), it.getNodesProcessingJson()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            dailyUsageMetricsDtoArray = thisCollection$iv.toArray(new DailyUsageMetricsDto[0]);
        } else {
            dailyUsageMetricsDtoArray = null;
        }
        return dailyUsageMetricsDtoArray;
    }

    @NotNull
    public final List<DailyUsageMetricsFileRecord> findDailyUsageMetricsForCSV(int instAnalysisCtrlId) {
        return this.dailyUsageMetricsRepository.findDailyUsageMetricsForCSV(instAnalysisCtrlId);
    }

    @NotNull
    public final List<DailyUsageMetricsFileRecord> getExampleDailyUsageMetricsForCSV() {
        return this.examplesFactory.getExampleUsageMetrics();
    }

    @NotNull
    public final DailyUsageMetricsDto findOrCreateUsageMetrics(@NotNull Date date, @NotNull InstAnalysisCtrl instAnalysisCtrl) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)instAnalysisCtrl, (String)"instAnalysisCtrl");
        Object[] usageMetricsList = this.dailyUsageMetricsRepository.findDailyUsageMetrics(date, instAnalysisCtrl.getID());
        DailyUsageMetrics usageMetric = usageMetricsList != null ? (DailyUsageMetrics)ArraysKt.firstOrNull((Object[])usageMetricsList) : null;
        DailyUsageMetricsDto usageMetricDto = null;
        if (usageMetric == null) {
            usageMetricDto = new DailyUsageMetricsDto(null, instAnalysisCtrl.getID(), date, 0, 0, 0, "");
        } else {
            usageMetricDto = DailyUsageMetricsRepositoryKt.toDto(usageMetric);
            usageMetricDto.setDailyActiveUsers(0);
            usageMetricDto.setPeakHourlyUsersByDay(0);
            usageMetricDto.setPeakHourlyRequestsByDay(0);
        }
        return usageMetricDto;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(DailyUsageMetricsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/guardrails/DailyUsageMetricsService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

