/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.jira.migration.guardrails.AssessmentQueryList;
import com.atlassian.jira.migration.guardrails.ClusterNodeInfrastructureDto;
import com.atlassian.jira.migration.guardrails.DatabaseInfoDto;
import com.atlassian.jira.migration.guardrails.ExampleBrowserMetrics;
import com.atlassian.jira.migration.guardrails.InstanceInfrastructureDto;
import com.atlassian.jira.migration.guardrails.InstanceMetadataDto;
import com.atlassian.jira.migration.guardrails.ProductDto;
import com.atlassian.jira.migration.guardrails.model.ApiUsageDto;
import com.atlassian.jira.migration.guardrails.model.BrowserMetricsDto;
import com.atlassian.jira.migration.guardrails.model.DeviceDto;
import com.atlassian.jira.migration.guardrails.model.NetworkDto;
import com.atlassian.jira.migration.guardrails.queries.AssessmentQuery;
import com.atlassian.jira.migration.guardrails.queries.QueryProductType;
import com.atlassian.jira.migration.guardrails.repository.BrowserMetrics;
import com.atlassian.jira.migration.guardrails.repository.DailyUsageMetricsFileRecord;
import com.atlassian.jira.migration.guardrails.repository.NetworkInfoDto;
import com.atlassian.jira.migration.guardrails.repository.ResponseType;
import com.atlassian.jira.migration.guardrails.util.InstantExtensionsKt;
import com.atlassian.jira.migration.metadataaggregator.providers.JiraServerMetadataProvider;
import com.atlassian.migration.prc.client.util.MapperUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bJ@\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\r0\b\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u001e\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002H\r0\u0012J\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/guardrails/ExamplesFactory;", "", "jiraServerMetadataProvider", "Lcom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider;", "assessmentQueryList", "Lcom/atlassian/jira/migration/guardrails/AssessmentQueryList;", "(Lcom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider;Lcom/atlassian/jira/migration/guardrails/AssessmentQueryList;)V", "getExampleApiUsageMetrics", "", "Lcom/atlassian/jira/migration/guardrails/model/ApiUsageDto;", "getExampleBrowserMetrics", "Lcom/atlassian/jira/migration/guardrails/repository/BrowserMetrics;", "getExampleGuardrailsResponse", "T", "responseTypes", "", "Lcom/atlassian/jira/migration/guardrails/repository/ResponseType;", "output", "Lkotlin/Function3;", "", "Lcom/atlassian/jira/migration/guardrails/queries/QueryProductType;", "getExampleInstanceMetadata", "Lcom/atlassian/jira/migration/guardrails/InstanceMetadataDto;", "getExampleUsageMetrics", "Lcom/atlassian/jira/migration/guardrails/repository/DailyUsageMetricsFileRecord;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nExamplesFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExamplesFactory.kt\ncom/atlassian/jira/migration/guardrails/ExamplesFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,197:1\n766#2:198\n857#2,2:199\n215#3,2:201\n*S KotlinDebug\n*F\n+ 1 ExamplesFactory.kt\ncom/atlassian/jira/migration/guardrails/ExamplesFactory\n*L\n69#1:198\n69#1:199,2\n70#1:201,2\n*E\n"})
public final class ExamplesFactory {
    @NotNull
    private final JiraServerMetadataProvider jiraServerMetadataProvider;
    @NotNull
    private final AssessmentQueryList assessmentQueryList;

    @Inject
    public ExamplesFactory(@NotNull JiraServerMetadataProvider jiraServerMetadataProvider, @NotNull AssessmentQueryList assessmentQueryList) {
        Intrinsics.checkNotNullParameter((Object)jiraServerMetadataProvider, (String)"jiraServerMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)assessmentQueryList, (String)"assessmentQueryList");
        this.jiraServerMetadataProvider = jiraServerMetadataProvider;
        this.assessmentQueryList = assessmentQueryList;
    }

    @NotNull
    public final List<BrowserMetrics> getExampleBrowserMetrics() {
        Object[] objectArray = new BrowserMetricsDto[]{new BrowserMetricsDto("Chrome", "119.0.0.0", "MacIntel", new DeviceDto(6, 8), new NetworkDto("4g", 10.0, 100), "HTTP/1.1"), new BrowserMetricsDto("Edge", "123.0.0.0", "Win32", new DeviceDto(10, 8), new NetworkDto("3g", 10.0, 200), "HTTP/1.1"), new BrowserMetricsDto("Chrome", "118.0.0.0", "MacIntel", new DeviceDto(6, 8), new NetworkDto("4g", 10.0, 50), "HTTP/1.1"), new BrowserMetricsDto("Firefox", "120.0.0.0", "MacIntel", new DeviceDto(6, 8), new NetworkDto("4g", 10.0, 50), "HTTP/1.1"), new BrowserMetricsDto("Chrome", "119.0.0.0", "Linux", new DeviceDto(10, 8), new NetworkDto("3g", 10.0, 50), "HTTP/1.1"), new BrowserMetricsDto("Chrome", "118.0.0.0", "MacIntel", new DeviceDto(10, 8), new NetworkDto("4g", 10.0, 50), "HTTP/1.1"), new BrowserMetricsDto("Opera", "105.0.0.0", "Android", new DeviceDto(6, 8), new NetworkDto("4g", 10.0, 100), "HTTP/1.1")};
        List exampleBrowserMetrics = CollectionsKt.listOf((Object[])objectArray);
        long nowMillis = System.currentTimeMillis();
        List<BrowserMetrics> list = IntStream.range(0, exampleBrowserMetrics.size()).mapToObj(arg_0 -> ExamplesFactory.getExampleBrowserMetrics$lambda$0(nowMillis, exampleBrowserMetrics, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<T> getExampleGuardrailsResponse(@NotNull Set<? extends ResponseType> responseTypes, @NotNull Function3<? super String, ? super String, ? super QueryProductType, ? extends T> output) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(responseTypes, (String)"responseTypes");
        Intrinsics.checkNotNullParameter(output, (String)"output");
        List results2 = new ArrayList();
        Iterable $this$filter$iv = this.assessmentQueryList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AssessmentQuery it = (AssessmentQuery)element$iv$iv;
            boolean bl = false;
            if (!it.isQueryEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (AssessmentQuery query : (List)destination$iv$iv) {
            Map<String, String> $this$forEach$iv = query.getExample();
            boolean $i$f$forEach = false;
            for (Map.Entry<String, String> element$iv : $this$forEach$iv.entrySet()) {
                QueryProductType productType;
                Map.Entry<String, String> entry = element$iv;
                boolean bl = false;
                String queryId = (String)entry.getKey();
                String result2 = (String)entry.getValue();
                Intrinsics.checkNotNull((Object)((Object)query.getQueryIds().get(queryId)));
                ResponseType responseType = ResponseType.Companion.getByQueryResult(query, productType);
                if (!responseTypes.contains((Object)responseType)) continue;
                results2.add(output.invoke((Object)queryId, (Object)result2, (Object)productType));
            }
        }
        return results2;
    }

    @NotNull
    public final InstanceMetadataDto getExampleInstanceMetadata() {
        Object[] objectArray = new ProductDto[]{new ProductDto("Jira Core", "7.13.0", "SEN-500"), new ProductDto("Jira Software", "7.13.0", "SEN-500"), new ProductDto("Jira Servicedesk", "3.16.0", "SEN-500")};
        List list = CollectionsKt.listOf((Object[])objectArray);
        DatabaseInfoDto databaseInfoDto = new DatabaseInfoDto("PostgreSQL", "16.2", 4, 512L, 1024L);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        InstanceInfrastructureDto instanceInfrastructureDto = new InstanceInfrastructureDto(databaseInfoDto, 1, CollectionsKt.listOf((Object)new ClusterNodeInfrastructureDto(string, "system", 4, 768L, 2048L, 4096L, CollectionsKt.listOf((Object)new NetworkInfoDto("w0", 300L, 100L, 0.0, 1.0)))), "256m", "1024m");
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = TimeZone.getDefault().getID();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getID(...)");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        Intrinsics.checkNotNullExpressionValue((Object)zoneOffset, (String)"UTC");
        return new InstanceMetadataDto(list, instanceInfrastructureDto, "1.10.16", "AAAA-BBBB-CCCC-DDDD", string2, string3, InstantExtensionsKt.toAssessmentDateTimeFormat(instant, zoneOffset), this.jiraServerMetadataProvider.getServerBaseUrl());
    }

    @NotNull
    public final List<DailyUsageMetricsFileRecord> getExampleUsageMetrics() {
        String nodesProcessingJson = "{\"id\":\"mycluster1\",\"data_collection_status\":\"complete\",\"node_status\":\"available\"},{\"id\":\"mycluster2\",\"data_collection_status\":\"complete\",\"node_status\":\"available\"},{\"id\":\"mycluster3\",\"data_collection_status\":\"complete\",\"node_status\":\"available\"},{\"id\":\"mycluster4\",\"data_collection_status\":\"complete\",\"node_status\":\"available\"},{\"id\":\"mycluster5\",\"data_collection_status\":\"complete\",\"node_status\":\"available\"}]";
        Object[] objectArray = new DailyUsageMetricsFileRecord[3];
        String string = LocalDate.now().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = Instant.now().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        objectArray[0] = new DailyUsageMetricsFileRecord(string, 1000, 450, 100000, nodesProcessingJson, "AAAA-BBBB-CCCC-DDDD", string2);
        String string3 = LocalDate.now().minusDays(1L).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String string4 = Instant.now().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        objectArray[1] = new DailyUsageMetricsFileRecord(string3, 450, 350, 1231234, nodesProcessingJson, "AAAA-BBBB-CCCC-DDDD", string4);
        String string5 = LocalDate.now().minusDays(2L).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        String string6 = Instant.now().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
        objectArray[2] = new DailyUsageMetricsFileRecord(string5, 943, 632, 112137, nodesProcessingJson, "AAAA-BBBB-CCCC-DDDD", string6);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<ApiUsageDto> getExampleApiUsageMetrics() {
        Object[] objectArray = new ApiUsageDto[3];
        Date date = Date.from(LocalDate.now().atStartOfDay(ZoneOffset.UTC).toInstant());
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"from(...)");
        Object[] objectArray2 = new Long[]{11111L, 22222L};
        objectArray[0] = new ApiUsageDto(1, date, "559aead08264d5795d3909718cdd05abd49572e84fe55590eef31a88a08fdffd", "JQL_SEARCH", "GET", "DIRECT", "BROWSER", CollectionsKt.listOf((Object[])objectArray2), 10L);
        Date date2 = Date.from(LocalDate.now().minusDays(1L).atStartOfDay(ZoneOffset.UTC).toInstant());
        Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"from(...)");
        objectArray[1] = new ApiUsageDto(2, date2, "df7e70e5021544f4834bbee64a9e3789febc4be81470df629cad6ddb03320a5c", "SERVER_INFO", "POST", "INTERNAL", "ROBOT", CollectionsKt.emptyList(), 20L);
        Date date3 = Date.from(LocalDate.now().minusDays(2L).atStartOfDay(ZoneOffset.UTC).toInstant());
        Intrinsics.checkNotNullExpressionValue((Object)date3, (String)"from(...)");
        objectArray[2] = new ApiUsageDto(3, date3, "df7e70e5021544f4834bbee64a9e3789febc4be81470df629cad6ddb03320a5c", "PROJECT_DATA", "PATCH", "EXTERNAL", "EMPTY", CollectionsKt.listOf((Object)11111L), 30L);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final ExampleBrowserMetrics getExampleBrowserMetrics$lambda$0(long $nowMillis, List $exampleBrowserMetrics, int it) {
        Intrinsics.checkNotNullParameter((Object)$exampleBrowserMetrics, (String)"$exampleBrowserMetrics");
        long l = $nowMillis - (long)it * Duration.ofHours(1L).toMillis();
        String string = "user" + it;
        String string2 = MapperUtil.Companion.getMapper().writeValueAsString($exampleBrowserMetrics.get(it));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"writeValueAsString(...)");
        return new ExampleBrowserMetrics(l, string, string2);
    }
}

