/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.jira.migration.guardrails.ClusterNodeInfrastructureDto;
import com.atlassian.jira.migration.guardrails.DatabaseInfoDto;
import com.atlassian.jira.migration.guardrails.InfrastructureNodeSpecificDataService;
import com.atlassian.jira.migration.guardrails.InstanceInfrastructureDto;
import com.atlassian.jira.migration.guardrails.repository.ClusterNodeInfrastructure;
import com.atlassian.jira.migration.serverdataextractors.JiraServerStatsReader;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.schema.DialectProvider;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J4\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010 \u001a\u00020!H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/guardrails/InfrastructureDataService;", "", "jiraServerStatsReader", "Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "infrastructureNodeSpecificDataService", "Lcom/atlassian/jira/migration/guardrails/InfrastructureNodeSpecificDataService;", "(Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/guardrails/InfrastructureNodeSpecificDataService;)V", "runtimeMxBean", "Ljava/lang/management/RuntimeMXBean;", "xms", "", "xmx", "collectData", "Lcom/atlassian/jira/migration/guardrails/InstanceInfrastructureDto;", "fetchQueryResult", "", "db", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseConnection;", "sql", "div", "getDbInfo", "Lcom/atlassian/jira/migration/guardrails/DatabaseInfoDto;", "getDbInfoUsingQueries", "cpuQuery", "ramQuery", "storageQuery", "getMysqlServerInfo", "getOracleInfo", "getPostgresServerInfo", "getSqlServerInfo", "postConstruct", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nInfrastructureDataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InfrastructureDataService.kt\ncom/atlassian/jira/migration/guardrails/InfrastructureDataService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,175:1\n11065#2:176\n11400#2,3:177\n*S KotlinDebug\n*F\n+ 1 InfrastructureDataService.kt\ncom/atlassian/jira/migration/guardrails/InfrastructureDataService\n*L\n46#1:176\n46#1:177,3\n*E\n"})
public final class InfrastructureDataService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraServerStatsReader jiraServerStatsReader;
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final InfrastructureNodeSpecificDataService infrastructureNodeSpecificDataService;
    @NotNull
    private final RuntimeMXBean runtimeMxBean;
    @NotNull
    private String xms;
    @NotNull
    private String xmx;
    private static final Logger logger = LoggerFactory.getLogger(InfrastructureDataService.class);
    public static final int START_INDEX_ARG_VALUE = 4;
    public static final long MB = 0x100000L;
    public static final long UNKNOWN = -1L;

    @Inject
    public InfrastructureDataService(@NotNull JiraServerStatsReader jiraServerStatsReader, @NotNull DatabaseAccessor databaseAccessor, @NotNull InfrastructureNodeSpecificDataService infrastructureNodeSpecificDataService) {
        Intrinsics.checkNotNullParameter((Object)jiraServerStatsReader, (String)"jiraServerStatsReader");
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)infrastructureNodeSpecificDataService, (String)"infrastructureNodeSpecificDataService");
        this.jiraServerStatsReader = jiraServerStatsReader;
        this.databaseAccessor = databaseAccessor;
        this.infrastructureNodeSpecificDataService = infrastructureNodeSpecificDataService;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)runtimeMXBean, (String)"getRuntimeMXBean(...)");
        this.runtimeMxBean = runtimeMXBean;
        this.xms = "Not Available";
        this.xmx = "Not Available";
    }

    @PostConstruct
    public final void postConstruct() {
        List<String> arguments = this.runtimeMxBean.getInputArguments();
        for (String arg : arguments) {
            Intrinsics.checkNotNull((Object)arg);
            if (StringsKt.startsWith$default((String)arg, (String)"-Xms", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNullExpressionValue((Object)arg.substring(4), (String)"substring(...)");
                this.xms = this.xms;
            }
            if (!StringsKt.startsWith$default((String)arg, (String)"-Xmx", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)arg.substring(4), (String)"substring(...)");
            this.xmx = this.xmx;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final InstanceInfrastructureDto collectData() {
        void $this$mapTo$iv$iv;
        ClusterNodeInfrastructure[] nodesInfo;
        ClusterNodeInfrastructure[] $this$map$iv = nodesInfo = this.infrastructureNodeSpecificDataService.cleanupAndFetchAllNodesInfrastructure();
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ClusterNodeInfrastructureDto(it.getNodeId(), it.getOperatingSystem(), it.getCpuCount(), it.getRamMb(), it.getStorageUsedMb(), it.getStorageAvailableMb(), this.infrastructureNodeSpecificDataService.findAllNetworkInterfaces(it.getNodeId())));
        }
        List nodesInfoDto = (List)destination$iv$iv;
        DatabaseInfoDto databaseInfoDto = this.getDbInfo();
        int n2 = this.jiraServerStatsReader.getNumberOfClusterNodes();
        object = this.xmx;
        String string = this.xms;
        return new InstanceInfrastructureDto(databaseInfoDto, n2, nodesInfoDto, string, (String)object);
    }

    private final DatabaseInfoDto getDbInfo() {
        Object object = this.databaseAccessor.run(this::getDbInfo, OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (DatabaseInfoDto)object;
    }

    private final DatabaseInfoDto getDbInfo(DatabaseConnection db) {
        DatabaseInfoDto databaseInfoDto;
        DialectProvider.SupportedDatabase supportedDatabase = db.getDialectConfig().getDatabaseInfo().getSupportedDatabase();
        switch (supportedDatabase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[supportedDatabase.ordinal()]) {
            case 1: {
                databaseInfoDto = this.getOracleInfo(db);
                break;
            }
            case 2: {
                databaseInfoDto = this.getSqlServerInfo(db);
                break;
            }
            case 3: {
                databaseInfoDto = this.getPostgresServerInfo(db);
                break;
            }
            case 4: {
                databaseInfoDto = this.getMysqlServerInfo(db);
                break;
            }
            default: {
                databaseInfoDto = InfrastructureDataService.getDbInfoUsingQueries$default(this, db, null, null, null, 14, null);
            }
        }
        return databaseInfoDto;
    }

    private final DatabaseInfoDto getOracleInfo(DatabaseConnection db) {
        return InfrastructureDataService.getDbInfoUsingQueries$default(this, db, "select value from v$osstat where stat_name like 'NUM_CPUS'", null, "select sum(bytes) from user_segments", 4, null);
    }

    private final DatabaseInfoDto getSqlServerInfo(DatabaseConnection db) {
        return this.getDbInfoUsingQueries(db, "select cpu_count from sys.dm_os_sys_info", "select total_physical_memory_kb * 1024 from sys.dm_os_sys_memory", "select sum(size) * 8 * 1024 from sys.master_files where database_id = DB_ID()");
    }

    private final DatabaseInfoDto getPostgresServerInfo(DatabaseConnection db) {
        return InfrastructureDataService.getDbInfoUsingQueries$default(this, db, null, null, "select pg_database_size(current_database())", 6, null);
    }

    private final DatabaseInfoDto getMysqlServerInfo(DatabaseConnection db) {
        return InfrastructureDataService.getDbInfoUsingQueries$default(this, db, null, null, "select sum(data_length+index_length) from information_schema.tables where table_schema = database()", 6, null);
    }

    private final DatabaseInfoDto getDbInfoUsingQueries(DatabaseConnection db, String cpuQuery, String ramQuery, String storageQuery) {
        return new DatabaseInfoDto(this.jiraServerStatsReader.databaseProductName(), this.jiraServerStatsReader.databaseProductVersion(), (int)InfrastructureDataService.fetchQueryResult$default(this, db, cpuQuery, 0L, 4, null), this.fetchQueryResult(db, ramQuery, 0x100000L), this.fetchQueryResult(db, storageQuery, 0x100000L));
    }

    static /* synthetic */ DatabaseInfoDto getDbInfoUsingQueries$default(InfrastructureDataService infrastructureDataService, DatabaseConnection databaseConnection, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        return infrastructureDataService.getDbInfoUsingQueries(databaseConnection, string, string2, string3);
    }

    private final long fetchQueryResult(DatabaseConnection db, String sql, long div) {
        try {
            if (sql == null) {
                return -1L;
            }
            ResultSet query = db.getJdbcConnection().createStatement().executeQuery(sql);
            return query.next() ? MathKt.roundToLong((double)((double)query.getLong(1) / (double)div)) : -1L;
        }
        catch (SQLException e) {
            logger.info("Failed running query: " + sql, (Throwable)e);
            return -1L;
        }
    }

    static /* synthetic */ long fetchQueryResult$default(InfrastructureDataService infrastructureDataService, DatabaseConnection databaseConnection, String string, long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = 1L;
        }
        return infrastructureDataService.fetchQueryResult(databaseConnection, string, l);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/guardrails/InfrastructureDataService$Companion;", "", "()V", "MB", "", "START_INDEX_ARG_VALUE", "", "UNKNOWN", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DialectProvider.SupportedDatabase.values().length];
            try {
                nArray[DialectProvider.SupportedDatabase.ORACLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DialectProvider.SupportedDatabase.SQLSERVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DialectProvider.SupportedDatabase.POSTGRESSQL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DialectProvider.SupportedDatabase.MYSQL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

