/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.migration.guardrails.InfrastructureNodeSpecificDataService;
import com.atlassian.jira.migration.guardrails.InstanceAnalysisControlService;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentServiceKt;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/guardrails/InfrastructureMetricsJobRunner;", "Lcom/atlassian/scheduler/JobRunner;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "infrastructureNodeSpecificDataService", "Lcom/atlassian/jira/migration/guardrails/InfrastructureNodeSpecificDataService;", "instanceAnalysisControlService", "Lcom/atlassian/jira/migration/guardrails/InstanceAnalysisControlService;", "(Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/cluster/ClusterManager;Lcom/atlassian/jira/migration/guardrails/InfrastructureNodeSpecificDataService;Lcom/atlassian/jira/migration/guardrails/InstanceAnalysisControlService;)V", "getNodeId", "", "postConstruct", "", "preDestroy", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "request", "Lcom/atlassian/scheduler/JobRunnerRequest;", "Companion", "jira-migration-plugin"})
public final class InfrastructureMetricsJobRunner
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final ClusterManager clusterManager;
    @NotNull
    private final InfrastructureNodeSpecificDataService infrastructureNodeSpecificDataService;
    @NotNull
    private final InstanceAnalysisControlService instanceAnalysisControlService;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final JobRunnerKey JOB_RUNNER_KEY;
    @NotNull
    private static final JobId JOB_ID;
    public static final int BYTES_IN_MB = 0x100000;
    public static final int BITS_IN_MEGABITS = 1000000;

    @Inject
    public InfrastructureMetricsJobRunner(@NotNull SchedulerService schedulerService, @NotNull ClusterManager clusterManager, @NotNull InfrastructureNodeSpecificDataService infrastructureNodeSpecificDataService, @NotNull InstanceAnalysisControlService instanceAnalysisControlService) {
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        Intrinsics.checkNotNullParameter((Object)infrastructureNodeSpecificDataService, (String)"infrastructureNodeSpecificDataService");
        Intrinsics.checkNotNullParameter((Object)instanceAnalysisControlService, (String)"instanceAnalysisControlService");
        this.schedulerService = schedulerService;
        this.clusterManager = clusterManager;
        this.infrastructureNodeSpecificDataService = infrastructureNodeSpecificDataService;
        this.instanceAnalysisControlService = instanceAnalysisControlService;
    }

    @PostConstruct
    public final void postConstruct() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(this.instanceAnalysisControlService.lowTrafficOnlySchedule()));
    }

    @PreDestroy
    public final void preDestroy() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            if (this.instanceAnalysisControlService.hasActiveAssessment()) {
                log.info("Running job {} on node {}", (Object)request.getJobId(), (Object)this.getNodeId());
                this.infrastructureNodeSpecificDataService.recordNodeData(this.getNodeId());
            } else {
                log.info("Skipping job {} on node {} because assessment collection is not active", (Object)request.getJobId(), (Object)this.getNodeId());
            }
            return JobRunnerResponse.success();
        }
        catch (UnsupportedOperationException e) {
            log.error("Data collection not supported on system", (Throwable)e);
        }
        catch (SecurityException e) {
            log.error("No permissions to cluster node", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Error occurred while collecting infrastructure data", (Throwable)e);
        }
        return JobRunnerResponse.failed((String)"Error occurred while collecting infrastructure data");
    }

    private final String getNodeId() {
        return InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(InfrastructureMetricsJobRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"jira-migration-jira-infrastructure-metrics-job-key");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        JOB_RUNNER_KEY = jobRunnerKey;
        JobId jobId = JobId.of((String)"jira-migration-jira-infrastructure-metrics-job-id");
        Intrinsics.checkNotNull((Object)jobId);
        JOB_ID = jobId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/guardrails/InfrastructureMetricsJobRunner$Companion;", "", "()V", "BITS_IN_MEGABITS", "", "BYTES_IN_MB", "JOB_ID", "Lcom/atlassian/scheduler/config/JobId;", "getJOB_ID", "()Lcom/atlassian/scheduler/config/JobId;", "JOB_RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getJOB_RUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final JobRunnerKey getJOB_RUNNER_KEY() {
            return JOB_RUNNER_KEY;
        }

        @NotNull
        public final JobId getJOB_ID() {
            return JOB_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

