/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.migration.guardrails.ClusterNodeInfrastructureDto;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentServiceKt;
import com.atlassian.jira.migration.guardrails.repository.ClusterNodeInfrastructure;
import com.atlassian.jira.migration.guardrails.repository.ClusterNodeInfrastructureRepository;
import com.atlassian.jira.migration.guardrails.repository.ClusterNodeInfrastructureRepositoryKt;
import com.atlassian.jira.migration.guardrails.repository.ClusterNodeNetwork;
import com.atlassian.jira.migration.guardrails.repository.NetworkInfoDto;
import java.io.File;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000eJ\u0011\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/guardrails/InfrastructureNodeSpecificDataService;", "", "clusterNodeInfrastructureRepository", "Lcom/atlassian/jira/migration/guardrails/repository/ClusterNodeInfrastructureRepository;", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "jiraHome", "Lcom/atlassian/jira/config/util/JiraHome;", "(Lcom/atlassian/jira/migration/guardrails/repository/ClusterNodeInfrastructureRepository;Lcom/atlassian/jira/cluster/ClusterManager;Lcom/atlassian/jira/config/util/JiraHome;)V", "calculatePacketsErrorRate", "", "errors", "", "packets", "calculatePacketsErrorRate$jira_migration_plugin", "cleanupAndFetchAllNodesInfrastructure", "", "Lcom/atlassian/jira/migration/guardrails/repository/ClusterNodeInfrastructure;", "()[Lcom/atlassian/jira/migration/guardrails/repository/ClusterNodeInfrastructure;", "findAllNetworkInterfaces", "", "Lcom/atlassian/jira/migration/guardrails/repository/NetworkInfoDto;", "nodeId", "", "recordNodeData", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nInfrastructureNodeSpecificDataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InfrastructureNodeSpecificDataService.kt\ncom/atlassian/jira/migration/guardrails/InfrastructureNodeSpecificDataService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,77:1\n1549#2:78\n1620#2,3:79\n1549#2:82\n1620#2,3:83\n1855#2,2:100\n1549#2:104\n1620#2,3:105\n10513#3:86\n10738#3,3:87\n10741#3,3:97\n372#4,7:90\n37#5,2:102\n*S KotlinDebug\n*F\n+ 1 InfrastructureNodeSpecificDataService.kt\ncom/atlassian/jira/migration/guardrails/InfrastructureNodeSpecificDataService\n*L\n26#1:78\n26#1:79,3\n58#1:82\n58#1:83,3\n63#1:100,2\n69#1:104\n69#1:105,3\n60#1:86\n60#1:87,3\n60#1:97,3\n60#1:90,7\n64#1:102,2\n*E\n"})
public final class InfrastructureNodeSpecificDataService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClusterNodeInfrastructureRepository clusterNodeInfrastructureRepository;
    @NotNull
    private final ClusterManager clusterManager;
    @NotNull
    private final JiraHome jiraHome;
    @NotNull
    private static final Duration INACTIVITY_PERIOD;

    @Inject
    public InfrastructureNodeSpecificDataService(@NotNull ClusterNodeInfrastructureRepository clusterNodeInfrastructureRepository, @NotNull ClusterManager clusterManager, @NotNull JiraHome jiraHome) {
        Intrinsics.checkNotNullParameter((Object)clusterNodeInfrastructureRepository, (String)"clusterNodeInfrastructureRepository");
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        Intrinsics.checkNotNullParameter((Object)jiraHome, (String)"jiraHome");
        this.clusterNodeInfrastructureRepository = clusterNodeInfrastructureRepository;
        this.clusterManager = clusterManager;
        this.jiraHome = jiraHome;
    }

    /*
     * WARNING - void declaration
     */
    public final void recordNodeData(@NotNull String nodeId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
        HardwareAbstractionLayer hardware = new SystemInfo().getHardware();
        List list = hardware.getNetworkIFs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNetworkIFs(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NetworkIF networkIF = (NetworkIF)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            it.updateAttributes();
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            collection.add(new NetworkInfoDto(string, it.getMTU(), it.getSpeed() / (long)1000000, this.calculatePacketsErrorRate$jira_migration_plugin(it.getInErrors(), it.getPacketsRecv()), this.calculatePacketsErrorRate$jira_migration_plugin(it.getOutErrors(), it.getPacketsSent())));
        }
        List networkIfs = (List)destination$iv$iv;
        String string = new SystemInfo().getOperatingSystem().toString();
        long l = hardware.getMemory().getTotal() / (long)0x100000;
        long l2 = FileUtils.sizeOfDirectory((File)this.jiraHome.getHome()) / (long)0x100000;
        long l3 = this.jiraHome.getHome().getFreeSpace() / (long)0x100000;
        int n = hardware.getProcessor().getPhysicalProcessorCount();
        ClusterNodeInfrastructureDto nodeInfrastructure = new ClusterNodeInfrastructureDto(nodeId, string, n, l, l2, l3, networkIfs);
        this.clusterNodeInfrastructureRepository.saveClusterNodeInfrastructureItem(nodeInfrastructure);
    }

    public final double calculatePacketsErrorRate$jira_migration_plugin(long errors, long packets) {
        long total = packets + errors;
        return total > 0L ? (double)errors / (double)total * (double)100 : 0.0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClusterNodeInfrastructure[] cleanupAndFetchAllNodesInfrastructure() {
        ClusterNodeInfrastructure[] clusterNodeInfrastructureArray;
        block13: {
            block12: {
                ClusterNodeInfrastructureRepository $this$groupByTo$iv$iv;
                List list;
                Object destination$iv$iv;
                Timestamp minTimestamp = Timestamp.from(Instant.now().minus(INACTIVITY_PERIOD));
                if (this.clusterManager.isClustered()) {
                    void $this$mapTo$iv$iv;
                    Set set = this.clusterManager.getAllNodes();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllNodes(...)");
                    Iterable $this$map$iv = set;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Node node = (Node)item$iv$iv;
                        Object object = destination$iv$iv;
                        boolean bl = false;
                        object.add(it.getNodeId());
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.listOf((Object)InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager));
                }
                List allClusterNodes = list;
                ClusterNodeInfrastructure[] $this$groupBy$iv = this.clusterNodeInfrastructureRepository.findAll();
                boolean $i$f$groupBy2 = false;
                destination$iv$iv = $this$groupBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                int it = ((void)$this$groupByTo$iv$iv).length;
                for (int item$iv$iv = 0; item$iv$iv < it; ++item$iv$iv) {
                    Object object;
                    void element$iv$iv;
                    void it2 = element$iv$iv = $this$groupByTo$iv$iv[item$iv$iv];
                    boolean bl = false;
                    Boolean key$iv$iv = it2.getLastUpdated().compareTo(minTimestamp) > 0 && allClusterNodes.contains(it2.getNodeId());
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Map nodesByIsValid = destination$iv$iv2;
                List list2 = (List)nodesByIsValid.get(false);
                if (list2 != null) {
                    void $this$forEach$iv;
                    Iterable $i$f$groupBy2 = list2;
                    $this$groupByTo$iv$iv = this.clusterNodeInfrastructureRepository;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ClusterNodeInfrastructure p0 = (ClusterNodeInfrastructure)element$iv;
                        boolean bl = false;
                        $this$groupByTo$iv$iv.delete(p0);
                    }
                }
                if ((clusterNodeInfrastructureArray = (ClusterNodeInfrastructure[])nodesByIsValid.get(true)) == null) break block12;
                Collection $this$toTypedArray$iv = (Collection)clusterNodeInfrastructureArray;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                clusterNodeInfrastructureArray = thisCollection$iv.toArray(new ClusterNodeInfrastructure[0]);
                if (clusterNodeInfrastructureArray != null) break block13;
            }
            clusterNodeInfrastructureArray = new ClusterNodeInfrastructure[]{};
        }
        return clusterNodeInfrastructureArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<NetworkInfoDto> findAllNetworkInterfaces(@NotNull String nodeId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
        Iterable $this$map$iv = this.clusterNodeInfrastructureRepository.findAllNetworkInterfaces(nodeId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClusterNodeNetwork clusterNodeNetwork = (ClusterNodeNetwork)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ClusterNodeInfrastructureRepositoryKt.toDto((ClusterNodeNetwork)it));
        }
        return (List)destination$iv$iv;
    }

    static {
        Duration duration = Duration.ofDays(1L).plusHours(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"plusHours(...)");
        INACTIVITY_PERIOD = duration;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/guardrails/InfrastructureNodeSpecificDataService$Companion;", "", "()V", "INACTIVITY_PERIOD", "Ljava/time/Duration;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

