/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.guardrails.AccessLogProcessingControlService;
import com.atlassian.jira.migration.guardrails.AccessLogProcessingItemService;
import com.atlassian.jira.migration.guardrails.InstanceAnalysisControlServiceKt;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentConfig;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentService;
import com.atlassian.jira.migration.guardrails.UsageMetricsPersistenceJobRunner;
import com.atlassian.jira.migration.guardrails.cancel.AssessmentCanceledChecker;
import com.atlassian.jira.migration.guardrails.event.AssessmentCompletionEvent;
import com.atlassian.jira.migration.guardrails.exceptions.AssessmentCanceledException;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingControl;
import com.atlassian.jira.migration.guardrails.repository.InstAnalysisCtrl;
import com.atlassian.jira.migration.guardrails.repository.InstanceAnalysisControlRepository;
import com.atlassian.jira.migration.guardrails.repository.InstanceAnalysisControlRepositoryKt;
import com.atlassian.jira.migration.guardrails.repository.InstanceAssessmentCompletionStatus;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 =2\u00020\u0001:\u0001=BO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0002J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\"\u001a\u00020#J\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020-J\b\u0010/\u001a\u00020\u001fH\u0007J\b\u00100\u001a\u00020\u001fH\u0007J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020-2\u0006\u00106\u001a\u00020#H\u0002J \u00107\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020#J\u001a\u0010:\u001a\u00020\u001f2\b\b\u0002\u00108\u001a\u00020)2\b\b\u0002\u0010;\u001a\u00020<R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/atlassian/jira/migration/guardrails/InstanceAnalysisControlService;", "Lcom/atlassian/scheduler/JobRunner;", "instanceAnalysisControlRepository", "Lcom/atlassian/jira/migration/guardrails/repository/InstanceAnalysisControlRepository;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "features", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "usageMetricsPersistenceJobRunner", "Lcom/atlassian/jira/migration/guardrails/UsageMetricsPersistenceJobRunner;", "accessLogProcessingControlService", "Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingControlService;", "accessLogProcessingItemService", "Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingItemService;", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/guardrails/repository/InstanceAnalysisControlRepository;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/guardrails/UsageMetricsPersistenceJobRunner;Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingControlService;Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingItemService;Lcom/atlassian/jira/cluster/ClusterManager;Lcom/atlassian/event/api/EventPublisher;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "assessmentDuration", "Ljava/time/Duration;", "calculateRemainingDuration", "instanceAnalysisControl", "Lcom/atlassian/jira/migration/guardrails/repository/InstAnalysisCtrl;", "createAccessLogProcessingItemForAllNodes", "", "instAnalysisCtrl", "createInstanceAnalysisControl", "analysisType", "", "findInstanceAnalysisControl", "finishAssessmentCollection", "status", "Lcom/atlassian/jira/migration/guardrails/repository/InstanceAssessmentCompletionStatus;", "hasActiveAssessment", "", "isCanceledChecker", "Lcom/atlassian/jira/migration/guardrails/cancel/AssessmentCanceledChecker;", "lowTrafficOnlyHourlySchedule", "Lcom/atlassian/scheduler/config/Schedule;", "lowTrafficOnlySchedule", "postConstruct", "preDestroy", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "request", "Lcom/atlassian/scheduler/JobRunnerRequest;", "schedule", "cron", "scheduleAssessmentControlJob", "cloudTriggered", "configJson", "startAssessmentCollection", "config", "Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentConfig;", "Companion", "jira-migration-plugin"})
public final class InstanceAnalysisControlService
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InstanceAnalysisControlRepository instanceAnalysisControlRepository;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final MigrationFeatures features;
    @NotNull
    private final UsageMetricsPersistenceJobRunner usageMetricsPersistenceJobRunner;
    @NotNull
    private final AccessLogProcessingControlService accessLogProcessingControlService;
    @NotNull
    private final AccessLogProcessingItemService accessLogProcessingItemService;
    @NotNull
    private final ClusterManager clusterManager;
    @NotNull
    private final EventPublisher eventPublisher;
    @NotNull
    private final ObjectMapperFactory objectMapperFactory;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private static final String EVERY_DAY_1AM = "0 0 1 ? * * *";
    @NotNull
    private static final String HOURLY_AT_NIGHT = "0 0 21,22,23,0,1,2,3,4 ? * * *";
    @NotNull
    private static final Logger log;
    @NotNull
    private static final JobRunnerKey RUNNER_KEY;
    @NotNull
    private static final JobId JOB_ID;

    @Inject
    public InstanceAnalysisControlService(@NotNull InstanceAnalysisControlRepository instanceAnalysisControlRepository, @NotNull SchedulerService schedulerService, @NotNull MigrationFeatures features, @NotNull UsageMetricsPersistenceJobRunner usageMetricsPersistenceJobRunner, @NotNull AccessLogProcessingControlService accessLogProcessingControlService, @NotNull AccessLogProcessingItemService accessLogProcessingItemService, @NotNull ClusterManager clusterManager, @NotNull EventPublisher eventPublisher, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)instanceAnalysisControlRepository, (String)"instanceAnalysisControlRepository");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)features, (String)"features");
        Intrinsics.checkNotNullParameter((Object)usageMetricsPersistenceJobRunner, (String)"usageMetricsPersistenceJobRunner");
        Intrinsics.checkNotNullParameter((Object)accessLogProcessingControlService, (String)"accessLogProcessingControlService");
        Intrinsics.checkNotNullParameter((Object)accessLogProcessingItemService, (String)"accessLogProcessingItemService");
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.instanceAnalysisControlRepository = instanceAnalysisControlRepository;
        this.schedulerService = schedulerService;
        this.features = features;
        this.usageMetricsPersistenceJobRunner = usageMetricsPersistenceJobRunner;
        this.accessLogProcessingControlService = accessLogProcessingControlService;
        this.accessLogProcessingItemService = accessLogProcessingItemService;
        this.clusterManager = clusterManager;
        this.eventPublisher = eventPublisher;
        this.objectMapperFactory = objectMapperFactory;
        this.objectMapper = this.objectMapperFactory.createObjectMapper();
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @PostConstruct
    public final void postConstruct() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
    }

    @PreDestroy
    public final void preDestroy() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
        log.info("Instance analysis control job unregistered successfully.");
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        JobRunnerResponse jobRunnerResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            InstAnalysisCtrl instAnalysisCtrl = this.instanceAnalysisControlRepository.findInstanceAnalysisControl("BROWSER_METRICS");
            if (instAnalysisCtrl != null && !InstanceAnalysisControlRepositoryKt.isFinished(instAnalysisCtrl)) {
                log.info("Updating end time on instance analysis control");
                Duration remainingDuration = this.calculateRemainingDuration(instAnalysisCtrl);
                if (!this.features.getCollectL1Metrics() || remainingDuration.isZero() || remainingDuration.isNegative()) {
                    this.finishAssessmentCollection(InstanceAssessmentCompletionStatus.COMPLETE);
                }
            }
            jobRunnerResponse = JobRunnerResponse.success((String)request.getJobId().toString());
        }
        catch (Throwable e) {
            log.error("Failed to run instance analysis control with job id " + request.getJobId() + ": " + e.getMessage(), e);
            jobRunnerResponse = JobRunnerResponse.failed((Throwable)e);
        }
        return jobRunnerResponse;
    }

    public final void startAssessmentCollection(boolean cloudTriggered, @NotNull InstanceAssessmentConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Duration assessmentDuration = this.assessmentDuration();
        String configJson = this.objectMapper.writeValueAsString((Object)config2);
        if (config2.getCollectBrowserMetrics()) {
            log.info("Initializing browser metrics collection");
            this.createInstanceAnalysisControl("BROWSER_METRICS");
            Intrinsics.checkNotNull((Object)configJson);
            this.scheduleAssessmentControlJob(assessmentDuration, cloudTriggered, configJson);
            log.info("Browser metrics collection started");
        }
        if (config2.getCollectUsageMetrics()) {
            log.info("Initializing usage metrics collection");
            InstAnalysisCtrl instAnalysisCtrl = this.createInstanceAnalysisControl("USAGE_METRICS");
            this.createAccessLogProcessingItemForAllNodes(instAnalysisCtrl);
            this.usageMetricsPersistenceJobRunner.schedule(assessmentDuration, MapsKt.mapOf((Pair)TuplesKt.to((Object)"CONFIG_JSON", (Object)configJson)));
            log.info("Usage metrics collection started");
        }
    }

    public static /* synthetic */ void startAssessmentCollection$default(InstanceAnalysisControlService instanceAnalysisControlService, boolean bl, InstanceAssessmentConfig instanceAssessmentConfig, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            instanceAssessmentConfig = new InstanceAssessmentConfig(false, false, 3, null);
        }
        instanceAnalysisControlService.startAssessmentCollection(bl, instanceAssessmentConfig);
    }

    private final void createAccessLogProcessingItemForAllNodes(InstAnalysisCtrl instAnalysisCtrl) {
        if (this.clusterManager.isClustered()) {
            for (Node node : this.clusterManager.getAllNodes()) {
                String string = node.getNodeId();
                Intrinsics.checkNotNull((Object)string);
                AccessLogProcessingControl control = this.accessLogProcessingControlService.recordAccessLogProcessingControlForNode(instAnalysisCtrl, string);
                this.accessLogProcessingItemService.recordAccessLogProcessingItemForControl(control);
            }
        } else {
            AccessLogProcessingControl control = this.accessLogProcessingControlService.recordAccessLogProcessingControlForNode(instAnalysisCtrl, "defaultClusterNode");
            this.accessLogProcessingItemService.recordAccessLogProcessingItemForControl(control);
        }
    }

    public final void finishAssessmentCollection(@NotNull InstanceAssessmentCompletionStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this.instanceAnalysisControlRepository.completeInstanceAnalysisControl("BROWSER_METRICS", status);
        this.instanceAnalysisControlRepository.completeInstanceAnalysisControl("USAGE_METRICS", status);
        Object object = this.schedulerService.getJobDetails(JOB_ID);
        if (object == null || (object = object.getParameters()) == null || (object = (Serializable)object.get("CLOUD_TRIGGERED")) == null) {
            object = false;
        }
        Object cloudTriggered = object;
        this.schedulerService.unscheduleJob(JOB_ID);
        this.usageMetricsPersistenceJobRunner.unschedule();
        if (Intrinsics.areEqual((Object)cloudTriggered, (Object)true)) {
            this.eventPublisher.publish((Object)new AssessmentCompletionEvent(status));
        }
        log.info("Instance analysis control is completed.");
    }

    public final void scheduleAssessmentControlJob(@NotNull Duration assessmentDuration, boolean cloudTriggered, @NotNull String configJson) {
        Intrinsics.checkNotNullParameter((Object)assessmentDuration, (String)"assessmentDuration");
        Intrinsics.checkNotNullParameter((Object)configJson, (String)"configJson");
        Duration interval = (Duration)ComparisonsKt.minOf((Comparable)assessmentDuration, (Comparable)Duration.ofHours(1L));
        Duration delay = (Duration)ComparisonsKt.minOf((Comparable)assessmentDuration.dividedBy(2L), (Comparable)Duration.ofHours(1L));
        SchedulerService $this$scheduleAssessmentControlJob_u24lambda_u240 = this.schedulerService;
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"CLOUD_TRIGGERED", (Object)cloudTriggered), TuplesKt.to((Object)"CONFIG_JSON", (Object)configJson)};
        $this$scheduleAssessmentControlJob_u24lambda_u240.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters(MapsKt.mapOf((Pair[])pairArray)).withSchedule(Schedule.forInterval((long)interval.toMillis(), (Date)Date.from(Instant.now().plus(delay)))));
    }

    public static /* synthetic */ void scheduleAssessmentControlJob$default(InstanceAnalysisControlService instanceAnalysisControlService, Duration duration, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        instanceAnalysisControlService.scheduleAssessmentControlJob(duration, bl, string);
    }

    @Nullable
    public final InstAnalysisCtrl findInstanceAnalysisControl(@NotNull String analysisType) {
        Intrinsics.checkNotNullParameter((Object)analysisType, (String)"analysisType");
        return this.instanceAnalysisControlRepository.findInstanceAnalysisControl(analysisType);
    }

    @NotNull
    public final AssessmentCanceledChecker isCanceledChecker() {
        InstAnalysisCtrl initial = this.findInstanceAnalysisControl("BROWSER_METRICS");
        Ref.BooleanRef canceled = new Ref.BooleanRef();
        return new AssessmentCanceledChecker(canceled, this, initial){
            final /* synthetic */ Ref.BooleanRef $canceled;
            final /* synthetic */ InstanceAnalysisControlService this$0;
            final /* synthetic */ InstAnalysisCtrl $initial;
            {
                this.$canceled = $canceled;
                this.this$0 = $receiver;
                this.$initial = $initial;
            }

            /*
             * Unable to fully structure code
             */
            public boolean isCanceled() {
                block2: {
                    if (this.$canceled.element) break block2;
                    ctrl = this.this$0.findInstanceAnalysisControl("BROWSER_METRICS");
                    if (ctrl != null && InstanceAnalysisControlRepositoryKt.isCanceled(ctrl)) ** GOTO lbl-1000
                    v0 = this.$initial;
                    v1 = ctrl;
                    if (!Intrinsics.areEqual((Object)(v0 != null ? Integer.valueOf(v0.getID()) : null), (Object)(v1 != null ? Integer.valueOf(v1.getID()) : null))) lbl-1000:
                    // 2 sources

                    {
                        v2 = true;
                    } else {
                        v2 = false;
                    }
                    this.$canceled.element = v2;
                }
                return this.$canceled.element;
            }

            public void checkCanceled() throws AssessmentCanceledException {
                AssessmentCanceledChecker.DefaultImpls.checkCanceled(this);
            }
        };
    }

    public final boolean hasActiveAssessment() {
        InstAnalysisCtrl instAnalysisCtrl = this.findInstanceAnalysisControl("BROWSER_METRICS");
        return instAnalysisCtrl != null ? !InstanceAnalysisControlRepositoryKt.isFinished(instAnalysisCtrl) : false;
    }

    @NotNull
    public final InstAnalysisCtrl createInstanceAnalysisControl(@NotNull String analysisType) {
        Intrinsics.checkNotNullParameter((Object)analysisType, (String)"analysisType");
        return this.instanceAnalysisControlRepository.createInstanceAnalysisControl(analysisType);
    }

    @NotNull
    public final Duration calculateRemainingDuration(@NotNull InstAnalysisCtrl instanceAnalysisControl) {
        Intrinsics.checkNotNullParameter((Object)instanceAnalysisControl, (String)"instanceAnalysisControl");
        Duration elapsed = Duration.between(Instant.ofEpochMilli(instanceAnalysisControl.getStartTimestamp()), Instant.now());
        Duration remaining = (Duration)RangesKt.coerceAtLeast((Comparable)this.assessmentDuration().minus(elapsed), (Comparable)Duration.ZERO);
        if (remaining.isZero() && elapsed.compareTo(Duration.ofHours(1L)) < 0) {
            List list = this.schedulerService.getJobsByJobRunnerKey(InstanceAssessmentService.Companion.getRUNNER_KEY());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getJobsByJobRunnerKey(...)");
            if (!((Collection)list).isEmpty()) {
                Duration duration = Duration.ofMinutes(1L);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
                return duration;
            }
        }
        Intrinsics.checkNotNull((Object)remaining);
        return remaining;
    }

    private final Duration assessmentDuration() {
        Duration duration;
        if (this.features.getQuickAssessment()) {
            Duration duration2 = InstanceAnalysisControlServiceKt.access$getBROWSER_METRICS_COLLECTION_TIME_QUICK$p();
            duration = duration2;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"access$getBROWSER_METRIC\u2026LECTION_TIME_QUICK$p(...)");
        } else {
            Duration duration3 = InstanceAnalysisControlServiceKt.access$getBROWSER_METRICS_COLLECTION_TIME$p();
            duration = duration3;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"access$getBROWSER_METRICS_COLLECTION_TIME$p(...)");
        }
        return duration;
    }

    @NotNull
    public final Schedule lowTrafficOnlySchedule() {
        return this.schedule(EVERY_DAY_1AM);
    }

    @NotNull
    public final Schedule lowTrafficOnlyHourlySchedule() {
        return this.schedule(HOURLY_AT_NIGHT);
    }

    private final Schedule schedule(String cron) {
        Schedule schedule;
        if (this.features.getQuickAssessment()) {
            Schedule schedule2 = Schedule.forInterval((long)InstanceAnalysisControlServiceKt.access$getBROWSER_METRICS_COLLECTION_TIME_QUICK$p().toMillis(), (Date)Date.from(Instant.now().plus(InstanceAnalysisControlServiceKt.access$getBROWSER_METRICS_COLLECTION_TIME_QUICK$p().dividedBy(2L))));
            Intrinsics.checkNotNull((Object)schedule2);
            schedule = schedule2;
        } else {
            Schedule schedule3 = Schedule.forCronExpression((String)cron);
            Intrinsics.checkNotNull((Object)schedule3);
            schedule = schedule3;
        }
        return schedule;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(InstanceAnalysisControlService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"com.atlassian.jira.migration.guardrails.InstanceAnalysisControlScheduler");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        RUNNER_KEY = jobRunnerKey;
        JobId jobId = JobId.of((String)"instance-analysis-control-job-id");
        Intrinsics.checkNotNull((Object)jobId);
        JOB_ID = jobId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/guardrails/InstanceAnalysisControlService$Companion;", "", "()V", "EVERY_DAY_1AM", "", "HOURLY_AT_NIGHT", "JOB_ID", "Lcom/atlassian/scheduler/config/JobId;", "getJOB_ID", "()Lcom/atlassian/scheduler/config/JobId;", "RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getRUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final JobRunnerKey getRUNNER_KEY() {
            return RUNNER_KEY;
        }

        @NotNull
        public final JobId getJOB_ID() {
            return JOB_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

