/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.assessment.InstanceAssessmentUploadService;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.events.InstanceAssessmentFinishedEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.guardrails.AssessmentQueryList;
import com.atlassian.jira.migration.guardrails.AssessmentStatus;
import com.atlassian.jira.migration.guardrails.CloudJobType;
import com.atlassian.jira.migration.guardrails.InstanceAnalysisControlService;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentAnalyticsDto;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentConfig;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentServiceKt;
import com.atlassian.jira.migration.guardrails.cancel.AssessmentCanceledChecker;
import com.atlassian.jira.migration.guardrails.event.AssessmentCompletionEvent;
import com.atlassian.jira.migration.guardrails.exceptions.AssessmentCanceledException;
import com.atlassian.jira.migration.guardrails.queries.App;
import com.atlassian.jira.migration.guardrails.queries.AssessmentDatabaseAccessor;
import com.atlassian.jira.migration.guardrails.queries.AssessmentQuery;
import com.atlassian.jira.migration.guardrails.queries.QueryProductType;
import com.atlassian.jira.migration.guardrails.repository.GrResponseGroup;
import com.atlassian.jira.migration.guardrails.repository.GrResponseGroupRepository;
import com.atlassian.jira.migration.guardrails.repository.GuardrailsResponse;
import com.atlassian.jira.migration.guardrails.repository.GuardrailsResponseRepository;
import com.atlassian.jira.migration.guardrails.repository.InstAnalysisCtrl;
import com.atlassian.jira.migration.guardrails.repository.InstanceAnalysisControlRepositoryKt;
import com.atlassian.jira.migration.guardrails.repository.InstanceAssessmentCompletionStatus;
import com.atlassian.jira.migration.guardrails.repository.QueryAssessmentDto;
import com.atlassian.jira.migration.guardrails.repository.ResponseType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.status.JobDetails;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u0016\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 v2\u00020\u0001:\u0001vB\u008f\u0001\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\u0006\u0010\"\u001a\u00020#\u00a2\u0006\u0002\u0010$J\b\u0010)\u001a\u00020*H\u0002J\u0006\u0010+\u001a\u00020,J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u000200H\u0002JL\u00101\u001a&\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u0002050403\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u000207022\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u000207H\u0002J\u000e\u00101\u001a\u0002052\u0006\u0010?\u001a\u000205J0\u0010@\u001a\u00020*2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010A\u001a\u00020B2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u000207H\u0002J\n\u0010C\u001a\u0004\u0018\u00010DH\u0002J\u0006\u0010E\u001a\u00020,J\b\u0010F\u001a\u00020,H\u0002J\u0010\u0010G\u001a\u00020,2\u0006\u0010H\u001a\u00020DH\u0002J\u001f\u0010I\u001a\u0002072\u0010\u0010J\u001a\f\u0012\u0006\b\u0001\u0012\u00020L\u0018\u00010KH\u0002\u00a2\u0006\u0002\u0010MJ\u0018\u0010I\u001a\u0002072\u0006\u0010N\u001a\u0002072\u0006\u0010>\u001a\u000207H\u0002J\u0017\u0010O\u001a\f\u0012\u0006\b\u0001\u0012\u00020L\u0018\u00010KH\u0002\u00a2\u0006\u0002\u0010PJ\b\u0010Q\u001a\u00020,H\u0002J*\u0010R\u001a$\u0012\f\u0012\n U*\u0004\u0018\u00010T0T U*\u0010\u0012\f\u0012\n U*\u0004\u0018\u00010T0T0V0SH\u0002J\u0010\u0010W\u001a\u0002072\u0006\u0010X\u001a\u000206H\u0002J\u0010\u0010Y\u001a\u00020*2\u0006\u0010Z\u001a\u00020[H\u0007J\b\u0010\\\u001a\u00020*H\u0007J\b\u0010]\u001a\u00020*H\u0007J\u0018\u0010^\u001a\u00020*2\u0006\u0010?\u001a\u0002052\u0006\u0010_\u001a\u000206H\u0002J\u0010\u0010`\u001a\u00020a2\u0006\u0010/\u001a\u000200H\u0002J\u0018\u0010b\u001a\u00020a2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u0010c\u001a\u00020a2\u0006\u0010/\u001a\u000200H\u0016J\u001a\u0010d\u001a\u00020B2\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020f04J\u0018\u0010g\u001a\u00020*2\u0006\u0010<\u001a\u00020=2\u0006\u0010h\u001a\u000206H\u0002J\u0010\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020lH\u0002J\u0010\u0010m\u001a\u00020j2\u0006\u00108\u001a\u000209H\u0002J\u000e\u0010n\u001a\u00020*2\u0006\u0010-\u001a\u00020.J\u001a\u0010o\u001a\u00020,2\b\b\u0002\u0010p\u001a\u00020j2\b\b\u0002\u0010q\u001a\u00020rJ\u0010\u0010s\u001a\u00020*2\u0006\u0010t\u001a\u00020uH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006w"}, d2={"Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentService;", "Lcom/atlassian/scheduler/JobRunner;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "assessmentQueryList", "Lcom/atlassian/jira/migration/guardrails/AssessmentQueryList;", "guardrailsResponseRepository", "Lcom/atlassian/jira/migration/guardrails/repository/GuardrailsResponseRepository;", "grResponseGroupRepository", "Lcom/atlassian/jira/migration/guardrails/repository/GrResponseGroupRepository;", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "databaseAccessor", "Lcom/atlassian/jira/database/DatabaseAccessor;", "instanceAnalysisControlService", "Lcom/atlassian/jira/migration/guardrails/InstanceAnalysisControlService;", "features", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "instanceAssessmentUploadService", "Lcom/atlassian/jira/migration/assessment/InstanceAssessmentUploadService;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "clock", "Ljava/time/Clock;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/migration/guardrails/AssessmentQueryList;Lcom/atlassian/jira/migration/guardrails/repository/GuardrailsResponseRepository;Lcom/atlassian/jira/migration/guardrails/repository/GrResponseGroupRepository;Lcom/atlassian/jira/cluster/ClusterManager;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/database/DatabaseAccessor;Lcom/atlassian/jira/migration/guardrails/InstanceAnalysisControlService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/plugin/PluginAccessor;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/migration/assessment/InstanceAssessmentUploadService;Lcom/atlassian/event/api/EventPublisher;Ljava/time/Clock;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "cancelActiveNodeJobs", "", "cancelAssessmentCollection", "Lcom/atlassian/jira/migration/guardrails/AssessmentStatus;", "cloudJobType", "Lcom/atlassian/jira/migration/guardrails/CloudJobType;", "request", "Lcom/atlassian/scheduler/JobRunnerRequest;", "executeQuery", "Lkotlin/Triple;", "Lkotlin/Result;", "", "", "", "", "assessmentQuery", "Lcom/atlassian/jira/migration/guardrails/queries/AssessmentQuery;", "cancelChecker", "Lcom/atlassian/jira/migration/guardrails/cancel/AssessmentCanceledChecker;", "analyticsDto", "Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentAnalyticsDto;", "cpuLoadBeforeAssessmentStart", "queryId", "executeQueryAndSave", "jobId", "Lcom/atlassian/scheduler/config/JobId;", "findControl", "Lcom/atlassian/jira/migration/guardrails/repository/InstAnalysisCtrl;", "getAssessmentProgress", "getAssessmentStatus", "getCompleteAnalysisProgress", "instanceAnalysisControl", "getCpuLoad", "oldCpuTicks", "", "", "([[J)D", "queryCpuUsage", "getCpuTicks", "()[[J", "getGrQueriesProgress", "jobs", "", "Lcom/atlassian/scheduler/status/JobDetails;", "kotlin.jvm.PlatformType", "", "measureCpuLoad", "measurementDuration", "onAssessmentCompletionEvent", "event", "Lcom/atlassian/jira/migration/guardrails/event/AssessmentCompletionEvent;", "postConstruct", "preDestroy", "recordQueryMetric", "elapsed", "runAssessment", "Lcom/atlassian/scheduler/JobRunnerResponse;", "runDiscover", "runJob", "scheduleJob", "params", "Ljava/io/Serializable;", "sendAssessmentAnalytics", "totalExecutionTime", "shouldSkip", "", "productType", "Lcom/atlassian/jira/migration/guardrails/queries/QueryProductType;", "shouldSkipQuery", "startDiscover", "startInstanceAssessment", "cloudTriggered", "config", "Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentConfig;", "stopAssessmentCollection", "status", "Lcom/atlassian/jira/migration/guardrails/repository/InstanceAssessmentCompletionStatus;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nInstanceAssessmentService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstanceAssessmentService.kt\ncom/atlassian/jira/migration/guardrails/InstanceAssessmentService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,460:1\n1#2:461\n1549#3:462\n1620#3,3:463\n1855#3,2:470\n1855#3,2:475\n766#3:477\n857#3,2:478\n1855#3,2:480\n1726#3,3:482\n125#4:466\n152#4,3:467\n215#4,2:472\n26#5:474\n*S KotlinDebug\n*F\n+ 1 InstanceAssessmentService.kt\ncom/atlassian/jira/migration/guardrails/InstanceAssessmentService\n*L\n184#1:462\n184#1:463,3\n279#1:470,2\n400#1:475,2\n428#1:477\n428#1:478,2\n429#1:480,2\n438#1:482,3\n265#1:466\n265#1:467,3\n299#1:472,2\n313#1:474\n*E\n"})
public final class InstanceAssessmentService
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final AssessmentQueryList assessmentQueryList;
    @NotNull
    private final GuardrailsResponseRepository guardrailsResponseRepository;
    @NotNull
    private final GrResponseGroupRepository grResponseGroupRepository;
    @NotNull
    private final ClusterManager clusterManager;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final InstanceAnalysisControlService instanceAnalysisControlService;
    @NotNull
    private final MigrationFeatures features;
    @NotNull
    private final PluginAccessor pluginAccessor;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @NotNull
    private final InstanceAssessmentUploadService instanceAssessmentUploadService;
    @NotNull
    private final EventPublisher eventPublisher;
    @NotNull
    private final Clock clock;
    @NotNull
    private final ObjectMapperFactory objectMapperFactory;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final JobRunnerKey RUNNER_KEY;
    @NotNull
    public static final String SERVER_NODE = "serverNode";
    @NotNull
    public static final String DEFAULT_NODE = "defaultClusterNode";
    @NotNull
    public static final String BROWSER_METRICS = "BROWSER_METRICS";
    @NotNull
    public static final String APPLICATION_USER_PARAM = "APPLICATION_USER";
    @NotNull
    public static final String CLOUD_TRIGGERED = "CLOUD_TRIGGERED";
    @NotNull
    public static final String CLOUD_JOB_TYPE = "CLOUD_JOB_TYPE";
    @NotNull
    public static final String CONFIG_JSON = "CONFIG_JSON";
    @NotNull
    private static final Map<CloudJobType, String> DISCOVER_QUERIES;

    @Inject
    public InstanceAssessmentService(@NotNull SchedulerService schedulerService, @NotNull AssessmentQueryList assessmentQueryList, @NotNull GuardrailsResponseRepository guardrailsResponseRepository, @NotNull GrResponseGroupRepository grResponseGroupRepository, @NotNull ClusterManager clusterManager, @NotNull MigrationEventBus migrationEventBus, @NotNull MetricsEventService metricsEventService, @NotNull DatabaseAccessor databaseAccessor, @NotNull InstanceAnalysisControlService instanceAnalysisControlService, @NotNull MigrationFeatures features, @NotNull PluginAccessor pluginAccessor, @NotNull UserManager userManager, @NotNull JiraAuthenticationContext jiraAuthenticationContext, @NotNull InstanceAssessmentUploadService instanceAssessmentUploadService, @NotNull EventPublisher eventPublisher, @NotNull Clock clock, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)assessmentQueryList, (String)"assessmentQueryList");
        Intrinsics.checkNotNullParameter((Object)guardrailsResponseRepository, (String)"guardrailsResponseRepository");
        Intrinsics.checkNotNullParameter((Object)grResponseGroupRepository, (String)"grResponseGroupRepository");
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)instanceAnalysisControlService, (String)"instanceAnalysisControlService");
        Intrinsics.checkNotNullParameter((Object)features, (String)"features");
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)instanceAssessmentUploadService, (String)"instanceAssessmentUploadService");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.schedulerService = schedulerService;
        this.assessmentQueryList = assessmentQueryList;
        this.guardrailsResponseRepository = guardrailsResponseRepository;
        this.grResponseGroupRepository = grResponseGroupRepository;
        this.clusterManager = clusterManager;
        this.migrationEventBus = migrationEventBus;
        this.metricsEventService = metricsEventService;
        this.databaseAccessor = databaseAccessor;
        this.instanceAnalysisControlService = instanceAnalysisControlService;
        this.features = features;
        this.pluginAccessor = pluginAccessor;
        this.userManager = userManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.instanceAssessmentUploadService = instanceAssessmentUploadService;
        this.eventPublisher = eventPublisher;
        this.clock = clock;
        this.objectMapperFactory = objectMapperFactory;
        this.objectMapper = this.objectMapperFactory.createObjectMapper();
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @PostConstruct
    public final void postConstruct() {
        Object object;
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
        Object object2 = this;
        try {
            InstanceAssessmentService $this$postConstruct_u24lambda_u240 = object2;
            boolean bl = false;
            $this$postConstruct_u24lambda_u240.eventPublisher.register((Object)$this$postConstruct_u24lambda_u240);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            log.error("Failed to register InstanceAssessmentService", (Throwable)it);
        }
        this.cancelActiveNodeJobs();
    }

    @PreDestroy
    public final void preDestroy() {
        this.cancelActiveNodeJobs();
        this.eventPublisher.unregister((Object)this);
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
    }

    public final void startDiscover(@NotNull CloudJobType cloudJobType) {
        Intrinsics.checkNotNullParameter((Object)((Object)cloudJobType), (String)"cloudJobType");
        this.scheduleJob(MapsKt.mapOf((Pair)TuplesKt.to((Object)CLOUD_JOB_TYPE, (Object)cloudJobType.toString())));
    }

    @NotNull
    public final AssessmentStatus startInstanceAssessment(boolean cloudTriggered, @NotNull InstanceAssessmentConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        GrResponseGroup latestResponseGroup = this.grResponseGroupRepository.findLatestResponseGroup();
        if (this.instanceAnalysisControlService.hasActiveAssessment() || latestResponseGroup != null && latestResponseGroup.getEndTimestamp() == null) {
            return AssessmentStatus.ActiveAssessment.INSTANCE;
        }
        if (this.features.getCollectL1Metrics()) {
            this.instanceAnalysisControlService.startAssessmentCollection(cloudTriggered, config2);
        }
        String configJson = this.objectMapper.writeValueAsString((Object)config2);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CLOUD_TRIGGERED, (Object)cloudTriggered), TuplesKt.to((Object)CONFIG_JSON, (Object)configJson)};
        JobId jobId = this.scheduleJob(MapsKt.mapOf((Pair[])pairArray));
        String string = jobId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager);
        Intrinsics.checkNotNull((Object)configJson);
        this.grResponseGroupRepository.createResponseGroup(string, string2, configJson);
        return AssessmentStatus.NewlyCreatedAssessment.INSTANCE;
    }

    public static /* synthetic */ AssessmentStatus startInstanceAssessment$default(InstanceAssessmentService instanceAssessmentService, boolean bl, InstanceAssessmentConfig instanceAssessmentConfig, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            instanceAssessmentConfig = new InstanceAssessmentConfig(false, false, 3, null);
        }
        return instanceAssessmentService.startInstanceAssessment(bl, instanceAssessmentConfig);
    }

    @NotNull
    public final JobId scheduleJob(@NotNull Map<String, ? extends Serializable> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        String nodeId = InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager);
        log.info("Scheduling job - nodeId: " + nodeId);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)SERVER_NODE, (Object)nodeId), TuplesKt.to((Object)APPLICATION_USER_PARAM, (Object)this.jiraAuthenticationContext.getLoggedInUser().getId())};
        JobConfig config2 = JobConfig.forJobRunnerKey((JobRunnerKey)RUNNER_KEY).withParameters(MapsKt.plus(params, (Map)MapsKt.mapOf((Pair[])pairArray))).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        JobId jobId = this.schedulerService.scheduleJobWithGeneratedId(config2);
        Intrinsics.checkNotNullExpressionValue((Object)jobId, (String)"scheduleJobWithGeneratedId(...)");
        JobId jobId2 = jobId;
        log.info("Scheduled job - jobId: " + jobId2 + " - nodeId: " + nodeId);
        return jobId2;
    }

    @NotNull
    public final AssessmentStatus getAssessmentProgress() {
        AssessmentStatus assessmentStatus = this.getAssessmentStatus();
        return assessmentStatus instanceof AssessmentStatus.CompletedAssessment ? (AssessmentStatus)new AssessmentStatus.CompletedAssessment(((AssessmentStatus.CompletedAssessment)assessmentStatus).getLastStatusUpdateInstant(), ((AssessmentStatus.CompletedAssessment)assessmentStatus).getStatus()) : assessmentStatus;
    }

    @NotNull
    public final AssessmentStatus cancelAssessmentCollection() {
        this.stopAssessmentCollection(InstanceAssessmentCompletionStatus.CANCELED);
        return this.getAssessmentProgress();
    }

    private final AssessmentStatus getAssessmentStatus() {
        Object object;
        block3: {
            block4: {
                block2: {
                    if (this.features.getCollectL1Metrics()) break block2;
                    object = this.getGrQueriesProgress();
                    break block3;
                }
                object = this.findControl();
                if (object == null) break block4;
                Object p0 = object;
                boolean bl = false;
                AssessmentStatus assessmentStatus = this.getCompleteAnalysisProgress((InstAnalysisCtrl)p0);
                object = assessmentStatus;
                if (assessmentStatus != null) break block3;
            }
            object = AssessmentStatus.NoActiveAssessment.INSTANCE;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final AssessmentStatus getGrQueriesProgress() {
        void $this$mapTo$iv$iv;
        GrResponseGroup grResponseGroup = this.grResponseGroupRepository.findLatestResponseGroup();
        if (grResponseGroup == null) {
            return AssessmentStatus.NoActiveAssessment.INSTANCE;
        }
        GrResponseGroup grResponseGroup2 = grResponseGroup;
        Iterable $this$map$iv = this.jobs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JobDetails jobDetails = (JobDetails)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getJobId().toString());
        }
        if (!((List)destination$iv$iv).contains(grResponseGroup2.getJobId())) {
            Instant instant;
            Long l = grResponseGroup2.getEndTimestamp();
            if (l != null) {
                long p0 = ((Number)l).longValue();
                boolean bl = false;
                instant = Instant.ofEpochMilli(p0);
            } else {
                instant = null;
            }
            String string = "COMPLETE";
            Instant instant2 = instant;
            return new AssessmentStatus.CompletedAssessment(instant2, string);
        }
        GuardrailsResponse[] guardrailsResponses = this.guardrailsResponseRepository.findResponses(grResponseGroup2.getJobId());
        int progress = guardrailsResponses.length * 100 / RangesKt.coerceAtLeast((int)this.assessmentQueryList.size(), (int)1);
        return new AssessmentStatus.InProgressAssessment(progress + "% COMPLETE", "QUERYING_DATABASE", Instant.ofEpochMilli(grResponseGroup2.getStartTimestamp()), null);
    }

    private final AssessmentStatus getCompleteAnalysisProgress(InstAnalysisCtrl instanceAnalysisControl) {
        if (InstanceAnalysisControlRepositoryKt.isFinished(instanceAnalysisControl)) {
            Instant instant;
            Long endTimestamp;
            Long l = endTimestamp = instanceAnalysisControl.getEndTimestamp();
            if (l != null) {
                long p0 = ((Number)l).longValue();
                boolean bl = false;
                instant = Instant.ofEpochMilli(p0);
            } else {
                instant = null;
            }
            String string = instanceAnalysisControl.getCompletionStatus();
            Instant instant2 = instant;
            return new AssessmentStatus.CompletedAssessment(instant2, string);
        }
        java.time.Duration remainingDuration = this.instanceAnalysisControlService.calculateRemainingDuration(instanceAnalysisControl);
        if (remainingDuration.isZero()) {
            this.stopAssessmentCollection(InstanceAssessmentCompletionStatus.COMPLETE);
        }
        return new AssessmentStatus.InProgressAssessment(remainingDuration.toHours() + " h " + remainingDuration.toMinutes() % (long)60 + " m remaining", "COLLECTING_BROWSER_METRICS", Instant.ofEpochMilli(instanceAnalysisControl.getStartTimestamp()), remainingDuration.toMillis());
    }

    private final void stopAssessmentCollection(InstanceAssessmentCompletionStatus status) {
        block0: {
            log.info("Stopping Assessment Collection.");
            InstAnalysisCtrl instAnalysisCtrl = this.findControl();
            if (instAnalysisCtrl == null) break block0;
            InstAnalysisCtrl it = instAnalysisCtrl;
            boolean bl = false;
            this.instanceAnalysisControlService.finishAssessmentCollection(status);
        }
    }

    @NotNull
    public final String executeQuery(@NotNull String queryId) {
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        Object object = this.assessmentQueryList.execute-IoAF18A(queryId);
        ResultKt.throwOnFailure((Object)object);
        return (String)object;
    }

    /*
     * WARNING - void declaration
     */
    private final void executeQueryAndSave(AssessmentQuery assessmentQuery, AssessmentCanceledChecker cancelChecker, JobId jobId, InstanceAssessmentAnalyticsDto analyticsDto, double cpuLoadBeforeAssessmentStart) {
        void $this$mapTo$iv$iv;
        Object object;
        boolean success = false;
        String queryStatus = null;
        queryStatus = "FAILED";
        Result assessmentQueryResult = null;
        Long queryDuration = null;
        Double queryCpuLoad = null;
        if (this.shouldSkipQuery(assessmentQuery)) {
            queryStatus = "SKIPPED";
        } else if (cancelChecker.isCanceled()) {
            queryStatus = "CANCELED";
        } else {
            Object it;
            Triple<Result<Map<String, String>>, Long, Double> triple = this.executeQuery(assessmentQuery, cancelChecker, analyticsDto, cpuLoadBeforeAssessmentStart);
            Object result2 = ((Result)triple.component1()).unbox-impl();
            long duration = ((Number)triple.component2()).longValue();
            double loadDiff = ((Number)triple.component3()).doubleValue();
            queryDuration = duration;
            queryCpuLoad = loadDiff;
            assessmentQueryResult = Result.box-impl((Object)result2);
            object = assessmentQueryResult.unbox-impl();
            if (Result.isSuccess-impl((Object)object)) {
                it = (Map)object;
                boolean bl = false;
                success = true;
                analyticsDto.incrementSuccessfulQueries();
                queryStatus = "COMPLETE";
            }
            object = assessmentQueryResult.unbox-impl();
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Object it2 = it = throwable;
                boolean bl = false;
                if (it2 instanceof AssessmentCanceledException) {
                    queryStatus = "CANCELED";
                    queryDuration = null;
                    queryCpuLoad = null;
                } else if (it2 instanceof SQLException && duration >= Duration.getInWholeMilliseconds-impl((long)AssessmentDatabaseAccessor.Companion.getASSESSMENT_QUERY_TIMEOUT-UwyO8pc())) {
                    queryStatus = "TIMED_OUT";
                    queryDuration = null;
                    queryCpuLoad = null;
                }
            }
        }
        Map<String, QueryProductType> $this$map$iv = assessmentQuery.getQueryIds();
        boolean $i$f$map = false;
        Map<String, QueryProductType> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        object = $this$mapTo$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            Object object2;
            Object object3;
            Map.Entry item$iv$iv;
            Map.Entry it2 = item$iv$iv = object.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean shouldSkip = this.shouldSkip((QueryProductType)((Object)it2.getValue()));
            ResponseType responseType = ResponseType.Companion.getByQueryResult(assessmentQuery, (QueryProductType)((Object)it2.getValue()));
            String string = (String)it2.getKey();
            String string2 = jobId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            collection.add(new QueryAssessmentDto(responseType, string, string2, success && !shouldSkip, shouldSkip ? "SKIPPED" : queryStatus, shouldSkip ? null : ((object3 = assessmentQueryResult) != null && (object3 = (Map)(Result.isFailure-impl((Object)(object2 = object3.unbox-impl())) ? null : object2)) != null ? (String)object3.get(it2.getKey()) : null), ((QueryProductType)((Object)it2.getValue())).parentProduct(), shouldSkip ? null : queryDuration, shouldSkip ? null : queryCpuLoad));
        }
        List assessmentQueryDtos = (List)destination$iv$iv;
        Iterable $this$forEach$iv = assessmentQueryDtos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            QueryAssessmentDto it = (QueryAssessmentDto)element$iv;
            boolean bl = false;
            this.guardrailsResponseRepository.recordAssessmentDto(it);
        }
    }

    private final Triple<Result<Map<String, String>>, Long, Double> executeQuery(AssessmentQuery assessmentQuery, AssessmentCanceledChecker cancelChecker, InstanceAssessmentAnalyticsDto analyticsDto, double cpuLoadBeforeAssessmentStart) {
        long start = this.clock.instant().toEpochMilli();
        log.info("Executing query with queryId '" + assessmentQuery.getQueryIds().keySet() + '\'');
        long[][] cpuTicks = this.getCpuTicks();
        Object object = assessmentQuery.executeAll-IoAF18A(cancelChecker);
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            boolean bl = false;
            log.error("Error during guardrails query execution with queryId '" + assessmentQuery.getQueryIds() + '\'', it);
            analyticsDto.incrementFailedQueries();
        }
        Object assessmentQueryResults = object;
        long elapsed = this.clock.instant().toEpochMilli() - start;
        double queryCpuUsage = this.getCpuLoad(cpuTicks);
        log.info("Finished executing query with queryId '" + assessmentQuery.getQueryIds() + "' in " + elapsed + "ms");
        Map<String, QueryProductType> $this$forEach$iv = assessmentQuery.getQueryIds();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, QueryProductType>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, QueryProductType> element$iv;
            Map.Entry<String, QueryProductType> it = element$iv = iterator2.next();
            boolean bl = false;
            this.recordQueryMetric(it.getKey(), elapsed);
        }
        return new Triple((Object)Result.box-impl((Object)assessmentQueryResults), (Object)elapsed, (Object)this.getCpuLoad(queryCpuUsage, cpuLoadBeforeAssessmentStart));
    }

    private final double getCpuLoad(double queryCpuUsage, double cpuLoadBeforeAssessmentStart) {
        return new BigDecimal(String.valueOf(queryCpuUsage - cpuLoadBeforeAssessmentStart)).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    private final long[][] getCpuTicks() {
        long[][] lArray;
        try {
            lArray = new SystemInfo().getHardware().getProcessor().getProcessorCpuLoadTicks();
        }
        catch (Exception e) {
            log.error("Error measuring CPU ticks", (Throwable)e);
            boolean $i$f$emptyArray = false;
            lArray = new long[0][];
        }
        return lArray;
    }

    private final double getCpuLoad(long[][] oldCpuTicks) {
        double d;
        try {
            double[] cpuLoads = new SystemInfo().getHardware().getProcessor().getProcessorCpuLoadBetweenTicks(oldCpuTicks);
            Intrinsics.checkNotNull((Object)cpuLoads);
            d = ArraysKt.average((double[])cpuLoads);
        }
        catch (Exception e) {
            log.error("Error measuring CPU load", (Throwable)e);
            d = 0.0;
        }
        return d;
    }

    private final double measureCpuLoad(long measurementDuration) {
        double d;
        try {
            double[] cpuLoads = new SystemInfo().getHardware().getProcessor().getProcessorCpuLoad(measurementDuration);
            Intrinsics.checkNotNull((Object)cpuLoads);
            d = ArraysKt.average((double[])cpuLoads);
        }
        catch (Exception e) {
            log.error("Error measuring CPU load", (Throwable)e);
            d = 0.0;
        }
        return d;
    }

    private final void sendAssessmentAnalytics(InstanceAssessmentAnalyticsDto analyticsDto, long totalExecutionTime) {
        block2: {
            Object object;
            Object object2 = this;
            try {
                InstanceAssessmentService $this$sendAssessmentAnalytics_u24lambda_u2412 = object2;
                boolean bl = false;
                String dbType = $this$sendAssessmentAnalytics_u24lambda_u2412.databaseAccessor.getDatabaseVendor().getHumanReadableName();
                MigrationEventBus migrationEventBus = $this$sendAssessmentAnalytics_u24lambda_u2412.migrationEventBus;
                int n = analyticsDto.getSuccessfulQueries();
                int n2 = analyticsDto.getFailedQueries();
                Intrinsics.checkNotNull((Object)dbType);
                migrationEventBus.post(new InstanceAssessmentFinishedEvent(n, n2, totalExecutionTime, dbType));
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            log.error("Error sending analytics for Instance Assessment", (Throwable)it);
        }
    }

    private final void recordQueryMetric(String queryId, long elapsed) {
        block2: {
            Object object;
            Object object2 = this;
            try {
                InstanceAssessmentService $this$recordQueryMetric_u24lambda_u2414 = object2;
                boolean bl = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"query_id", (Object)queryId), TuplesKt.to((Object)"db_type", (Object)$this$recordQueryMetric_u24lambda_u2414.databaseAccessor.getDatabaseVendor().getHumanReadableName())};
                $this$recordQueryMetric_u24lambda_u2414.metricsEventService.sendGaugeEvent(MetricsEventService.OperationType.ASSESSMENT_QUERY_GAUGE, elapsed, MapsKt.mapOf((Pair[])pairArray));
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            log.error("Exception while recording Metric for assessment query with id: '" + queryId + '\'', (Throwable)it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        JobRunnerResponse jobRunnerResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            JobRunnerResponse jobRunnerResponse2;
            Map map = request.getJobConfig().getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getParameters(...)");
            Map params = map;
            Object v = params.get(APPLICATION_USER_PARAM);
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Long");
            Object t = this.userManager.getUserById((Long)v).get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            ApplicationUser applicationUser = (ApplicationUser)t;
            this.jiraAuthenticationContext.setLoggedInUser(applicationUser);
            CloudJobType cloudJobType = this.cloudJobType(request);
            switch (cloudJobType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cloudJobType.ordinal()]) {
                case 1: {
                    jobRunnerResponse2 = this.runAssessment(request);
                    break;
                }
                case 2: {
                    jobRunnerResponse2 = this.runDiscover(CloudJobType.APP_LINKS_DISCOVERY, request);
                    break;
                }
                case -1: {
                    jobRunnerResponse2 = this.runAssessment(request);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            JobRunnerResponse jobRunnerResponse3 = jobRunnerResponse2;
            return jobRunnerResponse3;
        }
        catch (Throwable e) {
            String errorMessage2 = "Failed to run job - jobId: " + request.getJobId() + " - nodeId: " + InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager) + " - " + e.getMessage();
            log.error(errorMessage2, e);
            CloudJobType cloudJobType = this.cloudJobType(request);
            if (cloudJobType != null) {
                CloudJobType cloudJobType2 = cloudJobType;
                InstanceAssessmentUploadService instanceAssessmentUploadService = this.instanceAssessmentUploadService;
                CloudJobType p0 = cloudJobType2;
                boolean bl = false;
                instanceAssessmentUploadService.failInCloud(p0);
            }
            JobRunnerResponse jobRunnerResponse4 = JobRunnerResponse.failed((String)errorMessage2);
            Intrinsics.checkNotNull((Object)jobRunnerResponse4);
            jobRunnerResponse = jobRunnerResponse4;
        }
        finally {
            this.jiraAuthenticationContext.clearLoggedInUser();
        }
        return jobRunnerResponse;
    }

    private final CloudJobType cloudJobType(JobRunnerRequest request) {
        Object object;
        block3: {
            block2: {
                object = (Serializable)request.getJobConfig().getParameters().get(CLOUD_JOB_TYPE);
                if (object == null) break block2;
                Serializable $this$cloudJobType_u24lambda_u2417 = object;
                boolean bl = false;
                CloudJobType cloudJobType = CloudJobType.valueOf((String)((Object)$this$cloudJobType_u24lambda_u2417));
                object = cloudJobType;
                if (cloudJobType != null) break block3;
            }
            object = Intrinsics.areEqual(request.getJobConfig().getParameters().get(CLOUD_TRIGGERED), (Object)true) ? CloudJobType.ASSESSMENT : null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final JobRunnerResponse runAssessment(JobRunnerRequest request) {
        void $this$forEach$iv;
        log.info("Measuring CPU load");
        double cpuLoadBeforeAssessmentStart = this.measureCpuLoad(1000L);
        log.info("Load measured, running job - jobId: " + request.getJobId() + " - nodeId: " + InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager));
        long start = this.clock.instant().toEpochMilli();
        InstanceAssessmentAnalyticsDto analyticsDto = new InstanceAssessmentAnalyticsDto(0, 0, 3, null);
        AssessmentCanceledChecker cancelChecker = this.instanceAnalysisControlService.isCanceledChecker();
        Iterable iterable = this.assessmentQueryList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AssessmentQuery it = (AssessmentQuery)element$iv;
            boolean bl = false;
            if (!it.isQueryEnabled()) continue;
            JobId jobId = request.getJobId();
            Intrinsics.checkNotNullExpressionValue((Object)jobId, (String)"getJobId(...)");
            this.executeQueryAndSave(it, cancelChecker, jobId, analyticsDto, cpuLoadBeforeAssessmentStart);
        }
        long elapsed = this.clock.instant().toEpochMilli() - start;
        this.sendAssessmentAnalytics(analyticsDto, elapsed);
        String string = request.getJobId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.grResponseGroupRepository.completeResponseGroup(string);
        JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success((String)request.getJobId().toString());
        Intrinsics.checkNotNullExpressionValue((Object)jobRunnerResponse, (String)"success(...)");
        return jobRunnerResponse;
    }

    private final JobRunnerResponse runDiscover(CloudJobType cloudJobType, JobRunnerRequest request) {
        String string = DISCOVER_QUERIES.get((Object)cloudJobType);
        if (string == null) {
            JobRunnerResponse jobRunnerResponse = JobRunnerResponse.failed((String)("Query not found " + (Object)((Object)cloudJobType)));
            Intrinsics.checkNotNullExpressionValue((Object)jobRunnerResponse, (String)"failed(...)");
            return jobRunnerResponse;
        }
        String queryId = string;
        String string2 = request.getJobId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.instanceAssessmentUploadService.uploadDiscoverZip(string2, queryId, request.getStartTime().getTime(), cloudJobType);
        JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success((String)request.getJobId().toString());
        Intrinsics.checkNotNullExpressionValue((Object)jobRunnerResponse, (String)"success(...)");
        return jobRunnerResponse;
    }

    @EventListener
    public final void onAssessmentCompletionEvent(@NotNull AssessmentCompletionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        switch (WhenMappings.$EnumSwitchMapping$1[event.getStatus().ordinal()]) {
            case 1: {
                this.instanceAssessmentUploadService.uploadAssessmentZip();
                break;
            }
            case 2: {
                this.instanceAssessmentUploadService.failInCloud(CloudJobType.ASSESSMENT);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cancelActiveNodeJobs() {
        void $this$filterTo$iv$iv;
        String nodeId = InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager);
        log.info("Cancelling active node jobs - nodeId: " + nodeId);
        Iterable $this$filter$iv = this.jobs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JobDetails it = (JobDetails)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getParameters().get(SERVER_NODE), (Object)nodeId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JobDetails it = (JobDetails)element$iv;
            boolean bl = false;
            log.info("Cancelling job - jobId: " + nodeId + " - serverNode: " + it.getParameters().get(SERVER_NODE));
            this.schedulerService.unscheduleJob(it.getJobId());
        }
        log.info("Finished cancelling active node jobs - nodeId: " + nodeId);
    }

    private final boolean shouldSkipQuery(AssessmentQuery assessmentQuery) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = CollectionsKt.distinct((Iterable)assessmentQuery.getQueryIds().values());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    QueryProductType p0 = (QueryProductType)((Object)element$iv);
                    boolean bl2 = false;
                    if (this.shouldSkip(p0)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean shouldSkip(QueryProductType productType) {
        boolean bl;
        App app = productType.getApp();
        if (app != null) {
            App $this$shouldSkip_u24lambda_u2422 = app;
            boolean bl2 = false;
            bl = this.pluginAccessor.getPlugin($this$shouldSkip_u24lambda_u2422.getAppKey()) == null;
        } else {
            bl = false;
        }
        return bl;
    }

    private final InstAnalysisCtrl findControl() {
        return this.instanceAnalysisControlService.findInstanceAnalysisControl(BROWSER_METRICS);
    }

    private final List<JobDetails> jobs() {
        List list = this.schedulerService.getJobsByJobRunnerKey(RUNNER_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getJobsByJobRunnerKey(...)");
        return list;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(InstanceAssessmentService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"com.atlassian.jira.migration.guardrails.InstanceAssessmentService");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        RUNNER_KEY = jobRunnerKey;
        DISCOVER_QUERIES = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)CloudJobType.APP_LINKS_DISCOVERY), (Object)"APP_LINKS"));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentService$Companion;", "", "()V", "APPLICATION_USER_PARAM", "", "BROWSER_METRICS", "CLOUD_JOB_TYPE", "CLOUD_TRIGGERED", "CONFIG_JSON", "DEFAULT_NODE", "DISCOVER_QUERIES", "", "Lcom/atlassian/jira/migration/guardrails/CloudJobType;", "getDISCOVER_QUERIES", "()Ljava/util/Map;", "RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getRUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "SERVER_NODE", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final JobRunnerKey getRUNNER_KEY() {
            return RUNNER_KEY;
        }

        @NotNull
        public final Map<CloudJobType, String> getDISCOVER_QUERIES() {
            return DISCOVER_QUERIES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CloudJobType.values().length];
            try {
                nArray[CloudJobType.ASSESSMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudJobType.APP_LINKS_DISCOVERY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[InstanceAssessmentCompletionStatus.values().length];
            try {
                nArray[InstanceAssessmentCompletionStatus.COMPLETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstanceAssessmentCompletionStatus.CANCELED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

