/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.jira.migration.guardrails.AssessmentQueryList;
import com.atlassian.jira.migration.guardrails.AssessmentZipExportFailedException;
import com.atlassian.jira.migration.guardrails.AssessmentZipOutputStreamResult;
import com.atlassian.jira.migration.guardrails.BrowserMetricsService;
import com.atlassian.jira.migration.guardrails.DailyUsageMetricsService;
import com.atlassian.jira.migration.guardrails.ExamplesFactory;
import com.atlassian.jira.migration.guardrails.FileToZip;
import com.atlassian.jira.migration.guardrails.InstanceAnalysisControlService;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentZipExporter;
import com.atlassian.jira.migration.guardrails.InstanceMetadataDto;
import com.atlassian.jira.migration.guardrails.InstanceMetadataService;
import com.atlassian.jira.migration.guardrails.InstanceMetadataServiceKt;
import com.atlassian.jira.migration.guardrails.PresaleAppAssessmentService;
import com.atlassian.jira.migration.guardrails.ProductDto;
import com.atlassian.jira.migration.guardrails.ProductName;
import com.atlassian.jira.migration.guardrails.apiUsage.ApiUsageService;
import com.atlassian.jira.migration.guardrails.csv.GuardrailsCsvEncoder;
import com.atlassian.jira.migration.guardrails.queries.QueryProductType;
import com.atlassian.jira.migration.guardrails.repository.AppResponseFileRecord;
import com.atlassian.jira.migration.guardrails.repository.DailyUsageMetricsFileRecord;
import com.atlassian.jira.migration.guardrails.repository.GrResponseGroup;
import com.atlassian.jira.migration.guardrails.repository.GrResponseGroupRepository;
import com.atlassian.jira.migration.guardrails.repository.GuardrailsResponseFileRecord;
import com.atlassian.jira.migration.guardrails.repository.GuardrailsResponseRepository;
import com.atlassian.jira.migration.guardrails.repository.InstAnalysisCtrl;
import com.atlassian.jira.migration.guardrails.repository.JESATResponseFileRecord;
import com.atlassian.jira.migration.guardrails.repository.ResponseFileRecord;
import com.atlassian.jira.migration.guardrails.repository.ResponseType;
import com.atlassian.jira.migration.guardrails.repository.SeparateFileResponseRecord;
import com.atlassian.jira.migration.guardrails.util.AssessmentZipBuilder;
import com.atlassian.jira.migration.guardrails.util.AssessmentZipBuilderFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.StreamingOutput;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.encoder.CsvEncoder;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.prefs.CsvPreference;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 42\u00020\u0001:\u000245B_\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J9\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'J.\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'J\u0016\u0010-\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'J,\u0010.\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010)\u001a\u00020\u001d2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020$00H\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentZipExporter;", "", "guardrailsResponseRepository", "Lcom/atlassian/jira/migration/guardrails/repository/GuardrailsResponseRepository;", "browserMetricsService", "Lcom/atlassian/jira/migration/guardrails/BrowserMetricsService;", "instanceMetadataService", "Lcom/atlassian/jira/migration/guardrails/InstanceMetadataService;", "grResponseGroupRepository", "Lcom/atlassian/jira/migration/guardrails/repository/GrResponseGroupRepository;", "dailyUsageMetricsService", "Lcom/atlassian/jira/migration/guardrails/DailyUsageMetricsService;", "apiUsageService", "Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageService;", "instanceAnalysisControlService", "Lcom/atlassian/jira/migration/guardrails/InstanceAnalysisControlService;", "appAssessmentService", "Lcom/atlassian/jira/migration/guardrails/PresaleAppAssessmentService;", "assessmentQueryList", "Lcom/atlassian/jira/migration/guardrails/AssessmentQueryList;", "examplesFactory", "Lcom/atlassian/jira/migration/guardrails/ExamplesFactory;", "zipBuilderFactory", "Lcom/atlassian/jira/migration/guardrails/util/AssessmentZipBuilderFactory;", "(Lcom/atlassian/jira/migration/guardrails/repository/GuardrailsResponseRepository;Lcom/atlassian/jira/migration/guardrails/BrowserMetricsService;Lcom/atlassian/jira/migration/guardrails/InstanceMetadataService;Lcom/atlassian/jira/migration/guardrails/repository/GrResponseGroupRepository;Lcom/atlassian/jira/migration/guardrails/DailyUsageMetricsService;Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageService;Lcom/atlassian/jira/migration/guardrails/InstanceAnalysisControlService;Lcom/atlassian/jira/migration/guardrails/PresaleAppAssessmentService;Lcom/atlassian/jira/migration/guardrails/AssessmentQueryList;Lcom/atlassian/jira/migration/guardrails/ExamplesFactory;Lcom/atlassian/jira/migration/guardrails/util/AssessmentZipBuilderFactory;)V", "createCsv", "Ljavax/ws/rs/core/StreamingOutput;", "fileHeaders", "", "", "records", "", "Lcom/atlassian/jira/migration/guardrails/repository/ResponseFileRecord;", "dataMapping", "([Ljava/lang/String;Ljava/util/List;[Ljava/lang/String;)Ljavax/ws/rs/core/StreamingOutput;", "export", "Lcom/atlassian/jira/migration/guardrails/AssessmentZipOutputStreamResult;", "date", "outputStream", "Ljava/io/OutputStream;", "exportDiscover", "jobId", "queryId", "startTimestamp", "", "exportExample", "exportWithZip", "block", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/guardrails/util/AssessmentZipBuilder;", "noRecordsFound", "Lcom/atlassian/jira/migration/guardrails/AssessmentZipOutputStreamResult$Failed;", "Companion", "Exporter", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nInstanceAssessmentZipExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstanceAssessmentZipExporter.kt\ncom/atlassian/jira/migration/guardrails/InstanceAssessmentZipExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n1855#2,2:344\n*S KotlinDebug\n*F\n+ 1 InstanceAssessmentZipExporter.kt\ncom/atlassian/jira/migration/guardrails/InstanceAssessmentZipExporter\n*L\n104#1:344,2\n*E\n"})
public final class InstanceAssessmentZipExporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GuardrailsResponseRepository guardrailsResponseRepository;
    @NotNull
    private final BrowserMetricsService browserMetricsService;
    @NotNull
    private final InstanceMetadataService instanceMetadataService;
    @NotNull
    private final GrResponseGroupRepository grResponseGroupRepository;
    @NotNull
    private final DailyUsageMetricsService dailyUsageMetricsService;
    @NotNull
    private final ApiUsageService apiUsageService;
    @NotNull
    private final InstanceAnalysisControlService instanceAnalysisControlService;
    @NotNull
    private final PresaleAppAssessmentService appAssessmentService;
    @NotNull
    private final AssessmentQueryList assessmentQueryList;
    @NotNull
    private final ExamplesFactory examplesFactory;
    @NotNull
    private final AssessmentZipBuilderFactory zipBuilderFactory;
    @NotNull
    private static final String NOT_AVAILABLE = "Not Available";
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String[] fileHeader;
    @NotNull
    private static final String[] csvMapping;

    @Inject
    public InstanceAssessmentZipExporter(@NotNull GuardrailsResponseRepository guardrailsResponseRepository, @NotNull BrowserMetricsService browserMetricsService, @NotNull InstanceMetadataService instanceMetadataService, @NotNull GrResponseGroupRepository grResponseGroupRepository, @NotNull DailyUsageMetricsService dailyUsageMetricsService, @NotNull ApiUsageService apiUsageService, @NotNull InstanceAnalysisControlService instanceAnalysisControlService, @NotNull PresaleAppAssessmentService appAssessmentService, @NotNull AssessmentQueryList assessmentQueryList, @NotNull ExamplesFactory examplesFactory, @NotNull AssessmentZipBuilderFactory zipBuilderFactory) {
        Intrinsics.checkNotNullParameter((Object)guardrailsResponseRepository, (String)"guardrailsResponseRepository");
        Intrinsics.checkNotNullParameter((Object)browserMetricsService, (String)"browserMetricsService");
        Intrinsics.checkNotNullParameter((Object)instanceMetadataService, (String)"instanceMetadataService");
        Intrinsics.checkNotNullParameter((Object)grResponseGroupRepository, (String)"grResponseGroupRepository");
        Intrinsics.checkNotNullParameter((Object)dailyUsageMetricsService, (String)"dailyUsageMetricsService");
        Intrinsics.checkNotNullParameter((Object)apiUsageService, (String)"apiUsageService");
        Intrinsics.checkNotNullParameter((Object)instanceAnalysisControlService, (String)"instanceAnalysisControlService");
        Intrinsics.checkNotNullParameter((Object)appAssessmentService, (String)"appAssessmentService");
        Intrinsics.checkNotNullParameter((Object)assessmentQueryList, (String)"assessmentQueryList");
        Intrinsics.checkNotNullParameter((Object)examplesFactory, (String)"examplesFactory");
        Intrinsics.checkNotNullParameter((Object)zipBuilderFactory, (String)"zipBuilderFactory");
        this.guardrailsResponseRepository = guardrailsResponseRepository;
        this.browserMetricsService = browserMetricsService;
        this.instanceMetadataService = instanceMetadataService;
        this.grResponseGroupRepository = grResponseGroupRepository;
        this.dailyUsageMetricsService = dailyUsageMetricsService;
        this.apiUsageService = apiUsageService;
        this.instanceAnalysisControlService = instanceAnalysisControlService;
        this.appAssessmentService = appAssessmentService;
        this.assessmentQueryList = assessmentQueryList;
        this.examplesFactory = examplesFactory;
        this.zipBuilderFactory = zipBuilderFactory;
    }

    @NotNull
    public final AssessmentZipOutputStreamResult export(@NotNull String date, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        GrResponseGroup grResponseGroup = this.grResponseGroupRepository.findLatestResponseGroup();
        if (grResponseGroup == null) {
            return this.noRecordsFound(outputStream);
        }
        GrResponseGroup grResponseGroup2 = grResponseGroup;
        InstanceMetadataDto instanceMetadata = this.instanceMetadataService.exportInstanceDataDto(grResponseGroup2.getStartTimestamp());
        return new Exporter(grResponseGroup2.getJobId(), instanceMetadata, date, false).export(outputStream);
    }

    @NotNull
    public final AssessmentZipOutputStreamResult exportDiscover(@NotNull String jobId, @NotNull String queryId, long startTimestamp, @NotNull String date, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        InstanceMetadataDto metadata = this.instanceMetadataService.exportInstanceDataDto(startTimestamp);
        return this.exportWithZip(outputStream, jobId, (Function1<? super AssessmentZipBuilder, ? extends AssessmentZipOutputStreamResult>)((Function1)new Function1<AssessmentZipBuilder, AssessmentZipOutputStreamResult>(this, queryId, date, metadata, outputStream){
            final /* synthetic */ InstanceAssessmentZipExporter this$0;
            final /* synthetic */ String $queryId;
            final /* synthetic */ String $date;
            final /* synthetic */ InstanceMetadataDto $metadata;
            final /* synthetic */ OutputStream $outputStream;
            {
                this.this$0 = $receiver;
                this.$queryId = $queryId;
                this.$date = $date;
                this.$metadata = $metadata;
                this.$outputStream = $outputStream;
                super(1);
            }

            @NotNull
            public final AssessmentZipOutputStreamResult invoke(@NotNull AssessmentZipBuilder zip) {
                Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
                InstanceAssessmentZipExporter.access$getAssessmentQueryList$p(this.this$0).addToZip(this.$queryId, this.$date, this.$metadata, zip);
                AssessmentZipBuilder.addJsonToZip$default(zip, InstanceMetadataServiceKt.mapNullFields(this.$metadata), "jira-instance-metadata-" + this.$date + ".jsonl", null, 4, null);
                return new AssessmentZipOutputStreamResult.Success(this.$outputStream);
            }
        }));
    }

    @NotNull
    public final AssessmentZipOutputStreamResult exportExample(@NotNull String date, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        InstanceMetadataDto instanceMetadata = this.instanceMetadataService.exportExampleInstanceDataDto();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new Exporter(string, instanceMetadata, date, true).export(outputStream);
    }

    private final AssessmentZipOutputStreamResult.Failed noRecordsFound(OutputStream outputStream) {
        return new AssessmentZipOutputStreamResult.Failed(outputStream, new AssessmentZipExportFailedException("No records found"), true);
    }

    private final StreamingOutput createCsv(String[] fileHeaders, List<? extends ResponseFileRecord> records, String[] dataMapping) {
        boolean useDataMappingWriter = !(dataMapping.length == 0);
        return arg_0 -> InstanceAssessmentZipExporter.createCsv$lambda$2(fileHeaders, records, useDataMappingWriter, dataMapping, arg_0);
    }

    private final AssessmentZipOutputStreamResult exportWithZip(OutputStream outputStream, String jobId, Function1<? super AssessmentZipBuilder, ? extends AssessmentZipOutputStreamResult> block) {
        try {
            AssessmentZipBuilder zip = this.zipBuilderFactory.createZipBuilder();
            AssessmentZipOutputStreamResult result2 = (AssessmentZipOutputStreamResult)block.invoke((Object)zip);
            if (result2 instanceof AssessmentZipOutputStreamResult.Success) {
                zip.createZip(outputStream);
            }
            return result2;
        }
        catch (Exception e) {
            logger.error("Unable to generate assessment ZIP (jobId: " + jobId + ')', (Throwable)e);
            return new AssessmentZipOutputStreamResult.Failed(outputStream, new AssessmentZipExportFailedException("Failed to generate assessment ZIP file", e), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createCsv$lambda$2(String[] $fileHeaders, List $records, boolean $useDataMappingWriter, String[] $dataMapping, OutputStream it) {
        Intrinsics.checkNotNullParameter((Object)$fileHeaders, (String)"$fileHeaders");
        Intrinsics.checkNotNullParameter((Object)$records, (String)"$records");
        Intrinsics.checkNotNullParameter((Object)$dataMapping, (String)"$dataMapping");
        try {
            Closeable closeable = (Closeable)new CsvBeanWriter((Writer)new OutputStreamWriter(it, StandardCharsets.UTF_8), new CsvPreference.Builder('\"', 44, "\r\n").useEncoder((CsvEncoder)new GuardrailsCsvEncoder()).build());
            Throwable throwable = null;
            try {
                CsvBeanWriter writer = (CsvBeanWriter)closeable;
                boolean bl = false;
                writer.writeHeader(Arrays.copyOf($fileHeaders, $fileHeaders.length));
                Iterable $this$forEach$iv = $records;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ResponseFileRecord record = (ResponseFileRecord)element$iv;
                    boolean bl2 = false;
                    if ($useDataMappingWriter) {
                        writer.write((Object)record.toFileRecord(), Arrays.copyOf($dataMapping, $dataMapping.length));
                        continue;
                    }
                    writer.write((Object)record.toFileRecord(), Arrays.copyOf($fileHeaders, $fileHeaders.length));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw new IOException("Unable to generate CSV file for instance assessment", e);
        }
    }

    public static final /* synthetic */ AssessmentZipOutputStreamResult.Failed access$noRecordsFound(InstanceAssessmentZipExporter $this, OutputStream outputStream) {
        return $this.noRecordsFound(outputStream);
    }

    public static final /* synthetic */ BrowserMetricsService access$getBrowserMetricsService$p(InstanceAssessmentZipExporter $this) {
        return $this.browserMetricsService;
    }

    public static final /* synthetic */ ApiUsageService access$getApiUsageService$p(InstanceAssessmentZipExporter $this) {
        return $this.apiUsageService;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(InstanceAssessmentZipExporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        logger = logger2;
        String[] stringArray = new String[]{"query_item", "query_result", "query_status", "product_name", "product_version", "sen", "server_id", "instance_timezone", "assessment_starting_date", "query_duration", "query_cpu_load"};
        fileHeader = stringArray;
        stringArray = new String[]{"QueryItem", "QueryResult", "QueryStatus", "ProductName", "ProductVersion", "SEN", "ServerId", "InstanceTimezone", "AssessmentStartingDate", "QueryDuration", "QueryCpuLoad"};
        csvMapping = stringArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentZipExporter$Companion;", "", "()V", "NOT_AVAILABLE", "", "csvMapping", "", "getCsvMapping", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fileHeader", "getFileHeader", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final String[] getFileHeader() {
            return fileHeader;
        }

        @NotNull
        public final String[] getCsvMapping() {
            return csvMapping;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentZipExporter$Exporter;", "", "jobId", "", "metadata", "Lcom/atlassian/jira/migration/guardrails/InstanceMetadataDto;", "date", "isExample", "", "(Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentZipExporter;Ljava/lang/String;Lcom/atlassian/jira/migration/guardrails/InstanceMetadataDto;Ljava/lang/String;Z)V", "assessmentDate", "serverId", "createAppAssessmentFiles", "", "Lcom/atlassian/jira/migration/guardrails/FileToZip;", "createGuardrails", "Ljavax/ws/rs/core/StreamingOutput;", "createJESAT", "createUsageMetrics", "export", "Lcom/atlassian/jira/migration/guardrails/AssessmentZipOutputStreamResult;", "outputStream", "Ljava/io/OutputStream;", "exportSeparateAssessmentFiles", "", "zipBuilder", "Lcom/atlassian/jira/migration/guardrails/util/AssessmentZipBuilder;", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nInstanceAssessmentZipExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstanceAssessmentZipExporter.kt\ncom/atlassian/jira/migration/guardrails/InstanceAssessmentZipExporter$Exporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n1194#2,2:344\n1222#2,4:346\n1549#2:350\n1620#2,3:351\n1549#2:354\n1620#2,3:355\n1855#2,2:358\n*S KotlinDebug\n*F\n+ 1 InstanceAssessmentZipExporter.kt\ncom/atlassian/jira/migration/guardrails/InstanceAssessmentZipExporter$Exporter\n*L\n171#1:344,2\n171#1:346,4\n175#1:350\n175#1:351,3\n243#1:354\n243#1:355,3\n268#1:358,2\n*E\n"})
    public final class Exporter {
        @NotNull
        private final String jobId;
        @NotNull
        private final InstanceMetadataDto metadata;
        @NotNull
        private final String date;
        private final boolean isExample;
        @NotNull
        private final String serverId;
        @NotNull
        private final String assessmentDate;

        public Exporter(@NotNull String jobId, @NotNull InstanceMetadataDto metadata, String date, boolean isExample) {
            Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            this.jobId = jobId;
            this.metadata = metadata;
            this.date = date;
            this.isExample = isExample;
            this.serverId = this.metadata.getServerId();
            this.assessmentDate = this.metadata.getAssessmentDate();
        }

        @NotNull
        public final AssessmentZipOutputStreamResult export(@NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            return InstanceAssessmentZipExporter.this.exportWithZip(outputStream, this.jobId, (Function1<? super AssessmentZipBuilder, ? extends AssessmentZipOutputStreamResult>)((Function1)new Function1<AssessmentZipBuilder, AssessmentZipOutputStreamResult>(this, InstanceAssessmentZipExporter.this, outputStream){
                final /* synthetic */ Exporter this$0;
                final /* synthetic */ InstanceAssessmentZipExporter this$1;
                final /* synthetic */ OutputStream $outputStream;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$outputStream = $outputStream;
                    super(1);
                }

                @NotNull
                public final AssessmentZipOutputStreamResult invoke(@NotNull AssessmentZipBuilder zip) {
                    Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
                    StreamingOutput guardrails = Exporter.access$createGuardrails(this.this$0);
                    StreamingOutput jesat = Exporter.access$createJESAT(this.this$0);
                    if (guardrails == null && jesat == null) {
                        return InstanceAssessmentZipExporter.access$noRecordsFound(this.this$1, this.$outputStream);
                    }
                    AssessmentZipBuilder.addToZip$default(zip, guardrails, "jira-entities-" + Exporter.access$getDate$p(this.this$0) + ".csv", null, 4, null);
                    AssessmentZipBuilder.addToZip$default(zip, guardrails, "cloud-database-queries-" + Exporter.access$getDate$p(this.this$0) + ".csv", null, 4, null);
                    AssessmentZipBuilder.addToZip$default(zip, InstanceAssessmentZipExporter.access$getBrowserMetricsService$p(this.this$1).exportBrowserMetrics("jira-browser-metrics-" + Exporter.access$getDate$p(this.this$0), Exporter.access$getServerId$p(this.this$0), Exporter.access$getAssessmentDate$p(this.this$0), Exporter.access$isExample$p(this.this$0)), null, 2, null);
                    AssessmentZipBuilder.addJsonToZip$default(zip, InstanceMetadataServiceKt.mapNullFields(Exporter.access$getMetadata$p(this.this$0)), "jira-instance-metadata-" + Exporter.access$getDate$p(this.this$0) + ".jsonl", null, 4, null);
                    AssessmentZipBuilder.addToZip$default(zip, Exporter.access$createUsageMetrics(this.this$0), "jira-usage-metrics-" + Exporter.access$getDate$p(this.this$0) + ".csv", null, 4, null);
                    AssessmentZipBuilder.addToZip$default(zip, InstanceAssessmentZipExporter.access$getApiUsageService$p(this.this$1).exportApiUsageMetrics("jira-api-usage-" + Exporter.access$getDate$p(this.this$0), Exporter.access$isExample$p(this.this$0)), null, 2, null);
                    Iterable $this$forEach$iv = Exporter.access$createAppAssessmentFiles(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        FileToZip it = (FileToZip)element$iv;
                        boolean bl = false;
                        zip.addToZip(it.getPath(), it.getDirName());
                    }
                    Exporter.access$exportSeparateAssessmentFiles(this.this$0, zip);
                    return new AssessmentZipOutputStreamResult.Success(this.$outputStream);
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        private final StreamingOutput createGuardrails() {
            void $this$mapTo$iv$iv;
            Object object;
            void $this$associateByTo$iv$iv;
            List<GuardrailsResponseFileRecord> list;
            boolean bl = this.isExample;
            if (bl) {
                ResponseType[] responseTypeArray = new ResponseType[]{ResponseType.GUARDRAILS, ResponseType.ALL};
                list = InstanceAssessmentZipExporter.this.examplesFactory.getExampleGuardrailsResponse(SetsKt.setOf((Object[])responseTypeArray), createGuardrails.guardrailsResponse.1.INSTANCE);
            } else if (!bl) {
                list = InstanceAssessmentZipExporter.this.guardrailsResponseRepository.findGuardrailsResponsesForCSV(this.jobId);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List<GuardrailsResponseFileRecord> guardrailsResponse2 = list;
            Iterable $this$associateBy$iv = this.metadata.getProducts();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Object destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                ProductDto productDto = (ProductDto)element$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.put(it.getName(), element$iv$iv);
            }
            Map productsExtracted = destination$iv$iv;
            ProductDto productDto = (ProductDto)productsExtracted.get(ProductName.JIRA_CORE.toString());
            String jiraCoreVersion = productDto != null ? productDto.getVersion() : null;
            ProductDto productDto2 = (ProductDto)productsExtracted.get(ProductName.JIRA_SERVICEDESK.toString());
            String jsmVersion = productDto2 != null ? productDto2.getVersion() : null;
            Iterable $this$map$iv = guardrailsResponse2;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object2;
                String string;
                void it;
                GuardrailsResponseFileRecord bl2 = (GuardrailsResponseFileRecord)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)it.getProductName(), (Object)QueryProductType.JSM.getProductName())) {
                    string = jsmVersion;
                    if (string == null) {
                        string = InstanceAssessmentZipExporter.NOT_AVAILABLE;
                    }
                } else {
                    string = jiraCoreVersion;
                    if (string == null) {
                        string = InstanceAssessmentZipExporter.NOT_AVAILABLE;
                    }
                }
                it.setProductVersion(string);
                if (Intrinsics.areEqual((Object)it.getProductName(), (Object)QueryProductType.JSM.getProductName())) {
                    object2 = (ProductDto)productsExtracted.get(ProductName.JIRA_SERVICEDESK.toString());
                    if (object2 == null || (object2 = ((ProductDto)object2).getSen()) == null) {
                        object2 = InstanceAssessmentZipExporter.NOT_AVAILABLE;
                    }
                } else {
                    object2 = (ProductDto)productsExtracted.get(ProductName.JIRA_CORE.toString());
                    if (object2 == null || (object2 = ((ProductDto)object2).getSen()) == null) {
                        ProductDto productDto3 = (ProductDto)productsExtracted.get(ProductName.JIRA_SOFTWARE.toString());
                        object2 = productDto3 != null ? productDto3.getSen() : null;
                        if (object2 == null) {
                            object2 = InstanceAssessmentZipExporter.NOT_AVAILABLE;
                        }
                    }
                }
                it.setSen((String)object2);
                it.setServerId(this.serverId);
                it.setInstanceTimezone(this.metadata.getInstanceTimezone());
                it.setAssessmentStartingDate(this.assessmentDate);
                object.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv2;
            return guardrailsResponse2.isEmpty() ? null : InstanceAssessmentZipExporter.this.createCsv(Companion.getFileHeader(), guardrailsResponse2, Companion.getCsvMapping());
        }

        private final StreamingOutput createJESAT() {
            List<JESATResponseFileRecord> list;
            String[] stringArray = new String[]{"query_id", "query_response", "success"};
            String[] fileHeaders = stringArray;
            String[] stringArray2 = new String[]{"queryId", "queryResponse", "success"};
            String[] csvMappings = stringArray2;
            boolean bl = this.isExample;
            if (bl) {
                ResponseType[] responseTypeArray = new ResponseType[]{ResponseType.JESAT, ResponseType.ALL};
                list = InstanceAssessmentZipExporter.this.examplesFactory.getExampleGuardrailsResponse(SetsKt.setOf((Object[])responseTypeArray), createJESAT.jesatResponse.1.INSTANCE);
            } else if (!bl) {
                list = InstanceAssessmentZipExporter.this.guardrailsResponseRepository.findJESATResponsesForCSV(this.jobId);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List<JESATResponseFileRecord> jesatResponse2 = list;
            return jesatResponse2.isEmpty() ? null : InstanceAssessmentZipExporter.this.createCsv(fileHeaders, jesatResponse2, csvMappings);
        }

        /*
         * WARNING - void declaration
         */
        private final StreamingOutput createUsageMetrics() {
            void $this$mapTo$iv$iv;
            List<DailyUsageMetricsFileRecord> list;
            String[] stringArray = new String[]{"date", "active_users", "peak_hour_users", "peak_hour_requests", "nodes", "server_id", "assessment_starting_date"};
            String[] fileHeaders = stringArray;
            String[] stringArray2 = new String[]{"MetricsDate", "DailyActiveUsers", "PeakHourlyUsersByDay", "PeakHourlyRequestsByDay", "NodesProcessingJson", "ServerId", "AssessmentStartingDate"};
            String[] dataMapping = stringArray2;
            boolean bl = this.isExample;
            if (bl) {
                list = InstanceAssessmentZipExporter.this.dailyUsageMetricsService.getExampleDailyUsageMetricsForCSV();
            } else if (!bl) {
                InstAnalysisCtrl instAnalysisCtrl = InstanceAssessmentZipExporter.this.instanceAnalysisControlService.findInstanceAnalysisControl("USAGE_METRICS");
                if (instAnalysisCtrl == null) {
                    return null;
                }
                InstAnalysisCtrl instAnalysisCtrl2 = instAnalysisCtrl;
                list = InstanceAssessmentZipExporter.this.dailyUsageMetricsService.findDailyUsageMetricsForCSV(instAnalysisCtrl2.getID());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List<DailyUsageMetricsFileRecord> dailyUsageMetrics = list;
            Iterable $this$map$iv = dailyUsageMetrics;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DailyUsageMetricsFileRecord dailyUsageMetricsFileRecord = (DailyUsageMetricsFileRecord)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                it.setServerId(this.serverId);
                it.setAssessmentStartingDate(this.assessmentDate);
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            return InstanceAssessmentZipExporter.this.createCsv(fileHeaders, dailyUsageMetrics, dataMapping);
        }

        private final List<FileToZip> createAppAssessmentFiles() {
            List<AppResponseFileRecord> list;
            boolean bl = this.isExample;
            if (bl) {
                list = InstanceAssessmentZipExporter.this.examplesFactory.getExampleGuardrailsResponse(SetsKt.setOf((Object)((Object)ResponseType.APP)), createAppAssessmentFiles.appResponses.1.INSTANCE);
            } else if (!bl) {
                list = InstanceAssessmentZipExporter.this.guardrailsResponseRepository.findApplicableAppResponsesForCsv(this.jobId);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List<AppResponseFileRecord> appResponses2 = list;
            return InstanceAssessmentZipExporter.this.appAssessmentService.exportAppAssessments(appResponses2, this.serverId, this.assessmentDate, this.date);
        }

        /*
         * WARNING - void declaration
         */
        private final void exportSeparateAssessmentFiles(AssessmentZipBuilder zipBuilder) {
            void $this$forEach$iv;
            List<Object> list;
            boolean bl = this.isExample;
            if (bl) {
                list = InstanceAssessmentZipExporter.this.examplesFactory.getExampleGuardrailsResponse(SetsKt.setOf((Object)((Object)ResponseType.SEPARATE)), exportSeparateAssessmentFiles.fileResponses.1.INSTANCE);
            } else if (!bl) {
                list = InstanceAssessmentZipExporter.this.guardrailsResponseRepository.findSeparateFileResponses(this.jobId);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List<Object> fileResponses2 = list;
            Iterable iterable = fileResponses2;
            InstanceAssessmentZipExporter instanceAssessmentZipExporter = InstanceAssessmentZipExporter.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SeparateFileResponseRecord it = (SeparateFileResponseRecord)element$iv;
                boolean bl2 = false;
                instanceAssessmentZipExporter.assessmentQueryList.addToZip(it.getQueryId(), this.date, this.metadata, it.getQueryResponse(), zipBuilder);
            }
        }

        public static final /* synthetic */ StreamingOutput access$createGuardrails(Exporter $this) {
            return $this.createGuardrails();
        }

        public static final /* synthetic */ StreamingOutput access$createJESAT(Exporter $this) {
            return $this.createJESAT();
        }

        public static final /* synthetic */ String access$getDate$p(Exporter $this) {
            return $this.date;
        }

        public static final /* synthetic */ String access$getServerId$p(Exporter $this) {
            return $this.serverId;
        }

        public static final /* synthetic */ String access$getAssessmentDate$p(Exporter $this) {
            return $this.assessmentDate;
        }

        public static final /* synthetic */ boolean access$isExample$p(Exporter $this) {
            return $this.isExample;
        }

        public static final /* synthetic */ InstanceMetadataDto access$getMetadata$p(Exporter $this) {
            return $this.metadata;
        }

        public static final /* synthetic */ StreamingOutput access$createUsageMetrics(Exporter $this) {
            return $this.createUsageMetrics();
        }

        public static final /* synthetic */ List access$createAppAssessmentFiles(Exporter $this) {
            return $this.createAppAssessmentFiles();
        }

        public static final /* synthetic */ void access$exportSeparateAssessmentFiles(Exporter $this, AssessmentZipBuilder zipBuilder) {
            $this.exportSeparateAssessmentFiles(zipBuilder);
        }
    }
}

