/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.migration.guardrails.InfrastructureDataService;
import com.atlassian.jira.migration.guardrails.InstanceInfrastructureDto;
import com.atlassian.jira.migration.guardrails.InstanceMetadataDto;
import com.atlassian.jira.migration.guardrails.ProductDto;
import com.atlassian.jira.migration.guardrails.ProductName;
import com.atlassian.jira.migration.guardrails.util.InstantExtensionsKt;
import com.atlassian.jira.migration.metadataaggregator.providers.JiraServerMetadataProvider;
import com.atlassian.jira.migration.sen.JiraSenInfo;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.migration.version.JiraMigrationVersionService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aBG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/guardrails/InstanceMetadataCollector;", "", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "jiraMigrationVersionService", "Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "timeZoneService", "Lcom/atlassian/jira/timezone/TimeZoneService;", "applicationProperties", "Lcom/atlassian/jira/config/properties/ApplicationProperties;", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "infrastructureDataService", "Lcom/atlassian/jira/migration/guardrails/InfrastructureDataService;", "jiraServerMetadataProvider", "Lcom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider;", "(Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/timezone/TimeZoneService;Lcom/atlassian/jira/config/properties/ApplicationProperties;Lcom/atlassian/plugin/PluginAccessor;Lcom/atlassian/jira/migration/guardrails/InfrastructureDataService;Lcom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider;)V", "collectMetadata", "Lcom/atlassian/jira/migration/guardrails/InstanceMetadataDto;", "startTimestamp", "", "collectProductsData", "", "Lcom/atlassian/jira/migration/guardrails/ProductDto;", "Companion", "jira-migration-plugin"})
public final class InstanceMetadataCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final JiraMigrationVersionService jiraMigrationVersionService;
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @NotNull
    private final TimeZoneService timeZoneService;
    @NotNull
    private final ApplicationProperties applicationProperties;
    @NotNull
    private final PluginAccessor pluginAccessor;
    @NotNull
    private final InfrastructureDataService infrastructureDataService;
    @NotNull
    private final JiraServerMetadataProvider jiraServerMetadataProvider;
    @NotNull
    private static final Logger log;
    @NotNull
    public static final String SERVER_ID = "com.atlassian.analytics.client.configuration.serverid";
    @NotNull
    public static final String INSTANCE_UUID = "com.atlassian.analytics.client.configuration.uuid";
    @NotNull
    public static final String JSM_PLUGIN = "com.atlassian.servicedesk";

    @Inject
    public InstanceMetadataCollector(@NotNull SENSupplier senSupplier, @NotNull JiraMigrationVersionService jiraMigrationVersionService, @NotNull JiraAuthenticationContext jiraAuthenticationContext, @NotNull TimeZoneService timeZoneService, @NotNull ApplicationProperties applicationProperties, @NotNull PluginAccessor pluginAccessor, @NotNull InfrastructureDataService infrastructureDataService, @NotNull JiraServerMetadataProvider jiraServerMetadataProvider) {
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)jiraMigrationVersionService, (String)"jiraMigrationVersionService");
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)timeZoneService, (String)"timeZoneService");
        Intrinsics.checkNotNullParameter((Object)applicationProperties, (String)"applicationProperties");
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        Intrinsics.checkNotNullParameter((Object)infrastructureDataService, (String)"infrastructureDataService");
        Intrinsics.checkNotNullParameter((Object)jiraServerMetadataProvider, (String)"jiraServerMetadataProvider");
        this.senSupplier = senSupplier;
        this.jiraMigrationVersionService = jiraMigrationVersionService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.timeZoneService = timeZoneService;
        this.applicationProperties = applicationProperties;
        this.pluginAccessor = pluginAccessor;
        this.infrastructureDataService = infrastructureDataService;
        this.jiraServerMetadataProvider = jiraServerMetadataProvider;
    }

    @NotNull
    public final InstanceMetadataDto collectMetadata(long startTimestamp) {
        log.info("Collecting Instance metadata.");
        String serverID = this.applicationProperties.getText(SERVER_ID);
        String instanceUUID = this.applicationProperties.getText(INSTANCE_UUID);
        TimeZoneInfo instanceDefaultTZ = this.timeZoneService.getDefaultTimeZoneInfo((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()));
        Instant instant = Instant.ofEpochMilli(startTimestamp);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
        ZoneId zoneId = ZoneId.of(instanceDefaultTZ.getTimeZoneId());
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"of(...)");
        String startDateTime = InstantExtensionsKt.toAssessmentDateTimeFormat(instant, zoneId);
        InstanceInfrastructureDto infrastructureData = this.infrastructureDataService.collectData();
        List<ProductDto> products = this.collectProductsData();
        log.info("Instance metadata collected.");
        String string = this.jiraServerMetadataProvider.getJcmaVersion();
        Intrinsics.checkNotNull((Object)serverID);
        Intrinsics.checkNotNull((Object)instanceUUID);
        String string2 = instanceDefaultTZ.getGMTOffset();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getGMTOffset(...)");
        return new InstanceMetadataDto(products, infrastructureData, string, serverID, instanceUUID, StringsKt.removeSurrounding((String)string2, (CharSequence)"(", (CharSequence)")"), startDateTime, this.jiraServerMetadataProvider.getServerBaseUrl());
    }

    private final List<ProductDto> collectProductsData() {
        Plugin plugin;
        Plugin plugin2;
        JiraSenInfo sen = this.senSupplier.getSens();
        ProductDto jiraCore = new ProductDto(ProductName.JIRA_CORE.toString(), this.jiraMigrationVersionService.getJiraServerVersion(), sen.getJiraCoreSen());
        ProductDto jiraSoftware = new ProductDto(ProductName.JIRA_SOFTWARE.toString(), (plugin2 = this.pluginAccessor.getPlugin("com.pyxis.greenhopper.jira")) != null && (plugin2 = plugin2.getPluginInformation()) != null ? plugin2.getVersion() : null, sen.getJiraSoftwareSen());
        ProductDto jiraServicedesk = new ProductDto(ProductName.JIRA_SERVICEDESK.toString(), (plugin = this.pluginAccessor.getPlugin(JSM_PLUGIN)) != null && (plugin = plugin.getPluginInformation()) != null ? plugin.getVersion() : null, sen.getJiraServicedeskSen());
        Object[] objectArray = new ProductDto[]{jiraCore, jiraSoftware, jiraServicedesk};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(InstanceMetadataCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/guardrails/InstanceMetadataCollector$Companion;", "", "()V", "INSTANCE_UUID", "", "JSM_PLUGIN", "SERVER_ID", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

