/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.guardrails.FileToZip;
import com.atlassian.jira.migration.guardrails.queries.App;
import com.atlassian.jira.migration.guardrails.queries.AppType;
import com.atlassian.jira.migration.guardrails.queries.QueryProductType;
import com.atlassian.jira.migration.guardrails.queries.apps.AppUsageService;
import com.atlassian.jira.migration.guardrails.repository.AppResponseFileRecord;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ2\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013J\"\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u001c\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u001dH\u0002J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0002J6\u0010 \u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J$\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00132\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u001dH\u0002J0\u0010&\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0015\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/atlassian/jira/migration/guardrails/PresaleAppAssessmentService;", "", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "features", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "appUsageService", "Lcom/atlassian/jira/migration/guardrails/queries/apps/AppUsageService;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/guardrails/queries/apps/AppUsageService;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "exportAppAssessments", "", "Lcom/atlassian/jira/migration/guardrails/FileToZip;", "appAssessments", "Lcom/atlassian/jira/migration/guardrails/repository/AppResponseFileRecord;", "serverId", "", "assessmentStartingDate", "date", "getFileName", "appName", "appMetadata", "Lcom/atlassian/jira/migration/guardrails/queries/App;", "hasNoData", "", "assessmentMap", "", "parseQueryResponse", "queryResponse", "writeAppSpecificDataToJsonl", "presaleAppAssessments", "writeJsonl", "Ljava/nio/file/Path;", "fileName", "data", "writeUserInstalledAppDataToJsonl", "assessments", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPresaleAppAssessmentService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PresaleAppAssessmentService.kt\ncom/atlassian/jira/migration/guardrails/PresaleAppAssessmentService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,142:1\n766#2:143\n857#2,2:144\n1477#2:146\n1502#2,3:147\n1505#2,3:157\n1179#2,2:164\n1253#2,4:166\n1179#2,2:170\n1253#2,4:172\n372#3,7:150\n526#3:176\n511#3,6:177\n125#4:160\n152#4,3:161\n*S KotlinDebug\n*F\n+ 1 PresaleAppAssessmentService.kt\ncom/atlassian/jira/migration/guardrails/PresaleAppAssessmentService\n*L\n41#1:143\n41#1:144,2\n42#1:146\n42#1:147,3\n42#1:157,3\n63#1:164,2\n63#1:166,4\n91#1:170,2\n91#1:172,4\n42#1:150,7\n109#1:176\n109#1:177,6\n43#1:160\n43#1:161,3\n*E\n"})
public final class PresaleAppAssessmentService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final MigrationFeatures features;
    @NotNull
    private final AppUsageService appUsageService;
    @NotNull
    private final ObjectMapperFactory objectMapperFactory;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private static final Logger log;

    @Inject
    public PresaleAppAssessmentService(@NotNull LocalFileDataOutput localFileDataOutput, @NotNull MigrationFeatures features, @NotNull AppUsageService appUsageService, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)features, (String)"features");
        Intrinsics.checkNotNullParameter((Object)appUsageService, (String)"appUsageService");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.localFileDataOutput = localFileDataOutput;
        this.features = features;
        this.appUsageService = appUsageService;
        this.objectMapperFactory = objectMapperFactory;
        this.objectMapper = this.objectMapperFactory.createObjectMapper();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FileToZip> exportAppAssessments(@NotNull List<AppResponseFileRecord> appAssessments, @NotNull String serverId, @NotNull String assessmentStartingDate, @NotNull String date) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        AppResponseFileRecord it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(appAssessments, (String)"appAssessments");
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        Intrinsics.checkNotNullParameter((Object)assessmentStartingDate, (String)"assessmentStartingDate");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (!this.features.getCollectL1Metrics() || appAssessments.isEmpty()) {
            log.info("No app assessments to export.");
            return CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = appAssessments;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AppResponseFileRecord)element$iv$iv;
            boolean bl = false;
            if (!it.getSuccess()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (AppResponseFileRecord)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getQueryProductType().getProductName();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            String appName = (String)entry.getKey();
            List assessments = (List)entry.getValue();
            object.add(Intrinsics.areEqual((Object)appName, (Object)QueryProductType.ALL_APPS.getProductName()) ? this.writeUserInstalledAppDataToJsonl(serverId, assessmentStartingDate, assessments, date) : this.writeAppSpecificDataToJsonl(serverId, assessmentStartingDate, assessments, appName, date));
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final FileToZip writeAppSpecificDataToJsonl(String serverId, String assessmentStartingDate, List<AppResponseFileRecord> presaleAppAssessments, String appName, String date) {
        void $this$associateTo$iv$iv;
        log.info("Exporting App Assessments for " + appName + '.');
        App appMetadata = AppUsageService.Companion.getPluginMetadataFromName(appName);
        String fileName = this.getFileName(appName, date, appMetadata);
        Iterable $this$associate$iv = presaleAppAssessments;
        boolean $i$f$associate22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            AppResponseFileRecord it = (AppResponseFileRecord)element$iv$iv;
            boolean bl = false;
            String string = it.getQueryId();
            Object object = this.parseQueryResponse(it.getQueryResponse());
            if (object == null) {
                object = "";
            }
            Pair pair = TuplesKt.to((Object)string, (Object)object);
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map assessmentMap = destination$iv$iv;
        Pair[] $i$f$associate22 = new Pair[]{TuplesKt.to((Object)"serverId", (Object)serverId), TuplesKt.to((Object)"assessmentStartingDate", (Object)assessmentStartingDate), TuplesKt.to((Object)"name", (Object)appName), TuplesKt.to((Object)"version", (Object)this.appUsageService.getPluginVersionFromName(appName)), TuplesKt.to((Object)"type", (Object)AppUsageService.Companion.getPluginTypeFromName(appName)), TuplesKt.to((Object)"appAssessment", (Object)assessmentMap)};
        Map resultObject = MapsKt.mapOf((Pair[])$i$f$associate22);
        Path filePath = this.writeJsonl(fileName, resultObject);
        log.info(appName + " Assessments exported.");
        App app = appMetadata;
        return new FileToZip(filePath, (app != null ? app.getAppType() : null) == AppType.SYSTEM_APP ? null : "Apps");
    }

    private final String getFileName(String appName, String date, App appMetadata) {
        String string;
        App app = appMetadata;
        if ((app == null ? -1 : WhenMappings.$EnumSwitchMapping$0[app.ordinal()]) == 1) {
            string = "jira-automation-" + date + ".jsonl";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = appName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            string = stringBuilder.append(StringsKt.replace$default((String)string2, (String)" ", (String)"-", (boolean)false, (int)4, null)).append('-').append(date).append(".jsonl").toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final FileToZip writeUserInstalledAppDataToJsonl(String serverId, String assessmentStartingDate, List<AppResponseFileRecord> assessments, String date) {
        void $this$associateTo$iv$iv;
        log.info("Exporting User-installed Apps Assessments.");
        String fileName = "user-installed-apps-" + date + ".jsonl";
        Iterable $this$associate$iv = assessments;
        boolean $i$f$associate22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            AppResponseFileRecord it = (AppResponseFileRecord)element$iv$iv;
            boolean bl = false;
            String string = it.getQueryId();
            Object object = this.parseQueryResponse(it.getQueryResponse());
            if (object == null) {
                object = "";
            }
            Pair pair = TuplesKt.to((Object)string, (Object)object);
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map assessmentMap = destination$iv$iv;
        if (this.hasNoData(assessmentMap)) {
            log.info("User-installed Apps Assessments skipped - no apps available installed.");
            return null;
        }
        Pair[] $i$f$associate22 = new Pair[]{TuplesKt.to((Object)"serverId", (Object)serverId), TuplesKt.to((Object)"assessmentStartingDate", (Object)assessmentStartingDate), TuplesKt.to((Object)"appAssessment", (Object)assessmentMap)};
        Map resultObject = MapsKt.mapOf((Pair[])$i$f$associate22);
        Path jsonPathFile = this.writeJsonl(fileName, resultObject);
        log.info("User-installed Apps Assessments exported.");
        return new FileToZip(jsonPathFile, "Apps");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasNoData(Map<String, ? extends Object> assessmentMap) {
        void $this$filterTo$iv$iv;
        Map<String, ? extends Object> $this$filter$iv = assessmentMap;
        boolean $i$f$filter = false;
        Map<String, ? extends Object> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((CharSequence)it.getValue().toString()).length() > 0 && !Intrinsics.areEqual((Object)it.getValue().toString(), (Object)"[]"))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path writeJsonl(String fileName, Map<String, ? extends Object> data2) {
        Path jsonPathFile = this.localFileDataOutput.exportDirectory().resolve(fileName);
        Closeable closeable = new BufferedWriter(Files.newBufferedWriter(jsonPathFile, StandardCharsets.UTF_8, new OpenOption[0]));
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)closeable;
            boolean bl = false;
            String jsonData = this.objectMapper.writeValueAsString(data2);
            writer.write(jsonData);
            writer.newLine();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNull((Object)jsonPathFile);
        return jsonPathFile;
    }

    private final Object parseQueryResponse(String queryResponse) {
        Object object;
        try {
            if (queryResponse == null) {
                return null;
            }
            Integer n = StringsKt.toIntOrNull((String)StringsKt.removeSurrounding((String)queryResponse, (CharSequence)"\""));
            if (n == null) {
                n = this.objectMapper.readTree(queryResponse);
            }
            object = n;
        }
        catch (JsonProcessingException e) {
            object = queryResponse;
        }
        return object;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(PresaleAppAssessmentService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/guardrails/PresaleAppAssessmentService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[App.values().length];
            try {
                nArray[App.A4J.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

