/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.guardrails.AccessLogProcessingControlService;
import com.atlassian.jira.migration.guardrails.AccessLogProcessingItemService;
import com.atlassian.jira.migration.guardrails.DailyUsageMetricsService;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentServiceKt;
import com.atlassian.jira.migration.guardrails.UsageMetricsPersistenceJobRunner;
import com.atlassian.jira.migration.guardrails.UsageMetricsPersistenceParams;
import com.atlassian.jira.migration.guardrails.apiUsage.ApiUsageService;
import com.atlassian.jira.migration.guardrails.model.DailyUsageMetricsDto;
import com.atlassian.jira.migration.guardrails.model.DataCollectionStatus;
import com.atlassian.jira.migration.guardrails.model.NodeStatus;
import com.atlassian.jira.migration.guardrails.model.UsageMetricsNodeJsonDto;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingControl;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingItem;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingItemStatus;
import com.atlassian.jira.migration.guardrails.repository.InstAnalysisCtrl;
import com.atlassian.jira.migration.guardrails.repository.InstanceAnalysisControlRepository;
import com.atlassian.jira.migration.guardrails.repository.InstanceAnalysisControlRepositoryKt;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 K2\u00020\u0001:\u0001KBO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0014\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020'0&H\u0002J\u0012\u0010(\u001a\u00020 2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010+\u001a\u00020*2\u0006\u0010#\u001a\u00020$H\u0002JL\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0018002\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u000203\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001800022\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020302H\u0002J\b\u00105\u001a\u00020 H\u0007J\b\u00106\u001a\u00020 H\u0007J\u0010\u00107\u001a\u00020 2\u0006\u00108\u001a\u000209H\u0002JY\u0010:\u001a8\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u000203\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001800\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u000203020;2\u0006\u0010<\u001a\u00020\u00182\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u00a2\u0006\u0002\u0010>J\u0010\u0010?\u001a\u00020 2\u0006\u00108\u001a\u000209H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020CH\u0016J&\u0010D\u001a\u00020 2\u0006\u0010E\u001a\u00020F2\u0016\b\u0002\u0010G\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020H\u0018\u00010&J\u0012\u0010I\u001a\u00020*2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0006\u0010J\u001a\u00020 R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/atlassian/jira/migration/guardrails/UsageMetricsPersistenceJobRunner;", "Lcom/atlassian/scheduler/JobRunner;", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "instanceAnalysisControlRepository", "Lcom/atlassian/jira/migration/guardrails/repository/InstanceAnalysisControlRepository;", "accessLogProcessingControlService", "Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingControlService;", "accessLogProcessingItemService", "Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingItemService;", "dailyUsageMetricsService", "Lcom/atlassian/jira/migration/guardrails/DailyUsageMetricsService;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "apiUsageService", "Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageService;", "(Lcom/atlassian/jira/cluster/ClusterManager;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/migration/guardrails/repository/InstanceAnalysisControlRepository;Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingControlService;Lcom/atlassian/jira/migration/guardrails/AccessLogProcessingItemService;Lcom/atlassian/jira/migration/guardrails/DailyUsageMetricsService;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageService;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "convertAccessLogPrcItemStatusToDataCollectionStatus", "", "item", "Lcom/atlassian/jira/migration/guardrails/repository/AccessLogProcessingItemStatus;", "defineCellProcessors", "", "Lorg/supercsv/cellprocessor/ift/CellProcessor;", "()[Lorg/supercsv/cellprocessor/ift/CellProcessor;", "generateUsageMetricsForSpecificDate", "", "dateBeingProcessed", "Ljava/time/LocalDate;", "instAnalysisCtrl", "Lcom/atlassian/jira/migration/guardrails/repository/InstAnalysisCtrl;", "getNodeDirectoryMap", "", "Ljava/io/File;", "handleAccessLogWithQuickAssessments", "hasAccessLogCollectionFinished", "", "hasAccessLogTimeWindowCollectionClosed", "persistUsageMetrics", "usageMetricDto", "Lcom/atlassian/jira/migration/guardrails/model/DailyUsageMetricsDto;", "activeUsers", "", "hourlyDistinctUserSets", "", "", "combinedHourlyRequests", "postConstruct", "preDestroy", "processAccessLogProcessingItem", "params", "Lcom/atlassian/jira/migration/guardrails/UsageMetricsPersistenceParams;", "processCsvFile", "Lkotlin/Triple;", "csvFilePath", "processors", "(Ljava/lang/String;[Lorg/supercsv/cellprocessor/ift/CellProcessor;)Lkotlin/Triple;", "processNodeDirectories", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "request", "Lcom/atlassian/scheduler/JobRunnerRequest;", "schedule", "assessmentDuration", "Ljava/time/Duration;", "parameters", "Ljava/io/Serializable;", "shouldRunJob", "unschedule", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUsageMetricsPersistenceJobRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsageMetricsPersistenceJobRunner.kt\ncom/atlassian/jira/migration/guardrails/UsageMetricsPersistenceJobRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,354:1\n1549#2:355\n1620#2,3:356\n1238#2,4:380\n18#3:359\n26#4:360\n215#5:361\n216#5:369\n215#5,2:370\n372#6,7:362\n453#6:378\n403#6:379\n372#6,7:385\n8541#7,2:372\n8801#7,4:374\n1#8:384\n*S KotlinDebug\n*F\n+ 1 UsageMetricsPersistenceJobRunner.kt\ncom/atlassian/jira/migration/guardrails/UsageMetricsPersistenceJobRunner\n*L\n125#1:355\n125#1:356,3\n286#1:380,4\n219#1:359\n219#1:360\n242#1:361\n242#1:369\n246#1:370,2\n243#1:362,7\n286#1:378\n286#1:379\n327#1:385,7\n263#1:372,2\n263#1:374,4\n*E\n"})
public final class UsageMetricsPersistenceJobRunner
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClusterManager clusterManager;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final InstanceAnalysisControlRepository instanceAnalysisControlRepository;
    @NotNull
    private final AccessLogProcessingControlService accessLogProcessingControlService;
    @NotNull
    private final AccessLogProcessingItemService accessLogProcessingItemService;
    @NotNull
    private final DailyUsageMetricsService dailyUsageMetricsService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ApiUsageService apiUsageService;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final JobRunnerKey JOB_RUNNER_KEY;
    @NotNull
    private static final JobId JOB_ID;

    @Inject
    public UsageMetricsPersistenceJobRunner(@NotNull ClusterManager clusterManager, @NotNull SchedulerService schedulerService, @NotNull InstanceAnalysisControlRepository instanceAnalysisControlRepository, @NotNull AccessLogProcessingControlService accessLogProcessingControlService, @NotNull AccessLogProcessingItemService accessLogProcessingItemService, @NotNull DailyUsageMetricsService dailyUsageMetricsService, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull MigrationFeatures migrationFeatures, @NotNull ApiUsageService apiUsageService) {
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)instanceAnalysisControlRepository, (String)"instanceAnalysisControlRepository");
        Intrinsics.checkNotNullParameter((Object)accessLogProcessingControlService, (String)"accessLogProcessingControlService");
        Intrinsics.checkNotNullParameter((Object)accessLogProcessingItemService, (String)"accessLogProcessingItemService");
        Intrinsics.checkNotNullParameter((Object)dailyUsageMetricsService, (String)"dailyUsageMetricsService");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)apiUsageService, (String)"apiUsageService");
        this.clusterManager = clusterManager;
        this.schedulerService = schedulerService;
        this.instanceAnalysisControlRepository = instanceAnalysisControlRepository;
        this.accessLogProcessingControlService = accessLogProcessingControlService;
        this.accessLogProcessingItemService = accessLogProcessingItemService;
        this.dailyUsageMetricsService = dailyUsageMetricsService;
        this.migrationFeatures = migrationFeatures;
        this.apiUsageService = apiUsageService;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @PostConstruct
    public final void postConstruct() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
    }

    @PreDestroy
    public final void preDestroy() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    public final void schedule(@NotNull Duration assessmentDuration, @Nullable Map<String, ? extends Serializable> parameters) {
        Intrinsics.checkNotNullParameter((Object)assessmentDuration, (String)"assessmentDuration");
        Duration delay = (Duration)ComparisonsKt.minOf((Comparable)assessmentDuration.dividedBy(2L), (Comparable)Duration.ofHours(1L));
        SchedulerService $this$schedule_u24lambda_u240 = this.schedulerService;
        boolean bl = false;
        $this$schedule_u24lambda_u240.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters(parameters).withSchedule(Schedule.forInterval((long)TimeUnit.HOURS.toMillis(1L), (Date)Date.from(Instant.now().plus(delay)))));
    }

    public static /* synthetic */ void schedule$default(UsageMetricsPersistenceJobRunner usageMetricsPersistenceJobRunner, Duration duration, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        usageMetricsPersistenceJobRunner.schedule(duration, map);
    }

    public final void unschedule() {
        this.schedulerService.unscheduleJob(JOB_ID);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        JobRunnerResponse jobRunnerResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            void $this$mapTo$iv$iv;
            ApiUsageService.SaveSession saveSession;
            log.info("Running job - jobId: " + request.getJobId() + " - nodeId: " + InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager));
            long startTimestamp = System.currentTimeMillis();
            InstAnalysisCtrl instAnalysisCtrl = this.instanceAnalysisControlRepository.findInstanceAnalysisControl("USAGE_METRICS");
            this.handleAccessLogWithQuickAssessments(instAnalysisCtrl);
            if (!this.shouldRunJob(instAnalysisCtrl)) {
                log.info("Usage metrics collection is not in progress or still ongoing, ignoring job.");
                return JobRunnerResponse.success((String)request.getJobId().toString());
            }
            if (this.migrationFeatures.getEnableApiUsageAssessment()) {
                InstAnalysisCtrl instAnalysisCtrl2 = instAnalysisCtrl;
                Intrinsics.checkNotNull((Object)instAnalysisCtrl2);
                saveSession = this.apiUsageService.newSaveSession(instAnalysisCtrl2);
            } else {
                saveSession = null;
            }
            ApiUsageService.SaveSession saveSession2 = saveSession;
            LocalDate now = LocalDate.now();
            Iterable $this$map$iv = (Iterable)new IntRange(1, 14);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(now.minus((long)it, ChronoUnit.DAYS));
            }
            List datesFrom14DaysAgoList = (List)destination$iv$iv;
            for (LocalDate dateBeingProcessed : datesFrom14DaysAgoList) {
                InstAnalysisCtrl instAnalysisCtrl3 = instAnalysisCtrl;
                Intrinsics.checkNotNull((Object)instAnalysisCtrl3);
                this.generateUsageMetricsForSpecificDate(dateBeingProcessed, instAnalysisCtrl3);
                ApiUsageService.SaveSession saveSession3 = saveSession2;
                if (saveSession3 == null) continue;
                saveSession3.generateApiUsageMetricsForSpecificDate(dateBeingProcessed);
            }
            InstAnalysisCtrl instAnalysisCtrl4 = instAnalysisCtrl;
            Intrinsics.checkNotNull((Object)instAnalysisCtrl4);
            instAnalysisCtrl4.setEndTimestamp(System.currentTimeMillis());
            this.instanceAnalysisControlRepository.updateInstanceAnalysisControl(instAnalysisCtrl);
            log.info("Finalizing usage metrics persistence - time taken: " + (System.currentTimeMillis() - startTimestamp) + "ms");
            jobRunnerResponse = JobRunnerResponse.success((String)request.getJobId().toString());
        }
        catch (Throwable e) {
            String errorMessage2 = "Failed to run job - jobId: " + request.getJobId() + " - nodeId: " + InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager) + " - " + e.getMessage();
            log.error(errorMessage2, e);
            jobRunnerResponse = JobRunnerResponse.failed((String)errorMessage2);
        }
        return jobRunnerResponse;
    }

    private final void handleAccessLogWithQuickAssessments(InstAnalysisCtrl instAnalysisCtrl) {
        block3: {
            if (!this.migrationFeatures.getQuickAssessment()) {
                return;
            }
            Instant startTime = Instant.now();
            InstAnalysisCtrl instAnalysisCtrl2 = instAnalysisCtrl;
            if (instAnalysisCtrl2 == null) break block3;
            InstAnalysisCtrl $this$handleAccessLogWithQuickAssessments_u24lambda_u242 = instAnalysisCtrl2;
            boolean bl = false;
            while (!this.hasAccessLogTimeWindowCollectionClosed($this$handleAccessLogWithQuickAssessments_u24lambda_u242) && !this.hasAccessLogCollectionFinished($this$handleAccessLogWithQuickAssessments_u24lambda_u242)) {
                if (Duration.between(startTime, Instant.now()).compareTo(Duration.ofMinutes(5L)) > 0) {
                    log.warn("Timeout reached while waiting for access log collection to finish.");
                    break;
                }
                TimeUnit.SECONDS.sleep(1L);
            }
        }
    }

    private final boolean shouldRunJob(InstAnalysisCtrl instAnalysisCtrl) {
        return instAnalysisCtrl != null && !InstanceAnalysisControlRepositoryKt.isFinished(instAnalysisCtrl) && (this.hasAccessLogCollectionFinished(instAnalysisCtrl) || this.hasAccessLogTimeWindowCollectionClosed(instAnalysisCtrl));
    }

    private final void generateUsageMetricsForSpecificDate(LocalDate dateBeingProcessed, InstAnalysisCtrl instAnalysisCtrl) {
        log.info("UsageMetricsPersistenceJobRunner - processing collected data from: " + dateBeingProcessed);
        Date date = Date.from(dateBeingProcessed.atStartOfDay(ZoneId.systemDefault()).toInstant());
        Intrinsics.checkNotNull((Object)date);
        DailyUsageMetricsDto usageMetricDto = this.dailyUsageMetricsService.findOrCreateUsageMetrics(date, instAnalysisCtrl);
        try {
            Map combinedHourlyUsers = new LinkedHashMap();
            Set combinedActiveUsers = new LinkedHashSet();
            Map combinedHourlyRequests = new LinkedHashMap();
            UsageMetricsPersistenceParams params = new UsageMetricsPersistenceParams(dateBeingProcessed, combinedHourlyUsers, combinedActiveUsers, combinedHourlyRequests, instAnalysisCtrl, null, null, null, 224, null);
            this.processNodeDirectories(params);
            log.info("UsageMetricsPersistenceJobRunner - combinedHourlyUsers size: " + combinedHourlyUsers.size());
            log.info("UsageMetricsPersistenceJobRunner - combinedActiveUsers size: " + combinedActiveUsers.size());
            log.info("UsageMetricsPersistenceJobRunner - combinedHourlyRequests size: " + combinedHourlyRequests.values().size());
            String string = this.objectMapper.writeValueAsString(params.getNodeJsonDtoList());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            usageMetricDto.setNodesProcessingJson(string);
            this.persistUsageMetrics(usageMetricDto, combinedActiveUsers, combinedHourlyUsers, combinedHourlyRequests);
        }
        catch (Throwable e) {
            log.error("Failed to generate usage metrics for date: " + date, e);
        }
    }

    private final boolean hasAccessLogCollectionFinished(InstAnalysisCtrl instAnalysisCtrl) {
        return this.accessLogProcessingControlService.countControlNotYetFinished(instAnalysisCtrl) == 0;
    }

    private final boolean hasAccessLogTimeWindowCollectionClosed(InstAnalysisCtrl instAnalysisCtrl) {
        Duration elapsed = Duration.between(Instant.ofEpochMilli(instAnalysisCtrl.getStartTimestamp()), Instant.now());
        Duration taskDuration = Duration.ofHours(20L);
        Duration duration = (Duration)RangesKt.coerceAtLeast((Comparable)taskDuration.minus(elapsed), (Comparable)Duration.ZERO);
        return duration.isZero() || duration.isNegative();
    }

    private final void processNodeDirectories(UsageMetricsPersistenceParams params) {
        AccessLogProcessingItem[] accessLogProcessingControlList = this.accessLogProcessingItemService.findByInstAnalysysCtrlAndDate(params.getInstAnalysisCtrl(), params.getDateBeingProcessed());
        params.setNodeDirMap(this.getNodeDirectoryMap());
        params.setNodeJsonDtoList(new ArrayList());
        AccessLogProcessingItem[] $this$orEmpty$iv = accessLogProcessingControlList;
        boolean $i$f$orEmpty = false;
        AccessLogProcessingItem[] accessLogProcessingItemArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            boolean $i$f$emptyArray = false;
            accessLogProcessingItemArray = new AccessLogProcessingItem[]{};
        }
        for (AccessLogProcessingItem accessLogPrcItem : accessLogProcessingItemArray) {
            params.setAccessLogPrcItem(accessLogPrcItem);
            this.processAccessLogProcessingItem(params);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processAccessLogProcessingItem(UsageMetricsPersistenceParams params) {
        AccessLogProcessingItem accessLogProcessingItem = params.getAccessLogPrcItem();
        Intrinsics.checkNotNull((Object)accessLogProcessingItem);
        AccessLogProcessingItem accessLogPrcItem = accessLogProcessingItem;
        AccessLogProcessingControl accessLogPrcCtrl = accessLogPrcItem.getAccessLogProcCtrl();
        File nodeDir = params.getNodeDirMap().get(accessLogPrcCtrl.getNode());
        String nodeStatus = accessLogPrcItem.getStatus() != AccessLogProcessingItemStatus.SCHEDULED ? NodeStatus.AVAILABLE.getValue() : NodeStatus.UNAVAILABLE.getValue();
        String dataCollectionStatus = this.convertAccessLogPrcItemStatusToDataCollectionStatus(accessLogPrcItem.getStatus());
        if (nodeDir != null) {
            int hour;
            Map.Entry entry;
            Map.Entry element$iv;
            LocalDate localDate = params.getDateBeingProcessed();
            String string = nodeDir.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String csvFilePath = this.dailyUsageMetricsService.getDailyTrafficByHourFilePath(localDate, string);
            CellProcessor[] processors = this.defineCellProcessors();
            Triple<Map<Integer, Set<String>>, Set<String>, Map<Integer, Integer>> triple = this.processCsvFile(csvFilePath, processors);
            Map hourlyUsers = (Map)triple.component1();
            Set activeUsers = (Set)triple.component2();
            Map hourlyRequestsCount = (Map)triple.component3();
            Map $this$forEach$iv = hourlyUsers;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object;
                void $this$getOrPut$iv;
                entry = element$iv = iterator2.next();
                boolean bl = false;
                hour = ((Number)entry.getKey()).intValue();
                Set userSet = (Set)entry.getValue();
                Map<Integer, Set<String>> map = params.getCombinedHourlyUsers();
                Integer key$iv = hour;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).addAll(userSet);
            }
            params.getCombinedActiveUsers().addAll(activeUsers);
            $this$forEach$iv = hourlyRequestsCount;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry = element$iv = iterator2.next();
                boolean bl = false;
                hour = ((Number)entry.getKey()).intValue();
                int requestCount = ((Number)entry.getValue()).intValue();
                params.getCombinedHourlyRequests().merge(hour, requestCount, (arg_0, arg_1) -> UsageMetricsPersistenceJobRunner.processAccessLogProcessingItem$lambda$6$lambda$5(processAccessLogProcessingItem.2.1.INSTANCE, arg_0, arg_1));
            }
        }
        params.getNodeJsonDtoList().add(new UsageMetricsNodeJsonDto(accessLogPrcCtrl.getNode(), dataCollectionStatus, nodeStatus));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, File> getNodeDirectoryMap() {
        Map map;
        String parentDirPath = this.dailyUsageMetricsService.getUsageMetricsParentFolder();
        File[] fileArray = new File(parentDirPath).listFiles(UsageMetricsPersistenceJobRunner::getNodeDirectoryMap$lambda$7);
        if (fileArray != null) {
            void $this$associateByTo$iv$iv;
            File[] $this$associateBy$iv = fileArray;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            File[] fileArray2 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void element$iv$iv;
                void var12_12 = element$iv$iv = $this$associateByTo$iv$iv[i];
                Map map2 = destination$iv$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                map2.put(string, element$iv$iv);
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private final String convertAccessLogPrcItemStatusToDataCollectionStatus(AccessLogProcessingItemStatus item) {
        return item.isFailedOrScheduledStatus() ? DataCollectionStatus.FAILED.getValue() : (item.isMissingFileStatus() ? DataCollectionStatus.MISSING_FILE.getValue() : DataCollectionStatus.COMPLETE.getValue());
    }

    /*
     * WARNING - void declaration
     */
    private final void persistUsageMetrics(DailyUsageMetricsDto usageMetricDto, Set<String> activeUsers, Map<Integer, Set<String>> hourlyDistinctUserSets, Map<Integer, Integer> combinedHourlyRequests) {
        if (!((Collection)activeUsers).isEmpty()) {
            Comparable comparable;
            Comparable comparable2;
            void $this$mapValuesTo$iv$iv;
            Map<Integer, Set<String>> $this$mapValues$iv = hourlyDistinctUserSets;
            boolean $i$f$mapValues = false;
            Map<Integer, Set<String>> map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                Integer n = ((Set)it.getValue()).size();
                map3.put(k, n);
            }
            Map hourlyUsersCount = destination$iv$iv;
            Iterator iterator2 = ((Iterable)hourlyUsersCount.entrySet()).iterator();
            if (!iterator2.hasNext()) {
                comparable2 = null;
            } else {
                Map.Entry it = (Map.Entry)iterator2.next();
                boolean bl = false;
                Object object = ((Number)it.getValue()).intValue();
                while (iterator2.hasNext()) {
                    Object it2 = (Map.Entry)iterator2.next();
                    $i$a$-maxOfOrNull-UsageMetricsPersistenceJobRunner$persistUsageMetrics$peakHourlyUsers$1 = false;
                    if (object.compareTo(it2 = (Comparable)Integer.valueOf(((Number)it2.getValue()).intValue())) >= 0) continue;
                    object = it2;
                }
                comparable2 = object;
            }
            Integer n = (Integer)comparable2;
            int peakHourlyUsers = n != null ? n : 0;
            Iterator iterator3 = ((Iterable)combinedHourlyRequests.entrySet()).iterator();
            if (!iterator3.hasNext()) {
                comparable = null;
            } else {
                Map.Entry it = (Map.Entry)iterator3.next();
                boolean bl = false;
                Comparable comparable3 = Integer.valueOf(((Number)it.getValue()).intValue());
                while (iterator3.hasNext()) {
                    Map.Entry it3 = (Map.Entry)iterator3.next();
                    $i$a$-maxOfOrNull-UsageMetricsPersistenceJobRunner$persistUsageMetrics$peakHourlyRequests$1 = false;
                    Comparable comparable4 = Integer.valueOf(((Number)it3.getValue()).intValue());
                    if (comparable3.compareTo(comparable4) >= 0) continue;
                    comparable3 = comparable4;
                }
                comparable = comparable3;
            }
            Integer n2 = (Integer)comparable;
            int peakHourlyRequests = n2 != null ? n2 : 0;
            usageMetricDto.setDailyActiveUsers(activeUsers.size());
            usageMetricDto.setPeakHourlyUsersByDay(peakHourlyUsers);
            usageMetricDto.setPeakHourlyRequestsByDay(peakHourlyRequests);
            log.info("Successfully registered Usage Metrics row [" + usageMetricDto + "].");
        } else {
            log.info("User traffic file is empty, ignoring job.");
        }
        this.dailyUsageMetricsService.recordDailyUsageMetrics(usageMetricDto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Triple<Map<Integer, Set<String>>, Set<String>, Map<Integer, Integer>> processCsvFile(String csvFilePath, CellProcessor[] processors) {
        Map hourlyUsersCount = new LinkedHashMap();
        Set activeUsers = new LinkedHashSet();
        Map hourlyRequestsCount = new LinkedHashMap();
        if (!new File(csvFilePath).exists()) {
            log.info("File " + csvFilePath + " does not exist, ignoring.");
            return new Triple((Object)hourlyUsersCount, (Object)activeUsers, (Object)hourlyRequestsCount);
        }
        log.info("Processing file " + csvFilePath);
        Closeable closeable = (Closeable)new CsvListReader((Reader)new FileReader(csvFilePath), CsvPreference.STANDARD_PREFERENCE);
        Throwable throwable = null;
        try {
            CsvListReader listReader = (CsvListReader)closeable;
            boolean bl = false;
            List row = null;
            while (true) {
                Object object;
                void $this$getOrPut$iv;
                List list;
                List it = list = listReader.read(Arrays.copyOf(processors, processors.length));
                boolean bl2 = false;
                row = it;
                if (list == null) break;
                List list2 = row;
                Intrinsics.checkNotNull((Object)list2);
                Object e = list2.get(0);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
                String dateTimeString = (String)e;
                String hourString = StringsKt.substringAfter$default((String)dateTimeString, (char)':', null, (int)2, null);
                int hour = Integer.parseInt(hourString);
                Object e2 = row.get(1);
                Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type kotlin.String");
                String username = (String)e2;
                String string = (String)CollectionsKt.getOrNull((List)row, (int)2);
                int requestCount = string != null ? Integer.parseInt(string) : -1;
                Map map = hourlyUsersCount;
                Integer key$iv = hour;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(username);
                activeUsers.add(username);
                hourlyRequestsCount.merge(hour, requestCount, (arg_0, arg_1) -> UsageMetricsPersistenceJobRunner.processCsvFile$lambda$15$lambda$14(processCsvFile.1.3.INSTANCE, arg_0, arg_1));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return new Triple((Object)hourlyUsersCount, (Object)activeUsers, (Object)hourlyRequestsCount);
    }

    private final CellProcessor[] defineCellProcessors() {
        CellProcessor[] cellProcessorArray = new CellProcessor[]{new Optional(), new Optional(), new Optional()};
        return cellProcessorArray;
    }

    private static final Integer processAccessLogProcessingItem$lambda$6$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final boolean getNodeDirectoryMap$lambda$7(File file2) {
        return file2.isDirectory();
    }

    private static final Integer processCsvFile$lambda$15$lambda$14(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(UsageMetricsPersistenceJobRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"jira-migration-jira-usage-metrics-persistence-job-key");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        JOB_RUNNER_KEY = jobRunnerKey;
        JobId jobId = JobId.of((String)"jira-migration-jira-usage-metrics-persistence-job-id");
        Intrinsics.checkNotNull((Object)jobId);
        JOB_ID = jobId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/guardrails/UsageMetricsPersistenceJobRunner$Companion;", "", "()V", "JOB_ID", "Lcom/atlassian/scheduler/config/JobId;", "getJOB_ID", "()Lcom/atlassian/scheduler/config/JobId;", "JOB_RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getJOB_RUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final JobRunnerKey getJOB_RUNNER_KEY() {
            return JOB_RUNNER_KEY;
        }

        @NotNull
        public final JobId getJOB_ID() {
            return JOB_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

