/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.apiUsage;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentServiceKt;
import com.atlassian.jira.migration.guardrails.apiUsage.ApiUsageCsvOperationFacade;
import com.atlassian.jira.migration.guardrails.apiUsage.ApiUsageKey;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageCsvOperationFacade;", "", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "jiraHome", "Lcom/atlassian/jira/config/util/JiraHome;", "(Lcom/atlassian/jira/cluster/ClusterManager;Lcom/atlassian/jira/config/util/JiraHome;)V", "fileToRawLinesReader", "Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageCsvOperationFacade$CsvReadOperation;", "accessLogDate", "Ljava/time/LocalDate;", "nodeId", "", "getFilePath", "Ljava/nio/file/Path;", "date", "getParentFolder", "rawLinesToNewFileWriter", "Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageCsvOperationFacade$CsvWriteOperation;", "Companion", "CsvReadOperation", "CsvWriteOperation", "jira-migration-plugin"})
public final class ApiUsageCsvOperationFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClusterManager clusterManager;
    @NotNull
    private final JiraHome jiraHome;
    @NotNull
    private static final String[] fileHeaders;
    private static final int usernameHashIndex;
    private static final int apiTypeIndex;
    private static final int httpMethodIndex;
    private static final int referrerTypeIndex;
    private static final int userAgentTypeIndex;
    private static final int projectIdsJsonIndex;
    private static final Logger log;

    @Inject
    public ApiUsageCsvOperationFacade(@NotNull ClusterManager clusterManager, @NotNull JiraHome jiraHome) {
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        Intrinsics.checkNotNullParameter((Object)jiraHome, (String)"jiraHome");
        this.clusterManager = clusterManager;
        this.jiraHome = jiraHome;
    }

    @NotNull
    public final CsvWriteOperation rawLinesToNewFileWriter(@NotNull LocalDate accessLogDate) {
        Intrinsics.checkNotNullParameter((Object)accessLogDate, (String)"accessLogDate");
        log.debug("Creating CSV file on shared home folder for date {}.", (Object)accessLogDate);
        Path filePath = this.getFilePath(accessLogDate, InstanceAssessmentServiceKt.getNodeIdOrDefault(this.clusterManager));
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(filePath);
        Files.createFile(filePath, new FileAttribute[0]);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
        CsvListWriter csvListWriter = new CsvListWriter((Writer)Files.newBufferedWriter(filePath, openOptionArray), CsvPreference.STANDARD_PREFERENCE);
        return new CsvWriteOperation(csvListWriter);
    }

    @Nullable
    public final CsvReadOperation fileToRawLinesReader(@NotNull LocalDate accessLogDate, @NotNull String nodeId) {
        Intrinsics.checkNotNullParameter((Object)accessLogDate, (String)"accessLogDate");
        Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
        Path filePath = this.getFilePath(accessLogDate, nodeId);
        return Files.isReadable(filePath) ? new CsvReadOperation(new CsvListReader((Reader)Files.newBufferedReader(filePath), CsvPreference.STANDARD_PREFERENCE)) : null;
    }

    private final Path getParentFolder() {
        String[] stringArray = new String[]{File.separator, "usage-metrics"};
        Path path = Paths.get(this.jiraHome.getHomePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    private final Path getFilePath(LocalDate date, String nodeId) {
        String formattedDate = date.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        Path path = this.getParentFolder().resolve(nodeId).resolve("api-usage-" + formattedDate + ".csv");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    public static final /* synthetic */ int access$getUsernameHashIndex$cp() {
        return usernameHashIndex;
    }

    public static final /* synthetic */ int access$getApiTypeIndex$cp() {
        return apiTypeIndex;
    }

    public static final /* synthetic */ int access$getHttpMethodIndex$cp() {
        return httpMethodIndex;
    }

    public static final /* synthetic */ int access$getReferrerTypeIndex$cp() {
        return referrerTypeIndex;
    }

    public static final /* synthetic */ int access$getUserAgentTypeIndex$cp() {
        return userAgentTypeIndex;
    }

    public static final /* synthetic */ int access$getProjectIdsJsonIndex$cp() {
        return projectIdsJsonIndex;
    }

    static {
        String[] stringArray = new String[]{"usernameHash", "apiType", "httpMethod", "referrerType", "userAgentType", "projectIdsJson"};
        fileHeaders = stringArray;
        usernameHashIndex = ArraysKt.indexOf((Object[])fileHeaders, (Object)"usernameHash");
        apiTypeIndex = ArraysKt.indexOf((Object[])fileHeaders, (Object)"apiType");
        httpMethodIndex = ArraysKt.indexOf((Object[])fileHeaders, (Object)"httpMethod");
        referrerTypeIndex = ArraysKt.indexOf((Object[])fileHeaders, (Object)"referrerType");
        userAgentTypeIndex = ArraysKt.indexOf((Object[])fileHeaders, (Object)"userAgentType");
        projectIdsJsonIndex = ArraysKt.indexOf((Object[])fileHeaders, (Object)"projectIdsJson");
        log = LoggerFactory.getLogger(ApiUsageCsvOperationFacade.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageCsvOperationFacade$Companion;", "", "()V", "apiTypeIndex", "", "fileHeaders", "", "", "[Ljava/lang/String;", "httpMethodIndex", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "projectIdsJsonIndex", "referrerTypeIndex", "userAgentTypeIndex", "usernameHashIndex", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageCsvOperationFacade$CsvReadOperation;", "Ljava/lang/AutoCloseable;", "csvListReader", "Lorg/supercsv/io/CsvListReader;", "(Lorg/supercsv/io/CsvListReader;)V", "close", "", "lazyRead", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageKey;", "jira-migration-plugin"})
    public static final class CsvReadOperation
    implements AutoCloseable {
        @NotNull
        private final CsvListReader csvListReader;

        public CsvReadOperation(@NotNull CsvListReader csvListReader) {
            Intrinsics.checkNotNullParameter((Object)csvListReader, (String)"csvListReader");
            this.csvListReader = csvListReader;
        }

        @NotNull
        public final Sequence<ApiUsageKey> lazyRead() {
            return SequencesKt.map((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<List<String>>(this){
                final /* synthetic */ CsvReadOperation this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final List<String> invoke() {
                    List<E> list;
                    List<E> it = list = CsvReadOperation.access$getCsvListReader$p(this.this$0).read();
                    boolean bl = false;
                    return it != null ? list : null;
                }
            })), (Function1)lazyRead.2.INSTANCE);
        }

        @Override
        public void close() {
            this.csvListReader.close();
        }

        public static final /* synthetic */ CsvListReader access$getCsvListReader$p(CsvReadOperation $this) {
            return $this.csvListReader;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageCsvOperationFacade$CsvWriteOperation;", "Ljava/lang/AutoCloseable;", "csvListWriter", "Lorg/supercsv/io/CsvListWriter;", "(Lorg/supercsv/io/CsvListWriter;)V", "close", "", "write", "apiUsageKey", "Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageKey;", "jira-migration-plugin"})
    public static final class CsvWriteOperation
    implements AutoCloseable {
        @NotNull
        private final CsvListWriter csvListWriter;

        public CsvWriteOperation(@NotNull CsvListWriter csvListWriter) {
            Intrinsics.checkNotNullParameter((Object)csvListWriter, (String)"csvListWriter");
            this.csvListWriter = csvListWriter;
        }

        public final void write(@NotNull ApiUsageKey apiUsageKey) {
            Intrinsics.checkNotNullParameter((Object)apiUsageKey, (String)"apiUsageKey");
            String[] stringArray = new String[]{apiUsageKey.getUsernameHash(), apiUsageKey.getApiType().name(), apiUsageKey.getHttpMethod().name(), apiUsageKey.getReferrerType().name(), apiUsageKey.getUserAgentType().name(), StringsKt.replace$default((String)apiUsageKey.getProjectIdsJson(), (String)",", (String)";", (boolean)false, (int)4, null)};
            this.csvListWriter.write(stringArray);
        }

        @Override
        public void close() {
            this.csvListWriter.close();
        }
    }
}

