/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.apiUsage;

import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.features.DarkFeaturesExtensionsKt;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.guardrails.ExamplesFactory;
import com.atlassian.jira.migration.guardrails.apiUsage.ApiUsageCsvOperationFacade;
import com.atlassian.jira.migration.guardrails.apiUsage.ApiUsageKey;
import com.atlassian.jira.migration.guardrails.apiUsage.ApiUsageService;
import com.atlassian.jira.migration.guardrails.model.ApiUsageDto;
import com.atlassian.jira.migration.guardrails.model.ApiUsageDtoKt;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingControl;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingControlRepository;
import com.atlassian.jira.migration.guardrails.repository.ApiUsageRepository;
import com.atlassian.jira.migration.guardrails.repository.InstAnalysisCtrl;
import com.atlassian.jira.migration.utils.FileUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.StreamingOutput;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 &2\u00020\u0001:\u0002&'B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0012\u0010\u001c\u001a\u00060\u001dR\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageService;", "", "apiUsageRepository", "Lcom/atlassian/jira/migration/guardrails/repository/ApiUsageRepository;", "accessLogProcessingControlRepository", "Lcom/atlassian/jira/migration/guardrails/repository/AccessLogProcessingControlRepository;", "apiUsageCsvOperationFacade", "Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageCsvOperationFacade;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "examplesFactory", "Lcom/atlassian/jira/migration/guardrails/ExamplesFactory;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/guardrails/repository/ApiUsageRepository;Lcom/atlassian/jira/migration/guardrails/repository/AccessLogProcessingControlRepository;Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageCsvOperationFacade;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/guardrails/ExamplesFactory;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "exportApiUsageMetrics", "Ljava/nio/file/Path;", "filename", "", "isExample", "", "getExampleApiUsageMetrics", "", "Lcom/atlassian/jira/migration/guardrails/model/ApiUsageDto;", "newSaveSession", "Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageService$SaveSession;", "instAnalysisCtrl", "Lcom/atlassian/jira/migration/guardrails/repository/InstAnalysisCtrl;", "writeApiUsageMetricsJsonToInMemoryOutput", "", "writer", "Ljava/io/BufferedWriter;", "result", "writeWithPagination", "Companion", "SaveSession", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nApiUsageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiUsageService.kt\ncom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1549#2:175\n1620#2,3:176\n*S KotlinDebug\n*F\n+ 1 ApiUsageService.kt\ncom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageService\n*L\n46#1:175\n46#1:176,3\n*E\n"})
public final class ApiUsageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApiUsageRepository apiUsageRepository;
    @NotNull
    private final AccessLogProcessingControlRepository accessLogProcessingControlRepository;
    @NotNull
    private final ApiUsageCsvOperationFacade apiUsageCsvOperationFacade;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final ExamplesFactory examplesFactory;
    @NotNull
    private final ObjectMapper mapper;
    private static final int PAGE_SIZE = 1000;

    @Inject
    public ApiUsageService(@NotNull ApiUsageRepository apiUsageRepository, @NotNull AccessLogProcessingControlRepository accessLogProcessingControlRepository, @NotNull ApiUsageCsvOperationFacade apiUsageCsvOperationFacade, @NotNull MigrationFeatures migrationFeatures, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull ExamplesFactory examplesFactory, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)apiUsageRepository, (String)"apiUsageRepository");
        Intrinsics.checkNotNullParameter((Object)accessLogProcessingControlRepository, (String)"accessLogProcessingControlRepository");
        Intrinsics.checkNotNullParameter((Object)apiUsageCsvOperationFacade, (String)"apiUsageCsvOperationFacade");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)examplesFactory, (String)"examplesFactory");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.apiUsageRepository = apiUsageRepository;
        this.accessLogProcessingControlRepository = accessLogProcessingControlRepository;
        this.apiUsageCsvOperationFacade = apiUsageCsvOperationFacade;
        this.migrationFeatures = migrationFeatures;
        this.localFileDataOutput = localFileDataOutput;
        this.examplesFactory = examplesFactory;
        this.mapper = objectMapperFactory.createObjectMapper();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SaveSession newSaveSession(@NotNull InstAnalysisCtrl instAnalysisCtrl) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)instAnalysisCtrl, (String)"instAnalysisCtrl");
        this.apiUsageRepository.truncate();
        Iterable $this$map$iv = this.accessLogProcessingControlRepository.findAllByInstAnalysisCtrl(instAnalysisCtrl);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AccessLogProcessingControl accessLogProcessingControl = (AccessLogProcessingControl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getNode());
        }
        Set nodes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return new SaveSession(nodes);
    }

    @Nullable
    public final Path exportApiUsageMetrics(@NotNull String filename, boolean isExample) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        if (!this.migrationFeatures.getEnableApiUsageAssessment()) {
            DarkFeaturesExtensionsKt.getLog().info("Api usage assessment disabled");
            return null;
        }
        DarkFeaturesExtensionsKt.getLog().info("Exporting api usage metrics");
        int rowsCount = this.apiUsageRepository.getCount();
        StreamingOutput apiUsageMetricsStreamOutput = arg_0 -> ApiUsageService.exportApiUsageMetrics$lambda$2(rowsCount, isExample, this, arg_0);
        Path jsonlPathFile = this.localFileDataOutput.exportDirectory().resolve(filename + ".jsonl");
        Intrinsics.checkNotNull((Object)jsonlPathFile);
        FileUtil.INSTANCE.createAndWriteToFile(apiUsageMetricsStreamOutput, jsonlPathFile);
        DarkFeaturesExtensionsKt.getLog().info("Api usage metrics exported");
        return jsonlPathFile;
    }

    private final void writeApiUsageMetricsJsonToInMemoryOutput(BufferedWriter writer, List<ApiUsageDto> result2) {
        writer.write(result2.stream().map(arg_0 -> ApiUsageService.writeApiUsageMetricsJsonToInMemoryOutput$lambda$3((Function1)new Function1<ApiUsageDto, String>(this){
            final /* synthetic */ ApiUsageService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final String invoke(ApiUsageDto entity) {
                return ApiUsageService.access$getMapper$p(this.this$0).writeValueAsString((Object)entity);
            }
        }, arg_0)).collect(Collectors.joining("\n")));
    }

    private final void writeWithPagination(BufferedWriter writer) {
        int minId = this.apiUsageRepository.getMinId();
        int maxId = this.apiUsageRepository.getMaxId();
        int totalPages = (maxId - minId + 1000) / 1000;
        int lastPage = totalPages - 1;
        for (int page = 0; page < totalPages; ++page) {
            int currentMinId = minId + page * 1000;
            int currentMaxId = currentMinId + 1000;
            List<ApiUsageDto> result2 = this.apiUsageRepository.getPage(currentMinId, currentMaxId);
            this.writeApiUsageMetricsJsonToInMemoryOutput(writer, result2);
            if (lastPage == page) continue;
            writer.newLine();
        }
    }

    private final List<ApiUsageDto> getExampleApiUsageMetrics() {
        return this.examplesFactory.getExampleApiUsageMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void exportApiUsageMetrics$lambda$2(int $rowsCount, boolean $isExample, ApiUsageService this$0, OutputStream it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            Intrinsics.checkNotNull((Object)it);
            Closeable closeable = it;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Object object = charset;
            closeable = new BufferedWriter(new OutputStreamWriter((OutputStream)closeable, (Charset)object));
            object = null;
            try {
                BufferedWriter writer = (BufferedWriter)closeable;
                boolean bl = false;
                if ($rowsCount > 1000 && !$isExample) {
                    this$0.writeWithPagination(writer);
                } else {
                    List<ApiUsageDto> result2 = $isExample ? this$0.getExampleApiUsageMetrics() : this$0.apiUsageRepository.findAll();
                    this$0.writeApiUsageMetricsJsonToInMemoryOutput(writer, result2);
                }
                writer.newLine();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
        catch (RuntimeException e) {
            throw new IOException("Unable to export api usage metrics: " + e.getMessage(), e);
        }
    }

    private static final String writeApiUsageMetricsJsonToInMemoryOutput$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$p(ApiUsageService $this) {
        return $this.mapper;
    }

    public static final /* synthetic */ ApiUsageCsvOperationFacade access$getApiUsageCsvOperationFacade$p(ApiUsageService $this) {
        return $this.apiUsageCsvOperationFacade;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageService$Companion;", "", "()V", "PAGE_SIZE", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J>\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\tH\u0002J*\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0002J0\u0010\u001b\u001a\u00020\u00142\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\tH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageService$SaveSession;", "", "nodes", "", "", "(Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageService;Ljava/util/Set;)V", "windowSize", "", "createFirstOccurrences", "", "Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageKey;", "Lcom/atlassian/jira/migration/guardrails/model/ApiUsageDto;", "date", "Ljava/util/Date;", "new", "keysWithCounts", "", "findExistingInDb", "keys", "generateApiUsageMetricsForSpecificDate", "", "dateBeingProcessed", "Ljava/time/LocalDate;", "groupByAndCountFileChunk", "", "chunk", "", "updateExistingInDb", "existing", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nApiUsageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiUsageService.kt\ncom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageService$SaveSession\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1313#2:175\n1313#2,2:177\n1314#2:179\n1#3:176\n215#4,2:180\n1271#5,2:182\n1285#5,4:184\n1194#5,2:188\n1222#5,4:190\n1194#5,2:194\n1222#5,4:196\n*S KotlinDebug\n*F\n+ 1 ApiUsageService.kt\ncom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageService$SaveSession\n*L\n123#1:175\n126#1:177,2\n123#1:179\n141#1:180,2\n154#1:182,2\n154#1:184,4\n158#1:188,2\n158#1:190,4\n163#1:194,2\n163#1:196,4\n*E\n"})
    public final class SaveSession {
        @NotNull
        private final Set<String> nodes;
        private final int windowSize;

        public SaveSession(Set<String> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            this.nodes = nodes;
            this.windowSize = ApiUsageService.this.migrationFeatures.getApiUsageAssessmentBatchWriteSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void generateApiUsageMetricsForSpecificDate(@NotNull LocalDate dateBeingProcessed) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)dateBeingProcessed, (String)"dateBeingProcessed");
            Date dateConverted = Date.from(dateBeingProcessed.atStartOfDay(ZoneId.systemDefault()).toInstant());
            Cache cache2 = CacheBuilder.newBuilder().maximumSize(ApiUsageService.this.migrationFeatures.getApiUsageAssessmentCacheSize()).build();
            Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
            Cache cache3 = cache2;
            Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.nodes), (Function1)((Function1)new Function1<String, ApiUsageCsvOperationFacade.CsvReadOperation>(ApiUsageService.this, dateBeingProcessed){
                final /* synthetic */ ApiUsageService this$0;
                final /* synthetic */ LocalDate $dateBeingProcessed;
                {
                    this.this$0 = $receiver;
                    this.$dateBeingProcessed = $dateBeingProcessed;
                    super(1);
                }

                @Nullable
                public final ApiUsageCsvOperationFacade.CsvReadOperation invoke(@NotNull String node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    return ApiUsageService.access$getApiUsageCsvOperationFacade$p(this.this$0).fileToRawLinesReader(this.$dateBeingProcessed, node);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ApiUsageCsvOperationFacade.CsvReadOperation csv = (ApiUsageCsvOperationFacade.CsvReadOperation)element$iv;
                boolean bl = false;
                AutoCloseable autoCloseable = csv;
                Throwable throwable = null;
                try {
                    void $this$forEach$iv2;
                    ApiUsageCsvOperationFacade.CsvReadOperation it = (ApiUsageCsvOperationFacade.CsvReadOperation)autoCloseable;
                    boolean bl2 = false;
                    Sequence sequence2 = SequencesKt.chunked(csv.lazyRead(), (int)this.windowSize);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        List chunk = (List)element$iv2;
                        boolean bl3 = false;
                        Map<ApiUsageKey, Long> keysWithCounts = this.groupByAndCountFileChunk(chunk);
                        ImmutableMap fromCache = cache3.getAllPresent((Iterable)keysWithCounts.keySet());
                        Intrinsics.checkNotNull((Object)dateConverted);
                        Set<ApiUsageKey> set = keysWithCounts.keySet();
                        Set set2 = fromCache.keySet();
                        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
                        Map<ApiUsageKey, ApiUsageDto> missedCache = this.findExistingInDb(dateConverted, SetsKt.minus(set, (Iterable)set2));
                        Intrinsics.checkNotNull((Object)fromCache);
                        Map existing = MapsKt.plus((Map)((Map)fromCache), missedCache);
                        Map<ApiUsageKey, ApiUsageDto> map = this.createFirstOccurrences(dateConverted, SetsKt.minus(keysWithCounts.keySet(), (Iterable)existing.keySet()), keysWithCounts);
                        this.updateExistingInDb(existing, keysWithCounts);
                        cache3.putAll(MapsKt.plus(map, missedCache));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void updateExistingInDb(Map<ApiUsageKey, ApiUsageDto> existing, Map<ApiUsageKey, Long> keysWithCounts) {
            void $this$forEach$iv;
            Map<ApiUsageKey, ApiUsageDto> map = existing;
            ApiUsageService apiUsageService = ApiUsageService.this;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                ApiUsageKey key = (ApiUsageKey)entry.getKey();
                ApiUsageDto apiUsageDto = (ApiUsageDto)entry.getValue();
                long l = apiUsageDto.getCount();
                Long l2 = keysWithCounts.get(key);
                Intrinsics.checkNotNull((Object)l2);
                apiUsageDto.setCount(l + (long)((int)((Number)l2).longValue()));
                apiUsageService.apiUsageRepository.updateCounts(existing.values());
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Map<ApiUsageKey, ApiUsageDto> createFirstOccurrences(Date date, Set<ApiUsageKey> set, Map<ApiUsageKey, Long> keysWithCounts) {
            Map map;
            Map map2;
            Iterable $this$associateWith$iv = set;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void key;
                ApiUsageKey apiUsageKey = (ApiUsageKey)element$iv$iv;
                Object t = element$iv$iv;
                map2 = result$iv;
                boolean bl = false;
                Long l = keysWithCounts.get(key);
                Intrinsics.checkNotNull((Object)l);
                Long l2 = ((Number)l).longValue();
                map2.put(t, l2);
            }
            Map newOnes = result$iv;
            if (newOnes.isEmpty()) {
                map = MapsKt.emptyMap();
            } else {
                void $this$associateByTo$iv$iv;
                void $this$associateBy$iv;
                $this$associateWith$iv = ApiUsageService.this.apiUsageRepository.createAll(date, newOnes);
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                $this$associateWithTo$iv$iv = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    ApiUsageDto bl = (ApiUsageDto)element$iv$iv;
                    map2 = destination$iv$iv;
                    boolean bl2 = false;
                    map2.put(ApiUsageDtoKt.toKey((ApiUsageDto)it), element$iv$iv);
                }
                map = destination$iv$iv;
            }
            return map;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<ApiUsageKey, ApiUsageDto> findExistingInDb(Date date, Set<ApiUsageKey> keys) {
            Map map;
            if (keys.isEmpty()) {
                map = MapsKt.emptyMap();
            } else {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = ApiUsageService.this.apiUsageRepository.findByKeys(date, keys);
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    ApiUsageDto apiUsageDto = (ApiUsageDto)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    map2.put(ApiUsageDtoKt.toKey((ApiUsageDto)it), element$iv$iv);
                }
                map = destination$iv$iv;
            }
            return map;
        }

        private final Map<ApiUsageKey, Long> groupByAndCountFileChunk(List<ApiUsageKey> chunk) {
            Map<ApiUsageKey, Long> map = chunk.stream().collect(Collectors.groupingBy(arg_0 -> SaveSession.groupByAndCountFileChunk$lambda$7(groupByAndCountFileChunk.1.INSTANCE, arg_0), Collectors.counting()));
            Intrinsics.checkNotNullExpressionValue(map, (String)"collect(...)");
            return map;
        }

        private static final ApiUsageKey groupByAndCountFileChunk$lambda$7(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ApiUsageKey)$tmp0.invoke(p0);
        }
    }
}

