/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.csv;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.supercsv.encoder.CsvEncoder;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CsvContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/guardrails/csv/GuardrailsCsvEncoder;", "Lorg/supercsv/encoder/CsvEncoder;", "()V", "encode", "", "input", "context", "Lorg/supercsv/util/CsvContext;", "preference", "Lorg/supercsv/prefs/CsvPreference;", "jira-migration-plugin"})
public final class GuardrailsCsvEncoder
implements CsvEncoder {
    @NotNull
    public String encode(@NotNull String input, @NotNull CsvContext context, @NotNull CsvPreference preference) {
        boolean quotesRequiredForSurroundingSpaces;
        boolean quotesRequiredForSpecialChar;
        char quote;
        StringBuilder currentColumn;
        block13: {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)preference, (String)"preference");
            currentColumn = new StringBuilder();
            int delimiter = preference.getDelimiterChar();
            quote = preference.getQuoteChar();
            String eolSymbols = preference.getEndOfLineSymbols();
            int lastCharIndex = input.length() - 1;
            quotesRequiredForSpecialChar = false;
            boolean skipNewline = false;
            int i = 0;
            if (i > lastCharIndex) break block13;
            while (true) {
                block15: {
                    char c;
                    block14: {
                        c = input.charAt(i);
                        if (!skipNewline) break block14;
                        skipNewline = false;
                        if (c == '\n') break block15;
                    }
                    if (c == delimiter) {
                        quotesRequiredForSpecialChar = true;
                        currentColumn.append(c);
                    } else if (c == quote) {
                        quotesRequiredForSpecialChar = true;
                        currentColumn.append("\\");
                        currentColumn.append(c);
                    } else if (c == '\r') {
                        quotesRequiredForSpecialChar = true;
                        currentColumn.append(eolSymbols);
                        context.setLineNumber(context.getLineNumber() + 1);
                        skipNewline = true;
                    } else if (c == '\n') {
                        quotesRequiredForSpecialChar = true;
                        currentColumn.append(eolSymbols);
                        context.setLineNumber(context.getLineNumber() + 1);
                    } else {
                        currentColumn.append(c);
                    }
                }
                if (i == lastCharIndex) break;
                ++i;
            }
        }
        boolean quotesRequiredForMode = preference.getQuoteMode().quotesRequired(input, context, preference);
        boolean bl = quotesRequiredForSurroundingSpaces = preference.isSurroundingSpacesNeedQuotes() && input.length() > 0 && (input.charAt(0) == ' ' || input.charAt(input.length() - 1) == ' ');
        if (quotesRequiredForSpecialChar || quotesRequiredForMode || quotesRequiredForSurroundingSpaces) {
            currentColumn.insert(0, quote).append(quote);
        }
        String string = currentColumn.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

