/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.logs;

import com.atlassian.jira.migration.guardrails.logs.ApiType;
import com.atlassian.jira.migration.guardrails.logs.ApiTypeProvider;
import com.atlassian.jira.migration.guardrails.logs.HttpMethod;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J9\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0011\"\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\tH\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\rH\u0002J1\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\r2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0011\"\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\rR \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/guardrails/logs/ApiTypeProvider;", "", "()V", "matchersByMethod", "", "Lcom/atlassian/jira/migration/guardrails/logs/HttpMethod;", "", "Lcom/atlassian/jira/migration/guardrails/logs/ApiTypeProvider$ApiTypeMatcher;", "addMatcher", "", "apiType", "Lcom/atlassian/jira/migration/guardrails/logs/ApiType;", "pattern", "", "priority", "", "httpMethods", "", "(Lcom/atlassian/jira/migration/guardrails/logs/ApiType;Ljava/lang/String;I[Lcom/atlassian/jira/migration/guardrails/logs/HttpMethod;)V", "addReadMatchers", "addSimpleApiMatcher", "apiPath", "(Lcom/atlassian/jira/migration/guardrails/logs/ApiType;Ljava/lang/String;[Lcom/atlassian/jira/migration/guardrails/logs/HttpMethod;)V", "getApiType", "method", "path", "ApiTypeMatcher", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nApiTypeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiTypeProvider.kt\ncom/atlassian/jira/migration/guardrails/logs/ApiTypeProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n1045#2:230\n1855#2,2:231\n*S KotlinDebug\n*F\n+ 1 ApiTypeProvider.kt\ncom/atlassian/jira/migration/guardrails/logs/ApiTypeProvider\n*L\n213#1:230\n213#1:231,2\n*E\n"})
public final class ApiTypeProvider {
    @NotNull
    private final Map<HttpMethod, List<ApiTypeMatcher>> matchersByMethod = new LinkedHashMap();

    public ApiTypeProvider() {
        this.addReadMatchers();
    }

    private final void addReadMatchers() {
        this.addSimpleApiMatcher(ApiType.PERMISSIONS, "(my)?permissions");
        this.addSimpleApiMatcher(ApiType.APPLICATION_PROPERTIES, "application-properties(/advanced-settings)?");
        HttpMethod[] httpMethodArray = new HttpMethod[]{HttpMethod.PUT};
        this.addSimpleApiMatcher(ApiType.APPLICATION_PROPERTIES, "application-properties/\\w+", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.PUT};
        this.addSimpleApiMatcher(ApiType.APPLICATION_ROLE, "applicationrole/\\w+", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.PUT};
        this.addSimpleApiMatcher(ApiType.APPLICATION_ROLE, "applicationrole", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.DELETE};
        this.addSimpleApiMatcher(ApiType.ATTACHMENT, "attachment/.+", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST};
        this.addSimpleApiMatcher(ApiType.AUDITING, "auditing/record", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.DELETE};
        this.addSimpleApiMatcher(ApiType.AVATAR, "(universal_)?avatar/.+", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE};
        this.addSimpleApiMatcher(ApiType.CLUSTER, "cluster/.+", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.PUT, HttpMethod.DELETE};
        this.addSimpleApiMatcher(ApiType.COMMENT_PROPERTIES, "comment/.+/properties", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE};
        this.addSimpleApiMatcher(ApiType.COMPONENT, "component.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET};
        this.addSimpleApiMatcher(ApiType.CONFIGURATION, "configuration", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST};
        this.addSimpleApiMatcher(ApiType.FIELDS, "field", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET};
        this.addSimpleApiMatcher(ApiType.FIELDS, "customFieldOption/.+", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.DELETE};
        this.addSimpleApiMatcher(ApiType.FIELDS, "customFields.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.DELETE, HttpMethod.PUT};
        this.addSimpleApiMatcher(ApiType.DASHBOARD, "dashboard.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST};
        this.addSimpleApiMatcher(ApiType.EMAIL_TEMPLATES, "email-templates.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.PUT, HttpMethod.POST, HttpMethod.DELETE};
        this.addSimpleApiMatcher(ApiType.FILTER, "filter.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.DELETE};
        this.addSimpleApiMatcher(ApiType.GROUP, "group.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST};
        this.addSimpleApiMatcher(ApiType.INDEX, "(re)?index.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET};
        this.addSimpleApiMatcher(ApiType.ISSUE_CREATE_META, "issue/createmeta/.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE};
        this.addMatcher(ApiType.ISSUE_DATA, ".*/rest/api/[^/]+/issue.*", 1, httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.DELETE, HttpMethod.PUT};
        this.addSimpleApiMatcher(ApiType.ISSUE_PROPERTIES, "issue/[^/]+/properties", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST};
        this.addSimpleApiMatcher(ApiType.ISSUE_SUBTASK, "issue/[^/]+/subtask", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.DELETE, HttpMethod.PUT};
        this.addSimpleApiMatcher(ApiType.ISSUE_LINK, "(issueLink|issueLinkType)", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET};
        this.addSimpleApiMatcher(ApiType.ISSUE_SECURITY_SCHEMES, "issuesecurityschemes", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.DELETE, HttpMethod.PUT};
        this.addSimpleApiMatcher(ApiType.ISSUE_TYPE, "issuetype.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET};
        this.addSimpleApiMatcher(ApiType.AUTO_COMPLETE, "jql/autocompletedata.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.POST};
        this.addSimpleApiMatcher(ApiType.LICENSE_VALIDATION, "licenseValidator", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST};
        this.addSimpleApiMatcher(ApiType.MONITORING, "monitoring/.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.DELETE, HttpMethod.PUT};
        this.addSimpleApiMatcher(ApiType.MYSELF, "(myself|mypreferences)", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET};
        this.addSimpleApiMatcher(ApiType.NOTIFICATION_SCHEME, "notificationscheme", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST};
        this.addSimpleApiMatcher(ApiType.PASSWORD_POLICY, "password/policy.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.DELETE, HttpMethod.PUT};
        this.addSimpleApiMatcher(ApiType.PERMISSION_SCHEME, "permissionscheme.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.DELETE, HttpMethod.PUT};
        this.addSimpleApiMatcher(ApiType.PRIORITY, "priority.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE};
        this.addMatcher(ApiType.PROJECT_DATA, ".*/rest/api/[^/]+/(project|projectvalidate)([/?#]+.*)?", 1, httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.PUT, HttpMethod.DELETE};
        this.addMatcher(ApiType.PROJECT_PROPERTIES, ".*/rest/api/[^/]+/project/[^/]+/properties([/?#]+.*)?", 0, httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE};
        this.addMatcher(ApiType.PROJECT_ROLES, ".*/rest/api/[^/]+/project/[^/]+/role([/?#]+.*)?", 0, httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.PUT};
        this.addMatcher(ApiType.PROJECT_SCHEMES, ".*/rest/api/[^/]+/project/[^/]+/(issuesecuritylevelscheme|notificationscheme|permissionscheme)([/?#]+.*)?", 0, httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET};
        this.addSimpleApiMatcher(ApiType.RESOLUTION, "resolution.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE};
        this.addSimpleApiMatcher(ApiType.ROLES, "role.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE};
        this.addSimpleApiMatcher(ApiType.SCREENS, "screens.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET};
        this.addMatcher(ApiType.JQL_SEARCH, ".*/rest/api/[^/]+/search([/?#]+.*)?", 0, httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET};
        this.addSimpleApiMatcher(ApiType.SECURITY_LEVEL, "securitylevel/[^/]+", httpMethodArray);
        this.addSimpleApiMatcher(ApiType.SERVER_INFO, "serverInfo");
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.PUT};
        this.addSimpleApiMatcher(ApiType.SETTINGS, "settings/(baseUrl|columns)", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET};
        this.addSimpleApiMatcher(ApiType.STATUS, "status.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST};
        this.addSimpleApiMatcher(ApiType.TERMINOLOGY, "terminology/entries.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST};
        this.addSimpleApiMatcher(ApiType.UPGRADE, "upgrade", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE};
        this.addSimpleApiMatcher(ApiType.USER, "user.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE};
        this.addSimpleApiMatcher(ApiType.VERSION, "version.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE};
        this.addSimpleApiMatcher(ApiType.WORKFLOW, "workflow.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST};
        this.addSimpleApiMatcher(ApiType.WORKLOG, "worklog.*", httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.DELETE};
        this.addMatcher(ApiType.AUTH_SESSION, ".*/rest/auth/[^/]+/session([/?#]+.*)?", 0, httpMethodArray);
        httpMethodArray = new HttpMethod[]{HttpMethod.DELETE};
        this.addMatcher(ApiType.AUTH_WEBSUDO, ".*/rest/auth/[^/]+/websudo([/?#]+.*)?", 0, httpMethodArray);
    }

    private final void addSimpleApiMatcher(ApiType apiType, String apiPath) {
        HttpMethod[] httpMethodArray = new HttpMethod[]{HttpMethod.GET};
        this.addSimpleApiMatcher(apiType, apiPath, httpMethodArray);
    }

    private final void addSimpleApiMatcher(ApiType apiType, String apiPath, HttpMethod ... httpMethods) {
        this.addMatcher(apiType, ".*/rest/api/[^/]+/" + apiPath + "([/?#]+.*)?", 0, Arrays.copyOf(httpMethods, httpMethods.length));
    }

    private final void addMatcher(ApiType apiType, String pattern, int priority, HttpMethod ... httpMethods) {
        ApiTypeMatcher matcher = new ApiTypeMatcher(pattern, apiType, priority);
        for (HttpMethod method : httpMethods) {
            this.matchersByMethod.computeIfAbsent(method, arg_0 -> ApiTypeProvider.addMatcher$lambda$0(addMatcher.1.INSTANCE, arg_0)).add(matcher);
        }
    }

    @NotNull
    public final ApiType getApiType(@NotNull HttpMethod method, @NotNull String path) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            List list = this.matchersByMethod.get((Object)method);
            if (list == null) break block2;
            Iterable $this$sortedBy$iv = list;
            boolean $i$f$sortedBy = false;
            list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ApiTypeMatcher it = (ApiTypeMatcher)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (ApiTypeMatcher)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
                }
            });
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ApiTypeMatcher matcher = (ApiTypeMatcher)element$iv;
                    boolean bl = false;
                    if (!matcher.matches(path)) continue;
                    return matcher.getApiType();
                }
            }
        }
        return ApiType.UNKNOWN;
    }

    private static final List addMatcher$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/guardrails/logs/ApiTypeProvider$ApiTypeMatcher;", "", "pathPattern", "", "apiType", "Lcom/atlassian/jira/migration/guardrails/logs/ApiType;", "priority", "", "(Ljava/lang/String;Lcom/atlassian/jira/migration/guardrails/logs/ApiType;I)V", "getApiType", "()Lcom/atlassian/jira/migration/guardrails/logs/ApiType;", "Ljava/util/regex/Pattern;", "getPriority", "()I", "matches", "", "path", "jira-migration-plugin"})
    private static final class ApiTypeMatcher {
        @NotNull
        private final ApiType apiType;
        private final int priority;
        @NotNull
        private final Pattern pathPattern;

        public ApiTypeMatcher(@NotNull String pathPattern, @NotNull ApiType apiType, int priority) {
            Intrinsics.checkNotNullParameter((Object)pathPattern, (String)"pathPattern");
            Intrinsics.checkNotNullParameter((Object)((Object)apiType), (String)"apiType");
            this.apiType = apiType;
            this.priority = priority;
            Pattern pattern = Pattern.compile(pathPattern);
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            this.pathPattern = pattern;
        }

        @NotNull
        public final ApiType getApiType() {
            return this.apiType;
        }

        public final int getPriority() {
            return this.priority;
        }

        public final boolean matches(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.pathPattern.matcher(path).matches();
        }
    }
}

