/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.logs;

import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.guardrails.logs.ApiType;
import com.atlassian.jira.migration.jql.JqlParserService;
import com.atlassian.jira.migration.jql.JqlProjectIdentifier;
import com.atlassian.jira.migration.jql.ProjectInfo;
import com.atlassian.query.Query;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/guardrails/logs/ProjectIdProvider;", "", "jqlParserService", "Lcom/atlassian/jira/migration/jql/JqlParserService;", "jqlQueryParser", "Lcom/atlassian/jira/jql/parser/JqlQueryParser;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/jql/JqlParserService;Lcom/atlassian/jira/jql/parser/JqlQueryParser;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "extractJqlQuery", "", "input", "extractProjectKeyOrId", "getProjectIds", "", "", "path", "apiType", "Lcom/atlassian/jira/migration/guardrails/logs/ApiType;", "getProjectIdsFromJqlSearchPath", "getProjectIdsFromProjectsApiPath", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectIdProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectIdProvider.kt\ncom/atlassian/jira/migration/guardrails/logs/ProjectIdProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1#2:90\n1549#3:91\n1620#3,3:92\n*S KotlinDebug\n*F\n+ 1 ProjectIdProvider.kt\ncom/atlassian/jira/migration/guardrails/logs/ProjectIdProvider\n*L\n59#1:91\n59#1:92,3\n*E\n"})
public final class ProjectIdProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JqlParserService jqlParserService;
    @NotNull
    private final JqlQueryParser jqlQueryParser;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private static final Logger log = LoggerFactory.getLogger(ProjectIdProvider.class);
    @NotNull
    private static final Regex PROJECTS_API_REGEX = new Regex("/(project|projectvalidate|issue/createmeta)/([^/?]+)");
    @NotNull
    private static final Regex JQL_QUERY_API_REGEX = new Regex("jql=([^&/ ]*)(?=&(?:startAt|maxResults|validateQuery|fields|expand))?");
    @NotNull
    private static final Set<ApiType> PROJECT_RELATED_API_TYPES;

    @Inject
    public ProjectIdProvider(@NotNull JqlParserService jqlParserService, @NotNull JqlQueryParser jqlQueryParser, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)jqlParserService, (String)"jqlParserService");
        Intrinsics.checkNotNullParameter((Object)jqlQueryParser, (String)"jqlQueryParser");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.jqlParserService = jqlParserService;
        this.jqlQueryParser = jqlQueryParser;
        this.migrationFeatures = migrationFeatures;
    }

    @NotNull
    public final List<Long> getProjectIds(@NotNull String path, @NotNull ApiType apiType) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)apiType), (String)"apiType");
        ApiType apiType2 = apiType;
        return PROJECT_RELATED_API_TYPES.contains((Object)apiType2) ? this.getProjectIdsFromProjectsApiPath(path) : (apiType2 == ApiType.JQL_SEARCH ? this.getProjectIdsFromJqlSearchPath(path) : CollectionsKt.emptyList());
    }

    private final List<Long> getProjectIdsFromProjectsApiPath(String path) {
        JqlProjectIdentifier jqlProjectIdentifier;
        String string = this.extractProjectKeyOrId(path);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String projectKeyOrId = string;
        Long l = StringsKt.toLongOrNull((String)projectKeyOrId);
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            jqlProjectIdentifier = new JqlProjectIdentifier.ProjectReferenceId(it);
        } else {
            jqlProjectIdentifier = new JqlProjectIdentifier.ProjectReferenceKeyOrName(projectKeyOrId);
        }
        JqlProjectIdentifier projectIdentifier = jqlProjectIdentifier;
        ProjectInfo projectInfo = this.jqlParserService.getProjectId(projectIdentifier);
        return projectInfo instanceof ProjectInfo.ProjectId ? CollectionsKt.listOf((Object)((ProjectInfo.ProjectId)projectInfo).getId()) : CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Long> getProjectIdsFromJqlSearchPath(String path) {
        void $this$mapTo$iv$iv;
        String queryString;
        if (!this.migrationFeatures.getEnableCustomJqlParser()) {
            return CollectionsKt.emptyList();
        }
        try {
            queryString = URLDecoder.decode(this.extractJqlQuery(path), StandardCharsets.UTF_8.toString());
            queryString = this.jqlQueryParser.parseQuery(queryString);
        }
        catch (Exception e) {
            if (e instanceof JqlParseException) {
                log.warn("Failed to parse JQL query in path: " + path, (Throwable)e);
            } else {
                log.warn("Failed to decode JQL query in path: " + path, (Throwable)e);
            }
            return CollectionsKt.emptyList();
        }
        String jqlQuery = queryString;
        Intrinsics.checkNotNull((Object)jqlQuery);
        Iterable $this$map$iv = this.jqlParserService.getProjectIdsForQuery((Query)jqlQuery);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProjectInfo.ProjectId projectId = (ProjectInfo.ProjectId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    private final String extractJqlQuery(String input) {
        MatchResult matchResult = Regex.find$default((Regex)JQL_QUERY_API_REGEX, (CharSequence)input, (int)0, (int)2, null);
        MatchResult matchResult2 = matchResult;
        return matchResult2 != null && (matchResult2 = matchResult2.getGroups()) != null && (matchResult2 = matchResult2.get(1)) != null ? matchResult2.getValue() : null;
    }

    private final String extractProjectKeyOrId(String input) {
        MatchResult matchResult = Regex.find$default((Regex)PROJECTS_API_REGEX, (CharSequence)input, (int)0, (int)2, null);
        MatchResult matchResult2 = matchResult;
        return matchResult2 != null && (matchResult2 = matchResult2.getGroups()) != null && (matchResult2 = matchResult2.get(2)) != null ? matchResult2.getValue() : null;
    }

    static {
        ApiType[] apiTypeArray = new ApiType[]{ApiType.PROJECT_DATA, ApiType.PROJECT_ROLES, ApiType.PROJECT_PROPERTIES, ApiType.PROJECT_SCHEMES, ApiType.ISSUE_CREATE_META};
        PROJECT_RELATED_API_TYPES = SetsKt.setOf((Object[])apiTypeArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/guardrails/logs/ProjectIdProvider$Companion;", "", "()V", "JQL_QUERY_API_REGEX", "Lkotlin/text/Regex;", "PROJECTS_API_REGEX", "PROJECT_RELATED_API_TYPES", "", "Lcom/atlassian/jira/migration/guardrails/logs/ApiType;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

