/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.logs;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.migration.guardrails.logs.ReferrerType;
import com.atlassian.jira.migration.guardrails.logs.ReferrerTypeProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0015B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\b\u0010\u0011\u001a\u00020\rH\u0002J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0001\u00a2\u0006\u0002\b\u0013J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/guardrails/logs/ReferrerTypeProvider;", "", "applicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "(Lcom/atlassian/sal/api/ApplicationProperties;Lcom/atlassian/jira/cluster/ClusterManager;)V", "matchersByType", "", "Lcom/atlassian/jira/migration/guardrails/logs/ReferrerType;", "", "Lcom/atlassian/jira/migration/guardrails/logs/ReferrerTypeProvider$ReferrerTypeMatcher;", "addMatcher", "", "pattern", "", "referrerType", "addReferrerTypeMatchers", "findNodeIp", "findNodeIp$jira_migration_plugin", "entry", "ReferrerTypeMatcher", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nReferrerTypeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReferrerTypeProvider.kt\ncom/atlassian/jira/migration/guardrails/logs/ReferrerTypeProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,74:1\n288#2,2:75\n1855#2,2:78\n215#3:77\n216#3:80\n*S KotlinDebug\n*F\n+ 1 ReferrerTypeProvider.kt\ncom/atlassian/jira/migration/guardrails/logs/ReferrerTypeProvider\n*L\n47#1:75,2\n65#1:78,2\n64#1:77\n64#1:80\n*E\n"})
public final class ReferrerTypeProvider {
    @NotNull
    private final ApplicationProperties applicationProperties;
    @NotNull
    private final ClusterManager clusterManager;
    @NotNull
    private final Map<ReferrerType, List<ReferrerTypeMatcher>> matchersByType;

    @Inject
    public ReferrerTypeProvider(@NotNull ApplicationProperties applicationProperties, @NotNull ClusterManager clusterManager) {
        Intrinsics.checkNotNullParameter((Object)applicationProperties, (String)"applicationProperties");
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        this.applicationProperties = applicationProperties;
        this.clusterManager = clusterManager;
        this.matchersByType = new LinkedHashMap();
        this.addReferrerTypeMatchers();
    }

    private final void addReferrerTypeMatchers() {
        this.addMatcher("^-$", ReferrerType.DIRECT);
        this.addMatcher('^' + this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + "(/.*)?$", ReferrerType.INTERNAL);
        String nodeIp = this.findNodeIp$jira_migration_plugin();
        if (nodeIp != null) {
            this.addMatcher("^(https?://)?" + nodeIp + "(/.*)?$", ReferrerType.INTERNAL);
        }
    }

    @VisibleForTesting
    @Nullable
    public final String findNodeIp$jira_migration_plugin() {
        Object v1;
        block1: {
            String nodeId = this.clusterManager.getNodeId();
            Set set = this.clusterManager.getAllNodes();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllNodes(...)");
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Node node = (Node)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)node.getNodeId(), (Object)nodeId)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        Node node = v1;
        return node != null ? node.getIp() : null;
    }

    private final void addMatcher(String pattern, ReferrerType referrerType) {
        ReferrerTypeMatcher matcher = new ReferrerTypeMatcher(pattern, referrerType);
        this.matchersByType.computeIfAbsent(referrerType, arg_0 -> ReferrerTypeProvider.addMatcher$lambda$1(addMatcher.1.INSTANCE, arg_0)).add(matcher);
    }

    @NotNull
    public final ReferrerType referrerType(@NotNull String entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Map<ReferrerType, List<ReferrerTypeMatcher>> $this$forEach$iv = this.matchersByType;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ReferrerType, List<ReferrerTypeMatcher>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ReferrerType, List<ReferrerTypeMatcher>> element$iv;
            Map.Entry<ReferrerType, List<ReferrerTypeMatcher>> matchers = element$iv = iterator2.next();
            boolean bl = false;
            Iterable $this$forEach$iv2 = matchers.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ReferrerTypeMatcher matcher = (ReferrerTypeMatcher)element$iv2;
                boolean bl2 = false;
                if (!matcher.matches(entry)) continue;
                return matcher.getReferrerType();
            }
        }
        return ReferrerType.OTHER;
    }

    private static final List addMatcher$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/guardrails/logs/ReferrerTypeProvider$ReferrerTypeMatcher;", "", "pattern", "", "referrerType", "Lcom/atlassian/jira/migration/guardrails/logs/ReferrerType;", "(Ljava/lang/String;Lcom/atlassian/jira/migration/guardrails/logs/ReferrerType;)V", "getReferrerType", "()Lcom/atlassian/jira/migration/guardrails/logs/ReferrerType;", "referrerTypePattern", "Ljava/util/regex/Pattern;", "matches", "", "jira-migration-plugin"})
    private static final class ReferrerTypeMatcher {
        @NotNull
        private final ReferrerType referrerType;
        @NotNull
        private final Pattern referrerTypePattern;

        public ReferrerTypeMatcher(@NotNull String pattern, @NotNull ReferrerType referrerType) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)((Object)referrerType), (String)"referrerType");
            this.referrerType = referrerType;
            Pattern pattern2 = Pattern.compile(pattern);
            Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
            this.referrerTypePattern = pattern2;
        }

        @NotNull
        public final ReferrerType getReferrerType() {
            return this.referrerType;
        }

        public final boolean matches(@NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return this.referrerTypePattern.matcher(pattern).find();
        }
    }
}

