/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.logs;

import com.atlassian.jira.migration.guardrails.logs.ApiType;
import com.atlassian.jira.migration.guardrails.logs.ApiTypeProvider;
import com.atlassian.jira.migration.guardrails.logs.HttpMethod;
import com.atlassian.jira.migration.guardrails.logs.LogEntry;
import com.atlassian.jira.migration.guardrails.logs.ProjectIdProvider;
import com.atlassian.jira.migration.guardrails.logs.ReferrerType;
import com.atlassian.jira.migration.guardrails.logs.ReferrerTypeProvider;
import com.atlassian.jira.migration.guardrails.logs.UserAgentType;
import com.atlassian.jira.migration.guardrails.logs.UserAgentTypeProvider;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00132\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u001c\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0013H\u0002J&\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/atlassian/jira/migration/guardrails/logs/TomcatAccessLogParserV2;", "", "apiTypeProvider", "Lcom/atlassian/jira/migration/guardrails/logs/ApiTypeProvider;", "userAgentTypeProvider", "Lcom/atlassian/jira/migration/guardrails/logs/UserAgentTypeProvider;", "referrerTypeProvider", "Lcom/atlassian/jira/migration/guardrails/logs/ReferrerTypeProvider;", "projectIdProvider", "Lcom/atlassian/jira/migration/guardrails/logs/ProjectIdProvider;", "(Lcom/atlassian/jira/migration/guardrails/logs/ApiTypeProvider;Lcom/atlassian/jira/migration/guardrails/logs/UserAgentTypeProvider;Lcom/atlassian/jira/migration/guardrails/logs/ReferrerTypeProvider;Lcom/atlassian/jira/migration/guardrails/logs/ProjectIdProvider;)V", "cleanupUsername", "", "username", "findHttpMethodIndex", "", "line", "keyword", "findReferrerIndexes", "Lkotlin/Pair;", "findUserAgentIndexes", "getApiTypeAndHttpMethod", "Lcom/atlassian/jira/migration/guardrails/logs/ApiType;", "Lcom/atlassian/jira/migration/guardrails/logs/HttpMethod;", "getReferrerType", "Lcom/atlassian/jira/migration/guardrails/logs/ReferrerType;", "getUserAgentType", "Lcom/atlassian/jira/migration/guardrails/logs/UserAgentType;", "isIndexPairValid", "", "indexes", "isPrecededByChars", "idx", "chars", "", "", "parseLine", "Lcom/atlassian/jira/migration/guardrails/logs/LogEntry;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nTomcatAccessLogParserV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomcatAccessLogParserV2.kt\ncom/atlassian/jira/migration/guardrails/logs/TomcatAccessLogParserV2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n766#2:131\n857#2,2:132\n*S KotlinDebug\n*F\n+ 1 TomcatAccessLogParserV2.kt\ncom/atlassian/jira/migration/guardrails/logs/TomcatAccessLogParserV2\n*L\n20#1:131\n20#1:132,2\n*E\n"})
public final class TomcatAccessLogParserV2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApiTypeProvider apiTypeProvider;
    @NotNull
    private final UserAgentTypeProvider userAgentTypeProvider;
    @NotNull
    private final ReferrerTypeProvider referrerTypeProvider;
    @NotNull
    private final ProjectIdProvider projectIdProvider;
    private static final int USER_POS = 2;
    @NotNull
    private static final String COMMON_USER_AGENT_START = "Mozilla/";
    private static final int NOT_FOUND = -1;
    private static final int NUMBER_OF_QUOTATION_MARKS = 4;
    private static final int START_INDEX = 0;
    private static final int QUOTATION_MARK_OFFSET = 1;
    private static final int FOLLOWING_CHAR_INDEX = 1;

    @Inject
    public TomcatAccessLogParserV2(@NotNull ApiTypeProvider apiTypeProvider, @NotNull UserAgentTypeProvider userAgentTypeProvider, @NotNull ReferrerTypeProvider referrerTypeProvider, @NotNull ProjectIdProvider projectIdProvider) {
        Intrinsics.checkNotNullParameter((Object)apiTypeProvider, (String)"apiTypeProvider");
        Intrinsics.checkNotNullParameter((Object)userAgentTypeProvider, (String)"userAgentTypeProvider");
        Intrinsics.checkNotNullParameter((Object)referrerTypeProvider, (String)"referrerTypeProvider");
        Intrinsics.checkNotNullParameter((Object)projectIdProvider, (String)"projectIdProvider");
        this.apiTypeProvider = apiTypeProvider;
        this.userAgentTypeProvider = userAgentTypeProvider;
        this.referrerTypeProvider = referrerTypeProvider;
        this.projectIdProvider = projectIdProvider;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LogEntry parseLine(@NotNull String line) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String[] stringArray = new String[]{" "};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List data2 = (List)destination$iv$iv;
        String date = StringUtils.substringBetween((String)line, (String)"[", (String)"]");
        Pair<ApiType, HttpMethod> pair = this.getApiTypeAndHttpMethod(line);
        ApiType type = (ApiType)((Object)pair.component1());
        HttpMethod method = (HttpMethod)((Object)pair.component2());
        ReferrerType referrerType = this.getReferrerType(line);
        UserAgentType userAgentType = this.getUserAgentType(line);
        List projectIds = CollectionsKt.distinct((Iterable)this.projectIdProvider.getProjectIds(line, type));
        Intrinsics.checkNotNull((Object)date);
        return new LogEntry(date, this.cleanupUsername((String)CollectionsKt.getOrNull((List)data2, (int)2)), type, method, referrerType, userAgentType, projectIds);
    }

    private final Pair<ApiType, HttpMethod> getApiTypeAndHttpMethod(String line) {
        for (HttpMethod method : HttpMethod.getEntries()) {
            String keyword = "" + (Object)((Object)method) + ' ';
            int idx = this.findHttpMethodIndex(line, keyword);
            if (idx < 0) continue;
            int start = idx + keyword.length();
            int end = StringsKt.indexOf$default((CharSequence)line, (String)" ", (int)start, (boolean)false, (int)4, null);
            String string = line.substring(start, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return TuplesKt.to((Object)((Object)this.apiTypeProvider.getApiType(method, string)), (Object)((Object)method));
        }
        return TuplesKt.to((Object)((Object)ApiType.UNKNOWN), (Object)((Object)HttpMethod.UNKNOWN));
    }

    @VisibleForTesting
    @NotNull
    public final UserAgentType getUserAgentType(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Pair<Integer, Integer> indexes = this.findUserAgentIndexes(line);
        if (this.isIndexPairValid(indexes)) {
            String string = line.substring(((Number)indexes.getFirst()).intValue(), ((Number)indexes.getSecond()).intValue());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return this.userAgentTypeProvider.userAgentType(string);
        }
        return UserAgentType.OTHER;
    }

    @VisibleForTesting
    @NotNull
    public final ReferrerType getReferrerType(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Pair<Integer, Integer> indexes = this.findReferrerIndexes(line);
        if (this.isIndexPairValid(indexes)) {
            String string = line.substring(((Number)indexes.getFirst()).intValue(), ((Number)indexes.getSecond()).intValue());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return this.referrerTypeProvider.referrerType(string);
        }
        return ReferrerType.OTHER;
    }

    private final int findHttpMethodIndex(String line, String keyword) {
        int idx = StringsKt.indexOf$default((CharSequence)line, (String)keyword, (int)0, (boolean)false, (int)4, null);
        while (idx >= 0) {
            Object[] objectArray = new Character[]{Character.valueOf(' '), Character.valueOf('\"')};
            if (this.isPrecededByChars(line, idx, SetsKt.setOf((Object[])objectArray))) break;
            idx = StringsKt.indexOf$default((CharSequence)line, (String)keyword, (int)(idx + 1), (boolean)false, (int)4, null);
        }
        return idx;
    }

    @VisibleForTesting
    @NotNull
    public final Pair<Integer, Integer> findUserAgentIndexes(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        int userAgentStartIndex = StringsKt.indexOf$default((CharSequence)line, (String)COMMON_USER_AGENT_START, (int)0, (boolean)false, (int)4, null);
        int userAgentEndIndex = StringsKt.indexOf$default((CharSequence)line, (String)"\"", (int)userAgentStartIndex, (boolean)false, (int)4, null);
        if (userAgentStartIndex == -1) {
            int quotationMarkIndex = 0;
            quotationMarkIndex = line.length();
            int n = 4;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                quotationMarkIndex = StringsKt.lastIndexOf$default((CharSequence)line, (String)"\"", (int)(quotationMarkIndex - 1), (boolean)false, (int)4, null);
            }
            userAgentEndIndex = StringsKt.indexOf$default((CharSequence)line, (String)"\"", (int)(quotationMarkIndex + 1), (boolean)false, (int)4, null);
            userAgentStartIndex = quotationMarkIndex + 1;
        }
        return new Pair((Object)userAgentStartIndex, (Object)userAgentEndIndex);
    }

    @VisibleForTesting
    @NotNull
    public final Pair<Integer, Integer> findReferrerIndexes(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Pair<Integer, Integer> indexes = this.findUserAgentIndexes(line);
        if (!this.isIndexPairValid(indexes)) {
            return new Pair((Object)-1, (Object)-1);
        }
        int referrerEndIndex = StringsKt.lastIndexOf$default((CharSequence)line, (String)"\"", (int)(((Number)indexes.getFirst()).intValue() - 2), (boolean)false, (int)4, null);
        int referrerStartIndex = StringsKt.lastIndexOf$default((CharSequence)line, (String)"\"", (int)(referrerEndIndex - 1), (boolean)false, (int)4, null) + 1;
        return new Pair((Object)referrerStartIndex, (Object)referrerEndIndex);
    }

    private final boolean isIndexPairValid(Pair<Integer, Integer> indexes) {
        return ((Number)indexes.getFirst()).intValue() >= 0 && ((Number)indexes.getSecond()).intValue() >= 0 && ((Number)indexes.getFirst()).intValue() <= ((Number)indexes.getSecond()).intValue();
    }

    private final boolean isPrecededByChars(String line, int idx, Set<Character> chars) {
        return idx > 0 && chars.contains(Character.valueOf(line.charAt(idx - 1)));
    }

    private final String cleanupUsername(String username) {
        return StringUtils.isBlank((CharSequence)username) || Intrinsics.areEqual((Object)"-", (Object)username) ? null : StringUtils.strip((String)username, (String)"'\"");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/guardrails/logs/TomcatAccessLogParserV2$Companion;", "", "()V", "COMMON_USER_AGENT_START", "", "FOLLOWING_CHAR_INDEX", "", "NOT_FOUND", "NUMBER_OF_QUOTATION_MARKS", "QUOTATION_MARK_OFFSET", "START_INDEX", "USER_POS", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

