/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.logs;

import com.atlassian.jira.migration.guardrails.logs.UserAgentType;
import com.atlassian.jira.migration.guardrails.logs.UserAgentTypeProvider;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\r\u001a\u00020\tH\u0002J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000bR \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/guardrails/logs/UserAgentTypeProvider;", "", "()V", "matchersByType", "", "Lcom/atlassian/jira/migration/guardrails/logs/UserAgentType;", "", "Lcom/atlassian/jira/migration/guardrails/logs/UserAgentTypeProvider$UserAgentTypeMatcher;", "addMatcher", "", "pattern", "", "userAgentType", "addUserAgentTypeMatchers", "entry", "UserAgentTypeMatcher", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUserAgentTypeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserAgentTypeProvider.kt\ncom/atlassian/jira/migration/guardrails/logs/UserAgentTypeProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n215#2:100\n216#2:103\n1855#3,2:101\n*S KotlinDebug\n*F\n+ 1 UserAgentTypeProvider.kt\ncom/atlassian/jira/migration/guardrails/logs/UserAgentTypeProvider\n*L\n88#1:100\n88#1:103\n89#1:101,2\n*E\n"})
public final class UserAgentTypeProvider {
    @NotNull
    private final Map<UserAgentType, List<UserAgentTypeMatcher>> matchersByType = new LinkedHashMap();

    public UserAgentTypeProvider() {
        this.addUserAgentTypeMatchers();
    }

    private final void addUserAgentTypeMatchers() {
        this.addMatcher("(?<=\\b|[\\s;()])https?:\\/\\/(?:www\\.)?google\\.com(?=\\/|$|[\\s;()])", UserAgentType.ROBOT);
        this.addMatcher("(?<=\\b|[\\s;()])https?:\\/\\/(?:www\\.)?bing\\.com(?=\\/|$|[\\s;()])", UserAgentType.ROBOT);
        this.addMatcher("(?<=\\b|[\\s;()])https?:\\/\\/(?:www\\.)?facebook\\.com(?=\\/|$|[\\s;()])", UserAgentType.ROBOT);
        this.addMatcher("Mozilla\\/5\\.0 .*? AppleWebKit\\/\\d+(?:\\.\\d+){1,2} \\(KHTML, like Gecko\\) Chrome\\/(\\d+(?:\\.\\d+){1,3}) Safari\\/\\d+(?:\\.\\d+){1,2}", UserAgentType.BROWSER);
        this.addMatcher("Mozilla\\/5\\.0 .*? Gecko\\/20100101 Firefox\\/(\\d+\\.\\d+(?:\\.\\d+)?)", UserAgentType.BROWSER);
        this.addMatcher("Mozilla\\/5\\.0 .*? AppleWebKit\\/\\d+(?:\\.\\d+){1,2} \\(KHTML, like Gecko\\) Chrome\\/\\d+(?:\\.\\d+){1,3} Safari\\/\\d+(?:\\.\\d+){1,2} Edg\\/(\\d+(?:\\.\\d+){1,3})", UserAgentType.BROWSER);
        this.addMatcher("Mozilla\\/5\\.0 \\(Macintosh;.*? AppleWebKit\\/\\d+(?:\\.\\d+){1,2} \\(KHTML, like Gecko\\) Version\\/(\\d+\\.\\d+(?:\\.\\d+)?) Safari\\/\\d+(?:\\.\\d+){1,2}", UserAgentType.BROWSER);
        this.addMatcher("Mozilla\\/5\\.0 .*? AppleWebKit\\/\\d+(?:\\.\\d+){1,2} \\(KHTML, like Gecko\\) Chrome\\/\\d+(?:\\.\\d+){1,3} YaBrowser\\/(\\d+(?:\\.\\d+){1,3}) Safari\\/\\d+(?:\\.\\d+){1,2}", UserAgentType.BROWSER);
        this.addMatcher("Mozilla\\/5\\.0 .*? AppleWebKit\\/\\d+(?:\\.\\d+){1,2} \\(KHTML, like Gecko\\) Chrome\\/\\d+(?:\\.\\d+){1,3} Safari\\/\\d+(?:\\.\\d+){1,2} OPR\\/(\\d+(?:\\.\\d+){1,3})", UserAgentType.BROWSER);
        this.addMatcher("^$", UserAgentType.EMPTY);
    }

    private final void addMatcher(String pattern, UserAgentType userAgentType) {
        UserAgentTypeMatcher matcher = new UserAgentTypeMatcher(pattern, userAgentType);
        this.matchersByType.computeIfAbsent(userAgentType, arg_0 -> UserAgentTypeProvider.addMatcher$lambda$0(addMatcher.1.INSTANCE, arg_0)).add(matcher);
    }

    @NotNull
    public final UserAgentType userAgentType(@NotNull String entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Map<UserAgentType, List<UserAgentTypeMatcher>> $this$forEach$iv = this.matchersByType;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UserAgentType, List<UserAgentTypeMatcher>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<UserAgentType, List<UserAgentTypeMatcher>> element$iv;
            Map.Entry<UserAgentType, List<UserAgentTypeMatcher>> matchers = element$iv = iterator2.next();
            boolean bl = false;
            Iterable $this$forEach$iv2 = matchers.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                UserAgentTypeMatcher matcher = (UserAgentTypeMatcher)element$iv2;
                boolean bl2 = false;
                if (!matcher.matches(entry)) continue;
                return matcher.getUserAgentType();
            }
        }
        return UserAgentType.OTHER;
    }

    private static final List addMatcher$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/guardrails/logs/UserAgentTypeProvider$UserAgentTypeMatcher;", "", "pattern", "", "userAgentType", "Lcom/atlassian/jira/migration/guardrails/logs/UserAgentType;", "(Ljava/lang/String;Lcom/atlassian/jira/migration/guardrails/logs/UserAgentType;)V", "userAgentPattern", "Ljava/util/regex/Pattern;", "getUserAgentType", "()Lcom/atlassian/jira/migration/guardrails/logs/UserAgentType;", "matches", "", "jira-migration-plugin"})
    private static final class UserAgentTypeMatcher {
        @NotNull
        private final UserAgentType userAgentType;
        @NotNull
        private final Pattern userAgentPattern;

        public UserAgentTypeMatcher(@NotNull String pattern, @NotNull UserAgentType userAgentType) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)((Object)userAgentType), (String)"userAgentType");
            this.userAgentType = userAgentType;
            Pattern pattern2 = Pattern.compile(pattern);
            Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
            this.userAgentPattern = pattern2;
        }

        @NotNull
        public final UserAgentType getUserAgentType() {
            return this.userAgentType;
        }

        public final boolean matches(@NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return this.userAgentPattern.matcher(pattern).find();
        }
    }
}

