/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries;

import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.schema.DialectProvider;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.StatementOptions;
import java.sql.Connection;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015J\u001e\u0010\u0016\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015J(\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u0001H\u0019H\u00190\u0018\"\u0004\b\u0000\u0010\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0015J5\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001c0\u001c0\u00182\u001a\u0010\u001d\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00150\u001e\"\u0006\u0012\u0002\b\u00030\u0015\u00a2\u0006\u0002\u0010\u001fJ\"\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00190\u0018\"\u0004\b\u0000\u0010\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u000f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseConnection;", "", "db", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseConnection;", "queryTimeout", "Lkotlin/time/Duration;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseConnection;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "dialectConfig", "Lcom/atlassian/pocketknife/api/querydsl/schema/DialectProvider$Config;", "getDialectConfig", "()Lcom/atlassian/pocketknife/api/querydsl/schema/DialectProvider$Config;", "jdbcConnection", "Ljava/sql/Connection;", "getJdbcConnection", "()Ljava/sql/Connection;", "J", "count", "", "field", "Lcom/querydsl/core/types/dsl/SimpleExpression;", "from", "Lcom/querydsl/core/types/Expression;", "countDistinct", "select", "Lcom/querydsl/sql/SQLQuery;", "T", "kotlin.jvm.PlatformType", "expression", "Lcom/querydsl/core/Tuple;", "expressions", "", "([Lcom/querydsl/core/types/Expression;)Lcom/querydsl/sql/SQLQuery;", "setTimeout", "query", "jira-migration-plugin"})
public final class AssessmentDatabaseConnection {
    @NotNull
    private final DatabaseConnection db;
    private final long queryTimeout;

    private AssessmentDatabaseConnection(DatabaseConnection db, long queryTimeout) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.db = db;
        this.queryTimeout = queryTimeout;
    }

    @NotNull
    public final <T> SQLQuery<T> select(@NotNull Expression<T> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        SQLQuery sQLQuery = this.db.select(expression);
        Intrinsics.checkNotNullExpressionValue((Object)sQLQuery, (String)"select(...)");
        return this.setTimeout(sQLQuery);
    }

    @NotNull
    public final SQLQuery<Tuple> select(Expression<?> ... expressions) {
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        SQLQuery sQLQuery = this.db.select(Arrays.copyOf(expressions, expressions.length));
        Intrinsics.checkNotNullExpressionValue((Object)sQLQuery, (String)"select(...)");
        return this.setTimeout(sQLQuery);
    }

    public final long count(@NotNull SimpleExpression<?> field, @NotNull Expression<?> from) {
        Intrinsics.checkNotNullParameter(field, (String)"field");
        Intrinsics.checkNotNullParameter(from, (String)"from");
        NumberExpression numberExpression = field.count();
        Intrinsics.checkNotNullExpressionValue((Object)numberExpression, (String)"count(...)");
        return ((SQLQuery)this.select((Expression<T>)((Expression)numberExpression)).from(from)).fetchCount();
    }

    public final long countDistinct(@NotNull SimpleExpression<?> field, @NotNull Expression<?> from) {
        Intrinsics.checkNotNullParameter(field, (String)"field");
        Intrinsics.checkNotNullParameter(from, (String)"from");
        return ((SQLQuery)((SQLQuery)this.select((Expression<T>)((Expression)field)).distinct()).from(from)).fetchCount();
    }

    private final <T> SQLQuery<T> setTimeout(SQLQuery<T> query) {
        query.setStatementOptions(StatementOptions.builder().setQueryTimeout(Integer.valueOf((int)Duration.getInWholeSeconds-impl((long)this.queryTimeout))).build());
        return query;
    }

    @NotNull
    public final DialectProvider.Config getDialectConfig() {
        DialectProvider.Config config2 = this.db.getDialectConfig();
        Intrinsics.checkNotNullExpressionValue((Object)config2, (String)"getDialectConfig(...)");
        return config2;
    }

    @NotNull
    public final Connection getJdbcConnection() {
        Connection connection = this.db.getJdbcConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getJdbcConnection(...)");
        return connection;
    }

    public /* synthetic */ AssessmentDatabaseConnection(DatabaseConnection db, long queryTimeout, DefaultConstructorMarker $constructor_marker) {
        this(db, queryTimeout);
    }
}

