/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.guardrails.queries.AssessmentDatabaseAccessor;
import com.atlassian.jira.migration.guardrails.queries.AssessmentDatabaseConnection;
import com.atlassian.jira.migration.guardrails.queries.TableSizeFetcher;
import com.atlassian.jira.migration.guardrails.queries.TablesSizeFetcherKt;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0017\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0002J\u0012\u0010\r\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/MsSqlServerTableSizeFetcher;", "Lcom/atlassian/jira/migration/guardrails/queries/TableSizeFetcher;", "databaseAccessor", "Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseAccessor;", "(Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseAccessor;)V", "getSizeOfTable", "", "tableName", "", "parseBytes", "str", "(Ljava/lang/String;)Ljava/lang/Long;", "parseBytesOrZero", "parseLongOrZero", "parseSpaceUsedQueryResult", "Lcom/atlassian/jira/migration/guardrails/queries/MsSqlServerTableSizeFetcher$SpaceUsedResult;", "rs", "Ljava/sql/ResultSet;", "Companion", "SpaceUsedResult", "jira-migration-plugin"})
public final class MsSqlServerTableSizeFetcher
implements TableSizeFetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AssessmentDatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(MsSqlServerTableSizeFetcher.class);

    public MsSqlServerTableSizeFetcher(@NotNull AssessmentDatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public long getSizeOfTable(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Object object = this.databaseAccessor.run-IoAF18A((Function1)new Function1<AssessmentDatabaseConnection, Long>(tableName, this){
            final /* synthetic */ String $tableName;
            final /* synthetic */ MsSqlServerTableSizeFetcher this$0;
            {
                this.$tableName = $tableName;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull AssessmentDatabaseConnection db) {
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                CallableStatement spaceUsedCall = db.getJdbcConnection().prepareCall("{call sp_spaceused (?)}");
                spaceUsedCall.setString(1, this.$tableName);
                ResultSet result2 = spaceUsedCall.executeQuery();
                result2.next();
                Intrinsics.checkNotNull((Object)result2);
                SpaceUsedResult spaceUsedResult = MsSqlServerTableSizeFetcher.access$parseSpaceUsedQueryResult(this.this$0, result2);
                return spaceUsedResult.getDataBytes() + spaceUsedResult.getIndexSizeBytes();
            }
        });
        Logger logger2 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        Function1 function1 = TablesSizeFetcherKt.access$logAndReturnZero(logger2);
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        return ((Number)(throwable == null ? object : function1.invoke((Object)throwable))).longValue();
    }

    private final SpaceUsedResult parseSpaceUsedQueryResult(ResultSet rs) {
        String string = rs.getString("name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        long l = this.parseLongOrZero(rs.getString("rows"));
        String string2 = rs.getString("reserved");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        long l2 = this.parseBytesOrZero(string2);
        String string3 = rs.getString("data");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        long l3 = this.parseBytesOrZero(string3);
        String string4 = rs.getString("index_size");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
        long l4 = this.parseBytesOrZero(string4);
        String string5 = rs.getString("unused");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
        return new SpaceUsedResult(string, l, l2, l3, l4, this.parseBytesOrZero(string5));
    }

    private final long parseLongOrZero(String str) {
        long l;
        try {
            String string = str;
            l = string != null && (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) != null ? Long.parseLong(string) : 0L;
        }
        catch (NumberFormatException e) {
            log.warn("Could not parse string to long: {}", (Object)str, (Object)e);
            l = 0L;
        }
        return l;
    }

    private final long parseBytesOrZero(String str) {
        log.warn("Could not parse bytes value from the query response, returning value of 0 bytes instead");
        Long l = this.parseBytes(str);
        return l != null ? l : 0L;
    }

    @VisibleForTesting
    @Nullable
    public final Long parseBytes(@NotNull String str) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Regex valueWithUnitPattern = new Regex("(\\d+)\\s*(KB|MB|GB|TB)*");
        MatchResult matchResult = Regex.find$default((Regex)valueWithUnitPattern, (CharSequence)str, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        Object object = match.getGroups().get(1);
        if (object == null || (object = object.getValue()) == null) {
            return null;
        }
        Object value = object;
        Object object2 = match.getGroups().get(2);
        if (object2 == null || (object2 = object2.getValue()) == null) {
            return Long.parseLong((String)value);
        }
        Object unit = object2;
        String string = ((String)unit).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        switch (string) {
            case "kb": {
                l = Long.parseLong((String)value) * 1024L;
                break;
            }
            case "mb": {
                l = Long.parseLong((String)value) * 0x100000L;
                break;
            }
            case "gb": {
                l = Long.parseLong((String)value) * 0x40000000L;
                break;
            }
            case "tb": {
                l = Long.parseLong((String)value) * 0x10000000000L;
                break;
            }
            default: {
                l = null;
            }
        }
        return l;
    }

    public static final /* synthetic */ SpaceUsedResult access$parseSpaceUsedQueryResult(MsSqlServerTableSizeFetcher $this, ResultSet rs) {
        return $this.parseSpaceUsedQueryResult(rs);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/MsSqlServerTableSizeFetcher$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/MsSqlServerTableSizeFetcher$SpaceUsedResult;", "", "name", "", "rows", "", "reservedBytes", "dataBytes", "indexSizeBytes", "unusedBytes", "(Ljava/lang/String;JJJJJ)V", "getDataBytes", "()J", "getIndexSizeBytes", "getName", "()Ljava/lang/String;", "getReservedBytes", "getRows", "getUnusedBytes", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class SpaceUsedResult {
        @NotNull
        private final String name;
        private final long rows;
        private final long reservedBytes;
        private final long dataBytes;
        private final long indexSizeBytes;
        private final long unusedBytes;

        public SpaceUsedResult(@NotNull String name, long rows, long reservedBytes, long dataBytes, long indexSizeBytes, long unusedBytes) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.rows = rows;
            this.reservedBytes = reservedBytes;
            this.dataBytes = dataBytes;
            this.indexSizeBytes = indexSizeBytes;
            this.unusedBytes = unusedBytes;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getRows() {
            return this.rows;
        }

        public final long getReservedBytes() {
            return this.reservedBytes;
        }

        public final long getDataBytes() {
            return this.dataBytes;
        }

        public final long getIndexSizeBytes() {
            return this.indexSizeBytes;
        }

        public final long getUnusedBytes() {
            return this.unusedBytes;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final long component2() {
            return this.rows;
        }

        public final long component3() {
            return this.reservedBytes;
        }

        public final long component4() {
            return this.dataBytes;
        }

        public final long component5() {
            return this.indexSizeBytes;
        }

        public final long component6() {
            return this.unusedBytes;
        }

        @NotNull
        public final SpaceUsedResult copy(@NotNull String name, long rows, long reservedBytes, long dataBytes, long indexSizeBytes, long unusedBytes) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new SpaceUsedResult(name, rows, reservedBytes, dataBytes, indexSizeBytes, unusedBytes);
        }

        public static /* synthetic */ SpaceUsedResult copy$default(SpaceUsedResult spaceUsedResult, String string, long l, long l2, long l3, long l4, long l5, int n, Object object) {
            if ((n & 1) != 0) {
                string = spaceUsedResult.name;
            }
            if ((n & 2) != 0) {
                l = spaceUsedResult.rows;
            }
            if ((n & 4) != 0) {
                l2 = spaceUsedResult.reservedBytes;
            }
            if ((n & 8) != 0) {
                l3 = spaceUsedResult.dataBytes;
            }
            if ((n & 0x10) != 0) {
                l4 = spaceUsedResult.indexSizeBytes;
            }
            if ((n & 0x20) != 0) {
                l5 = spaceUsedResult.unusedBytes;
            }
            return spaceUsedResult.copy(string, l, l2, l3, l4, l5);
        }

        @NotNull
        public String toString() {
            return "SpaceUsedResult(name=" + this.name + ", rows=" + this.rows + ", reservedBytes=" + this.reservedBytes + ", dataBytes=" + this.dataBytes + ", indexSizeBytes=" + this.indexSizeBytes + ", unusedBytes=" + this.unusedBytes + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.rows);
            result2 = result2 * 31 + Long.hashCode(this.reservedBytes);
            result2 = result2 * 31 + Long.hashCode(this.dataBytes);
            result2 = result2 * 31 + Long.hashCode(this.indexSizeBytes);
            result2 = result2 * 31 + Long.hashCode(this.unusedBytes);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SpaceUsedResult)) {
                return false;
            }
            SpaceUsedResult spaceUsedResult = (SpaceUsedResult)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)spaceUsedResult.name)) {
                return false;
            }
            if (this.rows != spaceUsedResult.rows) {
                return false;
            }
            if (this.reservedBytes != spaceUsedResult.reservedBytes) {
                return false;
            }
            if (this.dataBytes != spaceUsedResult.dataBytes) {
                return false;
            }
            if (this.indexSizeBytes != spaceUsedResult.indexSizeBytes) {
                return false;
            }
            return this.unusedBytes == spaceUsedResult.unusedBytes;
        }
    }
}

