/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries;

import com.atlassian.jira.migration.guardrails.queries.AssessmentDatabaseAccessor;
import com.atlassian.jira.migration.guardrails.queries.AssessmentDatabaseConnection;
import com.atlassian.jira.migration.guardrails.queries.TableSizeFetcher;
import com.atlassian.jira.migration.guardrails.queries.TablesSizeFetcherKt;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberTemplate;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J%\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/OracleTableSizeFetcher;", "Lcom/atlassian/jira/migration/guardrails/queries/TableSizeFetcher;", "databaseAccessor", "Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseAccessor;", "(Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseAccessor;)V", "getIndexesSize", "", "db", "Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseConnection;", "tableName", "", "getSizeOfTable", "getTableSize", "kotlin.jvm.PlatformType", "(Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseConnection;Ljava/lang/String;)Ljava/lang/Long;", "Companion", "jira-migration-plugin"})
public final class OracleTableSizeFetcher
implements TableSizeFetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AssessmentDatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(OracleTableSizeFetcher.class);

    public OracleTableSizeFetcher(@NotNull AssessmentDatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public long getSizeOfTable(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Object object = this.databaseAccessor.run-IoAF18A((Function1)new Function1<AssessmentDatabaseConnection, Long>(this, tableName){
            final /* synthetic */ OracleTableSizeFetcher this$0;
            final /* synthetic */ String $tableName;
            {
                this.this$0 = $receiver;
                this.$tableName = $tableName;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull AssessmentDatabaseConnection db) {
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                return OracleTableSizeFetcher.access$getTableSize(this.this$0, db, this.$tableName) + OracleTableSizeFetcher.access$getIndexesSize(this.this$0, db, this.$tableName);
            }
        });
        Logger logger2 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        Function1 function1 = TablesSizeFetcherKt.access$logAndReturnZero(logger2);
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        return ((Number)(throwable == null ? object : function1.invoke((Object)throwable))).longValue();
    }

    private final Long getTableSize(AssessmentDatabaseConnection db, String tableName) {
        NumberTemplate numberTemplate = Expressions.numberTemplate(Long.TYPE, (String)"bytes", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)numberTemplate, (String)"numberTemplate(...)");
        return (Long)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)numberTemplate).from((Expression)Expressions.stringTemplate((String)"user_segments", (Object[])new Object[0]))).where((Predicate)Expressions.stringTemplate((String)"segment_type", (Object[])new Object[0]).eq((Object)"TABLE"))).where((Predicate)Expressions.stringTemplate((String)"segment_name", (Object[])new Object[0]).eq((Object)tableName))).fetchOne();
    }

    private final long getIndexesSize(AssessmentDatabaseConnection db, String tableName) {
        StringTemplate stringTemplate = Expressions.stringTemplate((String)"index_name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)stringTemplate, (String)"stringTemplate(...)");
        List indexesNames = ((SQLQuery)((SQLQuery)db.select((Expression)stringTemplate).from((Expression)Expressions.stringTemplate((String)"all_indexes", (Object[])new Object[0]))).where((Predicate)Expressions.stringTemplate((String)"table_name", (Object[])new Object[0]).eq((Object)tableName))).fetch();
        if (indexesNames.isEmpty()) {
            return 0L;
        }
        NumberTemplate numberTemplate = Expressions.numberTemplate(Long.TYPE, (String)"bytes", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)numberTemplate, (String)"numberTemplate(...)");
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)numberTemplate).from((Expression)Expressions.stringTemplate((String)"user_segments", (Object[])new Object[0]))).where((Predicate)Expressions.stringTemplate((String)"segment_type", (Object[])new Object[0]).eq((Object)"INDEX"))).where((Predicate)Expressions.stringTemplate((String)"segment_name", (Object[])new Object[0]).in((Collection)indexesNames))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return CollectionsKt.sumOfLong((Iterable)list);
    }

    public static final /* synthetic */ Long access$getTableSize(OracleTableSizeFetcher $this, AssessmentDatabaseConnection db, String tableName) {
        return $this.getTableSize(db, tableName);
    }

    public static final /* synthetic */ long access$getIndexesSize(OracleTableSizeFetcher $this, AssessmentDatabaseConnection db, String tableName) {
        return $this.getIndexesSize(db, tableName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/OracleTableSizeFetcher$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

