/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries.apps;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.migration.assessment.PluginManager;
import com.atlassian.jira.migration.guardrails.queries.App;
import com.atlassian.jira.migration.guardrails.queries.AppType;
import com.atlassian.jira.migration.guardrails.queries.QueryProductType;
import com.atlassian.jira.migration.guardrails.queries.apps.PluginAssessmentDetails;
import com.atlassian.jira.migration.guardrails.queries.apps.TransitionActionUtil;
import com.atlassian.jira.migration.guardrails.queries.apps.TransitionActionUtilFactory;
import com.atlassian.jira.plugin.workflow.WorkflowConditionModuleDescriptor;
import com.atlassian.jira.plugin.workflow.WorkflowFunctionModuleDescriptor;
import com.atlassian.jira.plugin.workflow.WorkflowValidatorModuleDescriptor;
import com.atlassian.migration.app.AbstractCloudMigrationRegistrar;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013J$\u0010\u0018\u001a\u0018\u0012\u0004\u0012\u00020\u0013\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u000e0\u00192\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/AppUsageService;", "", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "pluginManager", "Lcom/atlassian/jira/migration/assessment/PluginManager;", "customFieldManager", "Lcom/atlassian/jira/issue/CustomFieldManager;", "transitionActionUtilFactory", "Lcom/atlassian/jira/migration/guardrails/queries/apps/TransitionActionUtilFactory;", "abstractCloudMigrationRegistrar", "Lcom/atlassian/migration/app/AbstractCloudMigrationRegistrar;", "(Lcom/atlassian/plugin/PluginAccessor;Lcom/atlassian/jira/migration/assessment/PluginManager;Lcom/atlassian/jira/issue/CustomFieldManager;Lcom/atlassian/jira/migration/guardrails/queries/apps/TransitionActionUtilFactory;Lcom/atlassian/migration/app/AbstractCloudMigrationRegistrar;)V", "getAssessmentEligiblePluginDetails", "", "Lcom/atlassian/jira/migration/guardrails/queries/apps/PluginAssessmentDetails;", "getCustomFieldsForPlugin", "Lcom/atlassian/jira/issue/fields/CustomField;", "pluginKey", "", "getListenerType", "getPluginVersionFromKey", "getPluginVersionFromName", "pluginName", "getWorkflowEntitiesForPlugin", "", "Lcom/atlassian/plugin/descriptors/AbstractModuleDescriptor;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppUsageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppUsageService.kt\ncom/atlassian/jira/migration/guardrails/queries/apps/AppUsageService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n766#2:77\n857#2,2:78\n1549#2:80\n1620#2,3:81\n*S KotlinDebug\n*F\n+ 1 AppUsageService.kt\ncom/atlassian/jira/migration/guardrails/queries/apps/AppUsageService\n*L\n46#1:77\n46#1:78,2\n58#1:80\n58#1:81,3\n*E\n"})
public final class AppUsageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginAccessor pluginAccessor;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final CustomFieldManager customFieldManager;
    @NotNull
    private final TransitionActionUtilFactory transitionActionUtilFactory;
    @NotNull
    private final AbstractCloudMigrationRegistrar abstractCloudMigrationRegistrar;

    @Inject
    public AppUsageService(@NotNull PluginAccessor pluginAccessor, @NotNull PluginManager pluginManager, @NotNull CustomFieldManager customFieldManager, @NotNull TransitionActionUtilFactory transitionActionUtilFactory, @NotNull AbstractCloudMigrationRegistrar abstractCloudMigrationRegistrar) {
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)customFieldManager, (String)"customFieldManager");
        Intrinsics.checkNotNullParameter((Object)transitionActionUtilFactory, (String)"transitionActionUtilFactory");
        Intrinsics.checkNotNullParameter((Object)abstractCloudMigrationRegistrar, (String)"abstractCloudMigrationRegistrar");
        this.pluginAccessor = pluginAccessor;
        this.pluginManager = pluginManager;
        this.customFieldManager = customFieldManager;
        this.transitionActionUtilFactory = transitionActionUtilFactory;
        this.abstractCloudMigrationRegistrar = abstractCloudMigrationRegistrar;
    }

    @NotNull
    public final Map<String, List<AbstractModuleDescriptor<?>>> getWorkflowEntitiesForPlugin(@NotNull String pluginKey) {
        Intrinsics.checkNotNullParameter((Object)pluginKey, (String)"pluginKey");
        TransitionActionUtil transitionUtil = this.transitionActionUtilFactory.create(pluginKey);
        List<WorkflowFunctionModuleDescriptor> postFunctionDescriptors = transitionUtil.getPostFunctionDescriptors();
        List<WorkflowValidatorModuleDescriptor> validatorDescriptors = transitionUtil.getValidatorDescriptors();
        List<WorkflowConditionModuleDescriptor> conditionDescriptors = transitionUtil.getConditionDescriptors();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"postFunctions", postFunctionDescriptors), TuplesKt.to((Object)"validators", validatorDescriptors), TuplesKt.to((Object)"conditions", conditionDescriptors)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CustomField> getCustomFieldsForPlugin(@NotNull String pluginKey) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pluginKey, (String)"pluginKey");
        List list = this.customFieldManager.getCustomFieldObjects();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCustomFieldObjects(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CustomField it = (CustomField)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getCustomFieldType().getDescriptor().getPluginKey(), (Object)pluginKey)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String getPluginVersionFromName(@NotNull String pluginName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
        App app = Companion.getPluginMetadataFromName(pluginName);
        String keyFromName = app != null ? app.getAppKey() : null;
        Plugin plugin = this.pluginAccessor.getPlugin(keyFromName);
        if ((plugin != null && (plugin = plugin.getPluginInformation()) != null ? plugin.getVersion() : (string = null)) == null) {
            string = "0";
        }
        return string;
    }

    @NotNull
    public final String getPluginVersionFromKey(@NotNull String pluginKey) {
        String string;
        Intrinsics.checkNotNullParameter((Object)pluginKey, (String)"pluginKey");
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if ((plugin != null && (plugin = plugin.getPluginInformation()) != null ? plugin.getVersion() : (string = null)) == null) {
            string = "0";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PluginAssessmentDetails> getAssessmentEligiblePluginDetails() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.pluginManager.getEligibleAppsForAssessment();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p;
            Plugin plugin = (Plugin)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = p.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
            String string2 = p.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String string3 = p.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getKey(...)");
            String string4 = this.getPluginVersionFromKey(string3);
            String string5 = p.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getKey(...)");
            collection.add(new PluginAssessmentDetails(string, string2, string4, this.getListenerType(string5)));
        }
        return (List)destination$iv$iv;
    }

    private final String getListenerType(String pluginKey) {
        String string;
        try {
            string = this.abstractCloudMigrationRegistrar.getListenerMetadata(pluginKey).getListenerFamilyType().name();
        }
        catch (IllegalArgumentException e) {
            string = "NOT_FOUND";
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/AppUsageService$Companion;", "", "()V", "getPluginMetadataFromName", "Lcom/atlassian/jira/migration/guardrails/queries/App;", "pluginName", "", "getPluginTypeFromName", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final App getPluginMetadataFromName(@NotNull String pluginName) {
            Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
            QueryProductType queryProductType = QueryProductType.Companion.fromProductName(pluginName);
            return queryProductType != null ? queryProductType.getApp() : null;
        }

        @NotNull
        public final String getPluginTypeFromName(@NotNull String pluginName) {
            Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
            Object object = this.getPluginMetadataFromName(pluginName);
            if (object == null || (object = ((App)((Object)object)).getAppType()) == null || (object = ((AppType)((Object)object)).getAppTypeName()) == null) {
                object = "-";
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

