/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries.apps.jmcf;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.migration.db.ChangeGroupTable;
import com.atlassian.jira.migration.db.ChangeItemTable;
import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.db.ProjectTable;
import com.atlassian.jira.migration.db.apps.jmcf.JmcfFieldConfigItemTable;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.guardrails.queries.App;
import com.atlassian.jira.migration.guardrails.queries.AssessmentDatabaseAccessor;
import com.atlassian.jira.migration.guardrails.queries.AssessmentDatabaseConnection;
import com.atlassian.jira.migration.guardrails.queries.QueryProductType;
import com.atlassian.jira.migration.guardrails.queries.SingleResultAssessmentQuery;
import com.atlassian.jira.migration.guardrails.queries.apps.AppUsageService;
import com.atlassian.jira.migration.guardrails.queries.apps.jmcf.JmcfEntitiesPerCustomFieldQuery;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u0000 #2\u00020\u0001:\u0005#$%&'B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J*\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0014H\u0002J\u001b\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0014\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery;", "Lcom/atlassian/jira/migration/guardrails/queries/SingleResultAssessmentQuery;", "appUsageService", "Lcom/atlassian/jira/migration/guardrails/queries/apps/AppUsageService;", "databaseAccessor", "Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseAccessor;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/guardrails/queries/apps/AppUsageService;Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseAccessor;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "countIssuesAndTransitions", "", "db", "Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseConnection;", "jmcfFields", "", "Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$JmcfField;", "countTransitions", "", "", "issueIdsBatch", "", "createIssuesSeq", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$Issue;", "projectIdsBatch", "execute", "Lkotlin/Result;", "", "execute-d1pmJ48", "()Ljava/lang/Object;", "fetchJmcfFields", "getAssociatedProjectIds", "customFields", "isQueryEnabled", "", "Companion", "Issue", "JmcfField", "JmcfFieldSummary", "JmcfResult", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJmcfEntitiesPerCustomFieldQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JmcfEntitiesPerCustomFieldQuery.kt\ncom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,227:1\n1549#2:228\n1620#2,3:229\n1747#2,3:232\n1360#2:235\n1446#2,5:236\n1360#2:241\n1446#2,5:242\n1855#2,2:249\n1549#2:253\n1620#2,3:254\n1179#2,2:257\n1253#2,4:259\n1313#3:247\n1314#3:252\n215#4:248\n216#4:251\n*S KotlinDebug\n*F\n+ 1 JmcfEntitiesPerCustomFieldQuery.kt\ncom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery\n*L\n65#1:228\n65#1:229,3\n75#1:232,3\n78#1:235\n78#1:236,5\n79#1:241\n79#1:242,5\n103#1:249,2\n113#1:253\n113#1:254,3\n155#1:257,2\n155#1:259,4\n99#1:247\n99#1:252\n102#1:248\n102#1:251\n*E\n"})
public final class JmcfEntitiesPerCustomFieldQuery
extends SingleResultAssessmentQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppUsageService appUsageService;
    @NotNull
    private final AssessmentDatabaseAccessor databaseAccessor;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private static final BooleanExpression ALWAYS_TRUE_CONDITION = Expressions.ZERO.eq((Object)0);
    private static final String EXAMPLE;

    @Inject
    public JmcfEntitiesPerCustomFieldQuery(@NotNull AppUsageService appUsageService, @NotNull AssessmentDatabaseAccessor databaseAccessor, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)appUsageService, (String)"appUsageService");
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        String string = EXAMPLE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EXAMPLE");
        super("JMCF_CUSTOM_FIELDS", string, QueryProductType.JMCF);
        this.appUsageService = appUsageService;
        this.databaseAccessor = databaseAccessor;
        this.migrationFeatures = migrationFeatures;
    }

    @Override
    @NotNull
    protected Object execute-d1pmJ48() {
        return this.databaseAccessor.runWithLongTimeout-IoAF18A((Function1)new Function1<AssessmentDatabaseConnection, String>(this){
            final /* synthetic */ JmcfEntitiesPerCustomFieldQuery this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final String invoke(@NotNull AssessmentDatabaseConnection db) {
                void $this$sortedBy$iv;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                List jmcfFields = JmcfEntitiesPerCustomFieldQuery.access$fetchJmcfFields(this.this$0, db);
                NumberPath<Long> numberPath = ProjectTable.Companion.getPROJECT_TABLE().getID();
                Intrinsics.checkNotNullExpressionValue(numberPath, (String)"<get-ID>(...)");
                long allProjectsCount = db.count((SimpleExpression)numberPath, (Expression)ProjectTable.Companion.getPROJECT_TABLE());
                JmcfEntitiesPerCustomFieldQuery.access$countIssuesAndTransitions(this.this$0, db, jmcfFields);
                Iterable $this$map$iv = jmcfFields;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JmcfField jmcfField = (JmcfField)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getCustomField().getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    collection.add(new JmcfFieldSummary(string, it.getIssueCounter(), it.countProjects(allProjectsCount), it.countContexts(), it.getTransitionsCounter()));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                List jmcfFieldSummaries = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        JmcfFieldSummary it = (JmcfFieldSummary)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getCustomField());
                        it = (JmcfFieldSummary)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getCustomField())));
                    }
                });
                return com.atlassian.jira.migration.guardrails.queries.apps.jmcf.JmcfEntitiesPerCustomFieldQuery$Companion.access$wrapAndFormatResult(JmcfEntitiesPerCustomFieldQuery.Companion, jmcfFieldSummaries);
            }
        });
    }

    @Override
    public boolean isQueryEnabled() {
        return this.migrationFeatures.getEnableJmcfCustomFieldsAssessment();
    }

    /*
     * WARNING - void declaration
     */
    private final List<JmcfField> fetchJmcfFields(AssessmentDatabaseConnection db) {
        void $this$mapTo$iv$iv;
        NumberPath<Long> numberPath = JmcfFieldConfigItemTable.Companion.getJMCF_CONFIG_TABLE().getCustomFieldId();
        Intrinsics.checkNotNullExpressionValue(numberPath, (String)"<get-customFieldId>(...)");
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression)numberPath).from((Expression)JmcfFieldConfigItemTable.Companion.getJMCF_CONFIG_TABLE())).where((Predicate)JmcfFieldConfigItemTable.Companion.getJMCF_CONFIG_TABLE().getItemKey().eq((Object)"transitions"))).distinct()).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Set fieldsWithTransitionConfig = CollectionsKt.toSet((Iterable)list);
        Iterable $this$map$iv = this.appUsageService.getCustomFieldsForPlugin(App.JMCF.getAppKey());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CustomField customField = (CustomField)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JmcfField((CustomField)it, fieldsWithTransitionConfig.contains(it.getIdAsLong())));
        }
        return (List)destination$iv$iv;
    }

    private final Set<Long> getAssociatedProjectIds(List<JmcfField> customFields) {
        Set set;
        boolean associatedWithAllProjects;
        block7: {
            boolean bl;
            Iterable $this$any$iv = customFields;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JmcfField it = (JmcfField)element$iv;
                    boolean bl2 = false;
                    if (!it.getCustomField().isAllProjects()) continue;
                    bl = true;
                    break block7;
                }
                bl = associatedWithAllProjects = false;
            }
        }
        if (associatedWithAllProjects) {
            set = null;
        } else {
            Iterable list$iv$iv;
            JmcfField it;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = customFields;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (JmcfField)element$iv$iv;
                boolean bl = false;
                List list = it.getCustomField().getConfigurationSchemes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurationSchemes(...)");
                list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (FieldConfigScheme)element$iv$iv;
                boolean bl = false;
                List list = it.getAssociatedProjectIds();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAssociatedProjectIds(...)");
                list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        }
        return set;
    }

    private final void countIssuesAndTransitions(AssessmentDatabaseConnection db, List<JmcfField> jmcfFields) {
        if (jmcfFields.isEmpty()) {
            return;
        }
        Sequence $this$forEach$iv = SequencesKt.chunked((Sequence)SequencesKt.filter((Sequence)SequencesKt.map(this.createIssuesSeq(db, this.getAssociatedProjectIds(jmcfFields)), (Function1)((Function1)new Function1<Issue, Pair<? extends Long, ? extends List<? extends JmcfField>>>(jmcfFields){
            final /* synthetic */ List<JmcfField> $jmcfFields;
            {
                this.$jmcfFields = $jmcfFields;
                super(1);
            }

            @NotNull
            public final Pair<Long, List<JmcfField>> invoke(@NotNull Issue issue2) {
                JmcfField it;
                T element$iv$iv;
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
                Iterable $this$filter$iv = this.$jmcfFields;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                Iterator<T> iterator2 = $this$filterTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = iterator2.next();
                    it = (JmcfField)element$iv$iv;
                    boolean bl = false;
                    Boolean bl2 = it.isInScope(issue2);
                    Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"isInScope(...)");
                    if (!bl2.booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List associatedFields = (List)destination$iv$iv;
                Iterable $this$forEach$iv = associatedFields;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JmcfField it2 = (JmcfField)element$iv;
                    boolean bl = false;
                    it2.incrementIssuesCounter();
                }
                $this$forEach$iv = associatedFields;
                Long l = issue2.getId();
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                iterator2 = $this$filterTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = iterator2.next();
                    it = (JmcfField)element$iv$iv;
                    boolean bl = false;
                    if (!it.getReactsToTransitions()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return TuplesKt.to((Object)l, (Object)((List)destination$iv$iv));
            }
        })), (Function1)countIssuesAndTransitions.2.INSTANCE), (int)999);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map<Long, Long> idToTransitionCount;
            List idToFieldsPairsBatch = (List)element$iv;
            boolean bl = false;
            Map idToFields = MapsKt.toMap((Iterable)idToFieldsPairsBatch);
            Map<Long, Long> $this$forEach$iv2 = idToTransitionCount = this.countTransitions(db, idToFields.keySet());
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<Long, Long>> iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<Long, Long> element$iv2;
                Map.Entry<Long, Long> entry = element$iv2 = iterator2.next();
                boolean bl2 = false;
                long issueId = ((Number)entry.getKey()).longValue();
                long count2 = ((Number)entry.getValue()).longValue();
                List list = (List)idToFields.get(issueId);
                if (list == null) continue;
                Iterable $this$forEach$iv3 = list;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    JmcfField it = (JmcfField)element$iv3;
                    boolean bl3 = false;
                    it.incrementTransitionsCounter(count2);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<Issue> createIssuesSeq(AssessmentDatabaseConnection db, Set<Long> projectIdsBatch) {
        List list;
        if (projectIdsBatch == null) {
            list = CollectionsKt.listOf((Object)ALWAYS_TRUE_CONDITION);
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = CollectionsKt.chunked((Iterable)projectIdsBatch, (int)999);
            boolean $i$f$map = false;
            void var6_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                List list2 = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().in((Collection)it));
            }
            list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        List projectIdBatches = list;
        return SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)projectIdBatches), (Function1)((Function1)new Function1<BooleanExpression, Sequence<? extends Tuple>>(db){
            final /* synthetic */ AssessmentDatabaseConnection $db;
            {
                this.$db = $db;
                super(1);
            }

            @NotNull
            public final Sequence<Tuple> invoke(BooleanExpression projectIdBatchCondition) {
                Expression[] expressionArray = new Expression[3];
                Intrinsics.checkNotNullExpressionValue(JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID(), (String)"<get-ID>(...)");
                Intrinsics.checkNotNullExpressionValue(JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT(), (String)"<get-PROJECT>(...)");
                Intrinsics.checkNotNullExpressionValue((Object)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getISSUE_TYPE(), (String)"<get-ISSUE_TYPE>(...)");
                SQLQuery sQLQuery = (SQLQuery)this.$db.select(expressionArray).from((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE());
                expressionArray = new Predicate[]{JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().isNotNull(), JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getISSUE_TYPE().isNotNull(), projectIdBatchCondition};
                CloseableIterator closeableIterator = ((SQLQuery)sQLQuery.where((Predicate[])expressionArray)).iterate();
                Intrinsics.checkNotNullExpressionValue((Object)closeableIterator, (String)"iterate(...)");
                return SequencesKt.asSequence((Iterator)((Iterator)closeableIterator));
            }
        })), (Function1)createIssuesSeq.2.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Long, Long> countTransitions(AssessmentDatabaseConnection db, Set<Long> issueIdsBatch) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        SimpleExpression countColumn = SQLExpressions.count().as("count");
        Expression[] expressionArray = new Expression[2];
        Intrinsics.checkNotNullExpressionValue(ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getISSUE_ID(), (String)"<get-ISSUE_ID>(...)");
        Intrinsics.checkNotNull((Object)countColumn);
        expressionArray[1] = countColumn;
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)ChangeItemTable.Companion.getCHANGEITEM_TABLE())).join((EntityPath)ChangeGroupTable.Companion.getCHANGEGROUP_TABLE())).on((Predicate)ChangeItemTable.Companion.getCHANGEITEM_TABLE().getGROUP_ID().eq((Expression)ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getID()));
        expressionArray = new Predicate[]{ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getISSUE_ID().in((Collection)issueIdsBatch), ChangeItemTable.Companion.getCHANGEITEM_TABLE().getFIELD().eq((Object)"status")};
        Iterable iterable = ((SQLQuery)((SQLQuery)sQLQuery.where((Predicate[])expressionArray)).groupBy((Expression)ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getISSUE_ID())).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"fetch(...)");
        iterable = iterable;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var7_8 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Tuple it = (Tuple)element$iv$iv;
            boolean bl = false;
            Object object = it.get((Expression)ChangeGroupTable.Companion.getCHANGEGROUP_TABLE().getISSUE_ID());
            Intrinsics.checkNotNull((Object)object);
            Object object2 = it.get((Expression)countColumn);
            Intrinsics.checkNotNull((Object)object2);
            Pair pair = TuplesKt.to((Object)object, (Object)object2);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    public static final /* synthetic */ List access$fetchJmcfFields(JmcfEntitiesPerCustomFieldQuery $this, AssessmentDatabaseConnection db) {
        return $this.fetchJmcfFields(db);
    }

    public static final /* synthetic */ void access$countIssuesAndTransitions(JmcfEntitiesPerCustomFieldQuery $this, AssessmentDatabaseConnection db, List jmcfFields) {
        $this.countIssuesAndTransitions(db, jmcfFields);
    }

    static {
        Object[] objectArray = new JmcfFieldSummary[]{new JmcfFieldSummary("customfield_10099", 3L, 18L, 5L, null), new JmcfFieldSummary("customfield_10100", 1L, 7L, 18L, 18L), new JmcfFieldSummary("customfield_10101", 1L, 4L, 2L, 11L)};
        EXAMPLE = JmcfEntitiesPerCustomFieldQuery.Companion.wrapAndFormatResult(CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\t0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$Companion;", "", "()V", "ALWAYS_TRUE_CONDITION", "Lcom/querydsl/core/types/dsl/BooleanExpression;", "kotlin.jvm.PlatformType", "getALWAYS_TRUE_CONDITION", "()Lcom/querydsl/core/types/dsl/BooleanExpression;", "EXAMPLE", "", "getEXAMPLE", "()Ljava/lang/String;", "wrapAndFormatResult", "entities", "", "Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$JmcfFieldSummary;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final BooleanExpression getALWAYS_TRUE_CONDITION() {
            return ALWAYS_TRUE_CONDITION;
        }

        public final String getEXAMPLE() {
            return EXAMPLE;
        }

        private final String wrapAndFormatResult(List<JmcfFieldSummary> entities) {
            return new Gson().toJson((Object)new JmcfResult(entities.size(), entities));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$Issue;", "", "id", "", "projectId", "issueTypeId", "", "(JJLjava/lang/String;)V", "getId", "()J", "getIssueTypeId", "()Ljava/lang/String;", "getProjectId", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    private static final class Issue {
        private final long id;
        private final long projectId;
        @NotNull
        private final String issueTypeId;

        public Issue(long id, long projectId, @NotNull String issueTypeId) {
            Intrinsics.checkNotNullParameter((Object)issueTypeId, (String)"issueTypeId");
            this.id = id;
            this.projectId = projectId;
            this.issueTypeId = issueTypeId;
        }

        public final long getId() {
            return this.id;
        }

        public final long getProjectId() {
            return this.projectId;
        }

        @NotNull
        public final String getIssueTypeId() {
            return this.issueTypeId;
        }

        public final long component1() {
            return this.id;
        }

        public final long component2() {
            return this.projectId;
        }

        @NotNull
        public final String component3() {
            return this.issueTypeId;
        }

        @NotNull
        public final Issue copy(long id, long projectId, @NotNull String issueTypeId) {
            Intrinsics.checkNotNullParameter((Object)issueTypeId, (String)"issueTypeId");
            return new Issue(id, projectId, issueTypeId);
        }

        public static /* synthetic */ Issue copy$default(Issue issue2, long l, long l2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                l = issue2.id;
            }
            if ((n & 2) != 0) {
                l2 = issue2.projectId;
            }
            if ((n & 4) != 0) {
                string = issue2.issueTypeId;
            }
            return issue2.copy(l, l2, string);
        }

        @NotNull
        public String toString() {
            return "Issue(id=" + this.id + ", projectId=" + this.projectId + ", issueTypeId=" + this.issueTypeId + ')';
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.id);
            result2 = result2 * 31 + Long.hashCode(this.projectId);
            result2 = result2 * 31 + this.issueTypeId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Issue)) {
                return false;
            }
            Issue issue2 = (Issue)other;
            if (this.id != issue2.id) {
                return false;
            }
            if (this.projectId != issue2.projectId) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.issueTypeId, (Object)issue2.issueTypeId);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001:\u0001*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0006\u0010\u0015\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rJ\u0013\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u001a\u001a\u00020\rJ\r\u0010\u001b\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u001cJ\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\rJ\u001b\u0010#\u001a\n $*\u0004\u0018\u00010\u00050\u00052\u0006\u0010%\u001a\u00020&\u00a2\u0006\u0002\u0010'J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006+"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$JmcfField;", "", "customField", "Lcom/atlassian/jira/issue/fields/CustomField;", "reactsToTransitions", "", "(Lcom/atlassian/jira/issue/fields/CustomField;Z)V", "getCustomField", "()Lcom/atlassian/jira/issue/fields/CustomField;", "isInScopeCache", "Lcom/google/common/cache/LoadingCache;", "Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$JmcfField$ScopeKey;", "issuesCounter", "", "getReactsToTransitions", "()Z", "transitionCounter", "Ljava/lang/Long;", "component1", "component2", "copy", "countContexts", "countProjects", "allProjectsCount", "equals", "other", "getIssueCounter", "getTransitionsCounter", "()Ljava/lang/Long;", "hashCode", "", "incrementIssuesCounter", "", "incrementTransitionsCounter", "count", "isInScope", "kotlin.jvm.PlatformType", "issue", "Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$Issue;", "(Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$Issue;)Ljava/lang/Boolean;", "toString", "", "ScopeKey", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nJmcfEntitiesPerCustomFieldQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JmcfEntitiesPerCustomFieldQuery.kt\ncom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$JmcfField\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,227:1\n1360#2:228\n1446#2,5:229\n1#3:234\n*S KotlinDebug\n*F\n+ 1 JmcfEntitiesPerCustomFieldQuery.kt\ncom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$JmcfField\n*L\n177#1:228\n177#1:229,5\n*E\n"})
    private static final class JmcfField {
        @NotNull
        private final CustomField customField;
        private final boolean reactsToTransitions;
        private long issuesCounter;
        @Nullable
        private Long transitionCounter;
        @NotNull
        private final LoadingCache<ScopeKey, Boolean> isInScopeCache;

        public JmcfField(@NotNull CustomField customField, boolean reactsToTransitions) {
            Intrinsics.checkNotNullParameter((Object)customField, (String)"customField");
            this.customField = customField;
            this.reactsToTransitions = reactsToTransitions;
            this.transitionCounter = this.reactsToTransitions ? Long.valueOf(0L) : null;
            LoadingCache loadingCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(arg_0 -> JmcfField.isInScopeCache$lambda$1(this, arg_0)));
            Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
            this.isInScopeCache = loadingCache;
        }

        @NotNull
        public final CustomField getCustomField() {
            return this.customField;
        }

        public final boolean getReactsToTransitions() {
            return this.reactsToTransitions;
        }

        public final Boolean isInScope(@NotNull Issue issue2) {
            Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
            return (Boolean)this.isInScopeCache.get((Object)new ScopeKey(issue2.getProjectId(), issue2.getIssueTypeId()));
        }

        public final long countContexts() {
            return this.customField.getConfigurationSchemes().size();
        }

        /*
         * WARNING - void declaration
         */
        public final long countProjects(long allProjectsCount) {
            long l;
            if (this.customField.isAllProjects()) {
                l = allProjectsCount;
            } else {
                void $this$flatMapTo$iv$iv;
                List list = this.customField.getConfigurationSchemes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurationSchemes(...)");
                Iterable $this$flatMap$iv = list;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    FieldConfigScheme it = (FieldConfigScheme)element$iv$iv;
                    boolean bl = false;
                    List list2 = it.getAssociatedProjectIds();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAssociatedProjectIds(...)");
                    Iterable list$iv$iv = list2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                l = ((Collection)CollectionsKt.distinct((Iterable)((List)destination$iv$iv))).size();
            }
            return l;
        }

        public final void incrementIssuesCounter() {
            long l = this.issuesCounter;
            this.issuesCounter = l + 1L;
        }

        public final long getIssueCounter() {
            return this.issuesCounter;
        }

        public final void incrementTransitionsCounter(long count2) {
            Long l = this.transitionCounter;
            Intrinsics.checkNotNull((Object)l);
            this.transitionCounter = l + count2;
        }

        @Nullable
        public final Long getTransitionsCounter() {
            return this.transitionCounter;
        }

        @NotNull
        public final CustomField component1() {
            return this.customField;
        }

        public final boolean component2() {
            return this.reactsToTransitions;
        }

        @NotNull
        public final JmcfField copy(@NotNull CustomField customField, boolean reactsToTransitions) {
            Intrinsics.checkNotNullParameter((Object)customField, (String)"customField");
            return new JmcfField(customField, reactsToTransitions);
        }

        public static /* synthetic */ JmcfField copy$default(JmcfField jmcfField, CustomField customField, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                customField = jmcfField.customField;
            }
            if ((n & 2) != 0) {
                bl = jmcfField.reactsToTransitions;
            }
            return jmcfField.copy(customField, bl);
        }

        @NotNull
        public String toString() {
            return "JmcfField(customField=" + this.customField + ", reactsToTransitions=" + this.reactsToTransitions + ')';
        }

        public int hashCode() {
            int result2 = this.customField.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.reactsToTransitions);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JmcfField)) {
                return false;
            }
            JmcfField jmcfField = (JmcfField)other;
            if (!Intrinsics.areEqual((Object)this.customField, (Object)jmcfField.customField)) {
                return false;
            }
            return this.reactsToTransitions == jmcfField.reactsToTransitions;
        }

        private static final Boolean isInScopeCache$lambda$1(JmcfField this$0, ScopeKey key) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ScopeKey scopeKey = key;
            if (scopeKey != null) {
                ScopeKey it = scopeKey;
                boolean bl2 = false;
                bl = this$0.customField.isInScope(it.getProjectId(), it.getIssueTypeId());
            } else {
                bl = false;
            }
            return bl;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$JmcfField$ScopeKey;", "", "projectId", "", "issueTypeId", "", "(JLjava/lang/String;)V", "getIssueTypeId", "()Ljava/lang/String;", "getProjectId", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
        private static final class ScopeKey {
            private final long projectId;
            @NotNull
            private final String issueTypeId;

            public ScopeKey(long projectId, @NotNull String issueTypeId) {
                Intrinsics.checkNotNullParameter((Object)issueTypeId, (String)"issueTypeId");
                this.projectId = projectId;
                this.issueTypeId = issueTypeId;
            }

            public final long getProjectId() {
                return this.projectId;
            }

            @NotNull
            public final String getIssueTypeId() {
                return this.issueTypeId;
            }

            public final long component1() {
                return this.projectId;
            }

            @NotNull
            public final String component2() {
                return this.issueTypeId;
            }

            @NotNull
            public final ScopeKey copy(long projectId, @NotNull String issueTypeId) {
                Intrinsics.checkNotNullParameter((Object)issueTypeId, (String)"issueTypeId");
                return new ScopeKey(projectId, issueTypeId);
            }

            public static /* synthetic */ ScopeKey copy$default(ScopeKey scopeKey, long l, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    l = scopeKey.projectId;
                }
                if ((n & 2) != 0) {
                    string = scopeKey.issueTypeId;
                }
                return scopeKey.copy(l, string);
            }

            @NotNull
            public String toString() {
                return "ScopeKey(projectId=" + this.projectId + ", issueTypeId=" + this.issueTypeId + ')';
            }

            public int hashCode() {
                int result2 = Long.hashCode(this.projectId);
                result2 = result2 * 31 + this.issueTypeId.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ScopeKey)) {
                    return false;
                }
                ScopeKey scopeKey = (ScopeKey)other;
                if (this.projectId != scopeKey.projectId) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.issueTypeId, (Object)scopeKey.issueTypeId);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011JB\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0015\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$JmcfFieldSummary;", "", "customField", "", "issues", "", "projects", "contexts", "transitions", "(Ljava/lang/String;JJJLjava/lang/Long;)V", "getContexts", "()J", "getCustomField", "()Ljava/lang/String;", "getIssues", "getProjects", "getTransitions", "()Ljava/lang/Long;", "Ljava/lang/Long;", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;JJJLjava/lang/Long;)Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$JmcfFieldSummary;", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class JmcfFieldSummary {
        @NotNull
        private final String customField;
        private final long issues;
        private final long projects;
        private final long contexts;
        @Nullable
        private final Long transitions;

        public JmcfFieldSummary(@NotNull String customField, long issues, long projects, long contexts, @Nullable Long transitions) {
            Intrinsics.checkNotNullParameter((Object)customField, (String)"customField");
            this.customField = customField;
            this.issues = issues;
            this.projects = projects;
            this.contexts = contexts;
            this.transitions = transitions;
        }

        @NotNull
        public final String getCustomField() {
            return this.customField;
        }

        public final long getIssues() {
            return this.issues;
        }

        public final long getProjects() {
            return this.projects;
        }

        public final long getContexts() {
            return this.contexts;
        }

        @Nullable
        public final Long getTransitions() {
            return this.transitions;
        }

        @NotNull
        public final String component1() {
            return this.customField;
        }

        public final long component2() {
            return this.issues;
        }

        public final long component3() {
            return this.projects;
        }

        public final long component4() {
            return this.contexts;
        }

        @Nullable
        public final Long component5() {
            return this.transitions;
        }

        @NotNull
        public final JmcfFieldSummary copy(@NotNull String customField, long issues, long projects, long contexts, @Nullable Long transitions) {
            Intrinsics.checkNotNullParameter((Object)customField, (String)"customField");
            return new JmcfFieldSummary(customField, issues, projects, contexts, transitions);
        }

        public static /* synthetic */ JmcfFieldSummary copy$default(JmcfFieldSummary jmcfFieldSummary, String string, long l, long l2, long l3, Long l4, int n, Object object) {
            if ((n & 1) != 0) {
                string = jmcfFieldSummary.customField;
            }
            if ((n & 2) != 0) {
                l = jmcfFieldSummary.issues;
            }
            if ((n & 4) != 0) {
                l2 = jmcfFieldSummary.projects;
            }
            if ((n & 8) != 0) {
                l3 = jmcfFieldSummary.contexts;
            }
            if ((n & 0x10) != 0) {
                l4 = jmcfFieldSummary.transitions;
            }
            return jmcfFieldSummary.copy(string, l, l2, l3, l4);
        }

        @NotNull
        public String toString() {
            return "JmcfFieldSummary(customField=" + this.customField + ", issues=" + this.issues + ", projects=" + this.projects + ", contexts=" + this.contexts + ", transitions=" + this.transitions + ')';
        }

        public int hashCode() {
            int result2 = this.customField.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.issues);
            result2 = result2 * 31 + Long.hashCode(this.projects);
            result2 = result2 * 31 + Long.hashCode(this.contexts);
            result2 = result2 * 31 + (this.transitions == null ? 0 : ((Object)this.transitions).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JmcfFieldSummary)) {
                return false;
            }
            JmcfFieldSummary jmcfFieldSummary = (JmcfFieldSummary)other;
            if (!Intrinsics.areEqual((Object)this.customField, (Object)jmcfFieldSummary.customField)) {
                return false;
            }
            if (this.issues != jmcfFieldSummary.issues) {
                return false;
            }
            if (this.projects != jmcfFieldSummary.projects) {
                return false;
            }
            if (this.contexts != jmcfFieldSummary.contexts) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.transitions, (Object)jmcfFieldSummary.transitions);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$JmcfResult;", "", "totalCustomFields", "", "entitiesPerCustomField", "", "Lcom/atlassian/jira/migration/guardrails/queries/apps/jmcf/JmcfEntitiesPerCustomFieldQuery$JmcfFieldSummary;", "(ILjava/util/List;)V", "getEntitiesPerCustomField", "()Ljava/util/List;", "getTotalCustomFields", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "jira-migration-plugin"})
    public static final class JmcfResult {
        private final int totalCustomFields;
        @NotNull
        private final List<JmcfFieldSummary> entitiesPerCustomField;

        public JmcfResult(int totalCustomFields, @NotNull List<JmcfFieldSummary> entitiesPerCustomField) {
            Intrinsics.checkNotNullParameter(entitiesPerCustomField, (String)"entitiesPerCustomField");
            this.totalCustomFields = totalCustomFields;
            this.entitiesPerCustomField = entitiesPerCustomField;
        }

        public final int getTotalCustomFields() {
            return this.totalCustomFields;
        }

        @NotNull
        public final List<JmcfFieldSummary> getEntitiesPerCustomField() {
            return this.entitiesPerCustomField;
        }

        public final int component1() {
            return this.totalCustomFields;
        }

        @NotNull
        public final List<JmcfFieldSummary> component2() {
            return this.entitiesPerCustomField;
        }

        @NotNull
        public final JmcfResult copy(int totalCustomFields, @NotNull List<JmcfFieldSummary> entitiesPerCustomField) {
            Intrinsics.checkNotNullParameter(entitiesPerCustomField, (String)"entitiesPerCustomField");
            return new JmcfResult(totalCustomFields, entitiesPerCustomField);
        }

        public static /* synthetic */ JmcfResult copy$default(JmcfResult jmcfResult, int n, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = jmcfResult.totalCustomFields;
            }
            if ((n2 & 2) != 0) {
                list = jmcfResult.entitiesPerCustomField;
            }
            return jmcfResult.copy(n, list);
        }

        @NotNull
        public String toString() {
            return "JmcfResult(totalCustomFields=" + this.totalCustomFields + ", entitiesPerCustomField=" + this.entitiesPerCustomField + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.totalCustomFields);
            result2 = result2 * 31 + ((Object)this.entitiesPerCustomField).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JmcfResult)) {
                return false;
            }
            JmcfResult jmcfResult = (JmcfResult)other;
            if (this.totalCustomFields != jmcfResult.totalCustomFields) {
                return false;
            }
            return Intrinsics.areEqual(this.entitiesPerCustomField, jmcfResult.entitiesPerCustomField);
        }
    }
}

