/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\tJ\u0012\u0010\r\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/AssetFieldsAnalyzer;", "", "customFieldManager", "Lcom/atlassian/jira/issue/CustomFieldManager;", "(Lcom/atlassian/jira/issue/CustomFieldManager;)V", "getCustomFieldManager", "()Lcom/atlassian/jira/issue/CustomFieldManager;", "loadingCache", "Lcom/google/common/cache/LoadingCache;", "", "", "isAssetsField", "customFieldId", "isAssetsFieldUncached", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nScriptrunnerBehavioursQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptrunnerBehavioursQuery.kt\ncom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/AssetFieldsAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class AssetFieldsAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CustomFieldManager customFieldManager;
    @NotNull
    private final LoadingCache<String, Boolean> loadingCache;
    private static final long MAX_CACHE_SIZE = 10000L;
    @NotNull
    private static final String ASSETS_CUSTOM_FIELD_TYPE_KEY_PREFIX = "com.riadalabs.jira.plugins.insight:rlabs-customfield-";

    public AssetFieldsAnalyzer(@NotNull CustomFieldManager customFieldManager) {
        Intrinsics.checkNotNullParameter((Object)customFieldManager, (String)"customFieldManager");
        this.customFieldManager = customFieldManager;
        LoadingCache loadingCache = CacheBuilder.newBuilder().maximumSize(10000L).build(CacheLoader.from(arg_0 -> AssetFieldsAnalyzer.loadingCache$lambda$0(this, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.loadingCache = loadingCache;
    }

    @NotNull
    public final CustomFieldManager getCustomFieldManager() {
        return this.customFieldManager;
    }

    public final boolean isAssetsField(@Nullable String customFieldId) {
        Boolean bl;
        if (customFieldId != null) {
            String it = customFieldId;
            boolean bl2 = false;
            bl = (Boolean)this.loadingCache.get((Object)customFieldId);
        } else {
            bl = null;
        }
        Boolean bl3 = bl;
        return bl3 == null ? false : bl3;
    }

    private final boolean isAssetsFieldUncached(String customFieldId) {
        String string;
        CustomFieldType customFieldType;
        CharSequence charSequence = customFieldId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !StringsKt.startsWith$default((String)customFieldId, (String)"customfield_", (boolean)false, (int)2, null)) {
            return false;
        }
        charSequence = this.customFieldManager.getCustomFieldObject(customFieldId);
        return charSequence != null && (customFieldType = charSequence.getCustomFieldType()) != null && (string = customFieldType.getKey()) != null ? StringsKt.startsWith$default((String)string, (String)ASSETS_CUSTOM_FIELD_TYPE_KEY_PREFIX, (boolean)false, (int)2, null) : false;
    }

    private static final Boolean loadingCache$lambda$0(AssetFieldsAnalyzer this$0, String key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.isAssetsFieldUncached(key);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/AssetFieldsAnalyzer$Companion;", "", "()V", "ASSETS_CUSTOM_FIELD_TYPE_KEY_PREFIX", "", "MAX_CACHE_SIZE", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

