/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.guardrails.model.BehavioursConfigurations;
import com.atlassian.jira.migration.guardrails.model.Mapping;
import com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner.MappingType;
import com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner.ScriptrunnerBehavioursQuery;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\u0011\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/MappingsAnalyzer;", "", "applicationProperties", "Lcom/atlassian/jira/config/properties/ApplicationProperties;", "(Lcom/atlassian/jira/config/properties/ApplicationProperties;)V", "jiraAssociations", "", "", "jsmAssociations", "fetchMappingConfig", "Lcom/atlassian/jira/migration/guardrails/model/BehavioursConfigurations;", "getAllMappedIds", "mappings", "", "Lcom/atlassian/jira/migration/guardrails/model/Mapping;", "getMappingType", "Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/MappingType;", "behaviourId", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nScriptrunnerBehavioursQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptrunnerBehavioursQuery.kt\ncom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/MappingsAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,174:1\n1549#2:175\n1620#2,3:176\n1#3:179\n58#4:180\n51#4:181\n*S KotlinDebug\n*F\n+ 1 ScriptrunnerBehavioursQuery.kt\ncom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/MappingsAnalyzer\n*L\n114#1:175\n114#1:176,3\n122#1:180\n122#1:181\n*E\n"})
final class MappingsAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationProperties applicationProperties;
    @NotNull
    private final Set<String> jiraAssociations;
    @NotNull
    private final Set<String> jsmAssociations;
    private static final Logger LOG = LoggerFactory.getLogger(MappingsAnalyzer.class);
    @NotNull
    private static final String BEHAVIOURS_MAPPING_CONFIG_PROP_KEY = "BehaviourMap";

    public MappingsAnalyzer(@NotNull ApplicationProperties applicationProperties) {
        Intrinsics.checkNotNullParameter((Object)applicationProperties, (String)"applicationProperties");
        this.applicationProperties = applicationProperties;
        BehavioursConfigurations config2 = this.fetchMappingConfig();
        if (config2 == null) {
            this.jiraAssociations = SetsKt.emptySet();
            this.jsmAssociations = SetsKt.emptySet();
            LOG.warn("Scriptrunner's 'BehaviourMap' configuration not found");
        } else {
            this.jiraAssociations = this.getAllMappedIds(config2.getProjects());
            this.jsmAssociations = this.getAllMappedIds(config2.getServiceDesks());
        }
    }

    @NotNull
    public final Set<MappingType> getMappingType(@NotNull String behaviourId) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)behaviourId, (String)"behaviourId");
        Set $this$getMappingType_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        if (this.jiraAssociations.contains(behaviourId)) {
            $this$getMappingType_u24lambda_u240.add(MappingType.JIRA);
        }
        if (this.jsmAssociations.contains(behaviourId)) {
            $this$getMappingType_u24lambda_u240.add(MappingType.JIRA_SERVICE_MANAGEMENT);
        }
        return SetsKt.build((Set)set);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getAllMappedIds(List<? extends Mapping> mappings) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = mappings;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Mapping mapping = (Mapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAllMappedIds());
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final BehavioursConfigurations fetchMappingConfig() {
        String string;
        String string2 = this.applicationProperties.getText(BEHAVIOURS_MAPPING_CONFIG_PROP_KEY);
        if (string2 == null) return null;
        String it = string = string2;
        boolean bl = false;
        if (!StringExtensionsKt.isNotNullOrBlank(it)) return null;
        String string3 = string;
        String string4 = string3;
        if (string4 == null) return null;
        it = string4;
        boolean bl2 = false;
        ObjectMapper $this$readValue$iv = (ObjectMapper)ScriptrunnerBehavioursQuery.Companion.getXmlMapper();
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        BehavioursConfigurations behavioursConfigurations = (BehavioursConfigurations)$this$readValue$iv.readValue(it, (TypeReference)new TypeReference<BehavioursConfigurations>(){});
        return behavioursConfigurations;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/MappingsAnalyzer$Companion;", "", "()V", "BEHAVIOURS_MAPPING_CONFIG_PROP_KEY", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

