/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner;

import com.atlassian.jira.migration.db.apps.scriptrunner.ScriptrunnerScriptRunResultTable;
import com.atlassian.jira.migration.guardrails.queries.AssessmentDatabaseConnection;
import com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner.ScriptRunResult;
import com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner.ScriptRunStats;
import com.atlassian.jira.migration.guardrails.util.InstantExtensionsKt;
import com.google.common.collect.Lists;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tH\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/ScriptrunnerRunResultsUtil;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "MAX_BATCH_SIZE", "", "fetchScriptRunResultsBatch", "", "Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/ScriptRunResult;", "db", "Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseConnection;", "keys", "", "fetchScriptRunResultsByKey", "Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/ScriptRunStats;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nScriptrunnerRunResultsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptrunnerRunResultsUtil.kt\ncom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/ScriptrunnerRunResultsUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1549#2:72\n1620#2,3:73\n1603#2,9:76\n1855#2:85\n1856#2:88\n1612#2:89\n1#3:86\n1#3:87\n*S KotlinDebug\n*F\n+ 1 ScriptrunnerRunResultsUtil.kt\ncom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/ScriptrunnerRunResultsUtil\n*L\n20#1:72\n20#1:73,3\n36#1:76,9\n36#1:85\n36#1:88\n36#1:89\n36#1:87\n*E\n"})
public final class ScriptrunnerRunResultsUtil {
    @NotNull
    public static final ScriptrunnerRunResultsUtil INSTANCE = new ScriptrunnerRunResultsUtil();
    private static final int MAX_BATCH_SIZE = 999;
    private static final Logger LOG = LoggerFactory.getLogger(ScriptrunnerRunResultsUtil.class);

    private ScriptrunnerRunResultsUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScriptRunStats fetchScriptRunResultsByKey(@NotNull AssessmentDatabaseConnection db, @NotNull List<String> keys) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        List list = Lists.partition(keys, (int)999);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"partition(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list2 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(INSTANCE.fetchScriptRunResultsBatch(db, (List<String>)it));
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        Map map = null;
        List list3 = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        return new ScriptRunStats(list3, map, n, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScriptRunResult> fetchScriptRunResultsBatch(AssessmentDatabaseConnection db, List<String> keys) {
        void $this$mapNotNullTo$iv$iv;
        Expression[] expressionArray = new Expression[5];
        Intrinsics.checkNotNullExpressionValue((Object)ScriptrunnerScriptRunResultTable.Companion.getSCRIPTRUNNER_RUN_RESULT_TABLE().getKEY(), (String)"<get-KEY>(...)");
        Intrinsics.checkNotNullExpressionValue(ScriptrunnerScriptRunResultTable.Companion.getLAST_USED(), (String)"<get-LAST_USED>(...)");
        Intrinsics.checkNotNullExpressionValue(ScriptrunnerScriptRunResultTable.Companion.getNUMBER_OF_EXECUTIONS(), (String)"<get-NUMBER_OF_EXECUTIONS>(...)");
        Intrinsics.checkNotNullExpressionValue(ScriptrunnerScriptRunResultTable.Companion.getNUMBER_OF_EXECUTIONS_WITH_EXCEPTION(), (String)"<get-NUMBER_OF_EXECUTIONS_WITH_EXCEPTION>(...)");
        Intrinsics.checkNotNullExpressionValue(ScriptrunnerScriptRunResultTable.Companion.getMILLISECONDS_TAKEN_SUM(), (String)"<get-MILLISECONDS_TAKEN_SUM>(...)");
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)ScriptrunnerScriptRunResultTable.Companion.getSCRIPTRUNNER_RUN_RESULT_TABLE())).where((Predicate)ScriptrunnerScriptRunResultTable.Companion.getSCRIPTRUNNER_RUN_RESULT_TABLE().getKEY().in((Collection)keys))).groupBy((Expression)ScriptrunnerScriptRunResultTable.Companion.getSCRIPTRUNNER_RUN_RESULT_TABLE().getKEY())).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ScriptRunResult scriptRunResult;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Tuple row = (Tuple)element$iv$iv;
            boolean bl2 = false;
            String key = (String)row.get((Expression)ScriptrunnerScriptRunResultTable.Companion.getSCRIPTRUNNER_RUN_RESULT_TABLE().getKEY());
            if (key == null) {
                LOG.warn("Skipping run result with null key. Row details: " + row);
                scriptRunResult = null;
            } else {
                Long l;
                String string;
                Object object = row.get((Expression)ScriptrunnerScriptRunResultTable.Companion.getSCRIPTRUNNER_RUN_RESULT_TABLE().getKEY());
                Intrinsics.checkNotNull((Object)object);
                String string2 = (String)object;
                if ((Long)row.get((Expression)ScriptrunnerScriptRunResultTable.Companion.getLAST_USED()) != null) {
                    void it;
                    String string3 = string2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    Instant instant = Instant.ofEpochMilli(it.longValue());
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
                    string = InstantExtensionsKt.toIsoFormat(instant);
                    string2 = string3;
                } else {
                    string = null;
                }
                if ((l = (Long)row.get((Expression)ScriptrunnerScriptRunResultTable.Companion.getNUMBER_OF_EXECUTIONS())) == null) {
                    l = 0L;
                }
                Long l2 = l;
                Intrinsics.checkNotNull((Object)l2);
                long l3 = ((Number)l2).longValue();
                Long l4 = (Long)row.get((Expression)ScriptrunnerScriptRunResultTable.Companion.getNUMBER_OF_EXECUTIONS_WITH_EXCEPTION());
                if (l4 == null) {
                    l4 = 0L;
                }
                l2 = l4;
                Intrinsics.checkNotNull((Object)l2);
                long l5 = ((Number)l2).longValue();
                Long l6 = (Long)row.get((Expression)ScriptrunnerScriptRunResultTable.Companion.getMILLISECONDS_TAKEN_SUM());
                if (l6 == null) {
                    l6 = 0L;
                }
                l2 = l6;
                Intrinsics.checkNotNull((Object)l2);
                long l7 = ((Number)l2).longValue();
                long l8 = l5;
                long l9 = l3;
                String string4 = string;
                String string5 = string2;
                scriptRunResult = new ScriptRunResult(string5, string4, l9, l8, l7);
            }
            if (scriptRunResult == null) continue;
            ScriptRunResult it$iv$iv = scriptRunResult;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

