/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner;

import com.atlassian.jira.migration.common.Hasher;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.db.JiraWorkflowsTable;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.guardrails.model.Action;
import com.atlassian.jira.migration.guardrails.model.Conditions;
import com.atlassian.jira.migration.guardrails.model.Function;
import com.atlassian.jira.migration.guardrails.model.PostFunctions;
import com.atlassian.jira.migration.guardrails.model.RestrictTo;
import com.atlassian.jira.migration.guardrails.model.UnconditionalResult;
import com.atlassian.jira.migration.guardrails.model.Validators;
import com.atlassian.jira.migration.guardrails.model.Workflow;
import com.atlassian.jira.migration.guardrails.queries.AssessmentDatabaseAccessor;
import com.atlassian.jira.migration.guardrails.queries.AssessmentDatabaseConnection;
import com.atlassian.jira.migration.guardrails.queries.JsonResultAssessmentQuery;
import com.atlassian.jira.migration.guardrails.queries.QueryProductType;
import com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner.FunctionSummary;
import com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner.FunctionType;
import com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner.FunctionWithMetadata;
import com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner.ParsedWorkflowEntity;
import com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner.ScriptRunResult;
import com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner.ScriptRunStats;
import com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner.ScriptrunnerRunResultsUtil;
import com.atlassian.jira.migration.guardrails.queries.apps.scriptrunner.WorkflowEntity;
import com.atlassian.jira.migration.guardrails.util.InstantExtensionsKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.google.gson.Gson;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/ScriptrunnerWorkflowFunctionsQuery;", "Lcom/atlassian/jira/migration/guardrails/queries/JsonResultAssessmentQuery;", "databaseAccessor", "Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseAccessor;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseAccessor;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "buildSummary", "Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/FunctionSummary;", "functionWithMetadata", "Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/FunctionWithMetadata;", "runStats", "Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/ScriptRunStats;", "execute", "Lkotlin/Result;", "", "execute-d1pmJ48", "()Ljava/lang/Object;", "extractFunctions", "", "action", "Lcom/atlassian/jira/migration/guardrails/model/Action;", "workflow", "Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/ParsedWorkflowEntity;", "fetchRunStats", "db", "Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseConnection;", "functions", "fetchWorkflows", "Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/WorkflowEntity;", "isQueryEnabled", "", "parse", "workflowEntity", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nScriptrunnerWorkflowFunctionsQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptrunnerWorkflowFunctionsQuery.kt\ncom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/ScriptrunnerWorkflowFunctionsQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,229:1\n1603#2,9:230\n1855#2:239\n1856#2:241\n1612#2:242\n1549#2:245\n1620#2,3:246\n1549#2:249\n1620#2,3:250\n1549#2:253\n1620#2,3:254\n1603#2,9:257\n1855#2:266\n1549#2:267\n1620#2,3:268\n1856#2:272\n1612#2:273\n1603#2,9:274\n1855#2:283\n1856#2:285\n1612#2:286\n1#3:240\n1#3:271\n1#3:284\n1#3:287\n58#4:243\n51#4:244\n*S KotlinDebug\n*F\n+ 1 ScriptrunnerWorkflowFunctionsQuery.kt\ncom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/ScriptrunnerWorkflowFunctionsQuery\n*L\n52#1:230,9\n52#1:239\n52#1:241\n52#1:242\n90#1:245\n90#1:246,3\n95#1:249\n95#1:250,3\n96#1:253\n96#1:254,3\n98#1:257,9\n98#1:266\n100#1:267\n100#1:268,3\n98#1:272\n98#1:273\n112#1:274,9\n112#1:283\n112#1:285\n112#1:286\n52#1:240\n98#1:271\n112#1:284\n75#1:243\n75#1:244\n*E\n"})
public final class ScriptrunnerWorkflowFunctionsQuery
extends JsonResultAssessmentQuery {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final AssessmentDatabaseAccessor databaseAccessor;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private static final Logger log;
    @NotNull
    private static final Hasher HASHER;
    @NotNull
    private static final XmlMapper XML_MAPPER;
    @NotNull
    private static final List<FunctionSummary> EXAMPLE;

    @Inject
    public ScriptrunnerWorkflowFunctionsQuery(@NotNull AssessmentDatabaseAccessor databaseAccessor, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        super("WORKFLOWS", EXAMPLE, QueryProductType.SCRIPTRUNNER);
        this.databaseAccessor = databaseAccessor;
        this.migrationFeatures = migrationFeatures;
    }

    @Override
    @NotNull
    protected Object execute-d1pmJ48() {
        return this.databaseAccessor.run-IoAF18A((Function1)new Function1<AssessmentDatabaseConnection, String>(this){
            final /* synthetic */ ScriptrunnerWorkflowFunctionsQuery this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final String invoke(@NotNull AssessmentDatabaseConnection db) {
                void $this$sortedBy$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Iterable $this$filterTo$iv$iv;
                ParsedWorkflowEntity it;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                Iterable iterable = ScriptrunnerWorkflowFunctionsQuery.access$fetchWorkflows(this.this$0, db);
                ScriptrunnerWorkflowFunctionsQuery scriptrunnerWorkflowFunctionsQuery = this.this$0;
                boolean $i$f$map = false;
                void var6_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    WorkflowEntity workflowEntity = (WorkflowEntity)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(ScriptrunnerWorkflowFunctionsQuery.access$parse(scriptrunnerWorkflowFunctionsQuery, (WorkflowEntity)((Object)it)));
                }
                $this$map$iv = (List)destination$iv$iv;
                scriptrunnerWorkflowFunctionsQuery = this.this$0;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ParsedWorkflowEntity)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(ScriptrunnerWorkflowFunctionsQuery.access$extractFunctions(scriptrunnerWorkflowFunctionsQuery, it));
                }
                Iterable $this$filter$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
                boolean $i$f$filter = false;
                Iterable $i$f$map2 = $this$filter$iv;
                Object destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    FunctionWithMetadata it2 = (FunctionWithMetadata)element$iv$iv;
                    boolean bl = false;
                    if (!it2.getFunction().isScriptrunnerAction()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List functions = (List)destination$iv$iv2;
                ScriptRunStats runStats = ScriptrunnerWorkflowFunctionsQuery.access$fetchRunStats(this.this$0, db, functions);
                $this$filterTo$iv$iv = functions;
                destination$iv$iv2 = this.this$0;
                boolean $i$f$mapNotNull = false;
                Iterator<T> $i$f$mapTo2 = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FunctionSummary it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    FunctionWithMetadata it3 = (FunctionWithMetadata)element$iv$iv;
                    boolean bl2 = false;
                    if (ScriptrunnerWorkflowFunctionsQuery.access$buildSummary((ScriptrunnerWorkflowFunctionsQuery)destination$iv$iv2, it3, runStats) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv3;
                boolean $i$f$sortedBy = false;
                List functionsSummary = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        FunctionSummary it = (FunctionSummary)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getId());
                        it = (FunctionSummary)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
                    }
                });
                return new Gson().toJson((Object)functionsSummary);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<WorkflowEntity> fetchWorkflows(AssessmentDatabaseConnection db) {
        void $this$mapNotNullTo$iv$iv;
        Expression[] expressionArray = new Expression[3];
        Intrinsics.checkNotNullExpressionValue(JiraWorkflowsTable.Companion.getJIRA_WORKFLOWS_TABLE().getID(), (String)"<get-ID>(...)");
        Intrinsics.checkNotNullExpressionValue((Object)JiraWorkflowsTable.Companion.getJIRA_WORKFLOWS_TABLE().getNAME(), (String)"<get-NAME>(...)");
        Intrinsics.checkNotNullExpressionValue((Object)JiraWorkflowsTable.Companion.getJIRA_WORKFLOWS_TABLE().getDESCRIPTOR(), (String)"<get-DESCRIPTOR>(...)");
        List list = ((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)JiraWorkflowsTable.Companion.getJIRA_WORKFLOWS_TABLE())).where((Predicate)JiraWorkflowsTable.Companion.getJIRA_WORKFLOWS_TABLE().getDESCRIPTOR().contains("com.onresolve.jira.groovy"))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            WorkflowEntity workflowEntity;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Tuple workflowData = (Tuple)element$iv$iv;
            boolean bl2 = false;
            Long id = (Long)workflowData.get((Expression)JiraWorkflowsTable.Companion.getJIRA_WORKFLOWS_TABLE().getID());
            String name = (String)workflowData.get((Expression)JiraWorkflowsTable.Companion.getJIRA_WORKFLOWS_TABLE().getNAME());
            String descriptor = (String)workflowData.get((Expression)JiraWorkflowsTable.Companion.getJIRA_WORKFLOWS_TABLE().getDESCRIPTOR());
            if (id != null && descriptor != null) {
                workflowEntity = new WorkflowEntity(descriptor, id, name);
            } else {
                log.debug("Skipping workflow due to the missing id or descriptor. Workflow details: {}", (Object)workflowData);
                workflowEntity = null;
            }
            if (workflowEntity == null) continue;
            WorkflowEntity it$iv$iv = workflowEntity;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final ParsedWorkflowEntity parse(WorkflowEntity workflowEntity) {
        try {
            void $this$readValue$iv;
            ObjectMapper objectMapper2 = (ObjectMapper)XML_MAPPER;
            String content$iv = workflowEntity.getDescriptor();
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            return new ParsedWorkflowEntity((Workflow)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<Workflow>(){}), workflowEntity.getId(), workflowEntity.getName());
        }
        catch (IOException e) {
            throw new IOException("Failed to parse workflow descriptor. Workflow id: " + workflowEntity.getId() + ", descriptor: " + workflowEntity.getDescriptor(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FunctionWithMetadata> extractFunctions(ParsedWorkflowEntity workflow) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = workflow.getDescriptor().getActions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Action action = (Action)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.extractFunctions((Action)it, workflow));
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<FunctionWithMetadata> extractFunctions(Action action, ParsedWorkflowEntity workflow) {
        List list;
        List<UnconditionalResult> list2;
        List list3;
        Collection destination$iv$iv;
        List<Function> list4;
        List validatorFunction;
        List list5;
        Collection collection;
        Object object = action.getValidators();
        if (object != null && (object = ((Validators)object).getValidator()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Iterator it;
                Function function = (Function)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(new FunctionWithMetadata((Function)((Object)it), FunctionType.VALIDATOR, workflow));
            }
            list5 = (List)destination$iv$iv2;
        } else {
            list5 = validatorFunction = null;
        }
        if ((list4 = action.getRestrictTo()) != null && (list4 = ((RestrictTo)((Object)list4)).getConditions()) != null && (list4 = ((Conditions)((Object)list4)).getCondition()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list4;
            boolean $i$f$map = false;
            Iterable $i$f$mapTo = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Function function = (Function)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new FunctionWithMetadata((Function)it, FunctionType.CONDITION, workflow));
            }
            list3 = (List)destination$iv$iv;
        } else {
            list3 = null;
        }
        List conditionFunction = list3;
        Object[] objectArray = action.getResults();
        if (objectArray != null && (list2 = objectArray.getUnconditionalResult()) != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable $i$f$map = list2;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                List list6;
                List<Function> list7;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                UnconditionalResult it = (UnconditionalResult)element$iv$iv;
                boolean bl2 = false;
                PostFunctions postFunctions2 = it.getPostFunctions();
                if (postFunctions2 != null && (list7 = postFunctions2.getFunction()) != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = list7;
                    boolean $i$f$map2 = false;
                    void var26_38 = $this$map$iv;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        Function function = (Function)item$iv$iv;
                        Collection collection2 = destination$iv$iv4;
                        boolean bl3 = false;
                        collection2.add(new FunctionWithMetadata((Function)it2, FunctionType.POST_FUNCTION, workflow));
                    }
                    list6 = (List)destination$iv$iv4;
                } else {
                    list6 = null;
                }
                if (list6 == null) continue;
                List it$iv$iv = list6;
                boolean bl4 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            list = CollectionsKt.flatten((Iterable)((List)destination$iv$iv3));
        } else {
            list = null;
        }
        List postFunctions3 = list;
        objectArray = new List[]{validatorFunction, conditionFunction, postFunctions3};
        return CollectionsKt.flatten((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private final ScriptRunStats fetchRunStats(AssessmentDatabaseConnection db, List<FunctionWithMetadata> functions) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = functions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FunctionWithMetadata it = (FunctionWithMetadata)element$iv$iv;
            boolean bl2 = false;
            if (it.getFunction().getId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        return ScriptrunnerRunResultsUtil.INSTANCE.fetchScriptRunResultsByKey(db, it);
    }

    /*
     * WARNING - void declaration
     */
    private final FunctionSummary buildSummary(FunctionWithMetadata functionWithMetadata, ScriptRunStats runStats) {
        FunctionSummary functionSummary;
        Function function;
        Function function2;
        boolean isUgcCollectionEnabled = this.migrationFeatures.getEnableUgcCollectionDuringInstanceAssessment();
        Function it = function2 = functionWithMetadata.getFunction();
        boolean bl = false;
        Function function3 = function = StringExtensionsKt.isNotNullOrBlank(it.getId()) ? function2 : null;
        if (function != null) {
            String string;
            it = function;
            boolean bl2 = false;
            String string2 = it.getId();
            Intrinsics.checkNotNull((Object)string2);
            ScriptRunResult stats = runStats.forKey(string2);
            String string3 = it.getId();
            String string4 = string3;
            Intrinsics.checkNotNull((Object)string3);
            boolean bl3 = it.isActive();
            boolean bl4 = it.isUsingCustomScript();
            String string5 = isUgcCollectionEnabled ? functionWithMetadata.getWorkflow().getName() : null;
            String string6 = functionWithMetadata.getWorkflow().getName();
            if (string6 != null) {
                void it2;
                String string7 = string6;
                String string8 = string5;
                boolean bl5 = bl4;
                boolean bl6 = bl3;
                String string9 = string4;
                boolean bl7 = false;
                String string10 = HASHER.hash((String)it2);
                string4 = string9;
                bl3 = bl6;
                bl4 = bl5;
                string5 = string8;
                string = string10;
            } else {
                string = null;
            }
            long l = stats.getMillisecondsTakenSum();
            long l2 = stats.getNumberOfExecutionsWithException();
            long l3 = stats.getNumberOfExecutions();
            String string11 = stats.getLastUsed();
            FunctionType functionType = functionWithMetadata.getType();
            String string12 = it.getScriptClass();
            String string13 = string;
            String string14 = string5;
            boolean bl8 = bl4;
            boolean bl9 = bl3;
            String string15 = string4;
            functionSummary = new FunctionSummary(string15, bl9, bl8, string14, string13, string12, functionType, string11, l3, l2, l);
        } else {
            functionSummary = null;
        }
        return functionSummary;
    }

    @Override
    public boolean isQueryEnabled() {
        return this.migrationFeatures.getEnableScriptRunnerAssessment();
    }

    public static final /* synthetic */ List access$fetchWorkflows(ScriptrunnerWorkflowFunctionsQuery $this, AssessmentDatabaseConnection db) {
        return $this.fetchWorkflows(db);
    }

    public static final /* synthetic */ ScriptRunStats access$fetchRunStats(ScriptrunnerWorkflowFunctionsQuery $this, AssessmentDatabaseConnection db, List functions) {
        return $this.fetchRunStats(db, functions);
    }

    public static final /* synthetic */ ParsedWorkflowEntity access$parse(ScriptrunnerWorkflowFunctionsQuery $this, WorkflowEntity workflowEntity) {
        return $this.parse(workflowEntity);
    }

    public static final /* synthetic */ List access$extractFunctions(ScriptrunnerWorkflowFunctionsQuery $this, ParsedWorkflowEntity workflow) {
        return $this.extractFunctions(workflow);
    }

    public static final /* synthetic */ FunctionSummary access$buildSummary(ScriptrunnerWorkflowFunctionsQuery $this, FunctionWithMetadata functionWithMetadata, ScriptRunStats runStats) {
        return $this.buildSummary(functionWithMetadata, runStats);
    }

    static {
        Object[] objectArray;
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(ScriptrunnerWorkflowFunctionsQuery.class);
        HASHER = new Hasher();
        Object[] $this$XML_MAPPER_u24lambda_u2411 = objectArray = new XmlMapper();
        boolean bl = false;
        $this$XML_MAPPER_u24lambda_u2411.registerModule((Module)new KotlinModule.Builder().build());
        XML_MAPPER = objectArray;
        objectArray = new FunctionSummary[3];
        String string = HASHER.hash("Example workflow name");
        Instant instant = Instant.ofEpochMilli(1727733893582L);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
        objectArray[0] = new FunctionSummary("0d178611-f3ea-4e15-972f-cc2df808bd90", true, true, null, string, "com.onresolve.scriptrunner.canned.jira.workflow.conditions.CustomScriptCondition", FunctionType.CONDITION, InstantExtensionsKt.toIsoFormat(instant), 100L, 0L, 1000L, 8, null);
        String string2 = HASHER.hash("Example workflow name 2");
        Instant instant2 = Instant.ofEpochMilli(1727033893082L);
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"ofEpochMilli(...)");
        objectArray[1] = new FunctionSummary("1a23b4cf-67c8-440d-8199-c2d25fca0f10", false, true, null, string2, "com.onresolve.scriptrunner.canned.jira.workflow.validators.CustomScriptValidator", FunctionType.VALIDATOR, InstantExtensionsKt.toIsoFormat(instant2), 0L, 0L, 0L, 8, null);
        Instant instant3 = Instant.ofEpochMilli(1727533892582L);
        Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"ofEpochMilli(...)");
        objectArray[2] = new FunctionSummary("30724dcc-2174-401a-bc76-36c30e7c6db0", false, false, null, null, "com.onresolve.scriptrunner.canned.jira.workflow.postfunctions.CloneIssue", FunctionType.POST_FUNCTION, InstantExtensionsKt.toIsoFormat(instant3), 9999L, 8L, 22222L, 8, null);
        EXAMPLE = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/ScriptrunnerWorkflowFunctionsQuery$Companion;", "", "()V", "EXAMPLE", "", "Lcom/atlassian/jira/migration/guardrails/queries/apps/scriptrunner/FunctionSummary;", "getEXAMPLE", "()Ljava/util/List;", "HASHER", "Lcom/atlassian/jira/migration/common/Hasher;", "getHASHER", "()Lcom/atlassian/jira/migration/common/Hasher;", "XML_MAPPER", "Lcom/fasterxml/jackson/dataformat/xml/XmlMapper;", "getXML_MAPPER", "()Lcom/fasterxml/jackson/dataformat/xml/XmlMapper;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Hasher getHASHER() {
            return HASHER;
        }

        @NotNull
        public final XmlMapper getXML_MAPPER() {
            return XML_MAPPER;
        }

        @NotNull
        public final List<FunctionSummary> getEXAMPLE() {
            return EXAMPLE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

