/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries.memberships;

import com.atlassian.jira.migration.guardrails.queries.memberships.Users;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\"\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00062\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020$0#J\u000e\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u001dJ\u000e\u0010'\u001a\u00020$2\u0006\u0010&\u001a\u00020\u001dJ\u000e\u0010(\u001a\u00020$2\u0006\u0010&\u001a\u00020\u001dJ&\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u00062\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0-H\u0002J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\u0016\u0010/\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0019J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u001b\u00101\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000bH\u00c6\u0003JV\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u001a\b\u0002\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000bH\u00c6\u0001\u00a2\u0006\u0002\u00103J\u0013\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00107\u001a\u00020\u001dH\u00d6\u0001J\u0006\u00108\u001a\u00020\u001dJ\t\u00109\u001a\u00020:H\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u001b\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/memberships/Groups;", "", "groupIds", "", "parents", "", "", "activeAgentsGroupIds", "", "", "agentsParents", "", "([J[[ILjava/util/List;Ljava/util/Map;)V", "getActiveAgentsGroupIds", "()Ljava/util/List;", "getAgentsParents", "()Ljava/util/Map;", "allMemberCounts", "getAllMemberCounts", "()[I", "getGroupIds", "()[J", "memberCountsActiveWithLogin", "getMemberCountsActiveWithLogin", "getParents", "()[[I", "[[I", "queueForParents", "activeAgentsCount", "", "agents", "Lcom/atlassian/jira/migration/guardrails/queries/memberships/Users;", "add", "userGroups", "consumer", "Lkotlin/Function1;", "", "addActiveMembersWithLogin", "index", "addActiveMembersWithoutLogin", "addInactiveMembers", "addToQueue", "start", "groups", "processed", "", "component1", "component2", "component3", "component4", "copy", "([J[[ILjava/util/List;Ljava/util/Map;)Lcom/atlassian/jira/migration/guardrails/queries/memberships/Groups;", "equals", "", "other", "hashCode", "maxUsers", "toString", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMembershipResults.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MembershipResults.kt\ncom/atlassian/jira/migration/guardrails/queries/memberships/Groups\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n13330#2,2:233\n3819#2:235\n4337#2,2:236\n1855#3,2:238\n*S KotlinDebug\n*F\n+ 1 MembershipResults.kt\ncom/atlassian/jira/migration/guardrails/queries/memberships/Groups\n*L\n54#1:233,2\n84#1:235\n84#1:236,2\n84#1:238,2\n*E\n"})
public final class Groups {
    @NotNull
    private final long[] groupIds;
    @Nullable
    private final int[][] parents;
    @NotNull
    private final List<Long> activeAgentsGroupIds;
    @NotNull
    private final Map<Long, List<Long>> agentsParents;
    @NotNull
    private final int[] allMemberCounts;
    @NotNull
    private final int[] memberCountsActiveWithLogin;
    @NotNull
    private final int[] queueForParents;

    public Groups(@NotNull long[] groupIds, @Nullable int[][] parents2, @NotNull List<Long> activeAgentsGroupIds, @NotNull Map<Long, ? extends List<Long>> agentsParents) {
        Intrinsics.checkNotNullParameter((Object)groupIds, (String)"groupIds");
        Intrinsics.checkNotNullParameter(activeAgentsGroupIds, (String)"activeAgentsGroupIds");
        Intrinsics.checkNotNullParameter(agentsParents, (String)"agentsParents");
        this.groupIds = groupIds;
        this.parents = parents2;
        this.activeAgentsGroupIds = activeAgentsGroupIds;
        this.agentsParents = agentsParents;
        this.allMemberCounts = new int[this.groupIds.length];
        this.memberCountsActiveWithLogin = new int[this.groupIds.length];
        this.queueForParents = new int[this.groupIds.length];
    }

    @NotNull
    public final long[] getGroupIds() {
        return this.groupIds;
    }

    @Nullable
    public final int[][] getParents() {
        return this.parents;
    }

    @NotNull
    public final List<Long> getActiveAgentsGroupIds() {
        return this.activeAgentsGroupIds;
    }

    @NotNull
    public final Map<Long, List<Long>> getAgentsParents() {
        return this.agentsParents;
    }

    @NotNull
    public final int[] getAllMemberCounts() {
        return this.allMemberCounts;
    }

    @NotNull
    public final int[] getMemberCountsActiveWithLogin() {
        return this.memberCountsActiveWithLogin;
    }

    public final int add(@NotNull int[] userGroups, @NotNull Function1<? super Integer, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)userGroups, (String)"userGroups");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (this.parents == null) {
            int[] $this$forEach$iv = userGroups;
            boolean $i$f$forEach = false;
            for (int element$iv : $this$forEach$iv) {
                consumer.invoke((Object)element$iv);
            }
            return userGroups.length;
        }
        Set processed = new HashSet();
        int qLen = this.addToQueue(0, userGroups, processed);
        for (int i = 0; i < qLen; ++i) {
            int groupIdx = this.queueForParents[i];
            consumer.invoke((Object)groupIdx);
            qLen = this.addToQueue(qLen, this.parents[groupIdx], processed);
        }
        return qLen;
    }

    public final void addInactiveMembers(int index) {
        int[] nArray = this.allMemberCounts;
        int n = nArray[index];
        nArray[index] = n + 1;
    }

    public final void addActiveMembersWithoutLogin(int index) {
        int[] nArray = this.allMemberCounts;
        int n = nArray[index];
        nArray[index] = n + 1;
    }

    public final void addActiveMembersWithLogin(int index) {
        int[] nArray = this.allMemberCounts;
        int n = nArray[index];
        nArray[index] = n + 1;
        nArray = this.memberCountsActiveWithLogin;
        n = nArray[index];
        nArray[index] = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int addToQueue(int start, int[] groups2, Set<Integer> processed) {
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        int pos = 0;
        pos = start;
        Object $this$filter$iv = groups2;
        boolean $i$f$filter = false;
        int[] nArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!processed.add((int)it)) continue;
            destination$iv$iv.add((int)element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            n = pos;
            pos = n + 1;
            this.queueForParents[n] = it;
        }
        for (int group : groups2) {
            if (!processed.add(group)) continue;
            int n2 = pos;
            pos = n2 + 1;
            this.queueForParents[n2] = group;
        }
        return pos;
    }

    public final int activeAgentsCount(@Nullable Users agents) {
        Users users2 = agents;
        return users2 == null ? 0 : users2.getActiveWithLogin().length + agents.getActiveWithoutLogin().length;
    }

    public final int maxUsers() {
        Integer n = ArraysKt.maxOrNull((int[])this.allMemberCounts);
        return n != null ? n : 0;
    }

    @NotNull
    public final long[] component1() {
        return this.groupIds;
    }

    @Nullable
    public final int[][] component2() {
        return this.parents;
    }

    @NotNull
    public final List<Long> component3() {
        return this.activeAgentsGroupIds;
    }

    @NotNull
    public final Map<Long, List<Long>> component4() {
        return this.agentsParents;
    }

    @NotNull
    public final Groups copy(@NotNull long[] groupIds, @Nullable int[][] parents2, @NotNull List<Long> activeAgentsGroupIds, @NotNull Map<Long, ? extends List<Long>> agentsParents) {
        Intrinsics.checkNotNullParameter((Object)groupIds, (String)"groupIds");
        Intrinsics.checkNotNullParameter(activeAgentsGroupIds, (String)"activeAgentsGroupIds");
        Intrinsics.checkNotNullParameter(agentsParents, (String)"agentsParents");
        return new Groups(groupIds, parents2, activeAgentsGroupIds, agentsParents);
    }

    public static /* synthetic */ Groups copy$default(Groups groups2, long[] lArray, int[][] nArray, List list, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            lArray = groups2.groupIds;
        }
        if ((n & 2) != 0) {
            nArray = groups2.parents;
        }
        if ((n & 4) != 0) {
            list = groups2.activeAgentsGroupIds;
        }
        if ((n & 8) != 0) {
            map = groups2.agentsParents;
        }
        return groups2.copy(lArray, nArray, list, map);
    }

    @NotNull
    public String toString() {
        return "Groups(groupIds=" + Arrays.toString(this.groupIds) + ", parents=" + Arrays.toString((Object[])this.parents) + ", activeAgentsGroupIds=" + this.activeAgentsGroupIds + ", agentsParents=" + this.agentsParents + ')';
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.groupIds);
        result2 = result2 * 31 + (this.parents == null ? 0 : Arrays.hashCode((Object[])this.parents));
        result2 = result2 * 31 + ((Object)this.activeAgentsGroupIds).hashCode();
        result2 = result2 * 31 + ((Object)this.agentsParents).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Groups)) {
            return false;
        }
        Groups groups2 = (Groups)other;
        if (!Intrinsics.areEqual((Object)this.groupIds, (Object)groups2.groupIds)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parents, (Object)groups2.parents)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.activeAgentsGroupIds, groups2.activeAgentsGroupIds)) {
            return false;
        }
        return Intrinsics.areEqual(this.agentsParents, groups2.agentsParents);
    }
}

