/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries.memberships;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0000J\u0018\u0010\u0005\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0003H\u0002J\t\u0010\r\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u0012\u001a\u00020\tH\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\t0\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/memberships/MembershipCountHistogram;", "", "buckets", "", "([I)V", "add", "other", "", "value", "", "delta", "addAll", "values", "component1", "copy", "equals", "", "getIndex", "hashCode", "toString", "", "toStringMap", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMembershipResults.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MembershipResults.kt\ncom/atlassian/jira/migration/guardrails/queries/memberships/MembershipCountHistogram\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n1179#2,2:233\n1253#2,4:235\n*S KotlinDebug\n*F\n+ 1 MembershipResults.kt\ncom/atlassian/jira/migration/guardrails/queries/memberships/MembershipCountHistogram\n*L\n145#1:233,2\n145#1:235,4\n*E\n"})
public final class MembershipCountHistogram {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] buckets;
    @NotNull
    private static final int[] BUCKETS;
    @NotNull
    private static final String[] BUCKET_NAMES;

    public MembershipCountHistogram(@NotNull int[] buckets) {
        Intrinsics.checkNotNullParameter((Object)buckets, (String)"buckets");
        this.buckets = buckets;
    }

    public /* synthetic */ MembershipCountHistogram(int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            nArray = new int[BUCKETS.length + 1];
        }
        this(nArray);
    }

    public final void add(int value, int delta) {
        int[] nArray = this.buckets;
        int n = this.getIndex(value);
        nArray[n] = nArray[n] + delta;
    }

    public static /* synthetic */ void add$default(MembershipCountHistogram membershipCountHistogram, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        membershipCountHistogram.add(n, n2);
    }

    private final void addAll(int[] values) {
        for (int value : values) {
            MembershipCountHistogram.add$default(this, value, 0, 2, null);
        }
    }

    @NotNull
    public final MembershipCountHistogram add(@NotNull MembershipCountHistogram other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int[] nArray = Arrays.copyOf(this.buckets, this.buckets.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        int[] arr = nArray;
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            arr[n2] = arr[n2] + other.buckets[i];
        }
        return new MembershipCountHistogram(arr);
    }

    private final int getIndex(int value) {
        int index = ArraysKt.binarySearch$default((int[])BUCKETS, (int)value, (int)0, (int)0, (int)6, null);
        return index < 0 ? -index - 1 : index;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Integer> toStringMap() {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = (Iterable)ArraysKt.getIndices((int[])this.buckets);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        Iterator iterator2 = $this$associateTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv$iv = ((IntIterator)iterator2).nextInt();
            Map map = destination$iv$iv;
            int it = element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)BUCKET_NAMES[it], (Object)this.buckets[it]);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.guardrails.queries.memberships.MembershipCountHistogram");
        MembershipCountHistogram cfr_ignored_0 = (MembershipCountHistogram)other;
        return Arrays.equals(this.buckets, ((MembershipCountHistogram)other).buckets);
    }

    public int hashCode() {
        return Arrays.hashCode(this.buckets);
    }

    private final int[] component1() {
        return this.buckets;
    }

    @NotNull
    public final MembershipCountHistogram copy(@NotNull int[] buckets) {
        Intrinsics.checkNotNullParameter((Object)buckets, (String)"buckets");
        return new MembershipCountHistogram(buckets);
    }

    public static /* synthetic */ MembershipCountHistogram copy$default(MembershipCountHistogram membershipCountHistogram, int[] nArray, int n, Object object) {
        if ((n & 1) != 0) {
            nArray = membershipCountHistogram.buckets;
        }
        return membershipCountHistogram.copy(nArray);
    }

    @NotNull
    public String toString() {
        return "MembershipCountHistogram(buckets=" + Arrays.toString(this.buckets) + ')';
    }

    public MembershipCountHistogram() {
        this(null, 1, null);
    }

    static {
        int[] nArray = new int[]{0, 1, 5, 10, 25, 50, 75, 100, 250, 500, 1000, 5000};
        BUCKETS = nArray;
        int n = 0;
        int n2 = BUCKETS.length + 1;
        String[] stringArray = new String[n2];
        Companion companion = Companion;
        while (n < n2) {
            int n3 = n++;
            stringArray[n3] = companion.getBucketNameByIndex(n3);
        }
        BUCKET_NAMES = stringArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u001a\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/memberships/MembershipCountHistogram$Companion;", "", "()V", "BUCKETS", "", "BUCKET_NAMES", "", "", "[Ljava/lang/String;", "fromCounts", "Lcom/atlassian/jira/migration/guardrails/queries/memberships/MembershipCountHistogram;", "counts", "", "", "getBucketNameByIndex", "index", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final String getBucketNameByIndex(int index) {
            String start = index == 0 ? "0" : Integer.valueOf(BUCKETS[index - 1] + 1);
            return index == BUCKETS.length ? start + '+' : start + '-' + BUCKETS[index];
        }

        @NotNull
        public final MembershipCountHistogram fromCounts(@NotNull int[] counts) {
            Intrinsics.checkNotNullParameter((Object)counts, (String)"counts");
            MembershipCountHistogram histogram = new MembershipCountHistogram(null, 1, null);
            histogram.addAll(counts);
            return histogram;
        }

        @NotNull
        public final MembershipCountHistogram fromCounts(@NotNull Map<Integer, Integer> counts) {
            Intrinsics.checkNotNullParameter(counts, (String)"counts");
            MembershipCountHistogram histogram = new MembershipCountHistogram(null, 1, null);
            counts.forEach((arg_0, arg_1) -> Companion.fromCounts$lambda$0((Function2)new Function2<Integer, Integer, Unit>((Object)histogram){

                public final void invoke(int p0, int p1) {
                    ((MembershipCountHistogram)this.receiver).add(p0, p1);
                }
            }, arg_0, arg_1));
            return histogram;
        }

        private static final void fromCounts$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

