/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries.memberships;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.jira.migration.db.CwdGroupTable;
import com.atlassian.jira.migration.db.CwdMembershipTable;
import com.atlassian.jira.migration.db.CwdUserAttributesTable;
import com.atlassian.jira.migration.db.CwdUserTable;
import com.atlassian.jira.migration.db.LicenseRolesGroupTable;
import com.atlassian.jira.migration.guardrails.cancel.AssessmentCanceledChecker;
import com.atlassian.jira.migration.guardrails.queries.AssessmentDatabaseAccessor;
import com.atlassian.jira.migration.guardrails.queries.AssessmentDatabaseConnection;
import com.atlassian.jira.migration.guardrails.queries.memberships.Groups;
import com.atlassian.jira.migration.guardrails.queries.memberships.MembershipStats;
import com.atlassian.jira.migration.guardrails.queries.memberships.Memberships;
import com.atlassian.jira.migration.guardrails.queries.memberships.Users;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rH\u0002J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0011\u001a\u00020\u00102\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\nH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J4\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002JG\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\n0\u00152\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001f2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J.\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u00102\u0010\b\u0002\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\nH\u0002J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J%\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J'\u0010*\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u0002H+0-H\u0002\u00a2\u0006\u0002\u0010/J \u00100\u001a\u00020\u00162\u000e\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\n2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u001a\u00102\u001a\u00020\u000e2\u0010\u00103\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\nH\u0002J\u000e\u00104\u001a\u0002052\u0006\u0010\u0011\u001a\u00020\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/memberships/MembershipFetcher;", "", "directoryManager", "Lcom/atlassian/crowd/manager/directory/DirectoryManager;", "databaseAccessor", "Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseAccessor;", "cancelChecker", "Lcom/atlassian/jira/migration/guardrails/cancel/AssessmentCanceledChecker;", "(Lcom/atlassian/crowd/manager/directory/DirectoryManager;Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseAccessor;Lcom/atlassian/jira/migration/guardrails/cancel/AssessmentCanceledChecker;)V", "batchPredicates", "", "Lcom/querydsl/core/types/Predicate;", "emptyPair", "Lkotlin/Pair;", "", "fetchAgents", "", "directoryId", "agentGroups", "fetchAgentsGroups", "fetchParents", "", "", "membershipType", "Lcom/atlassian/crowd/model/membership/MembershipType;", "batchPredicate", "groupIds", "getAgentsParents", "agentsGroups", "", "parents", "", "(Ljava/util/Set;[[I[J)Ljava/util/Map;", "getMembershipStats", "Lcom/atlassian/jira/migration/guardrails/queries/memberships/MembershipStats;", "groups", "Lcom/atlassian/jira/migration/guardrails/queries/memberships/Groups;", "listActiveUsers", "userSubset", "listGroups", "(J[J)[[I", "processDirectory", "runQuery", "T", "callback", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseConnection;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "toIndexes", "ids", "toSortedLongArray", "list", "users", "Lcom/atlassian/jira/migration/guardrails/queries/memberships/Users;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMembershipFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MembershipFetcher.kt\ncom/atlassian/jira/migration/guardrails/queries/memberships/MembershipFetcher\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,269:1\n215#2,2:270\n215#2,2:294\n1#3:272\n766#4:273\n857#4,2:274\n1549#4:276\n1620#4,3:277\n1490#4:280\n1520#4,3:281\n1523#4,3:291\n372#5,7:284\n*S KotlinDebug\n*F\n+ 1 MembershipFetcher.kt\ncom/atlassian/jira/migration/guardrails/queries/memberships/MembershipFetcher\n*L\n61#1:270,2\n242#1:294,2\n108#1:273\n108#1:274,2\n111#1:276\n111#1:277,3\n186#1:280\n186#1:281,3\n186#1:291,3\n186#1:284,7\n*E\n"})
public final class MembershipFetcher {
    @NotNull
    private final DirectoryManager directoryManager;
    @NotNull
    private final AssessmentDatabaseAccessor databaseAccessor;
    @NotNull
    private final AssessmentCanceledChecker cancelChecker;

    @Inject
    public MembershipFetcher(@NotNull DirectoryManager directoryManager, @NotNull AssessmentDatabaseAccessor databaseAccessor, @NotNull AssessmentCanceledChecker cancelChecker) {
        Intrinsics.checkNotNullParameter((Object)directoryManager, (String)"directoryManager");
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        this.directoryManager = directoryManager;
        this.databaseAccessor = databaseAccessor;
        this.cancelChecker = cancelChecker;
    }

    @NotNull
    public final MembershipStats getMembershipStats() {
        MembershipStats result2 = MembershipStats.Companion.empty();
        for (Directory directory : this.directoryManager.findAllDirectories()) {
            if (!directory.isActive()) continue;
            Long l = directory.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            result2 = result2.add(this.processDirectory(((Number)l).longValue()));
        }
        return result2;
    }

    private final MembershipStats processDirectory(long directoryId) {
        Groups groups2 = this.groups(directoryId);
        Users users2 = this.users(directoryId);
        List<Long> allAgents = this.fetchAgents(directoryId, CollectionsKt.plus((Collection)groups2.getActiveAgentsGroupIds(), (Iterable)CollectionsKt.flatten((Iterable)groups2.getAgentsParents().values())));
        Pair<long[], long[]> activeAgents = !((Collection)allAgents).isEmpty() ? this.listActiveUsers(directoryId, allAgents) : this.emptyPair();
        Memberships memberships = new Memberships(groups2, users2, new Users((long[])activeAgents.getFirst(), (long[])activeAgents.getSecond(), allAgents.size()));
        for (Predicate batch : this.batchPredicates()) {
            Map<Long, int[]> userGroups = this.fetchParents(directoryId, MembershipType.GROUP_USER, batch, groups2.getGroupIds());
            userGroups.forEach((arg_0, arg_1) -> MembershipFetcher.processDirectory$lambda$0((Function2)new Function2<Long, int[], Unit>((Object)memberships){

                public final void invoke(long p0, @NotNull int[] p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    ((Memberships)this.receiver).addUserGroups(p0, p1);
                }
            }, arg_0, arg_1));
        }
        return memberships.toStats();
    }

    private final Groups groups(long directoryId) {
        long[] groupIds = this.listGroups(directoryId);
        List<Long> agentsGroups = this.fetchAgentsGroups(directoryId);
        int[][] parents2 = this.parents(directoryId, groupIds);
        Map<Long, List<Long>> agentsParents = this.getAgentsParents(CollectionsKt.toSet((Iterable)agentsGroups), parents2, groupIds);
        return new Groups(groupIds, parents2, agentsGroups, agentsParents);
    }

    private final int[][] parents(long directoryId, long[] groupIds) {
        if (!this.directoryManager.supportsNestedGroups(directoryId)) {
            return null;
        }
        int n = 0;
        int n2 = groupIds.length;
        int[][] nArrayArray = new int[n2][];
        while (n < n2) {
            int n3 = n++;
            nArrayArray[n3] = ArrayUtils.EMPTY_INT_ARRAY;
        }
        int[][] parents2 = nArrayArray;
        for (Predicate batch : this.batchPredicates()) {
            Map<Long, int[]> parentsMap;
            Map<Long, int[]> $this$forEach$iv = parentsMap = this.fetchParents(directoryId, MembershipType.GROUP_GROUP, batch, groupIds);
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Long, int[]>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<Long, int[]> element$iv;
                Map.Entry<Long, int[]> it = element$iv = iterator2.next();
                boolean bl = false;
                int index = ArraysKt.binarySearch$default((long[])groupIds, (long)((Number)it.getKey()).longValue(), (int)0, (int)0, (int)6, null);
                if (index < 0) continue;
                parents2[index] = it.getValue();
            }
        }
        return parents2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Long, List<Long>> getAgentsParents(Set<Long> agentsGroups, int[][] parents2, long[] groupIds) {
        void $this$filterTo$iv$iv;
        Collection<Long> collection;
        if (parents2 == null || agentsGroups == null) {
            return MapsKt.emptyMap();
        }
        int n = ((Object[])parents2).length;
        ArrayList<List> arrayList = new ArrayList<List>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            collection = arrayList;
            boolean bl = false;
            ((ArrayList)collection).add((Long)((Object)new ArrayList()));
        }
        List adjacencyList = arrayList;
        int n5 = ((Object[])parents2).length;
        for (int child = 0; child < n5; ++child) {
            for (int parent : parents2[child]) {
                ((List)adjacencyList.get(parent)).add(child);
            }
        }
        Map allDescendants = new LinkedHashMap();
        Iterable $this$filter$iv = (Iterable)ArraysKt.getIndices((Object[])((Object[])parents2));
        boolean $i$f$filter = false;
        Iterable it = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it2 = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!agentsGroups.contains(groupIds[it2])) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator2 = ((List)destination$iv$iv).iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            Object element$iv$iv;
            int group = ((Number)iterator2.next()).intValue();
            List<Integer> descendants = MembershipFetcher.getAgentsParents$dfs(adjacencyList, group);
            if (!(!((Collection)descendants).isEmpty())) continue;
            Map map = allDescendants;
            Long l = groupIds[group];
            Iterable $this$map$iv = descendants;
            boolean $i$f$map = false;
            element$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                int n6 = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(groupIds[it3]);
            }
            List list = (List)destination$iv$iv2;
            map.put(l, list);
        }
        return allDescendants;
    }

    private final List<Long> fetchAgentsGroups(long directoryId) {
        Object t = this.runQuery((Function1)new Function1<AssessmentDatabaseConnection, List<Long>>(directoryId){
            final /* synthetic */ long $directoryId;
            {
                this.$directoryId = $directoryId;
                super(1);
            }

            public final List<Long> invoke(@NotNull AssessmentDatabaseConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                NumberPath<Long> numberPath = CwdGroupTable.Companion.getCWD_GROUP_TABLE().getGroupId();
                Intrinsics.checkNotNullExpressionValue(numberPath, (String)"<get-groupId>(...)");
                return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)it.select((Expression)numberPath).from((Expression)CwdGroupTable.Companion.getCWD_GROUP_TABLE())).join((EntityPath)LicenseRolesGroupTable.Companion.getLICENSE_ROLES_GROUP_TABLE())).on((Predicate)CwdGroupTable.Companion.getCWD_GROUP_TABLE().getGroupName().toLowerCase().eq((Expression)LicenseRolesGroupTable.Companion.getLICENSE_ROLES_GROUP_TABLE().getGROUP_ID().toLowerCase()))).where((Predicate)LicenseRolesGroupTable.Companion.getLICENSE_ROLES_GROUP_TABLE().getLICENSE_ROLE_NAME().eq((Object)"jira-servicedesk"))).where((Predicate)CwdGroupTable.Companion.getCWD_GROUP_TABLE().getDirectoryId().eq((Object)this.$directoryId))).distinct()).fetch();
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"runQuery(...)");
        return (List)t;
    }

    private final List<Long> fetchAgents(long directoryId, List<Long> agentGroups) {
        List result2 = (List)this.runQuery((Function1)new Function1<AssessmentDatabaseConnection, List<Long>>(agentGroups, directoryId){
            final /* synthetic */ List<Long> $agentGroups;
            final /* synthetic */ long $directoryId;
            {
                this.$agentGroups = $agentGroups;
                this.$directoryId = $directoryId;
                super(1);
            }

            public final List<Long> invoke(@NotNull AssessmentDatabaseConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                NumberPath<Long> numberPath = CwdUserTable.Companion.getCWD_USER_TABLE().getUserId();
                Intrinsics.checkNotNullExpressionValue(numberPath, (String)"<get-userId>(...)");
                return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)it.select((Expression)numberPath).from((Expression)CwdUserTable.Companion.getCWD_USER_TABLE())).join((EntityPath)CwdMembershipTable.INSTANCE)).on((Predicate)CwdMembershipTable.INSTANCE.getChildId().eq((Expression)CwdUserTable.Companion.getCWD_USER_TABLE().getUserId()))).where((Predicate)CwdMembershipTable.INSTANCE.getParentId().in((Collection)this.$agentGroups))).where((Predicate)CwdMembershipTable.INSTANCE.getDirectoryId().eq((Object)this.$directoryId))).distinct()).fetch();
            }
        });
        List list = result2;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Users users(long directoryId) {
        long count2 = ((Number)this.runQuery((Function1)new Function1<AssessmentDatabaseConnection, Long>(directoryId){
            final /* synthetic */ long $directoryId;
            {
                this.$directoryId = $directoryId;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull AssessmentDatabaseConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                NumberPath<Long> numberPath = CwdUserTable.Companion.getCWD_USER_TABLE().getUserId();
                Intrinsics.checkNotNullExpressionValue(numberPath, (String)"<get-userId>(...)");
                return ((SQLQuery)((SQLQuery)it.select((Expression)numberPath).from((Expression)CwdUserTable.Companion.getCWD_USER_TABLE())).where((Predicate)CwdUserTable.Companion.getCWD_USER_TABLE().getDirectoryId().eq((Object)this.$directoryId))).fetchCount();
            }
        })).longValue();
        Pair users2 = MembershipFetcher.listActiveUsers$default(this, directoryId, null, 2, null);
        return new Users((long[])users2.getFirst(), (long[])users2.getSecond(), (int)count2);
    }

    private final long[] listGroups(long directoryId) {
        return this.toSortedLongArray((List)this.runQuery((Function1)new Function1<AssessmentDatabaseConnection, List<Long>>(directoryId){
            final /* synthetic */ long $directoryId;
            {
                this.$directoryId = $directoryId;
                super(1);
            }

            public final List<Long> invoke(@NotNull AssessmentDatabaseConnection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                NumberPath<Long> numberPath = CwdGroupTable.Companion.getCWD_GROUP_TABLE().getGroupId();
                Intrinsics.checkNotNullExpressionValue(numberPath, (String)"<get-groupId>(...)");
                return ((SQLQuery)((SQLQuery)it.select((Expression)numberPath).from((Expression)CwdGroupTable.Companion.getCWD_GROUP_TABLE())).where((Predicate)CwdGroupTable.Companion.getCWD_GROUP_TABLE().getDirectoryId().eq((Object)this.$directoryId))).fetch();
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<long[], long[]> listActiveUsers(long directoryId, List<Long> userSubset) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Object t = this.runQuery((Function1)new Function1<AssessmentDatabaseConnection, List<Tuple>>(directoryId, userSubset){
            final /* synthetic */ long $directoryId;
            final /* synthetic */ List<Long> $userSubset;
            {
                this.$directoryId = $directoryId;
                this.$userSubset = $userSubset;
                super(1);
            }

            public final List<Tuple> invoke(@NotNull AssessmentDatabaseConnection db) {
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                Object object = new Expression[2];
                Intrinsics.checkNotNullExpressionValue(CwdUserTable.Companion.getCWD_USER_TABLE().getUserId(), (String)"<get-userId>(...)");
                Intrinsics.checkNotNullExpressionValue((Object)CwdUserAttributesTable.Companion.getCWD_USER_ATTRIBUTES_TABLE().getAttributeValue().length(), (String)"length(...)");
                SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression<?>)object).from((Expression)CwdUserTable.Companion.getCWD_USER_TABLE())).leftJoin((EntityPath)CwdUserAttributesTable.Companion.getCWD_USER_ATTRIBUTES_TABLE())).on((Predicate)CwdUserAttributesTable.Companion.getCWD_USER_ATTRIBUTES_TABLE().getUserId().eq((Expression)CwdUserTable.Companion.getCWD_USER_TABLE().getUserId()).and((Predicate)CwdUserAttributesTable.Companion.getCWD_USER_ATTRIBUTES_TABLE().getAttributeName().eq((Object)"login.lastLoginMillis")))).where((Predicate)CwdUserTable.Companion.getCWD_USER_TABLE().getDirectoryId().eq((Object)this.$directoryId))).where((Predicate)CwdUserTable.Companion.getCWD_USER_TABLE().getActive().eq((Object)1));
                object = this.$userSubset;
                if (!(object == null || object.isEmpty())) {
                    query.where((Predicate)CwdUserTable.Companion.getCWD_USER_TABLE().getUserId().in((Collection)this.$userSubset));
                }
                return query.fetch();
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"runQuery(...)");
        Iterable iterable = (Iterable)t;
        boolean $i$f$groupBy = false;
        void var7_5 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Tuple it2 = (Tuple)element$iv$iv;
            boolean $i$a$-groupBy-MembershipFetcher$listActiveUsers$byHasLogin$42 = false;
            Integer n = (Integer)it2.get(1, Integer.TYPE);
            if (n == null) {
                n = 0;
            }
            Integer n2 = n;
            Intrinsics.checkNotNull((Object)n2);
            Boolean key$iv$iv = ((Number)n2).intValue() > 0;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Tuple $i$a$-groupBy-MembershipFetcher$listActiveUsers$byHasLogin$42 = (Tuple)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add((Long)it.get(0, Long.TYPE));
        }
        Map byHasLogin2 = destination$iv$iv;
        return new Pair((Object)this.toSortedLongArray((List)byHasLogin2.get(false)), (Object)this.toSortedLongArray((List)byHasLogin2.get(true)));
    }

    static /* synthetic */ Pair listActiveUsers$default(MembershipFetcher membershipFetcher, long l, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        return membershipFetcher.listActiveUsers(l, list);
    }

    private final Pair<long[], long[]> emptyPair() {
        return new Pair((Object)new long[0], (Object)new long[0]);
    }

    private final long[] toSortedLongArray(List<Long> list) {
        if (list == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtils.EMPTY_LONG_ARRAY, (String)"EMPTY_LONG_ARRAY");
            return ArrayUtils.EMPTY_LONG_ARRAY;
        }
        long[] result2 = new long[list.size()];
        int len = 0;
        for (Long id : list) {
            if (id == null) continue;
            result2[len++] = id;
        }
        if (len < result2.length) {
            long[] lArray = Arrays.copyOf(result2, len);
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
            result2 = lArray;
        }
        ArraysKt.sort((long[])result2);
        return result2;
    }

    private final List<Predicate> batchPredicates() {
        List result2 = new ArrayList();
        BooleanExpression booleanExpression = CwdMembershipTable.INSTANCE.getLowerChildName().lt((Comparable)((Object)"a"));
        Intrinsics.checkNotNullExpressionValue((Object)booleanExpression, (String)"lt(...)");
        result2.add(booleanExpression);
        BooleanExpression booleanExpression2 = CwdMembershipTable.INSTANCE.getLowerChildName().goe((Comparable)((Object)"z"));
        Intrinsics.checkNotNullExpressionValue((Object)booleanExpression2, (String)"goe(...)");
        result2.add(booleanExpression2);
        for (char c = 'a'; c < 'z'; c = (char)(c + '\u0001')) {
            char next = (char)(c + 1);
            BooleanExpression booleanExpression3 = CwdMembershipTable.INSTANCE.getLowerChildName().goe((Comparable)((Object)String.valueOf(c))).and((Predicate)CwdMembershipTable.INSTANCE.getLowerChildName().lt((Comparable)((Object)String.valueOf(next))));
            Intrinsics.checkNotNullExpressionValue((Object)booleanExpression3, (String)"and(...)");
            result2.add(booleanExpression3);
        }
        return result2;
    }

    private final Map<Long, int[]> fetchParents(long directoryId, MembershipType membershipType, Predicate batchPredicate, long[] groupIds) {
        Map parents2 = (Map)this.runQuery((Function1)new Function1<AssessmentDatabaseConnection, Map<Long, ? extends List<? extends Long>>>(directoryId, membershipType, batchPredicate){
            final /* synthetic */ long $directoryId;
            final /* synthetic */ MembershipType $membershipType;
            final /* synthetic */ Predicate $batchPredicate;
            {
                this.$directoryId = $directoryId;
                this.$membershipType = $membershipType;
                this.$batchPredicate = $batchPredicate;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Long, List<Long>> invoke(@NotNull AssessmentDatabaseConnection db) {
                void $this$groupByTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                Expression[] expressionArray = new Expression[2];
                Intrinsics.checkNotNullExpressionValue(CwdMembershipTable.INSTANCE.getChildId(), (String)"<get-childId>(...)");
                Intrinsics.checkNotNullExpressionValue(CwdMembershipTable.INSTANCE.getParentId(), (String)"<get-parentId>(...)");
                List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)CwdMembershipTable.INSTANCE)).where((Predicate)CwdMembershipTable.INSTANCE.getDirectoryId().eq((Object)this.$directoryId))).where((Predicate)CwdMembershipTable.INSTANCE.getMembershipType().eq((Object)this.$membershipType.name()))).where(this.$batchPredicate)).fetch();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
                Iterable $this$groupBy$iv = list;
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    void it;
                    Object object;
                    Tuple it2 = (Tuple)element$iv$iv;
                    boolean $i$a$-groupBy-MembershipFetcher$fetchParents$parents$1$32 = false;
                    Long key$iv$iv = (Long)it2.get(0, Long.TYPE);
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    Tuple $i$a$-groupBy-MembershipFetcher$fetchParents$parents$1$32 = (Tuple)element$iv$iv;
                    List list2 = list$iv$iv;
                    boolean bl = false;
                    list2.add((Long)it.get(1, Long.TYPE));
                }
                return destination$iv$iv;
            }
        });
        Map result2 = new LinkedHashMap();
        Map $this$forEach$iv = parents2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            if (it.getKey() == null) continue;
            Object k = it.getKey();
            Intrinsics.checkNotNull(k);
            result2.put(k, this.toIndexes((List)it.getValue(), groupIds));
        }
        return result2;
    }

    private final <T> T runQuery(Function1<? super AssessmentDatabaseConnection, ? extends T> callback) {
        this.cancelChecker.checkCanceled();
        Object object = this.databaseAccessor.run-IoAF18A(callback);
        ResultKt.throwOnFailure((Object)object);
        return (T)object;
    }

    private final int[] toIndexes(List<Long> ids, long[] groupIds) {
        int[] nArray;
        int[] indexes = new int[ids.size()];
        int len = 0;
        for (Long id : ids) {
            int index;
            if (id == null || (index = ArraysKt.binarySearch$default((long[])groupIds, (long)id, (int)0, (int)0, (int)6, null)) < 0) continue;
            indexes[len++] = index;
        }
        if (len == indexes.length) {
            nArray = indexes;
        } else {
            int[] nArray2 = Arrays.copyOf(indexes, len);
            nArray = nArray2;
            Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        }
        return nArray;
    }

    private static final void processDirectory$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final List<Integer> getAgentsParents$dfs(List<List<Integer>> adjacencyList, int source) {
        Set visited = new LinkedHashSet();
        Object[] objectArray = new Integer[]{source};
        List stack = CollectionsKt.mutableListOf((Object[])objectArray);
        List descendants = new ArrayList();
        while (!((Collection)stack).isEmpty()) {
            int node = ((Number)stack.remove(stack.size() - 1)).intValue();
            if (!visited.add(node)) continue;
            descendants.add(node);
            Iterator<Integer> iterator2 = adjacencyList.get(node).iterator();
            while (iterator2.hasNext()) {
                int child = ((Number)iterator2.next()).intValue();
                if (visited.contains(child)) continue;
                stack.add(child);
            }
        }
        descendants.remove((Object)source);
        return descendants;
    }
}

