/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries.memberships;

import com.atlassian.jira.migration.guardrails.queries.memberships.Groups;
import com.atlassian.jira.migration.guardrails.queries.memberships.MembershipCountHistogram;
import com.atlassian.jira.migration.guardrails.queries.memberships.MembershipStats;
import com.atlassian.jira.migration.guardrails.queries.memberships.Users;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0006\u0010\u001c\u001a\u00020\u001dJ\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/memberships/Memberships;", "", "groups", "Lcom/atlassian/jira/migration/guardrails/queries/memberships/Groups;", "users", "Lcom/atlassian/jira/migration/guardrails/queries/memberships/Users;", "agents", "(Lcom/atlassian/jira/migration/guardrails/queries/memberships/Groups;Lcom/atlassian/jira/migration/guardrails/queries/memberships/Users;Lcom/atlassian/jira/migration/guardrails/queries/memberships/Users;)V", "getAgents", "()Lcom/atlassian/jira/migration/guardrails/queries/memberships/Users;", "getGroups", "()Lcom/atlassian/jira/migration/guardrails/queries/memberships/Groups;", "getUsers", "addUserGroups", "", "userId", "", "groupIndexes", "", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toStats", "Lcom/atlassian/jira/migration/guardrails/queries/memberships/MembershipStats;", "toString", "", "jira-migration-plugin"})
public final class Memberships {
    @NotNull
    private final Groups groups;
    @NotNull
    private final Users users;
    @Nullable
    private final Users agents;

    public Memberships(@NotNull Groups groups2, @NotNull Users users2, @Nullable Users agents) {
        Intrinsics.checkNotNullParameter((Object)groups2, (String)"groups");
        Intrinsics.checkNotNullParameter((Object)users2, (String)"users");
        this.groups = groups2;
        this.users = users2;
        this.agents = agents;
    }

    @NotNull
    public final Groups getGroups() {
        return this.groups;
    }

    @NotNull
    public final Users getUsers() {
        return this.users;
    }

    @Nullable
    public final Users getAgents() {
        return this.agents;
    }

    public final void addUserGroups(long userId, @NotNull int[] groupIndexes) {
        Intrinsics.checkNotNullParameter((Object)groupIndexes, (String)"groupIndexes");
        Function1 appendTo2 = ArraysKt.binarySearch$default((long[])this.users.getActiveWithoutLogin(), (long)userId, (int)0, (int)0, (int)6, null) >= 0 ? (Function1)new Function1<Integer, Unit>((Object)this.groups){

            public final void invoke(int p0) {
                ((Groups)this.receiver).addActiveMembersWithoutLogin(p0);
            }
        } : (ArraysKt.binarySearch$default((long[])this.users.getActiveWithLogin(), (long)userId, (int)0, (int)0, (int)6, null) >= 0 ? (Function1)new Function1<Integer, Unit>((Object)this.groups){

            public final void invoke(int p0) {
                ((Groups)this.receiver).addActiveMembersWithLogin(p0);
            }
        } : (Function1)new Function1<Integer, Unit>((Object)this.groups){

            public final void invoke(int p0) {
                ((Groups)this.receiver).addInactiveMembers(p0);
            }
        });
        int groupCount = this.groups.add(groupIndexes, (Function1<? super Integer, Unit>)appendTo2);
        this.users.add(userId, groupCount);
    }

    @NotNull
    public final MembershipStats toStats() {
        Map overLimit = new LinkedHashMap();
        int emptyGroupsCount = 0;
        int n = this.groups.getGroupIds().length;
        for (int i = 0; i < n; ++i) {
            int count2 = this.groups.getAllMemberCounts()[i];
            if (count2 >= 35000) {
                Integer n2 = count2;
                overLimit.put(this.groups.getGroupIds()[i], n2);
                continue;
            }
            if (count2 != 0) continue;
            ++emptyGroupsCount;
        }
        Users users2 = this.agents;
        return new MembershipStats(overLimit, MembershipCountHistogram.Companion.fromCounts(this.groups.getMemberCountsActiveWithLogin()), this.users.getHistogram(), this.groups.getGroupIds().length, this.users.getUserCount(), this.users.getSumGroups(), this.groups.maxUsers(), this.users.getMaxGroups(), users2 != null ? users2.getUserCount() : 0, this.groups.activeAgentsCount(this.agents), emptyGroupsCount);
    }

    @NotNull
    public final Groups component1() {
        return this.groups;
    }

    @NotNull
    public final Users component2() {
        return this.users;
    }

    @Nullable
    public final Users component3() {
        return this.agents;
    }

    @NotNull
    public final Memberships copy(@NotNull Groups groups2, @NotNull Users users2, @Nullable Users agents) {
        Intrinsics.checkNotNullParameter((Object)groups2, (String)"groups");
        Intrinsics.checkNotNullParameter((Object)users2, (String)"users");
        return new Memberships(groups2, users2, agents);
    }

    public static /* synthetic */ Memberships copy$default(Memberships memberships, Groups groups2, Users users2, Users users3, int n, Object object) {
        if ((n & 1) != 0) {
            groups2 = memberships.groups;
        }
        if ((n & 2) != 0) {
            users2 = memberships.users;
        }
        if ((n & 4) != 0) {
            users3 = memberships.agents;
        }
        return memberships.copy(groups2, users2, users3);
    }

    @NotNull
    public String toString() {
        return "Memberships(groups=" + this.groups + ", users=" + this.users + ", agents=" + this.agents + ')';
    }

    public int hashCode() {
        int result2 = this.groups.hashCode();
        result2 = result2 * 31 + this.users.hashCode();
        result2 = result2 * 31 + (this.agents == null ? 0 : this.agents.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Memberships)) {
            return false;
        }
        Memberships memberships = (Memberships)other;
        if (!Intrinsics.areEqual((Object)this.groups, (Object)memberships.groups)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.users, (Object)memberships.users)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.agents, (Object)memberships.agents);
    }
}

