/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries.memberships;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.jira.migration.guardrails.cancel.AssessmentCanceledChecker;
import com.atlassian.jira.migration.guardrails.queries.AssessmentDatabaseAccessor;
import com.atlassian.jira.migration.guardrails.queries.GrQuery;
import com.atlassian.jira.migration.guardrails.queries.JesatQuery;
import com.atlassian.jira.migration.guardrails.queries.QueryProductType;
import com.atlassian.jira.migration.guardrails.queries.memberships.MembershipCountHistogram;
import com.atlassian.jira.migration.guardrails.queries.memberships.MembershipFetcher;
import com.atlassian.jira.migration.guardrails.queries.memberships.MembershipStats;
import com.atlassian.jira.migration.guardrails.queries.memberships.NestedGroupsQuery;
import com.atlassian.jira.migration.guardrails.util.JsonEntry;
import com.atlassian.jira.migration.guardrails.util.JsonUtils;
import com.atlassian.jira.migration.platform.GsonFactory;
import com.google.gson.Gson;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ/\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001c\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u000e0\u000e0\rH\u0016J$\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u000e0\u000e0\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/memberships/NestedGroupsQuery;", "Lcom/atlassian/jira/migration/guardrails/queries/GrQuery;", "Lcom/atlassian/jira/migration/guardrails/queries/JesatQuery;", "directoryManager", "Lcom/atlassian/crowd/manager/directory/DirectoryManager;", "databaseAccessor", "Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseAccessor;", "gsonFactory", "Lcom/atlassian/jira/migration/platform/GsonFactory;", "(Lcom/atlassian/crowd/manager/directory/DirectoryManager;Lcom/atlassian/jira/migration/guardrails/queries/AssessmentDatabaseAccessor;Lcom/atlassian/jira/migration/platform/GsonFactory;)V", "gson", "Lcom/google/gson/Gson;", "queryIds", "", "", "Lcom/atlassian/jira/migration/guardrails/queries/QueryProductType;", "getQueryIds", "()Ljava/util/Map;", "executeAll", "Lkotlin/Result;", "cancelChecker", "Lcom/atlassian/jira/migration/guardrails/cancel/AssessmentCanceledChecker;", "executeAll-IoAF18A", "(Lcom/atlassian/jira/migration/guardrails/cancel/AssessmentCanceledChecker;)Ljava/lang/Object;", "getExample", "kotlin.jvm.PlatformType", "toResults", "stats", "Lcom/atlassian/jira/migration/guardrails/queries/memberships/MembershipStats;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nNestedGroupsQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NestedGroupsQuery.kt\ncom/atlassian/jira/migration/guardrails/queries/memberships/NestedGroupsQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1271#2,2:102\n1285#2,4:104\n1271#2,2:108\n1285#2,4:110\n*S KotlinDebug\n*F\n+ 1 NestedGroupsQuery.kt\ncom/atlassian/jira/migration/guardrails/queries/memberships/NestedGroupsQuery\n*L\n67#1:102,2\n67#1:104,4\n68#1:108,2\n68#1:110,4\n*E\n"})
public final class NestedGroupsQuery
implements GrQuery,
JesatQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DirectoryManager directoryManager;
    @NotNull
    private final AssessmentDatabaseAccessor databaseAccessor;
    @NotNull
    private final Gson gson;
    @NotNull
    private final Map<String, QueryProductType> queryIds;
    @NotNull
    public static final String AVG_ANG_MAX_IN_GROUPS = "AVG_AND_MAX_MEMBERSHIPS_IN_GROUPS";
    @NotNull
    public static final String AVG_ANG_MAX_PER_USER = "AVG_AND_MAX_GROUPS_PER_USERS";
    @NotNull
    public static final String GROUPS_WITH_35K = "GROUPS_WITH_35K_OR_MORE_USER_MEMBERSHIPS";
    @NotNull
    public static final String HISTOGRAM_GROUPS_BY_SIZE = "HISTOGRAM_GROUPS_BY_SIZE";
    @NotNull
    public static final String HISTOGRAM_USERS_BY_SIZE = "HISTOGRAM_OF_ACTIVE_USERS_ACROSS_GROUPS";
    @NotNull
    public static final String MAX_GROUPS_USER = "MAX_GROUPS_USER";
    @NotNull
    public static final String ACTIVE_AGENTS = "ACTIVE_AGENTS";
    @NotNull
    public static final String ALL_AGENTS = "ALL_AGENTS";
    @NotNull
    public static final String EMPTY_GROUPS = "EMPTY_GROUPS";
    @NotNull
    private static final MembershipStats EXAMPLE;

    @Inject
    public NestedGroupsQuery(@NotNull DirectoryManager directoryManager, @NotNull AssessmentDatabaseAccessor databaseAccessor, @NotNull GsonFactory gsonFactory) {
        QueryProductType queryProductType;
        Map map;
        Object object;
        Object element$iv$iv;
        Object $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)directoryManager, (String)"directoryManager");
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)gsonFactory, (String)"gsonFactory");
        this.directoryManager = directoryManager;
        this.databaseAccessor = databaseAccessor;
        this.gson = gsonFactory.createGson();
        Object object2 = new String[]{AVG_ANG_MAX_IN_GROUPS, AVG_ANG_MAX_PER_USER, GROUPS_WITH_35K, HISTOGRAM_GROUPS_BY_SIZE, HISTOGRAM_USERS_BY_SIZE, MAX_GROUPS_USER, EMPTY_GROUPS};
        object2 = SetsKt.setOf((Object[])object2);
        NestedGroupsQuery nestedGroupsQuery = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Object $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator2 = $this$associateWithTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            String string = (String)element$iv$iv;
            object = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            queryProductType = QueryProductType.JIRA;
            map.put(object, queryProductType);
        }
        $this$associateWith$iv = new String[]{ACTIVE_AGENTS, ALL_AGENTS};
        $this$associateWith$iv = SetsKt.setOf((Object[])$this$associateWith$iv);
        map = result$iv;
        $i$f$associateWith = false;
        result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        $this$associateWithTo$iv$iv = $this$associateWith$iv;
        $i$f$associateWithTo = false;
        iterator2 = $this$associateWithTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            String it = (String)element$iv$iv;
            queryProductType = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            QueryProductType queryProductType2 = QueryProductType.JSM;
            object.put((QueryProductType)queryProductType, (QueryProductType)queryProductType2);
        }
        object = result$iv;
        nestedGroupsQuery.queryIds = MapsKt.plus((Map)map, object);
    }

    @Override
    @NotNull
    public Map<String, QueryProductType> getQueryIds() {
        return this.queryIds;
    }

    @Override
    @NotNull
    public Object executeAll-IoAF18A(@NotNull AssessmentCanceledChecker cancelChecker) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)cancelChecker, (String)"cancelChecker");
        try {
            boolean bl = false;
            MembershipFetcher membershipFetcher = new MembershipFetcher(this.directoryManager, this.databaseAccessor, cancelChecker);
            object = Result.constructor-impl(this.toResults(membershipFetcher.getMembershipStats()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    @Override
    @NotNull
    public Map<String, String> getExample() {
        return this.toResults(EXAMPLE);
    }

    private final Map<String, String> toResults(MembershipStats stats) {
        Pair[] pairArray = new Pair[9];
        JsonEntry[] jsonEntryArray = new JsonEntry[]{new JsonEntry("avg", Integer.valueOf(stats.averageGroupUsers())), new JsonEntry("max", Integer.valueOf(stats.getMaxGroupUsers()))};
        pairArray[0] = TuplesKt.to((Object)AVG_ANG_MAX_IN_GROUPS, (Object)JsonUtils.INSTANCE.jsonString(JsonUtils.INSTANCE.jsonStruct(jsonEntryArray)));
        jsonEntryArray = new JsonEntry[]{new JsonEntry("avg", Integer.valueOf(stats.averageUserGroups())), new JsonEntry("max", Integer.valueOf(stats.getMaxUserGroups()))};
        pairArray[1] = TuplesKt.to((Object)AVG_ANG_MAX_PER_USER, (Object)JsonUtils.INSTANCE.jsonString(JsonUtils.INSTANCE.jsonStruct(jsonEntryArray)));
        pairArray[2] = TuplesKt.to((Object)GROUPS_WITH_35K, (Object)Companion.formatGroupsWith35K(stats.getGroupsOverLimit()));
        pairArray[3] = TuplesKt.to((Object)HISTOGRAM_GROUPS_BY_SIZE, (Object)this.gson.toJson(stats.getGroupSizesHistogram().toStringMap()));
        pairArray[4] = TuplesKt.to((Object)HISTOGRAM_USERS_BY_SIZE, (Object)this.gson.toJson(stats.getUserGroupsHistogram().toStringMap()));
        pairArray[5] = TuplesKt.to((Object)MAX_GROUPS_USER, (Object)String.valueOf(stats.getMaxUserGroups()));
        pairArray[6] = TuplesKt.to((Object)ALL_AGENTS, (Object)String.valueOf(stats.getAgentsCount()));
        pairArray[7] = TuplesKt.to((Object)ACTIVE_AGENTS, (Object)String.valueOf(stats.getActiveAgentsCount()));
        pairArray[8] = TuplesKt.to((Object)EMPTY_GROUPS, (Object)String.valueOf(stats.getEmptyGroupsCount()));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public boolean isQueryEnabled() {
        return GrQuery.DefaultImpls.isQueryEnabled(this);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)246L, (Object)44000), TuplesKt.to((Object)18743L, (Object)120000)};
        Map map = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)205), TuplesKt.to((Object)1, (Object)100), TuplesKt.to((Object)10, (Object)201), TuplesKt.to((Object)200, (Object)34), TuplesKt.to((Object)120000, (Object)2)};
        MembershipCountHistogram membershipCountHistogram = MembershipCountHistogram.Companion.fromCounts(MapsKt.mapOf((Pair[])pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)200), TuplesKt.to((Object)1, (Object)66), TuplesKt.to((Object)10, (Object)701), TuplesKt.to((Object)246, (Object)1201), TuplesKt.to((Object)643, (Object)2)};
        EXAMPLE = new MembershipStats(map, membershipCountHistogram, MembershipCountHistogram.Companion.fromCounts(MapsKt.mapOf((Pair[])pairArray)), 14567, 128956, 1543231, 120000, 643, 17020, 15678, 10);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/memberships/NestedGroupsQuery$Companion;", "", "()V", "ACTIVE_AGENTS", "", "ALL_AGENTS", "AVG_ANG_MAX_IN_GROUPS", "AVG_ANG_MAX_PER_USER", "EMPTY_GROUPS", "EXAMPLE", "Lcom/atlassian/jira/migration/guardrails/queries/memberships/MembershipStats;", "getEXAMPLE", "()Lcom/atlassian/jira/migration/guardrails/queries/memberships/MembershipStats;", "GROUPS_WITH_35K", "HISTOGRAM_GROUPS_BY_SIZE", "HISTOGRAM_USERS_BY_SIZE", "MAX_GROUPS_USER", "formatGroupsWith35K", "groupsOverLimit", "", "", "", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nNestedGroupsQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NestedGroupsQuery.kt\ncom/atlassian/jira/migration/guardrails/queries/memberships/NestedGroupsQuery$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1045#2:102\n*S KotlinDebug\n*F\n+ 1 NestedGroupsQuery.kt\ncom/atlassian/jira/migration/guardrails/queries/memberships/NestedGroupsQuery$Companion\n*L\n59#1:102\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MembershipStats getEXAMPLE() {
            return EXAMPLE;
        }

        @VisibleForTesting
        @NotNull
        public final String formatGroupsWith35K(@NotNull Map<Long, Integer> groupsOverLimit) {
            Intrinsics.checkNotNullParameter(groupsOverLimit, (String)"groupsOverLimit");
            Iterable $this$sortedBy$iv = groupsOverLimit.entrySet();
            boolean $i$f$sortedBy = false;
            List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Long)it.getKey();
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Long)it.getKey()));
                }
            });
            return JsonUtils.INSTANCE.jsonString(sorted, formatGroupsWith35K.1.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

