/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.queries.memberships;

import com.atlassian.jira.migration.guardrails.queries.memberships.MembershipCountHistogram;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J'\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\u0006H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006'"}, d2={"Lcom/atlassian/jira/migration/guardrails/queries/memberships/Users;", "", "activeWithoutLogin", "", "activeWithLogin", "userCount", "", "([J[JI)V", "getActiveWithLogin", "()[J", "getActiveWithoutLogin", "histogram", "Lcom/atlassian/jira/migration/guardrails/queries/memberships/MembershipCountHistogram;", "getHistogram", "()Lcom/atlassian/jira/migration/guardrails/queries/memberships/MembershipCountHistogram;", "maxGroups", "getMaxGroups", "()I", "setMaxGroups", "(I)V", "sumGroups", "getSumGroups", "setSumGroups", "getUserCount", "add", "", "userId", "", "count", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "jira-migration-plugin"})
public final class Users {
    @NotNull
    private final long[] activeWithoutLogin;
    @NotNull
    private final long[] activeWithLogin;
    private final int userCount;
    @NotNull
    private final MembershipCountHistogram histogram;
    private int maxGroups;
    private int sumGroups;

    public Users(@NotNull long[] activeWithoutLogin, @NotNull long[] activeWithLogin, int userCount) {
        Intrinsics.checkNotNullParameter((Object)activeWithoutLogin, (String)"activeWithoutLogin");
        Intrinsics.checkNotNullParameter((Object)activeWithLogin, (String)"activeWithLogin");
        this.activeWithoutLogin = activeWithoutLogin;
        this.activeWithLogin = activeWithLogin;
        this.userCount = userCount;
        this.histogram = new MembershipCountHistogram(null, 1, null);
        this.histogram.add(0, this.activeWithLogin.length);
    }

    @NotNull
    public final long[] getActiveWithoutLogin() {
        return this.activeWithoutLogin;
    }

    @NotNull
    public final long[] getActiveWithLogin() {
        return this.activeWithLogin;
    }

    public final int getUserCount() {
        return this.userCount;
    }

    @NotNull
    public final MembershipCountHistogram getHistogram() {
        return this.histogram;
    }

    public final int getMaxGroups() {
        return this.maxGroups;
    }

    public final void setMaxGroups(int n) {
        this.maxGroups = n;
    }

    public final int getSumGroups() {
        return this.sumGroups;
    }

    public final void setSumGroups(int n) {
        this.sumGroups = n;
    }

    public final void add(long userId, int count2) {
        this.sumGroups += count2;
        this.maxGroups = RangesKt.coerceAtLeast((int)this.maxGroups, (int)count2);
        if (ArraysKt.binarySearch$default((long[])this.activeWithLogin, (long)userId, (int)0, (int)0, (int)6, null) >= 0) {
            MembershipCountHistogram.add$default(this.histogram, count2, 0, 2, null);
            this.histogram.add(0, -1);
        }
    }

    @NotNull
    public final long[] component1() {
        return this.activeWithoutLogin;
    }

    @NotNull
    public final long[] component2() {
        return this.activeWithLogin;
    }

    public final int component3() {
        return this.userCount;
    }

    @NotNull
    public final Users copy(@NotNull long[] activeWithoutLogin, @NotNull long[] activeWithLogin, int userCount) {
        Intrinsics.checkNotNullParameter((Object)activeWithoutLogin, (String)"activeWithoutLogin");
        Intrinsics.checkNotNullParameter((Object)activeWithLogin, (String)"activeWithLogin");
        return new Users(activeWithoutLogin, activeWithLogin, userCount);
    }

    public static /* synthetic */ Users copy$default(Users users2, long[] lArray, long[] lArray2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            lArray = users2.activeWithoutLogin;
        }
        if ((n2 & 2) != 0) {
            lArray2 = users2.activeWithLogin;
        }
        if ((n2 & 4) != 0) {
            n = users2.userCount;
        }
        return users2.copy(lArray, lArray2, n);
    }

    @NotNull
    public String toString() {
        return "Users(activeWithoutLogin=" + Arrays.toString(this.activeWithoutLogin) + ", activeWithLogin=" + Arrays.toString(this.activeWithLogin) + ", userCount=" + this.userCount + ')';
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.activeWithoutLogin);
        result2 = result2 * 31 + Arrays.hashCode(this.activeWithLogin);
        result2 = result2 * 31 + Integer.hashCode(this.userCount);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Users)) {
            return false;
        }
        Users users2 = (Users)other;
        if (!Intrinsics.areEqual((Object)this.activeWithoutLogin, (Object)users2.activeWithoutLogin)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.activeWithLogin, (Object)users2.activeWithLogin)) {
            return false;
        }
        return this.userCount == users2.userCount;
    }
}

