/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingControl;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingItem;
import com.atlassian.jira.migration.guardrails.repository.AccessLogProcessingItemStatus;
import com.atlassian.jira.migration.guardrails.repository.InstAnalysisCtrl;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nJ%\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/guardrails/repository/AccessLogProcessingItemRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "createAccessLogProcessingItem", "Lcom/atlassian/jira/migration/guardrails/repository/AccessLogProcessingItem;", "accessLogProcCtrl", "Lcom/atlassian/jira/migration/guardrails/repository/AccessLogProcessingControl;", "processingDate", "Ljava/util/Date;", "findByAccessLogProcCtrl", "date", "findByInstAnalysysCtrlAndDate", "", "instAnalysisCtrl", "Lcom/atlassian/jira/migration/guardrails/repository/InstAnalysisCtrl;", "(Lcom/atlassian/jira/migration/guardrails/repository/InstAnalysisCtrl;Ljava/util/Date;)[Lcom/atlassian/jira/migration/guardrails/repository/AccessLogProcessingItem;", "updateAccessLogProcessingItem", "", "accessLogProcessingItem", "jira-migration-plugin"})
public final class AccessLogProcessingItemRepository {
    @NotNull
    private final ActiveObjects ao;

    @Inject
    public AccessLogProcessingItemRepository(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        this.ao = ao;
    }

    @NotNull
    public final AccessLogProcessingItem createAccessLogProcessingItem(@NotNull AccessLogProcessingControl accessLogProcCtrl, @NotNull Date processingDate) {
        Intrinsics.checkNotNullParameter((Object)accessLogProcCtrl, (String)"accessLogProcCtrl");
        Intrinsics.checkNotNullParameter((Object)processingDate, (String)"processingDate");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ACCESS_LOG_PROC_CTRL_ID", (Object)accessLogProcCtrl.getID()), TuplesKt.to((Object)"PROCESSING_DATE", (Object)processingDate), TuplesKt.to((Object)"STATUS", (Object)((Object)AccessLogProcessingItemStatus.SCHEDULED))};
        RawEntity rawEntity = this.ao.create(AccessLogProcessingItem.class, MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntity, (String)"create(...)");
        return (AccessLogProcessingItem)rawEntity;
    }

    public final void updateAccessLogProcessingItem(@NotNull AccessLogProcessingItem accessLogProcessingItem) {
        Intrinsics.checkNotNullParameter((Object)accessLogProcessingItem, (String)"accessLogProcessingItem");
        accessLogProcessingItem.save();
    }

    @Nullable
    public final AccessLogProcessingItem findByAccessLogProcCtrl(@NotNull AccessLogProcessingControl accessLogProcCtrl, @NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)accessLogProcCtrl, (String)"accessLogProcCtrl");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Object[] objectArray = new Object[]{accessLogProcCtrl.getID(), date};
        Query query = Query.select().where("ACCESS_LOG_PROC_CTRL_ID = ? AND PROCESSING_DATE = ?", objectArray);
        RawEntity[] rawEntityArray = this.ao.find(AccessLogProcessingItem.class, query);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (AccessLogProcessingItem)ArraysKt.firstOrNull((Object[])rawEntityArray);
    }

    @Nullable
    public final AccessLogProcessingItem[] findByInstAnalysysCtrlAndDate(@NotNull InstAnalysisCtrl instAnalysisCtrl, @NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)instAnalysisCtrl, (String)"instAnalysisCtrl");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Object[] objectArray = new Object[]{instAnalysisCtrl.getID(), date};
        Query query = Query.select().alias(AccessLogProcessingItem.class, "ITEM").join(AccessLogProcessingControl.class, "ITEM.ACCESS_LOG_PROC_CTRL_ID = CTRL.ID").alias(AccessLogProcessingControl.class, "CTRL").where("CTRL.INST_ANALYSIS_CTRL_ID = ? AND ITEM.PROCESSING_DATE = ?", objectArray).order("CTRL.NODE");
        return (AccessLogProcessingItem[])this.ao.find(AccessLogProcessingItem.class, query);
    }
}

