/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.repository;

import com.atlassian.jira.migration.guardrails.apiUsage.ApiUsageKey;
import com.atlassian.jira.migration.guardrails.model.ApiUsageDto;
import com.atlassian.jira.migration.guardrails.model.ApiUsageDtoKt;
import com.atlassian.jira.migration.guardrails.repository.ApiUsageTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.ProjectableSQLQuery;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\u0013J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0006\u0010\u001b\u001a\u00020\u0006J\u0006\u0010\u001c\u001a\u00020\u0006J\u0006\u0010\u001d\u001a\u00020\u0006J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0006\u0010%\u001a\u00020&J\u0014\u0010'\u001a\u00020&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0)R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/atlassian/jira/migration/guardrails/repository/ApiUsageRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "calculateMaxChunkSize", "", "paramsPerRow", "clientSideFiltering", "", "Lcom/atlassian/jira/migration/guardrails/model/ApiUsageDto;", "superfluousElements", "expectedKeys", "", "Lcom/atlassian/jira/migration/guardrails/apiUsage/ApiUsageKey;", "createAll", "date", "Ljava/util/Date;", "newOnes", "", "", "dtoMapper", "it", "Lcom/querydsl/core/Tuple;", "findAll", "findByKeys", "toBeFound", "getCount", "getMaxId", "getMinId", "getPage", "minId", "maxId", "selectBase", "Lcom/querydsl/sql/SQLQuery;", "db", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseConnection;", "truncate", "", "updateCounts", "apiUsageDtos", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nApiUsageRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiUsageRepository.kt\ncom/atlassian/jira/migration/guardrails/repository/ApiUsageRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,221:1\n766#2:222\n857#2,2:223\n1360#2:227\n1446#2,2:228\n1549#2:230\n1620#2,3:231\n1549#2:234\n1620#2,3:235\n1448#2,3:238\n1549#2:241\n1620#2,3:242\n1549#2:245\n1620#2,3:246\n1855#2:249\n1855#2,2:250\n1856#2:252\n1855#2:253\n1855#2,2:254\n1856#2:256\n37#3,2:225\n*S KotlinDebug\n*F\n+ 1 ApiUsageRepository.kt\ncom/atlassian/jira/migration/guardrails/repository/ApiUsageRepository\n*L\n136#1:222\n136#1:223,2\n117#1:227\n117#1:228,2\n120#1:230\n120#1:231,3\n121#1:234\n121#1:235,3\n117#1:238,3\n160#1:241\n160#1:242,3\n167#1:245\n167#1:246,3\n193#1:249\n195#1:250,2\n193#1:252\n211#1:253\n213#1:254,2\n211#1:256\n143#1:225,2\n*E\n"})
public final class ApiUsageRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private static final ApiUsageTable TABLE = new ApiUsageTable(null, 1, null);

    @Inject
    public ApiUsageRepository(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    public final void truncate() {
        this.databaseAccessor.run(ApiUsageRepository::truncate$lambda$0, OnRollback.NOOP);
    }

    @NotNull
    public final List<ApiUsageDto> findByKeys(@NotNull Date date, @NotNull Set<ApiUsageKey> toBeFound) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter(toBeFound, (String)"toBeFound");
        List superfluousElements = (List)this.databaseAccessor.run(arg_0 -> ApiUsageRepository.findByKeys$lambda$3(toBeFound, this, date, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNull((Object)superfluousElements);
        return this.clientSideFiltering(superfluousElements, toBeFound);
    }

    private final int calculateMaxChunkSize(int paramsPerRow) {
        return (int)Math.ceil(2100.0 / (double)paramsPerRow);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ApiUsageDto> clientSideFiltering(List<ApiUsageDto> superfluousElements, Set<ApiUsageKey> expectedKeys) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = superfluousElements;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ApiUsageDto apiUsage = (ApiUsageDto)element$iv$iv;
            boolean bl = false;
            if (!expectedKeys.contains(ApiUsageDtoKt.toKey(apiUsage))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final SQLQuery<Tuple> selectBase(DatabaseConnection db) {
        List list = TABLE.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Path[] pathArray = thisCollection$iv.toArray(new Path[0]);
        ProjectableSQLQuery projectableSQLQuery = db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)TABLE);
        Intrinsics.checkNotNullExpressionValue((Object)projectableSQLQuery, (String)"from(...)");
        return (SQLQuery)projectableSQLQuery;
    }

    private final ApiUsageDto dtoMapper(Tuple it) {
        Object object = it.get((Expression)TABLE.getID());
        Intrinsics.checkNotNull((Object)object);
        int n = ((Number)object).intValue();
        Object object2 = it.get((Expression)TABLE.getDATE());
        Intrinsics.checkNotNull((Object)object2);
        Date date = (Date)object2;
        String string = (String)it.get((Expression)TABLE.getUSERNAME_HASH());
        Object object3 = it.get((Expression)TABLE.getAPI_TYPE());
        Intrinsics.checkNotNull((Object)object3);
        String string2 = (String)object3;
        Object object4 = it.get((Expression)TABLE.getHTTP_METHOD());
        Intrinsics.checkNotNull((Object)object4);
        String string3 = (String)object4;
        Object object5 = it.get((Expression)TABLE.getREFERRER_TYPE());
        Intrinsics.checkNotNull((Object)object5);
        String string4 = (String)object5;
        Object object6 = it.get((Expression)TABLE.getUSER_AGENT_TYPE());
        Intrinsics.checkNotNull((Object)object6);
        String string5 = (String)object6;
        Object object7 = new Gson().fromJson((String)it.get((Expression)TABLE.getPROJECT_IDS_JSON()), (TypeToken)new TypeToken<List<? extends Long>>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"fromJson(...)");
        List list = (List)object7;
        Object object8 = it.get((Expression)TABLE.getCOUNT());
        Intrinsics.checkNotNull((Object)object8);
        return new ApiUsageDto(n, date, string, string2, string3, string4, string5, list, ((Number)object8).longValue());
    }

    @NotNull
    public final List<ApiUsageDto> findAll() {
        Object object = this.databaseAccessor.run(arg_0 -> ApiUsageRepository.findAll$lambda$6(this, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    @NotNull
    public final List<ApiUsageDto> getPage(int minId, int maxId) {
        Object object = this.databaseAccessor.run(arg_0 -> ApiUsageRepository.getPage$lambda$8(this, minId, maxId, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    public final int getMinId() {
        Object object = this.databaseAccessor.run(ApiUsageRepository::getMinId$lambda$9, OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return ((Number)object).intValue();
    }

    public final int getMaxId() {
        Object object = this.databaseAccessor.run(ApiUsageRepository::getMaxId$lambda$10, OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return ((Number)object).intValue();
    }

    public final int getCount() {
        Object object = this.databaseAccessor.run(ApiUsageRepository::getCount$lambda$11, OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return ((Number)object).intValue();
    }

    @NotNull
    public final List<ApiUsageDto> createAll(@NotNull Date date, @NotNull Map<ApiUsageKey, Long> newOnes) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter(newOnes, (String)"newOnes");
        this.databaseAccessor.run(arg_0 -> ApiUsageRepository.createAll$lambda$14(date, newOnes, this, arg_0), OnRollback.NOOP);
        return this.findByKeys(date, newOnes.keySet());
    }

    public final void updateCounts(@NotNull Collection<ApiUsageDto> apiUsageDtos) {
        Intrinsics.checkNotNullParameter(apiUsageDtos, (String)"apiUsageDtos");
        this.databaseAccessor.run(arg_0 -> ApiUsageRepository.updateCounts$lambda$17(apiUsageDtos, this, arg_0), OnRollback.NOOP);
    }

    private static final Long truncate$lambda$0(DatabaseConnection db) {
        return db.delete((RelationalPath)TABLE).execute();
    }

    /*
     * WARNING - void declaration
     */
    private static final List findByKeys$lambda$3(Set $toBeFound, ApiUsageRepository this$0, Date $date, DatabaseConnection db) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$toBeFound, (String)"$toBeFound");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$date, (String)"$date");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)$toBeFound, (int)499);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Collection<Long> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            List chunk = (List)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)db);
            Iterable iterable2 = chunk;
            NumberPath<Long> numberPath = TABLE.getLOOKUP_HASH();
            BooleanExpression booleanExpression = TABLE.getDATE().eq((Object)Timestamp.from($date.toInstant()));
            Object object = this$0.selectBase(db);
            boolean $i$f$map22 = false;
            void var18_20 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                ApiUsageKey apiUsageKey = (ApiUsageKey)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(Long.valueOf(it.hashCode()));
            }
            collection = (List)destination$iv$iv2;
            Iterable iterable3 = ((SQLQuery)object.where((Predicate)booleanExpression.and((Predicate)numberPath.in((Collection)collection)))).fetch();
            Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"fetch(...)");
            iterable3 = iterable3;
            boolean $i$f$map = false;
            void $i$f$map22 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Object item$iv$iv2;
                item$iv$iv2 = (Tuple)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl3 = false;
                object.add((ApiUsageDto)this$0.dtoMapper((Tuple)p0));
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List findAll$lambda$6(ApiUsageRepository this$0, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)db);
        List list = ((SQLQuery)this$0.selectBase(db).orderBy(TABLE.getDATE().asc())).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.dtoMapper((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getPage$lambda$8(ApiUsageRepository this$0, int $minId, int $maxId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)db);
        List list = ((SQLQuery)((SQLQuery)this$0.selectBase(db).where((Predicate)TABLE.getID().goe((Number)$minId).and((Predicate)TABLE.getID().lt((Number)$maxId)))).orderBy(TABLE.getID().asc())).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.dtoMapper((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final Integer getMinId$lambda$9(DatabaseConnection db) {
        Integer n = (Integer)((SQLQuery)db.select((Expression)TABLE.getID().min()).from((Expression)TABLE)).fetchFirst();
        return n == null ? 0 : n;
    }

    private static final Integer getMaxId$lambda$10(DatabaseConnection db) {
        Integer n = (Integer)((SQLQuery)db.select((Expression)TABLE.getID().max()).from((Expression)TABLE)).fetchFirst();
        return n == null ? 0 : n;
    }

    private static final Integer getCount$lambda$11(DatabaseConnection db) {
        return (int)((Number)((SQLQuery)db.select((Expression)TABLE.getID().count()).from((Expression)TABLE)).fetchFirst()).longValue();
    }

    private static final Unit createAll$lambda$14(Date $date, Map $newOnes, ApiUsageRepository this$0, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$date, (String)"$date");
        Intrinsics.checkNotNullParameter((Object)$newOnes, (String)"$newOnes");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Timestamp timestamp = Timestamp.from($date.toInstant());
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)$newOnes.entrySet(), (int)this$0.calculateMaxChunkSize(TABLE.getColumns().size()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List chunk = (List)element$iv;
            boolean bl = false;
            SQLInsertClause sqlInsertClause = db.insert((RelationalPath)TABLE);
            Iterable $this$forEach$iv2 = chunk;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Map.Entry entry = (Map.Entry)element$iv2;
                boolean bl2 = false;
                ApiUsageKey key = (ApiUsageKey)entry.getKey();
                long count2 = ((Number)entry.getValue()).longValue();
                sqlInsertClause.set((Path)TABLE.getDATE(), (Object)timestamp).set((Path)TABLE.getUSERNAME_HASH(), (Object)key.getUsernameHash()).set((Path)TABLE.getAPI_TYPE(), (Object)key.getApiType().name()).set((Path)TABLE.getHTTP_METHOD(), (Object)key.getHttpMethod().name()).set((Path)TABLE.getREFERRER_TYPE(), (Object)key.getReferrerType().name()).set((Path)TABLE.getUSER_AGENT_TYPE(), (Object)key.getUserAgentType().name()).set((Path)TABLE.getPROJECT_IDS_JSON(), (Object)key.getProjectIdsJson()).set((Path)TABLE.getCOUNT(), (Object)count2).set((Path)TABLE.getLOOKUP_HASH(), (Object)key.hashCode()).addBatch();
            }
            sqlInsertClause.execute();
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateCounts$lambda$17(Collection $apiUsageDtos, ApiUsageRepository this$0, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$apiUsageDtos, (String)"$apiUsageDtos");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)$apiUsageDtos, (int)this$0.calculateMaxChunkSize(2));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List chunk = (List)element$iv;
            boolean bl = false;
            SQLUpdateClause sqlUpdateClause = db.update((RelationalPath)TABLE);
            Iterable $this$forEach$iv2 = chunk;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ApiUsageDto apiUsageDto = (ApiUsageDto)element$iv2;
                boolean bl2 = false;
                sqlUpdateClause.set((Path)TABLE.getCOUNT(), (Object)apiUsageDto.getCount()).where((Predicate)TABLE.getID().eq((Object)apiUsageDto.getId())).addBatch();
            }
            sqlUpdateClause.execute();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/guardrails/repository/ApiUsageRepository$Companion;", "", "()V", "TABLE", "Lcom/atlassian/jira/migration/guardrails/repository/ApiUsageTable;", "getTABLE", "()Lcom/atlassian/jira/migration/guardrails/repository/ApiUsageTable;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ApiUsageTable getTABLE() {
            return TABLE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

