/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.guardrails.model.BrowserMetricsDto;
import com.atlassian.jira.migration.guardrails.repository.BrowserMetrics;
import com.atlassian.jira.user.ApplicationUser;
import com.google.gson.Gson;
import java.time.Clock;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/guardrails/repository/BrowserMetricsRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "clock", "Ljava/time/Clock;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;Ljava/time/Clock;)V", "gson", "Lcom/google/gson/Gson;", "createBrowserMetrics", "Lcom/atlassian/jira/migration/guardrails/repository/BrowserMetrics;", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "browserMetricsDto", "Lcom/atlassian/jira/migration/guardrails/model/BrowserMetricsDto;", "deleteStaleMetrics", "", "findAll", "", "findMostRecent", "getCount", "", "getPage", "pageSize", "offSet", "Companion", "jira-migration-plugin"})
public final class BrowserMetricsRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActiveObjects ao;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Gson gson;
    @NotNull
    private static final Logger log;
    private static final long MAX_METRICS_AGE;
    private static final long TWENTY_FOUR_HOURS_PERIOD;

    @Inject
    public BrowserMetricsRepository(@NotNull ActiveObjects ao, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.ao = ao;
        this.clock = clock;
        this.gson = new Gson();
    }

    @NotNull
    public final BrowserMetrics createBrowserMetrics(@NotNull ApplicationUser user, @NotNull BrowserMetricsDto browserMetricsDto) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)browserMetricsDto, (String)"browserMetricsDto");
        log.info("Saving browser-metrics into the database.");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"CREATED_AT", (Object)this.clock.millis()), TuplesKt.to((Object)"USER_KEY", (Object)user.getKey()), TuplesKt.to((Object)"METRICS_JSON", (Object)this.gson.toJson((Object)browserMetricsDto))};
        RawEntity rawEntity = this.ao.create(BrowserMetrics.class, MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntity, (String)"create(...)");
        return (BrowserMetrics)rawEntity;
    }

    @Nullable
    public final BrowserMetrics findMostRecent(@NotNull ApplicationUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Object[] objectArray = new Object[]{user.getKey(), this.clock.millis() - TWENTY_FOUR_HOURS_PERIOD};
        RawEntity[] rawEntityArray = this.ao.find(BrowserMetrics.class, Query.select().where("USER_KEY = ? and CREATED_AT >= ?", objectArray).order("CREATED_AT DESC").limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (BrowserMetrics)SequencesKt.firstOrNull((Sequence)ArraysKt.asSequence((Object[])rawEntityArray));
    }

    @NotNull
    public final List<BrowserMetrics> findAll() {
        RawEntity[] rawEntityArray = this.ao.find(BrowserMetrics.class);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return ArraysKt.toList((Object[])rawEntityArray);
    }

    @NotNull
    public final List<BrowserMetrics> getPage(int pageSize, int offSet) {
        RawEntity[] rawEntityArray = this.ao.find(BrowserMetrics.class, Query.select().order("CREATED_AT DESC").limit(pageSize).offset(offSet));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return ArraysKt.toList((Object[])rawEntityArray);
    }

    public final int getCount() {
        return this.ao.count(BrowserMetrics.class);
    }

    public final void deleteStaleMetrics() {
        Object[] objectArray = new Object[]{this.clock.millis() - MAX_METRICS_AGE};
        int rowsDeleted = this.ao.deleteWithSQL(BrowserMetrics.class, "CREATED_AT < ?", objectArray);
        log.info("Deleted " + rowsDeleted + " stale browser metrics rows.");
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(BrowserMetricsRepository.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
        MAX_METRICS_AGE = TimeUnit.DAYS.toMillis(14L);
        TWENTY_FOUR_HOURS_PERIOD = TimeUnit.HOURS.toMillis(24L);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/guardrails/repository/BrowserMetricsRepository$Companion;", "", "()V", "MAX_METRICS_AGE", "", "TWENTY_FOUR_HOURS_PERIOD", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

