/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.guardrails.ClusterNodeInfrastructureDto;
import com.atlassian.jira.migration.guardrails.repository.ClusterNodeInfrastructure;
import com.atlassian.jira.migration.guardrails.repository.ClusterNodeNetwork;
import com.atlassian.jira.migration.guardrails.repository.NetworkInfoDto;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0011\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/guardrails/repository/ClusterNodeInfrastructureRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "delete", "", "node", "Lcom/atlassian/jira/migration/guardrails/repository/ClusterNodeInfrastructure;", "findAll", "", "()[Lcom/atlassian/jira/migration/guardrails/repository/ClusterNodeInfrastructure;", "findAllNetworkInterfaces", "", "Lcom/atlassian/jira/migration/guardrails/repository/ClusterNodeNetwork;", "nodeId", "", "findByNodeId", "saveClusterNodeInfrastructureItem", "Lcom/atlassian/jira/migration/guardrails/ClusterNodeInfrastructureDto;", "saveClusterNodeNetworkItem", "nodeInfrastructure", "network", "Lcom/atlassian/jira/migration/guardrails/repository/NetworkInfoDto;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nClusterNodeInfrastructureRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClusterNodeInfrastructureRepository.kt\ncom/atlassian/jira/migration/guardrails/repository/ClusterNodeInfrastructureRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,144:1\n1#2:145\n1855#3,2:146\n37#4,2:148\n*S KotlinDebug\n*F\n+ 1 ClusterNodeInfrastructureRepository.kt\ncom/atlassian/jira/migration/guardrails/repository/ClusterNodeInfrastructureRepository\n*L\n99#1:146,2\n131#1:148,2\n*E\n"})
public final class ClusterNodeInfrastructureRepository {
    @NotNull
    private final ActiveObjects ao;

    @Inject
    public ClusterNodeInfrastructureRepository(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        this.ao = ao;
    }

    @NotNull
    public final ClusterNodeInfrastructure saveClusterNodeInfrastructureItem(@NotNull ClusterNodeInfrastructureDto node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ClusterNodeInfrastructure clusterNodeInfrastructure = this.findByNodeId(node.getNodeId());
        if (clusterNodeInfrastructure != null) {
            ClusterNodeInfrastructure p0 = clusterNodeInfrastructure;
            boolean bl = false;
            this.delete(p0);
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"NODE_ID", (Object)node.getNodeId()), TuplesKt.to((Object)"OPERATING_SYSTEM", (Object)node.getOperatingSystem()), TuplesKt.to((Object)"CPU_COUNT", (Object)node.getCpuCount()), TuplesKt.to((Object)"RAM_MB", (Object)node.getRamMb()), TuplesKt.to((Object)"STORAGE_USED_MB", (Object)node.getStorageUsedMb()), TuplesKt.to((Object)"STORAGE_AVAILABLE_MB", (Object)node.getStorageAvailableMb()), TuplesKt.to((Object)"LAST_UPDATED", (Object)Timestamp.from(Instant.now()))};
        ClusterNodeInfrastructure infrastructure = (ClusterNodeInfrastructure)this.ao.create(ClusterNodeInfrastructure.class, MapsKt.mapOf((Pair[])pairArray));
        List<NetworkInfoDto> list = node.getNetworkInterfaces();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NetworkInfoDto it = (NetworkInfoDto)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)infrastructure);
                this.saveClusterNodeNetworkItem(infrastructure, it);
            }
        }
        Intrinsics.checkNotNull((Object)infrastructure);
        return infrastructure;
    }

    private final void saveClusterNodeNetworkItem(ClusterNodeInfrastructure nodeInfrastructure, NetworkInfoDto network) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"NODE_ID", (Object)nodeInfrastructure.getNodeId()), TuplesKt.to((Object)"NAME", (Object)network.getName()), TuplesKt.to((Object)"MTU_BPS", (Object)network.getMtuBps()), TuplesKt.to((Object)"MAX_SPEED_MBS", (Object)network.getMaxSpeedMbs()), TuplesKt.to((Object)"IN_ERRORS_PERCENT", (Object)network.getInErrorsPercent()), TuplesKt.to((Object)"OUT_ERRORS_PERCENT", (Object)network.getOutErrorsPercent()), TuplesKt.to((Object)"INFRASTRUCTURE_ID", (Object)nodeInfrastructure)};
        this.ao.create(ClusterNodeNetwork.class, MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public final ClusterNodeInfrastructure[] findAll() {
        RawEntity[] rawEntityArray = this.ao.find(ClusterNodeInfrastructure.class);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (ClusterNodeInfrastructure[])rawEntityArray;
    }

    @Nullable
    public final ClusterNodeInfrastructure findByNodeId(@NotNull String nodeId) {
        Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
        Object[] objectArray = new Object[]{nodeId};
        Object[] nodes = (ClusterNodeInfrastructure[])this.ao.find(ClusterNodeInfrastructure.class, Query.select().where("NODE_ID = ?", objectArray));
        Intrinsics.checkNotNull((Object)nodes);
        Collection $this$toTypedArray$iv = ArraysKt.drop((Object[])nodes, (int)1);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new ClusterNodeInfrastructure[0]);
        this.ao.delete((RawEntity[])Arrays.copyOf(objectArray, objectArray.length));
        return (ClusterNodeInfrastructure)ArraysKt.firstOrNull((Object[])nodes);
    }

    @NotNull
    public final List<ClusterNodeNetwork> findAllNetworkInterfaces(@NotNull String nodeId) {
        Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
        Object object = this.findByNodeId(nodeId);
        if (object == null || (object = object.getNetworkInterfaces()) == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final void delete(@NotNull ClusterNodeInfrastructure node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ClusterNodeNetwork[] clusterNodeNetworkArray = node.getNetworkInterfaces();
        this.ao.delete((RawEntity[])Arrays.copyOf(clusterNodeNetworkArray, clusterNodeNetworkArray.length));
        clusterNodeNetworkArray = new RawEntity[]{node};
        this.ao.delete((RawEntity[])clusterNodeNetworkArray);
    }
}

