/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.guardrails.model.DailyUsageMetricsDto;
import com.atlassian.jira.migration.guardrails.repository.DailyUsageMetrics;
import com.atlassian.jira.migration.guardrails.repository.DailyUsageMetricsFileRecord;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/guardrails/repository/DailyUsageMetricsRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "formatter", "Ljava/time/format/DateTimeFormatter;", "getFormatter", "()Ljava/time/format/DateTimeFormatter;", "findDailyUsageMetrics", "", "Lcom/atlassian/jira/migration/guardrails/repository/DailyUsageMetrics;", "metricsDate", "Ljava/util/Date;", "instAnalysisCtrlId", "", "(Ljava/util/Date;I)[Lcom/atlassian/jira/migration/guardrails/repository/DailyUsageMetrics;", "findDailyUsageMetricsForCSV", "", "Lcom/atlassian/jira/migration/guardrails/repository/DailyUsageMetricsFileRecord;", "saveDailyUsageMetrics", "dailyUsageMetricDto", "Lcom/atlassian/jira/migration/guardrails/model/DailyUsageMetricsDto;", "updateDailyUsageMetrics", "dailyUsageMetricsDto", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDailyUsageMetricsRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DailyUsageMetricsRepository.kt\ncom/atlassian/jira/migration/guardrails/repository/DailyUsageMetricsRepository\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,153:1\n37#2,2:154\n6152#3,2:156\n11065#3:158\n11400#3,3:159\n*S KotlinDebug\n*F\n+ 1 DailyUsageMetricsRepository.kt\ncom/atlassian/jira/migration/guardrails/repository/DailyUsageMetricsRepository\n*L\n133#1:154,2\n134#1:156,2\n139#1:158\n139#1:159,3\n*E\n"})
public final class DailyUsageMetricsRepository {
    @NotNull
    private final ActiveObjects ao;
    @NotNull
    private final DateTimeFormatter formatter;

    @Inject
    public DailyUsageMetricsRepository(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        this.ao = ao;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        this.formatter = dateTimeFormatter;
    }

    @NotNull
    public final DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    @Nullable
    public final DailyUsageMetrics saveDailyUsageMetrics(@NotNull DailyUsageMetricsDto dailyUsageMetricDto) {
        DailyUsageMetrics dailyUsageMetrics;
        Intrinsics.checkNotNullParameter((Object)dailyUsageMetricDto, (String)"dailyUsageMetricDto");
        if (dailyUsageMetricDto.getId() != null) {
            dailyUsageMetrics = this.updateDailyUsageMetrics(dailyUsageMetricDto);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"INST_ANALYSIS_CTRL_ID", (Object)dailyUsageMetricDto.getInstAnalysisCtrlId()), TuplesKt.to((Object)"METRICS_DATE", (Object)dailyUsageMetricDto.getMetricsDate()), TuplesKt.to((Object)"DAILY_ACTIVE_USERS", (Object)dailyUsageMetricDto.getDailyActiveUsers()), TuplesKt.to((Object)"PEAK_HOURLY_USERS_BY_DAY", (Object)dailyUsageMetricDto.getPeakHourlyUsersByDay()), TuplesKt.to((Object)"PEAK_HOURLY_REQUESTS_BY_DAY", (Object)dailyUsageMetricDto.getPeakHourlyRequestsByDay()), TuplesKt.to((Object)"NODES_PROCESSING_JSON", (Object)dailyUsageMetricDto.getNodesProcessingJson())};
            dailyUsageMetrics = (DailyUsageMetrics)this.ao.create(DailyUsageMetrics.class, MapsKt.mapOf((Pair[])pairArray));
        }
        DailyUsageMetrics dailyUsageMetrics2 = dailyUsageMetrics;
        return dailyUsageMetrics2;
    }

    private final DailyUsageMetrics updateDailyUsageMetrics(DailyUsageMetricsDto dailyUsageMetricsDto) {
        DailyUsageMetrics persistedEntity;
        DailyUsageMetrics dailyUsageMetrics;
        Object[] objectArray = new Object[]{dailyUsageMetricsDto.getId()};
        RawEntity[] rawEntityArray = this.ao.find(DailyUsageMetrics.class, "ID = ?", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        DailyUsageMetrics $this$updateDailyUsageMetrics_u24lambda_u240 = dailyUsageMetrics = (persistedEntity = (DailyUsageMetrics)ArraysKt.first((Object[])rawEntityArray));
        boolean bl = false;
        $this$updateDailyUsageMetrics_u24lambda_u240.setDailyActiveUsers(dailyUsageMetricsDto.getDailyActiveUsers());
        $this$updateDailyUsageMetrics_u24lambda_u240.setPeakHourlyUsersByDay(dailyUsageMetricsDto.getPeakHourlyUsersByDay());
        $this$updateDailyUsageMetrics_u24lambda_u240.setPeakHourlyRequestsByDay(dailyUsageMetricsDto.getPeakHourlyRequestsByDay());
        $this$updateDailyUsageMetrics_u24lambda_u240.setNodesProcessingJson(dailyUsageMetricsDto.getNodesProcessingJson());
        persistedEntity.save();
        Intrinsics.checkNotNull((Object)persistedEntity);
        return persistedEntity;
    }

    @Nullable
    public final DailyUsageMetrics[] findDailyUsageMetrics(@Nullable Date metricsDate, int instAnalysisCtrlId) {
        StringBuilder query = new StringBuilder("INST_ANALYSIS_CTRL_ID = ?");
        Object[] objectArray = new Object[]{instAnalysisCtrlId};
        List params = CollectionsKt.mutableListOf((Object[])objectArray);
        if (metricsDate != null) {
            query.append(" AND METRICS_DATE = ?");
            params.add(metricsDate);
        }
        Collection $this$toTypedArray$iv = params;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
        Object[] result2 = (DailyUsageMetrics[])this.ao.find(DailyUsageMetrics.class, query.toString(), Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNull((Object)result2);
        Object[] $this$sortByDescending$iv = result2;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.length > 1) {
            ArraysKt.sortWith((Object[])$this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DailyUsageMetrics it = (DailyUsageMetrics)b;
                    boolean bl = false;
                    Comparable comparable = it.getMetricsDate();
                    it = (DailyUsageMetrics)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getMetricsDate());
                }
            });
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DailyUsageMetricsFileRecord> findDailyUsageMetricsForCSV(int instAnalysisCtrlId) {
        List list;
        DailyUsageMetrics[] dailyUsageMetricsArray = this.findDailyUsageMetrics(null, instAnalysisCtrlId);
        if (dailyUsageMetricsArray != null) {
            void $this$mapTo$iv$iv;
            DailyUsageMetrics[] $this$map$iv = dailyUsageMetricsArray;
            boolean $i$f$map = false;
            DailyUsageMetrics[] dailyUsageMetricsArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = this.formatter.format(it.getMetricsDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                collection.add(new DailyUsageMetricsFileRecord(string, it.getDailyActiveUsers(), it.getPeakHourlyUsersByDay(), it.getPeakHourlyRequestsByDay(), it.getNodesProcessingJson(), null, null, 96, null));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

