/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.exception.NotFoundException;
import com.atlassian.jira.migration.guardrails.repository.GrResponseGroup;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\b\u0010\r\u001a\u0004\u0018\u00010\nJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/guardrails/repository/GrResponseGroupRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "completeResponseGroup", "", "jobId", "", "createResponseGroup", "Lcom/atlassian/jira/migration/guardrails/repository/GrResponseGroup;", "nodeId", "configJson", "findLatestResponseGroup", "findResponseGroup", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nGrResponseGroupRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrResponseGroupRepository.kt\ncom/atlassian/jira/migration/guardrails/repository/GrResponseGroupRepository\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,68:1\n13896#2,14:69\n*S KotlinDebug\n*F\n+ 1 GrResponseGroupRepository.kt\ncom/atlassian/jira/migration/guardrails/repository/GrResponseGroupRepository\n*L\n65#1:69,14\n*E\n"})
public final class GrResponseGroupRepository {
    @NotNull
    private final ActiveObjects ao;

    @Inject
    public GrResponseGroupRepository(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        this.ao = ao;
    }

    @NotNull
    public final GrResponseGroup createResponseGroup(@NotNull String jobId, @NotNull String nodeId, @NotNull String configJson) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
        Intrinsics.checkNotNullParameter((Object)configJson, (String)"configJson");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"JOB_ID", (Object)jobId), TuplesKt.to((Object)"NODE_ID", (Object)nodeId), TuplesKt.to((Object)"START_TIMESTAMP", (Object)System.currentTimeMillis()), TuplesKt.to((Object)"CONFIG_JSON", (Object)configJson)};
        RawEntity rawEntity = this.ao.create(GrResponseGroup.class, MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntity, (String)"create(...)");
        return (GrResponseGroup)rawEntity;
    }

    public final void completeResponseGroup(@NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        GrResponseGroup grResponseGroup = this.findResponseGroup(jobId);
        if (grResponseGroup == null) {
            throw new NotFoundException();
        }
        GrResponseGroup responseGroup = grResponseGroup;
        responseGroup.setEndTimestamp(System.currentTimeMillis());
        responseGroup.save();
    }

    private final GrResponseGroup findResponseGroup(String jobId) {
        Object[] objectArray = new Object[]{jobId};
        RawEntity[] rawEntityArray = this.ao.find(GrResponseGroup.class, "JOB_ID = ? ", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (GrResponseGroup)ArraysKt.firstOrNull((Object[])rawEntityArray);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final GrResponseGroup findLatestResponseGroup() {
        Object object;
        RawEntity[] rawEntityArray = this.ao.find(GrResponseGroup.class);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] $this$maxByOrNull$iv = rawEntityArray;
        boolean $i$f$maxByOrNull = false;
        if ($this$maxByOrNull$iv.length == 0) {
            object = null;
        } else {
            Object maxElem$iv = $this$maxByOrNull$iv[0];
            int lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$maxByOrNull$iv);
            if (lastIndex$iv == 0) {
                object = maxElem$iv;
            } else {
                void var3_3;
                GrResponseGroup grResponseGroup = (GrResponseGroup)maxElem$iv;
                boolean bl = false;
                long maxValue$iv = grResponseGroup.getStartTimestamp();
                IntIterator intIterator = new IntRange(1, lastIndex$iv).iterator();
                while (intIterator.hasNext()) {
                    int i$iv = intIterator.nextInt();
                    Object e$iv = $this$maxByOrNull$iv[i$iv];
                    GrResponseGroup grResponseGroup2 = (GrResponseGroup)e$iv;
                    $i$a$-maxByOrNull-GrResponseGroupRepository$findLatestResponseGroup$1 = false;
                    long v$iv = grResponseGroup2.getStartTimestamp();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                }
                object = var3_3;
            }
        }
        return (GrResponseGroup)object;
    }
}

