/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.guardrails.repository.AppResponseFileRecord;
import com.atlassian.jira.migration.guardrails.repository.GuardrailsResponse;
import com.atlassian.jira.migration.guardrails.repository.GuardrailsResponseFileRecord;
import com.atlassian.jira.migration.guardrails.repository.GuardrailsResponseRepository;
import com.atlassian.jira.migration.guardrails.repository.JESATResponseFileRecord;
import com.atlassian.jira.migration.guardrails.repository.QueryAssessmentDto;
import com.atlassian.jira.migration.guardrails.repository.ResponseType;
import com.atlassian.jira.migration.guardrails.repository.SeparateFileResponseRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\b\u001a\u00020\tJ\u001b\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\b\u001a\u00020\tJ\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007J\u001b\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ+\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fH\u0002\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\f2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/guardrails/repository/GuardrailsResponseRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "findApplicableAppResponses", "", "Lcom/atlassian/jira/migration/guardrails/repository/GuardrailsResponse;", "jobId", "", "(Ljava/lang/String;)[Lcom/atlassian/jira/migration/guardrails/repository/GuardrailsResponse;", "findApplicableAppResponsesForCsv", "", "Lcom/atlassian/jira/migration/guardrails/repository/AppResponseFileRecord;", "findApplicableGuardrailsResponses", "findApplicableJESATResponses", "findGuardrailsResponsesForCSV", "Lcom/atlassian/jira/migration/guardrails/repository/GuardrailsResponseFileRecord;", "findJESATResponsesForCSV", "Lcom/atlassian/jira/migration/guardrails/repository/JESATResponseFileRecord;", "findLatestResponse", "findResponses", "guardRailsResponseTypes", "Lcom/atlassian/jira/migration/guardrails/repository/ResponseType;", "(Ljava/lang/String;Ljava/util/List;)[Lcom/atlassian/jira/migration/guardrails/repository/GuardrailsResponse;", "findSeparateFileResponses", "Lcom/atlassian/jira/migration/guardrails/repository/SeparateFileResponseRecord;", "recordAssessmentDto", "queryAssessmentDto", "Lcom/atlassian/jira/migration/guardrails/repository/QueryAssessmentDto;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nGuardrailsResponseRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuardrailsResponseRepository.kt\ncom/atlassian/jira/migration/guardrails/repository/GuardrailsResponseRepository\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,277:1\n11065#2:278\n11400#2,3:279\n11065#2:282\n11400#2,3:283\n11065#2:286\n11400#2,3:287\n11065#2:290\n11400#2,3:291\n*S KotlinDebug\n*F\n+ 1 GuardrailsResponseRepository.kt\ncom/atlassian/jira/migration/guardrails/repository/GuardrailsResponseRepository\n*L\n204#1:278\n204#1:279,3\n227#1:282\n227#1:283,3\n246#1:286\n246#1:287,3\n262#1:290\n262#1:291,3\n*E\n"})
public final class GuardrailsResponseRepository {
    @NotNull
    private final ActiveObjects ao;

    @Inject
    public GuardrailsResponseRepository(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        this.ao = ao;
    }

    @NotNull
    public final GuardrailsResponse recordAssessmentDto(@NotNull QueryAssessmentDto queryAssessmentDto) {
        Intrinsics.checkNotNullParameter((Object)queryAssessmentDto, (String)"queryAssessmentDto");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"GUARDRAILS_RESPONSE_TYPE", (Object)((Object)queryAssessmentDto.getResponseType())), TuplesKt.to((Object)"QUERY_ID", (Object)queryAssessmentDto.getQueryId()), TuplesKt.to((Object)"GUARDRAILS_RESPONSE_TEXT", (Object)(queryAssessmentDto.getResponseType() != ResponseType.JESAT ? queryAssessmentDto.getResult() : null)), TuplesKt.to((Object)"JESAT_RESPONSE", (Object)(queryAssessmentDto.getResponseType() == ResponseType.JESAT || queryAssessmentDto.getResponseType() == ResponseType.ALL ? queryAssessmentDto.getResult() : null)), TuplesKt.to((Object)"SUCCESS", (Object)queryAssessmentDto.getSuccess()), TuplesKt.to((Object)"JOB_ID", (Object)queryAssessmentDto.getJobId()), TuplesKt.to((Object)"QUERY_STATUS", (Object)queryAssessmentDto.getQueryStatus()), TuplesKt.to((Object)"QUERY_PRODUCT_TYPE", (Object)((Object)queryAssessmentDto.getQueryProductType())), TuplesKt.to((Object)"QUERY_DURATION", (Object)queryAssessmentDto.getQueryDuration()), TuplesKt.to((Object)"QUERY_CPU_LOAD", (Object)queryAssessmentDto.getQueryCpuLoad())};
        RawEntity rawEntity = this.ao.create(GuardrailsResponse.class, MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntity, (String)"create(...)");
        return (GuardrailsResponse)rawEntity;
    }

    @NotNull
    public final GuardrailsResponse[] findResponses(@NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Object[] objectArray = new Object[]{jobId};
        RawEntity[] rawEntityArray = this.ao.find(GuardrailsResponse.class, "JOB_ID = ?", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (GuardrailsResponse[])rawEntityArray;
    }

    private final GuardrailsResponse[] findResponses(String jobId, List<? extends ResponseType> guardRailsResponseTypes) {
        Object[] objectArray = new Object[]{jobId};
        RawEntity[] rawEntityArray = this.ao.find(GuardrailsResponse.class, "JOB_ID = ? AND GUARDRAILS_RESPONSE_TYPE IN (" + CollectionsKt.joinToString$default((Iterable)guardRailsResponseTypes, null, null, null, (int)0, null, (Function1)findResponses.1.INSTANCE, (int)31, null) + ')', objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (GuardrailsResponse[])rawEntityArray;
    }

    @NotNull
    public final GuardrailsResponse[] findApplicableGuardrailsResponses(@NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        ResponseType[] responseTypeArray = new ResponseType[]{ResponseType.ALL, ResponseType.GUARDRAILS};
        return this.findResponses(jobId, CollectionsKt.listOf((Object[])responseTypeArray));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GuardrailsResponseFileRecord> findGuardrailsResponsesForCSV(@NotNull String jobId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        GuardrailsResponse[] $this$map$iv = this.findApplicableGuardrailsResponses(jobId);
        boolean $i$f$map = false;
        GuardrailsResponse[] guardrailsResponseArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new GuardrailsResponseFileRecord(it.getQueryId(), it.getGuardrailsResponseText(), it.getQueryStatus(), it.getQueryProductType().getProductName(), null, null, null, null, null, it.getQueryDuration(), it.getQueryCpuLoad(), 496, null));
        }
        return (List)destination$iv$iv;
    }

    private final GuardrailsResponse[] findApplicableJESATResponses(String jobId) {
        ResponseType[] responseTypeArray = new ResponseType[]{ResponseType.ALL, ResponseType.JESAT};
        return this.findResponses(jobId, CollectionsKt.listOf((Object[])responseTypeArray));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JESATResponseFileRecord> findJESATResponsesForCSV(@NotNull String jobId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        GuardrailsResponse[] $this$map$iv = this.findApplicableJESATResponses(jobId);
        boolean $i$f$map = false;
        GuardrailsResponse[] guardrailsResponseArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JESATResponseFileRecord(it.getQueryId(), it.getJesatResponse(), it.getSuccess()));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final GuardrailsResponse[] findApplicableAppResponses(@NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        return this.findResponses(jobId, CollectionsKt.listOf((Object)((Object)ResponseType.APP)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AppResponseFileRecord> findApplicableAppResponsesForCsv(@NotNull String jobId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        GuardrailsResponse[] $this$map$iv = this.findApplicableAppResponses(jobId);
        boolean $i$f$map = false;
        GuardrailsResponse[] guardrailsResponseArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AppResponseFileRecord(it.getQueryId(), it.getGuardrailsResponseText(), it.getSuccess(), it.getQueryProductType(), null, null, 48, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SeparateFileResponseRecord> findSeparateFileResponses(@NotNull String jobId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        GuardrailsResponse[] $this$map$iv = this.findResponses(jobId, CollectionsKt.listOf((Object)((Object)ResponseType.SEPARATE)));
        boolean $i$f$map = false;
        GuardrailsResponse[] guardrailsResponseArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SeparateFileResponseRecord(it.getQueryId(), it.getGuardrailsResponseText(), it.getSuccess()));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final GuardrailsResponse findLatestResponse() {
        Object[] result2 = (GuardrailsResponse[])this.ao.find(GuardrailsResponse.class, Query.select().order("ID DESC").limit(1));
        Intrinsics.checkNotNull((Object)result2);
        return (GuardrailsResponse)ArraysKt.singleOrNull((Object[])result2);
    }
}

