/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.guardrails.repository.InstAnalysisCtrl;
import com.atlassian.jira.migration.guardrails.repository.InstanceAnalysisControlRepositoryKt;
import com.atlassian.jira.migration.guardrails.repository.InstanceAssessmentCompletionStatus;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/guardrails/repository/InstanceAnalysisControlRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "completeInstanceAnalysisControl", "", "analysisType", "", "status", "Lcom/atlassian/jira/migration/guardrails/repository/InstanceAssessmentCompletionStatus;", "createInstanceAnalysisControl", "Lcom/atlassian/jira/migration/guardrails/repository/InstAnalysisCtrl;", "findInstanceAnalysisControl", "updateInstanceAnalysisControl", "instAnalysisCtrl", "jira-migration-plugin"})
public final class InstanceAnalysisControlRepository {
    @NotNull
    private final ActiveObjects ao;

    @Inject
    public InstanceAnalysisControlRepository(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        this.ao = ao;
    }

    @NotNull
    public final InstAnalysisCtrl createInstanceAnalysisControl(@NotNull String analysisType) {
        Intrinsics.checkNotNullParameter((Object)analysisType, (String)"analysisType");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ANALYSIS_TYPE", (Object)analysisType), TuplesKt.to((Object)"START_TIMESTAMP", (Object)System.currentTimeMillis())};
        RawEntity rawEntity = this.ao.create(InstAnalysisCtrl.class, MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntity, (String)"create(...)");
        return (InstAnalysisCtrl)rawEntity;
    }

    public final void completeInstanceAnalysisControl(@NotNull String analysisType, @NotNull InstanceAssessmentCompletionStatus status) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)analysisType, (String)"analysisType");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        InstAnalysisCtrl instAnalysisCtrl = this.findInstanceAnalysisControl(analysisType);
        if (instAnalysisCtrl != null) {
            InstAnalysisCtrl it = instAnalysisCtrl;
            boolean bl = false;
            if (!InstanceAnalysisControlRepositoryKt.isFinished(it)) {
                it.setEndTimestamp(System.currentTimeMillis());
                it.setCompletionStatus(status.name());
                it.save();
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException(("Analysis not found for type " + analysisType + '.').toString());
        }
    }

    public final void updateInstanceAnalysisControl(@NotNull InstAnalysisCtrl instAnalysisCtrl) {
        Intrinsics.checkNotNullParameter((Object)instAnalysisCtrl, (String)"instAnalysisCtrl");
        instAnalysisCtrl.save();
    }

    @Nullable
    public final InstAnalysisCtrl findInstanceAnalysisControl(@NotNull String analysisType) {
        Intrinsics.checkNotNullParameter((Object)analysisType, (String)"analysisType");
        Object[] objectArray = new Object[]{analysisType};
        Query query = Query.select().where("ANALYSIS_TYPE = ?", objectArray).order("START_TIMESTAMP DESC");
        RawEntity[] rawEntityArray = this.ao.find(InstAnalysisCtrl.class, query);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (InstAnalysisCtrl)ArraysKt.firstOrNull((Object[])rawEntityArray);
    }
}

