/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.rest;

import com.atlassian.jira.migration.guardrails.BrowserMetricsService;
import com.atlassian.jira.migration.guardrails.model.BrowserMetricsDto;
import com.atlassian.jira.migration.guardrails.rest.BrowserMetricsCheckResponse;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="browser-metrics")
@Consumes(value={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/guardrails/rest/BrowserMetricsResource;", "", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "browserMetricsService", "Lcom/atlassian/jira/migration/guardrails/BrowserMetricsService;", "(Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/migration/guardrails/BrowserMetricsService;)V", "addBrowserMetrics", "Ljavax/ws/rs/core/Response;", "browserMetricsDto", "Lcom/atlassian/jira/migration/guardrails/model/BrowserMetricsDto;", "request", "Ljavax/servlet/http/HttpServletRequest;", "isBrowserMetricsEnabled", "Lcom/atlassian/jira/migration/guardrails/rest/BrowserMetricsCheckResponse;", "Companion", "jira-migration-plugin"})
public final class BrowserMetricsResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @NotNull
    private final BrowserMetricsService browserMetricsService;
    @NotNull
    private static final Logger log;

    @Inject
    public BrowserMetricsResource(@NotNull JiraAuthenticationContext jiraAuthenticationContext, @NotNull BrowserMetricsService browserMetricsService) {
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)browserMetricsService, (String)"browserMetricsService");
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.browserMetricsService = browserMetricsService;
    }

    @GET
    @Path(value="/enabled")
    @Produces(value={"application/json"})
    @NotNull
    public final BrowserMetricsCheckResponse isBrowserMetricsEnabled() {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        Intrinsics.checkNotNull((Object)loggedInUser);
        return new BrowserMetricsCheckResponse(this.browserMetricsService.shouldCollectBrowserMetrics(loggedInUser));
    }

    @POST
    @NotNull
    public final Response addBrowserMetrics(@NotNull BrowserMetricsDto browserMetricsDto, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)browserMetricsDto, (String)"browserMetricsDto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        browserMetricsDto.setProtocol(request.getProtocol());
        Intrinsics.checkNotNull((Object)loggedInUser);
        this.browserMetricsService.recordBrowserMetrics(loggedInUser, browserMetricsDto);
        log.info("Browser-metrics saved successfully.");
        return ResponseUtils.created$default(ResponseUtils.INSTANCE, null, 1, null);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(BrowserMetricsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/guardrails/rest/BrowserMetricsResource$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

