/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.rest;

import com.atlassian.jira.migration.assessment.InstanceAssessmentUploadService;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.guardrails.AssessmentStatus;
import com.atlassian.jira.migration.guardrails.AssessmentZipOutputStreamResult;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentService;
import com.atlassian.jira.migration.guardrails.InstanceAssessmentZipExporter;
import com.atlassian.jira.migration.guardrails.rest.InstanceAssessmentMode;
import com.atlassian.jira.migration.guardrails.rest.InstanceAssessmentResourceStatus;
import com.atlassian.jira.migration.guardrails.rest.InstanceAssessmentResult;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Path(value="instance/assessment")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0007J2\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0007J\b\u0010\u001b\u001a\u00020\u0010H\u0007J\b\u0010\u001c\u001a\u00020\u0010H\u0007J\b\u0010\u001d\u001a\u00020\u0010H\u0007J\u0012\u0010\u001e\u001a\u00020\u00102\b\b\u0001\u0010\u001f\u001a\u00020 H\u0007J\b\u0010!\u001a\u00020\u0010H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/guardrails/rest/InstanceAssessmentResource;", "", "instanceAssessmentService", "Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentService;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "instanceAssessmentZipExporter", "Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentZipExporter;", "instanceAssessmentUploadService", "Lcom/atlassian/jira/migration/assessment/InstanceAssessmentUploadService;", "(Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentService;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/guardrails/InstanceAssessmentZipExporter;Lcom/atlassian/jira/migration/assessment/InstanceAssessmentUploadService;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "cancelAssessment", "Ljavax/ws/rs/core/Response;", "createResponse", "date", "", "zipFileBaseName", "responseSupplier", "Lkotlin/Function2;", "Ljava/io/OutputStream;", "Lcom/atlassian/jira/migration/guardrails/AssessmentZipOutputStreamResult;", "createZipDate", "downloadExampleZip", "downloadZip", "downloadZipDeprecated", "getAssessmentProgress", "startNewAssessment", "mode", "Lcom/atlassian/jira/migration/guardrails/rest/InstanceAssessmentMode;", "uploadAssessmentZip", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nInstanceAssessmentResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstanceAssessmentResource.kt\ncom/atlassian/jira/migration/guardrails/rest/InstanceAssessmentResource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
public final class InstanceAssessmentResource {
    @NotNull
    private final InstanceAssessmentService instanceAssessmentService;
    @NotNull
    private final InstanceAssessmentZipExporter instanceAssessmentZipExporter;
    @NotNull
    private final InstanceAssessmentUploadService instanceAssessmentUploadService;
    @NotNull
    private final ObjectMapper objectMapper;

    @Inject
    public InstanceAssessmentResource(@NotNull InstanceAssessmentService instanceAssessmentService, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull InstanceAssessmentZipExporter instanceAssessmentZipExporter, @NotNull InstanceAssessmentUploadService instanceAssessmentUploadService) {
        Intrinsics.checkNotNullParameter((Object)instanceAssessmentService, (String)"instanceAssessmentService");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)instanceAssessmentZipExporter, (String)"instanceAssessmentZipExporter");
        Intrinsics.checkNotNullParameter((Object)instanceAssessmentUploadService, (String)"instanceAssessmentUploadService");
        this.instanceAssessmentService = instanceAssessmentService;
        this.instanceAssessmentZipExporter = instanceAssessmentZipExporter;
        this.instanceAssessmentUploadService = instanceAssessmentUploadService;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @GET
    @Path(value="start")
    @NotNull
    public final Response startNewAssessment(@QueryParam(value="mode") @DefaultValue(value="FULL") @NotNull InstanceAssessmentMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        AssessmentStatus assessmentStatus = this.instanceAssessmentService.startInstanceAssessment(false, mode.getConfig());
        return assessmentStatus instanceof AssessmentStatus.ActiveAssessment ? ResponseUtils.INSTANCE.ok(new InstanceAssessmentResult(null, InstanceAssessmentResourceStatus.IN_PROGRESS, null, null, null, null, 61, null)) : (assessmentStatus instanceof AssessmentStatus.NewlyCreatedAssessment ? ResponseUtils.INSTANCE.ok(new InstanceAssessmentResult(null, InstanceAssessmentResourceStatus.NOT_STARTED, null, null, null, null, 61, null)) : ResponseUtils.internalServerError$default(ResponseUtils.INSTANCE, null, 1, null));
    }

    @PUT
    @Path(value="/cancel")
    @NotNull
    public final Response cancelAssessment() {
        this.instanceAssessmentService.cancelAssessmentCollection();
        return this.getAssessmentProgress();
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="progress")
    @NotNull
    public final Response getAssessmentProgress() {
        Response response2;
        AssessmentStatus result2 = this.instanceAssessmentService.getAssessmentProgress();
        if (result2 instanceof AssessmentStatus.InProgressAssessment) {
            Instant instant = ((AssessmentStatus.InProgressAssessment)result2).getLastStatusUpdateInstant();
            response2 = ResponseUtils.INSTANCE.ok(new InstanceAssessmentResult(((AssessmentStatus.InProgressAssessment)result2).getProgress(), InstanceAssessmentResourceStatus.IN_PROGRESS, "", ((AssessmentStatus.InProgressAssessment)result2).getDescription(), ((AssessmentStatus.InProgressAssessment)result2).getRemainingDuration(), instant != null ? Long.valueOf(instant.toEpochMilli()) : null));
        } else if (result2 instanceof AssessmentStatus.CompletedAssessment) {
            String string;
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            ResponseUtils responseUtils = ResponseUtils.INSTANCE;
            String string2 = null;
            CharSequence charSequence = ((AssessmentStatus.CompletedAssessment)result2).getStatus();
            InstanceAssessmentResourceStatus instanceAssessmentResourceStatus = charSequence == null || charSequence.length() == 0 ? InstanceAssessmentResourceStatus.COMPLETE : InstanceAssessmentResourceStatus.valueOf(((AssessmentStatus.CompletedAssessment)result2).getStatus());
            Instant instant = ((AssessmentStatus.CompletedAssessment)result2).getLastStatusUpdateInstant();
            if (instant != null) {
                void it;
                long l = instant.toEpochMilli();
                InstanceAssessmentResourceStatus instanceAssessmentResourceStatus2 = instanceAssessmentResourceStatus;
                String string3 = string2;
                ResponseUtils responseUtils2 = responseUtils;
                boolean bl = false;
                String string4 = formatter.format((long)it);
                responseUtils = responseUtils2;
                string2 = string3;
                instanceAssessmentResourceStatus = instanceAssessmentResourceStatus2;
                string = string4;
            } else {
                string = null;
            }
            Instant instant2 = ((AssessmentStatus.CompletedAssessment)result2).getLastStatusUpdateInstant();
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 9;
            Long l = instant2 != null ? Long.valueOf(instant2.toEpochMilli()) : null;
            Long l2 = 0L;
            String string5 = null;
            String string6 = string;
            InstanceAssessmentResourceStatus instanceAssessmentResourceStatus3 = instanceAssessmentResourceStatus;
            String string7 = string2;
            response2 = responseUtils.ok(new InstanceAssessmentResult(string7, instanceAssessmentResourceStatus3, string6, string5, l2, l, n, defaultConstructorMarker));
        } else {
            response2 = ResponseUtils.INSTANCE.ok(new InstanceAssessmentResult("", InstanceAssessmentResourceStatus.NOT_STARTED, "", null, null, null, 56, null));
        }
        return response2;
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="csv")
    @Deprecated(message="use /export path instead", replaceWith=@ReplaceWith(expression="downloadZip()", imports={}))
    @NotNull
    public final Response downloadZipDeprecated() {
        return this.downloadZip();
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="export")
    @NotNull
    public final Response downloadZip() {
        return this.createResponse(this.createZipDate(), "migration-assessments", (Function2<? super String, ? super OutputStream, ? extends AssessmentZipOutputStreamResult>)((Function2)new Function2<String, OutputStream, AssessmentZipOutputStreamResult>((Object)this.instanceAssessmentZipExporter){

            @NotNull
            public final AssessmentZipOutputStreamResult invoke(@NotNull String p0, @NotNull OutputStream p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((InstanceAssessmentZipExporter)this.receiver).export(p0, p1);
            }
        }));
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="export/example")
    @NotNull
    public final Response downloadExampleZip() {
        return this.createResponse(this.createZipDate(), "example-migration-assessments", (Function2<? super String, ? super OutputStream, ? extends AssessmentZipOutputStreamResult>)((Function2)new Function2<String, OutputStream, AssessmentZipOutputStreamResult>((Object)this.instanceAssessmentZipExporter){

            @NotNull
            public final AssessmentZipOutputStreamResult invoke(@NotNull String p0, @NotNull OutputStream p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((InstanceAssessmentZipExporter)this.receiver).exportExample(p0, p1);
            }
        }));
    }

    @POST
    @Path(value="upload")
    @NotNull
    public final Response uploadAssessmentZip() {
        this.instanceAssessmentUploadService.uploadAssessmentZip();
        return ResponseUtils.INSTANCE.ok("Upload successful");
    }

    private final Response createResponse(String date, String zipFileBaseName, Function2<? super String, ? super OutputStream, ? extends AssessmentZipOutputStreamResult> responseSupplier) {
        Response response2 = Response.ok(arg_0 -> InstanceAssessmentResource.createResponse$lambda$1(responseSupplier, date, arg_0)).type("application/zip").header("Content-disposition", (Object)("attachment; filename=" + zipFileBaseName + '-' + date + ".zip")).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    private final String createZipDate() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String string = formatter.format(LocalDateTime.now());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private static final void createResponse$lambda$1(Function2 $responseSupplier, String $date, OutputStream it) {
        Intrinsics.checkNotNullParameter((Object)$responseSupplier, (String)"$responseSupplier");
        Intrinsics.checkNotNullParameter((Object)$date, (String)"$date");
        Intrinsics.checkNotNull((Object)it);
        AssessmentZipOutputStreamResult result2 = (AssessmentZipOutputStreamResult)$responseSupplier.invoke((Object)$date, (Object)it);
        if (!(result2 instanceof AssessmentZipOutputStreamResult.Success) && result2 instanceof AssessmentZipOutputStreamResult.Failed) {
            throw new WebApplicationException(((AssessmentZipOutputStreamResult.Failed)result2).getError());
        }
    }
}

