/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.util;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.guardrails.model.ApplinkAppType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\u0011\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0007\u00a2\u0006\u0002\u0010\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"MIN_CLOUD_MAJOR_VERSION", "", "getAppType", "Lcom/atlassian/jira/migration/guardrails/model/ApplinkAppType;", "Lcom/atlassian/applinks/api/ApplicationLink;", "isCloud", "", "Lcom/atlassian/applinks/spi/Manifest;", "(Lcom/atlassian/applinks/spi/Manifest;)Ljava/lang/Boolean;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppLinkExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinkExtensions.kt\ncom/atlassian/jira/migration/guardrails/util/AppLinkExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,28:1\n1#2:29\n*E\n"})
public final class AppLinkExtensionsKt {
    private static final int MIN_CLOUD_MAJOR_VERSION = 1000;

    @NotNull
    public static final ApplinkAppType getAppType(@NotNull ApplicationLink $this$getAppType) {
        ApplinkAppType applinkAppType;
        Intrinsics.checkNotNullParameter((Object)$this$getAppType, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$getAppType.getType().getI18nKey(), (Object)"applinks.jira")) {
            applinkAppType = ApplinkAppType.JIRA;
        } else if (Intrinsics.areEqual((Object)$this$getAppType.getType().getI18nKey(), (Object)"applinks.confluence")) {
            applinkAppType = ApplinkAppType.CONFLUENCE;
        } else if (Intrinsics.areEqual((Object)$this$getAppType.getType().getI18nKey(), (Object)"applinks.crowd")) {
            applinkAppType = ApplinkAppType.CROWD;
        } else if (Intrinsics.areEqual((Object)$this$getAppType.getType().getI18nKey(), (Object)"applinks.bamboo")) {
            applinkAppType = ApplinkAppType.BAMBOO;
        } else if (Intrinsics.areEqual((Object)$this$getAppType.getType().getI18nKey(), (Object)"applinks.fisheye")) {
            applinkAppType = ApplinkAppType.FISHEYE;
        } else if (Intrinsics.areEqual((Object)$this$getAppType.getType().getI18nKey(), (Object)"applinks.stash")) {
            applinkAppType = ApplinkAppType.STASH;
        } else {
            String string = $this$getAppType.getType().getI18nKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getI18nKey(...)");
            applinkAppType = StringsKt.startsWith$default((String)string, (String)"applinks.bitbucket", (boolean)false, (int)2, null) ? ApplinkAppType.BITBUCKET : ApplinkAppType.OTHER;
        }
        return applinkAppType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Boolean isCloud(@NotNull Manifest $this$isCloud) {
        Intrinsics.checkNotNullParameter((Object)$this$isCloud, (String)"<this>");
        String string = $this$isCloud.getVersion();
        if (string == null) return null;
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (string2 == null) return null;
        List<String> list = StringExtensionsKt.splitBy(string2, ".");
        if (list == null) return null;
        String string3 = (String)CollectionsKt.firstOrNull(list);
        if (string3 == null) return null;
        Integer n = StringsKt.toIntOrNull((String)string3);
        if (n == null) return null;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Boolean bl2 = it >= 1000;
        return bl2;
    }
}

