/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.util;

import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.core.StreamingOutput;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000bJ\u001c\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000bJ$\u0010\u0011\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000bJ\"\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000bJ.\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\u0015H\u0002J.\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\r0\u0015H\u0002J\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002R\"\u0010\u0007\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/jira/migration/guardrails/util/AssessmentZipBuilder;", "", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "files", "", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "", "addJsonToZip", "", "data", "filename", "dirName", "addToZip", "path", "Ljavax/ws/rs/core/StreamingOutput;", "consumer", "Lkotlin/Function1;", "addToZipUsingBufferedWriter", "Ljava/io/BufferedWriter;", "createZip", "outputStream", "Ljava/io/OutputStream;", "prepareFile", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAssessmentZipBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssessmentZipBuilder.kt\ncom/atlassian/jira/migration/guardrails/util/AssessmentZipBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1#2:86\n1855#3,2:87\n*S KotlinDebug\n*F\n+ 1 AssessmentZipBuilder.kt\ncom/atlassian/jira/migration/guardrails/util/AssessmentZipBuilder\n*L\n81#1:87,2\n*E\n"})
public final class AssessmentZipBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final List<Pair<Path, String>> files;
    @NotNull
    public static final String ZIP_COMMENT = "atlassian-onprem-instance-assessment";

    public AssessmentZipBuilder(@NotNull LocalFileDataOutput localFileDataOutput, @NotNull ObjectMapper objectMapper2) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)objectMapper2, (String)"objectMapper");
        this.localFileDataOutput = localFileDataOutput;
        this.objectMapper = objectMapper2;
        this.files = new ArrayList();
    }

    public final void addToZip(@Nullable Path path, @Nullable String dirName) {
        if (path != null) {
            this.files.add((Pair<Path, String>)new Pair((Object)path, (Object)dirName));
        }
    }

    public static /* synthetic */ void addToZip$default(AssessmentZipBuilder assessmentZipBuilder, Path path, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        assessmentZipBuilder.addToZip(path, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addToZip(@Nullable StreamingOutput data2, @NotNull String filename, @Nullable String dirName) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        if (data2 != null) {
            Path path = this.prepareFile(filename);
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            int n = 8192;
            closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
            Throwable throwable = null;
            try {
                Closeable p0 = closeable;
                boolean bl = false;
                data2.write(p0);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            this.addToZip(path, dirName);
        }
    }

    public static /* synthetic */ void addToZip$default(AssessmentZipBuilder assessmentZipBuilder, StreamingOutput streamingOutput, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        assessmentZipBuilder.addToZip(streamingOutput, string, string2);
    }

    public final void addToZip(@NotNull String data2, @NotNull String filename, @Nullable String dirName) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.addToZipUsingBufferedWriter(filename, dirName, (Function1<? super BufferedWriter, Unit>)((Function1)new Function1<BufferedWriter, Unit>(data2){
            final /* synthetic */ String $data;
            {
                this.$data = $data;
                super(1);
            }

            public final void invoke(@NotNull BufferedWriter writer) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                writer.write(this.$data);
            }
        }));
    }

    public static /* synthetic */ void addToZip$default(AssessmentZipBuilder assessmentZipBuilder, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        assessmentZipBuilder.addToZip(string, string2, string3);
    }

    public final void addJsonToZip(@NotNull Object data2, @NotNull String filename, @Nullable String dirName) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.addToZipUsingBufferedWriter(filename, dirName, (Function1<? super BufferedWriter, Unit>)((Function1)new Function1<BufferedWriter, Unit>(this, data2){
            final /* synthetic */ AssessmentZipBuilder this$0;
            final /* synthetic */ Object $data;
            {
                this.this$0 = $receiver;
                this.$data = $data;
                super(1);
            }

            public final void invoke(@NotNull BufferedWriter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AssessmentZipBuilder.access$getObjectMapper$p(this.this$0).writeValue((Writer)it, this.$data);
            }
        }));
    }

    public static /* synthetic */ void addJsonToZip$default(AssessmentZipBuilder assessmentZipBuilder, Object object, String string, String string2, int n, Object object2) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        assessmentZipBuilder.addJsonToZip(object, string, string2);
    }

    private final void addToZipUsingBufferedWriter(String filename, String dirName, Function1<? super BufferedWriter, Unit> consumer) {
        this.addToZip(filename, dirName, (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>(consumer){
            final /* synthetic */ Function1<BufferedWriter, Unit> $consumer;
            {
                this.$consumer = $consumer;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = it;
                Object object2 = new OpenOption[]{};
                Function1<BufferedWriter, Unit> function1 = Charsets.UTF_8;
                int n = 8192;
                object = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length)), (Charset)function1), n);
                function1 = this.$consumer;
                Throwable throwable = null;
                try {
                    object2 = function1.invoke(object);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
        }));
    }

    private final void addToZip(String filename, String dirName, Function1<? super Path, Unit> consumer) {
        Path path = this.prepareFile(filename);
        consumer.invoke((Object)path);
        this.addToZip(path, dirName);
    }

    private final Path prepareFile(String filename) {
        Path jsonlPathFile = this.localFileDataOutput.exportDirectory().resolve(filename);
        Files.deleteIfExists(jsonlPathFile);
        Files.createFile(jsonlPathFile, new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)jsonlPathFile);
        return jsonlPathFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createZip(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Closeable closeable = new ZipOutputStream(new BufferedOutputStream(outputStream));
        Throwable throwable = null;
        try {
            ZipOutputStream zip = (ZipOutputStream)closeable;
            boolean bl = false;
            zip.setComment(ZIP_COMMENT);
            Iterable $this$forEach$iv = this.files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl2 = false;
                this.localFileDataOutput.addToZip(zip, (Path)it.getFirst(), (String)it.getSecond());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(AssessmentZipBuilder $this) {
        return $this.objectMapper;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/guardrails/util/AssessmentZipBuilder$Companion;", "", "()V", "ZIP_COMMENT", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

