/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\f\u0010\u0007\u001a\u00020\u0004*\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/guardrails/util/ExceptionUtils;", "", "()V", "getStackTraceAsLimitedString", "", "throwable", "", "getStackTraceAsString", "maxChars", "", "jira-migration-plugin"})
public final class ExceptionUtils {
    @NotNull
    public static final ExceptionUtils INSTANCE = new ExceptionUtils();

    private ExceptionUtils() {
    }

    @NotNull
    public final String getStackTraceAsLimitedString(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        return this.getStackTraceAsString(throwable, 1000);
    }

    @NotNull
    public final String getStackTraceAsString(@NotNull Throwable throwable, int maxChars) {
        String string;
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        String stackTraceString = this.getStackTraceAsString(throwable);
        if (stackTraceString.length() > maxChars) {
            String string2 = stackTraceString.substring(0, maxChars);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = stackTraceString;
        }
        return string;
    }

    private final String getStackTraceAsString(Throwable $this$getStackTraceAsString) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        $this$getStackTraceAsString.printStackTrace(pw);
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

