/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.util;

import com.atlassian.jira.migration.guardrails.util.JsonEntry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u0002H\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00040\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J<\u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072 \u0010\b\u001a\u001c\u0012\u0004\u0012\u0002H\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\tJ\u001f\u0010\u000f\u001a\u00020\u00042\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u000f\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014J\u001c\u0010\u000f\u001a\u00020\u00042\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/guardrails/util/JsonUtils;", "", "()V", "jsonArray", "Lcom/google/gson/JsonElement;", "E", "list", "", "map", "Lkotlin/Function1;", "jsonString", "", "obj", "", "Ljava/io/Serializable;", "jsonStruct", "entities", "", "Lcom/atlassian/jira/migration/guardrails/util/JsonEntry;", "([Lcom/atlassian/jira/migration/guardrails/util/JsonEntry;)Lcom/google/gson/JsonElement;", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJsonUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonUtils.kt\ncom/atlassian/jira/migration/guardrails/util/JsonUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1549#2:53\n1620#2,3:54\n*S KotlinDebug\n*F\n+ 1 JsonUtils.kt\ncom/atlassian/jira/migration/guardrails/util/JsonUtils\n*L\n33#1:53\n33#1:54,3\n*E\n"})
public final class JsonUtils {
    @NotNull
    public static final JsonUtils INSTANCE = new JsonUtils();

    private JsonUtils() {
    }

    @NotNull
    public final String jsonString(@NotNull JsonElement obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        String string = obj.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final <E> String jsonString(@NotNull Collection<? extends E> list, @NotNull Function1<? super E, ? extends Map<String, ? extends Serializable>> map) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        return this.jsonString(this.jsonArray(list, (Function1)new Function1<E, JsonElement>(map){
            final /* synthetic */ Function1<E, Map<String, Serializable>> $map;
            {
                this.$map = $map;
                super(1);
            }

            @Nullable
            public final JsonElement invoke(E it) {
                return JsonUtils.INSTANCE.jsonStruct((Map)this.$map.invoke(it));
            }
        }));
    }

    @NotNull
    public final <E> JsonElement jsonArray(@NotNull Collection<? extends E> list, @NotNull Function1<? super E, ? extends JsonElement> map) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        JsonArray result2 = new JsonArray();
        for (E item : list) {
            JsonElement entry = (JsonElement)map.invoke(item);
            if (entry == null) continue;
            result2.add(entry);
        }
        return (JsonElement)result2;
    }

    @NotNull
    public final JsonElement jsonStruct(JsonEntry ... entities) {
        Intrinsics.checkNotNullParameter((Object)entities, (String)"entities");
        return this.jsonStruct(ArraysKt.asList((Object[])entities));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsonElement jsonStruct(@NotNull Map<String, ? extends Serializable> map) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Iterable iterable = map.entrySet();
        JsonUtils jsonUtils = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JsonEntry((String)it.getKey(), (Serializable)it.getValue()));
        }
        return jsonUtils.jsonStruct((List)destination$iv$iv);
    }

    @NotNull
    public final JsonElement jsonStruct(@NotNull List<JsonEntry> entities) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        JsonObject result2 = new JsonObject();
        for (JsonEntry item : entities) {
            Serializable serializable = item.getValue();
            if (serializable instanceof Number) {
                result2.addProperty(item.getKey(), (Number)item.getValue());
                continue;
            }
            if (serializable instanceof String) {
                result2.addProperty(item.getKey(), (String)((Object)item.getValue()));
                continue;
            }
            if (serializable instanceof Boolean) {
                result2.addProperty(item.getKey(), (Boolean)item.getValue());
                continue;
            }
            if (!(serializable instanceof Character)) continue;
            result2.addProperty(item.getKey(), (Character)item.getValue());
        }
        return (JsonElement)result2;
    }
}

