/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.guardrails.util;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.guardrails.util.TomcatAccessLogParser;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0007J6\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006H\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0007J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0007J\u001c\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00062\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\u001d2\u0006\u0010\u0013\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/guardrails/util/TomcatAccessLogParser;", "", "()V", "datePatternRegex", "Lkotlin/text/Regex;", "createAccessLogFilesMap", "", "Ljava/time/LocalDate;", "Ljava/io/File;", "daysAgo", "", "createTomcatLogFolderFile", "tomcatLogFolderPath", "", "extractTimestamp", "logEntry", "extractUserId", "filterAccessLogFile", "", "file", "today", "accessLogFilesMap", "findDirectoryAbsolutePathIfExists", "parent", "findTomcatDirectory", "getDayHourKey", "timestamp", "listAccessLogFilesFromDaysAgo", "processLogFile", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nTomcatAccessLogParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomcatAccessLogParser.kt\ncom/atlassian/jira/migration/guardrails/util/TomcatAccessLogParser\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,159:1\n13309#2,2:160\n*S KotlinDebug\n*F\n+ 1 TomcatAccessLogParser.kt\ncom/atlassian/jira/migration/guardrails/util/TomcatAccessLogParser\n*L\n36#1:160,2\n*E\n"})
public final class TomcatAccessLogParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Regex datePatternRegex = new Regex("\\d{4}-\\d{2}-\\d{2}");
    @NotNull
    private static final Logger log;

    @NotNull
    public final Map<LocalDate, File> listAccessLogFilesFromDaysAgo(int daysAgo) {
        Map<LocalDate, File> accessLogFilesMap = this.createAccessLogFilesMap(daysAgo);
        LocalDate today = LocalDate.now();
        String tomcatLogFolderPath = this.findTomcatDirectory();
        if (tomcatLogFolderPath != null) {
            File tomcatLogFolder = this.createTomcatLogFolderFile(tomcatLogFolderPath);
            if (tomcatLogFolder.exists()) {
                log.info("Found tomcat log folder: " + tomcatLogFolderPath + '.');
                File[] fileArray = tomcatLogFolder.listFiles();
                if (fileArray != null) {
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File file2 = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)file2);
                        Intrinsics.checkNotNull((Object)today);
                        this.filterAccessLogFile(file2, today, daysAgo, accessLogFilesMap);
                    }
                }
            } else {
                log.info("Tomcat log folder does not exists: " + tomcatLogFolderPath + '.');
            }
        } else {
            log.info("Tomcat log folder is not configured.");
        }
        return accessLogFilesMap;
    }

    @VisibleForTesting
    @NotNull
    public final File createTomcatLogFolderFile(@NotNull String tomcatLogFolderPath) {
        Intrinsics.checkNotNullParameter((Object)tomcatLogFolderPath, (String)"tomcatLogFolderPath");
        return new File(tomcatLogFolderPath);
    }

    private final Map<LocalDate, File> createAccessLogFilesMap(int daysAgo) {
        Map accessLogFilesMap = new LinkedHashMap();
        LocalDate today = LocalDate.now();
        LocalDate startDate = today.minusDays(daysAgo);
        for (int i = 0; i < daysAgo; ++i) {
            LocalDate dateKey = startDate.plusDays(i).atStartOfDay().toLocalDate();
            Intrinsics.checkNotNull((Object)dateKey);
            accessLogFilesMap.put(dateKey, null);
        }
        return accessLogFilesMap;
    }

    private final void filterAccessLogFile(File file2, LocalDate today, int daysAgo, Map<LocalDate, File> accessLogFilesMap) {
        String string = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"access_log.", (boolean)false, (int)2, null)) {
            log.info("Found access log file: " + file2.getName() + '.');
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String string2 = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            MatchResult matchResult = Regex.find$default((Regex)this.datePatternRegex, (CharSequence)string2, (int)0, (int)2, null);
            String fileDateStr = matchResult != null ? matchResult.getValue() : null;
            LocalDate fileDate = LocalDate.parse(fileDateStr, dateFormatter).atStartOfDay().toLocalDate();
            if (!(fileDate.isBefore(today.minusDays(daysAgo)) || fileDate.isAfter(today) || Intrinsics.areEqual((Object)fileDate, (Object)today))) {
                Intrinsics.checkNotNull((Object)fileDate);
                accessLogFilesMap.put(fileDate, file2);
            } else {
                log.info("Not processing the file " + file2.getName() + ", because it's either before " + daysAgo + " days ago, or it's from today. If you need to collect today's data, please re-run the assessment tomorrow.");
            }
        }
    }

    @VisibleForTesting
    @Nullable
    public final String findTomcatDirectory() {
        String catalinaBase = System.getProperty("catalina.base");
        String catalinaHome = System.getProperty("catalina.home");
        String workingDirectory = System.getProperty("working.dir");
        String string = this.findDirectoryAbsolutePathIfExists(catalinaBase);
        if (string == null && (string = this.findDirectoryAbsolutePathIfExists(catalinaHome)) == null) {
            string = this.findDirectoryAbsolutePathIfExists(workingDirectory + "../");
        }
        return string;
    }

    private final String findDirectoryAbsolutePathIfExists(String parent) {
        if (parent != null) {
            String it = parent;
            boolean bl = false;
            Path path = Paths.get(it, new String[0]).resolve("logs");
            if (Files.exists(path, new LinkOption[0])) {
                return path.toUri().getPath();
            }
            return null;
        }
        return null;
    }

    @NotNull
    public final Map<String, Integer> processLogFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ConcurrentHashMap<String, Integer> userTrafficByHour = new ConcurrentHashMap<String, Integer>();
        try {
            ((Stream)Files.lines(file2.toPath()).parallel()).forEach(arg_0 -> TomcatAccessLogParser.processLogFile$lambda$2((Function1)new Function1<String, Unit>(this, userTrafficByHour){
                final /* synthetic */ TomcatAccessLogParser this$0;
                final /* synthetic */ ConcurrentHashMap<String, Integer> $userTrafficByHour;
                {
                    this.this$0 = $receiver;
                    this.$userTrafficByHour = $userTrafficByHour;
                    super(1);
                }

                public final void invoke(String line) {
                    Intrinsics.checkNotNull((Object)line);
                    String userId = this.this$0.extractUserId(line);
                    if (!StringsKt.isBlank((CharSequence)userId) && !Intrinsics.areEqual((Object)userId, (Object)"-")) {
                        String timestamp = this.this$0.extractTimestamp(line);
                        String dayHourKey = this.this$0.getDayHourKey(timestamp);
                        this.$userTrafficByHour.merge(dayHourKey + ',' + userId, 1, (arg_0, arg_1) -> processLogFile.1.invoke$lambda$0(processLogFile.1.INSTANCE, arg_0, arg_1));
                    }
                }

                private static final Integer invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Integer)$tmp0.invoke(p0, p1);
                }
            }, arg_0));
        }
        catch (Throwable e) {
            log.error("Error reading the log file: " + e.getMessage());
        }
        return userTrafficByHour;
    }

    @VisibleForTesting
    @NotNull
    public final String getDayHourKey(@NotNull String timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        String string = timestamp.substring(0, 14);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @VisibleForTesting
    @NotNull
    public final String extractUserId(@NotNull String logEntry) {
        String string;
        Intrinsics.checkNotNullParameter((Object)logEntry, (String)"logEntry");
        if (StringsKt.isBlank((CharSequence)logEntry)) {
            return "";
        }
        int start = StringsKt.indexOf$default((CharSequence)logEntry, (char)' ', (int)(StringsKt.indexOf$default((CharSequence)logEntry, (char)' ', (int)0, (boolean)false, (int)6, null) + 1), (boolean)false, (int)4, null) + 1;
        int end = StringsKt.indexOf$default((CharSequence)logEntry, (char)' ', (int)start, (boolean)false, (int)4, null);
        if (start != -1 && end != -1 && start < end) {
            String string2 = logEntry.substring(start, end);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = "";
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    public final String extractTimestamp(@NotNull String logEntry) {
        String string;
        Intrinsics.checkNotNullParameter((Object)logEntry, (String)"logEntry");
        int start = StringsKt.indexOf$default((CharSequence)logEntry, (char)'[', (int)0, (boolean)false, (int)6, null) + 1;
        int end = StringsKt.indexOf$default((CharSequence)logEntry, (char)']', (int)0, (boolean)false, (int)6, null);
        if (start != -1 && end != -1 && start < end) {
            String string2 = logEntry.substring(start, end);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = "";
        }
        return string;
    }

    private static final void processLogFile$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(TomcatAccessLogParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/guardrails/util/TomcatAccessLogParser$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

