/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.httpclient;

import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClientKt;
import com.atlassian.jira.migration.httpclient.BackOffHttpRequestRetryHandler;
import com.atlassian.jira.migration.httpclient.BackOffRequestSentEnabledRetryHandler;
import com.atlassian.jira.migration.httpclient.DefaultServiceUnavailableBackoffRetryStrategy;
import com.atlassian.jira.migration.httpclient.MigrationPluginConnectionKeepAliveStrategy;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.ServiceUnavailableBackoffRetryStrategy;
import com.atlassian.jira.migration.httpclient.TooManyRequestsConnectionBackoffStrategy;
import com.atlassian.jira.migration.httpclient.exceptions.ExceptionsKt;
import com.atlassian.jira.migration.httpclient.exceptions.HttpCommunicationException;
import com.atlassian.migration.app.dto.GetUrlResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import io.prometheus.metrics.core.datapoints.CounterDataPoint;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.MultiValueMap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 52\u00020\u0001:\u000245B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ'\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011\u00a2\u0006\u0002\u0010\u0012J'\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\t\u001a\u00020\nJ(\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u001c\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u001c\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013J\u001c\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011J)\u0010\u001f\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010 J\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H&J\u000e\u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\bH\u0016J\u0010\u0010'\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\fH\u0016J\u0018\u0010-\u001a\u00020\u00062\u0006\u0010,\u001a\u00020.2\u0006\u0010\t\u001a\u00020\nH\u0016J)\u0010/\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010&\u001a\u00020\u001b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H&\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\fH\u0016J\u0010\u00102\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\bH\u0002J\u0010\u00103\u001a\u00020\"2\u0006\u0010&\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/atlassian/jira/migration/httpclient/AbstractPluginHttpClient;", "", "httpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "(Lorg/apache/http/impl/client/CloseableHttpClient;)V", "checkExpectedResponseCode", "", "resp", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "requestConfig", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "createHttpUriRequest", "Lorg/apache/http/client/methods/HttpUriRequest;", "createRequest", "execute", "T", "returnType", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "Ljava/lang/Class;", "(Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;Ljava/lang/Class;)Ljava/lang/Object;", "", "file", "Ljava/nio/file/Path;", "(Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;Ljava/nio/file/Path;)Ljava/lang/Long;", "executeAndReturnHeaders", "Lorg/springframework/util/MultiValueMap;", "", "Lcom/atlassian/jira/migration/httpclient/AbstractPluginHttpClient$BodyWithHeaders;", "executeAndReturnOrHeader", "Lcom/atlassian/migration/app/dto/GetUrlResponse;", "getBody", "(Lcom/fasterxml/jackson/core/type/TypeReference;Lorg/apache/http/client/methods/CloseableHttpResponse;)Ljava/lang/Object;", "getBodyBytes", "", "body", "getResponse", "getResponseHeaders", "response", "handleDeleteRequest", "handleHttpCommunicationError", "Lcom/atlassian/jira/migration/httpclient/exceptions/HttpCommunicationException;", "ex", "Ljava/io/IOException;", "request", "injectBody", "Lorg/apache/http/HttpEntityEnclosingRequest;", "parseResponse", "(Ljava/lang/String;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "preHttpCallHook", "readContent", "readContentAsBytes", "BodyWithHeaders", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAbstractPluginHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractPluginHttpClient.kt\ncom/atlassian/jira/migration/httpclient/AbstractPluginHttpClient\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,386:1\n32#2:387\n33#2:389\n32#2,2:390\n1#3:388\n1855#4,2:392\n*S KotlinDebug\n*F\n+ 1 AbstractPluginHttpClient.kt\ncom/atlassian/jira/migration/httpclient/AbstractPluginHttpClient\n*L\n127#1:387\n127#1:389\n164#1:390,2\n272#1:392,2\n*E\n"})
public abstract class AbstractPluginHttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloseableHttpClient httpClient;
    private static final Logger log = LoggerFactory.getLogger(AbstractPluginHttpClient.class);
    private static final long ATLASSIAN_DNS_TIME_TO_LIVE = 55L;
    private static final long SOCKET_TIMEOUT = 120L;
    private static final long CONNECTION_TIMEOUT = 20L;
    private static final long CONNECTION_REQUEST_TIMEOUT = 20L;
    @NotNull
    private static final String MULTIPART_UPLOAD_DEBUG_REGEX = "migration/.+/storage/file/.+/upload/.+/complete";
    @NotNull
    private static final String HTTP_PATCH = "PATCH";
    private static final int CLIENT_BUILD_MAX_PER_ROUTE = 20;
    private static final int CLIENT_BUILD_MAX_TOTAL = 20;
    private static final int HEADER_MAP_INITIAL_CAPACITY = 8;
    @NotNull
    private static final String EXPIRES_HEADER_NAME = "Expires";
    @NotNull
    private static final String SERVER_HEADER_NAME = "Server";
    @NotNull
    private static final String SERVER_TIMING_HEADER_NAME = "Server-Timing";
    @NotNull
    private static final String X_TRACE_ID_HEADER_NAME = "X-Trace-Id";
    @NotNull
    private static final String ATL_REQUEST_ID_HEADER_NAME = "Atl-Request-Id";

    @VisibleForTesting
    public AbstractPluginHttpClient(@NotNull CloseableHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.httpClient = httpClient;
    }

    public /* synthetic */ AbstractPluginHttpClient(CloseableHttpClient closeableHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            closeableHttpClient = com.atlassian.jira.migration.httpclient.AbstractPluginHttpClient$Companion.createHttpClient$default(Companion, null, 1, null);
        }
        this(closeableHttpClient);
    }

    public final void execute(@NotNull MigrationPluginHttpRequest requestConfig) {
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        this.execute(requestConfig, Void.class);
    }

    public final <T> T execute(@NotNull MigrationPluginHttpRequest requestConfig, @NotNull Class<T> returnType) {
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        Intrinsics.checkNotNullParameter(returnType, (String)"returnType");
        return this.execute(requestConfig, (TypeReference)new TypeReference<T>(returnType){
            final /* synthetic */ Class<T> $returnType;
            {
                this.$returnType = $returnType;
            }

            @NotNull
            public Type getType() {
                return this.$returnType;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T execute(@NotNull MigrationPluginHttpRequest requestConfig, @NotNull TypeReference<T> returnType) {
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        Intrinsics.checkNotNullParameter(returnType, (String)"returnType");
        HttpUriRequest request = this.createRequest(requestConfig);
        try {
            this.preHttpCallHook(request);
            Closeable closeable = (Closeable)this.httpClient.execute(request);
            Throwable throwable = null;
            try {
                CloseableHttpResponse resp = (CloseableHttpResponse)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)resp);
                this.checkExpectedResponseCode(resp, requestConfig);
                T t = this.getBody(returnType, resp);
                return t;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw this.handleHttpCommunicationError(e, request);
        }
    }

    public void preHttpCallHook(@NotNull HttpUriRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        log.info("Executing HTTP {} request to URI: {}", (Object)request.getMethod(), (Object)request.getURI());
    }

    @NotNull
    public HttpCommunicationException handleHttpCommunicationError(@NotNull IOException ex, @NotNull HttpUriRequest request) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return ExceptionsKt.communicationError("An error occurred when requesting against HTTP " + request.getMethod() + ' ' + request.getURI() + ": " + ex.getMessage(), ex);
    }

    @NotNull
    public String getResponseHeaders(@NotNull CloseableHttpResponse response2) {
        StringBuilder stringBuilder;
        Object object;
        Object xTraceId;
        Object object2;
        Object serverTiming;
        Object object3;
        Object server;
        Object object4;
        Object expires;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Object object5 = response2.getFirstHeader(EXPIRES_HEADER_NAME);
        if (object5 == null || (object5 = object5.toString()) == null) {
            object5 = expires = "";
        }
        if ((object4 = response2.getFirstHeader(SERVER_HEADER_NAME)) == null || (object4 = object4.toString()) == null) {
            object4 = server = "";
        }
        if ((object3 = response2.getFirstHeader(SERVER_TIMING_HEADER_NAME)) == null || (object3 = object3.toString()) == null) {
            object3 = serverTiming = "";
        }
        if ((object2 = response2.getFirstHeader(X_TRACE_ID_HEADER_NAME)) == null || (object2 = object2.toString()) == null) {
            object2 = xTraceId = "";
        }
        if ((object = response2.getFirstHeader(ATL_REQUEST_ID_HEADER_NAME)) == null || (object = object.toString()) == null) {
            object = "";
        }
        Object atlRequestId = object;
        StringBuilder $this$getResponseHeaders_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getResponseHeaders_u24lambda_u241.append((String)expires + '\t');
        $this$getResponseHeaders_u24lambda_u241.append((String)server + '\t');
        $this$getResponseHeaders_u24lambda_u241.append((String)serverTiming + '\t');
        $this$getResponseHeaders_u24lambda_u241.append((String)atlRequestId + '\t');
        $this$getResponseHeaders_u24lambda_u241.append((String)xTraceId);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final GetUrlResponse executeAndReturnOrHeader(@NotNull MigrationPluginHttpRequest requestConfig, @NotNull TypeReference<String> returnType) {
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        Intrinsics.checkNotNullParameter(returnType, (String)"returnType");
        HttpUriRequest request = this.createRequest(requestConfig);
        try {
            this.preHttpCallHook(request);
            Closeable closeable = (Closeable)this.httpClient.execute(request);
            Throwable throwable = null;
            try {
                CloseableHttpResponse resp = (CloseableHttpResponse)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)resp);
                this.checkExpectedResponseCode(resp, requestConfig);
                HeaderIterator headerIterator = resp.headerIterator();
                Intrinsics.checkNotNullExpressionValue((Object)headerIterator, (String)"headerIterator(...)");
                Iterator $this$forEach$iv = (Iterator)headerIterator;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv;
                while (iterator2.hasNext()) {
                    Header header;
                    Object element$iv;
                    Object currentHeader = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(currentHeader, (String)"null cannot be cast to non-null type org.apache.http.Header");
                    Header it = header = (Header)currentHeader;
                    boolean bl3 = false;
                    Object object = Intrinsics.areEqual((Object)it.getName(), (Object)"X-Etag") ? header : null;
                    if (object == null) continue;
                    it = object;
                    boolean bl4 = false;
                    String string = it.getValue();
                    GetUrlResponse getUrlResponse = new GetUrlResponse(null, string);
                    return getUrlResponse;
                }
                GetUrlResponse getUrlResponse = new GetUrlResponse(this.getBody(returnType, resp), null);
                return getUrlResponse;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw this.handleHttpCommunicationError(e, request);
        }
    }

    @NotNull
    public final MultiValueMap<String, String> executeAndReturnHeaders(@NotNull MigrationPluginHttpRequest requestConfig) {
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        return this.executeAndReturnHeaders(requestConfig, Void.class).getHeaders();
    }

    @NotNull
    public final <T> BodyWithHeaders<T> executeAndReturnHeaders(@NotNull MigrationPluginHttpRequest requestConfig, @NotNull Class<T> returnType) {
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        Intrinsics.checkNotNullParameter(returnType, (String)"returnType");
        return this.executeAndReturnHeaders(requestConfig, (TypeReference)new TypeReference<T>(returnType){
            final /* synthetic */ Class<T> $returnType;
            {
                this.$returnType = $returnType;
            }

            @NotNull
            public Type getType() {
                return this.$returnType;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> BodyWithHeaders<T> executeAndReturnHeaders(@NotNull MigrationPluginHttpRequest requestConfig, @NotNull TypeReference<T> returnType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        Intrinsics.checkNotNullParameter(returnType, (String)"returnType");
        HttpUriRequest request = this.createRequest(requestConfig);
        if (request instanceof HttpPost) {
            String string = ((HttpPost)request).getURI().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            object = string;
            if (new Regex(MULTIPART_UPLOAD_DEBUG_REGEX).containsMatchIn((CharSequence)object)) {
                log.info("Request URI: " + ((HttpPost)request).getURI());
                log.info("Request Body: " + EntityUtils.toString((HttpEntity)((HttpPost)request).getEntity()));
            }
        }
        try {
            this.preHttpCallHook(request);
            object = (Closeable)this.httpClient.execute(request);
            Throwable throwable = null;
            try {
                CloseableHttpResponse resp = (CloseableHttpResponse)object;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)resp);
                this.checkExpectedResponseCode(resp, requestConfig);
                T body = this.getBody(returnType, resp);
                MultiValueMap headers = CollectionUtils.toMultiValueMap((Map)((Map)new LinkedCaseInsensitiveMap(8, Locale.ENGLISH)));
                HeaderIterator headerIterator = resp.headerIterator();
                Intrinsics.checkNotNullExpressionValue((Object)headerIterator, (String)"headerIterator(...)");
                Iterator $this$forEach$iv = (Iterator)headerIterator;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv;
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object currentHeader = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(currentHeader, (String)"null cannot be cast to non-null type org.apache.http.Header");
                    Header it = (Header)currentHeader;
                    boolean bl3 = false;
                    headers.add((Object)it.getName(), (Object)it.getValue());
                }
                Intrinsics.checkNotNull((Object)headers);
                BodyWithHeaders<T> bodyWithHeaders = new BodyWithHeaders<T>(body, (MultiValueMap<String, String>)headers);
                return bodyWithHeaders;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw this.handleHttpCommunicationError(e, request);
        }
    }

    private final <T> T getBody(TypeReference<T> returnType, CloseableHttpResponse resp) {
        Type type = returnType.getType();
        return (T)(Intrinsics.areEqual((Object)type, Void.class) ? (Object)Unit.INSTANCE : (Intrinsics.areEqual((Object)type, UUID.class) ? (Object)UUID.fromString(StringsKt.removeSurrounding((String)this.readContent(resp), (CharSequence)"\"")) : (Intrinsics.areEqual((Object)type, byte[].class) ? (Object)this.readContentAsBytes(resp) : this.parseResponse(this.readContent(resp), returnType))));
    }

    @NotNull
    public final CloseableHttpResponse getResponse(@NotNull MigrationPluginHttpRequest requestConfig) {
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        HttpUriRequest request = this.createRequest(requestConfig);
        try {
            this.preHttpCallHook(request);
            CloseableHttpResponse closeableHttpResponse = this.httpClient.execute(request);
            Intrinsics.checkNotNullExpressionValue((Object)closeableHttpResponse, (String)"execute(...)");
            CloseableHttpResponse response2 = closeableHttpResponse;
            this.checkExpectedResponseCode(response2, requestConfig);
            return response2;
        }
        catch (IOException e) {
            throw this.handleHttpCommunicationError(e, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Long execute(@NotNull MigrationPluginHttpRequest requestConfig, @NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        HttpUriRequest request = this.createRequest(requestConfig);
        try {
            this.preHttpCallHook(request);
            Closeable closeable = (Closeable)this.httpClient.execute(request);
            Throwable throwable = null;
            try {
                Long l;
                HttpEntity httpEntity;
                CloseableHttpResponse resp = (CloseableHttpResponse)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)resp);
                this.checkExpectedResponseCode(resp, requestConfig);
                HttpEntity httpEntity2 = httpEntity = resp.getEntity();
                if (httpEntity2 != null) {
                    InputStream inputStream;
                    Intrinsics.checkNotNull((Object)httpEntity2);
                    HttpEntity entity = httpEntity;
                    boolean bl2 = false;
                    InputStream inputStream2 = inputStream = entity.getContent();
                    if (inputStream2 != null) {
                        Intrinsics.checkNotNull((Object)inputStream2);
                        Closeable closeable2 = inputStream;
                        Throwable throwable2 = null;
                        try {
                            InputStream stream = (InputStream)closeable2;
                            boolean bl3 = false;
                            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                            Long l2 = Files.copy(stream, file2, copyOptionArray);
                            l = l2;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                    } else {
                        l = null;
                    }
                } else {
                    l = null;
                }
                Long l3 = l;
                return l3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw this.handleHttpCommunicationError(e, request);
        }
    }

    @NotNull
    public HttpUriRequest handleDeleteRequest(@NotNull MigrationPluginHttpRequest requestConfig) {
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        throw ExceptionsKt.protocolError("HTTP Method " + requestConfig.getMethod() + " is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkExpectedResponseCode(CloseableHttpResponse resp, MigrationPluginHttpRequest requestConfig) {
        int statusCode = resp.getStatusLine().getStatusCode();
        String[] stringArray = new String[]{String.valueOf(statusCode)};
        ((CounterDataPoint)AbstractPluginHttpClientKt.access$getResponsesCounter$p().labelValues(stringArray)).inc();
        if (!requestConfig.getExpectedStatusCodes().contains(statusCode)) {
            Object object;
            HttpEntity httpEntity = resp.getEntity();
            if (httpEntity != null) {
                InputStream inputStream;
                HttpEntity entity = httpEntity;
                boolean bl = false;
                InputStream inputStream2 = inputStream = entity.getContent();
                if (inputStream2 != null) {
                    Object object2;
                    Intrinsics.checkNotNull((Object)inputStream2);
                    InputStream stream = inputStream;
                    boolean bl2 = false;
                    try {
                        object2 = stream;
                        Object object3 = Charsets.UTF_8;
                        Object object4 = new InputStreamReader((InputStream)object2, (Charset)object3);
                        int n = 8192;
                        object2 = object4 instanceof BufferedReader ? (BufferedReader)object4 : new BufferedReader((Reader)object4, n);
                        object3 = null;
                        try {
                            BufferedReader p0 = (BufferedReader)object2;
                            boolean bl3 = false;
                            object4 = TextStreamsKt.readText((Reader)p0);
                        }
                        catch (Throwable throwable) {
                            object3 = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                        }
                        object2 = object4;
                    }
                    catch (IOException e) {
                        object2 = "";
                    }
                    object = object2;
                } else {
                    object = null;
                }
            } else {
                object = null;
            }
            Object responseEntityContent = object;
            throw ExceptionsKt.unexpectedStatusCode(statusCode, "Received an unexpected status code on executing HTTP " + requestConfig.getMethod() + " to " + requestConfig.getUri() + "; expected " + requestConfig.getExpectedStatusCodes() + ", but received " + statusCode + ": " + (String)responseEntityContent + " with response headers: {" + this.getResponseHeaders(resp) + '}');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readContent(CloseableHttpResponse response2) {
        Object object;
        try {
            InputStream inputStream = response2.getEntity().getContent();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getContent(...)");
            object = inputStream;
            Object object2 = Charsets.UTF_8;
            Object object3 = new InputStreamReader((InputStream)object, (Charset)object2);
            int n = 8192;
            object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                BufferedReader p0 = (BufferedReader)object;
                boolean bl = false;
                object3 = TextStreamsKt.readText((Reader)p0);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            object = object3;
        }
        catch (IOException e) {
            throw ExceptionsKt.communicationError("An error occurred attempting to read http content", e);
        }
        return object;
    }

    private final byte[] readContentAsBytes(CloseableHttpResponse response2) {
        byte[] byArray;
        try {
            InputStream inputStream = response2.getEntity().getContent();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getContent(...)");
            byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        }
        catch (IOException e) {
            throw ExceptionsKt.communicationError("An error occurred attempting to read http content", e);
        }
        return byArray;
    }

    public abstract <T> T parseResponse(@NotNull String var1, @NotNull TypeReference<T> var2);

    private final HttpUriRequest createRequest(MigrationPluginHttpRequest requestConfig) {
        HttpUriRequest httpUriRequest;
        HttpUriRequest $this$createRequest_u24lambda_u2416 = httpUriRequest = this.createHttpUriRequest(requestConfig);
        boolean bl = false;
        Iterable $this$forEach$iv = requestConfig.getHeaders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Header p0 = (Header)element$iv;
            boolean bl2 = false;
            $this$createRequest_u24lambda_u2416.addHeader(p0);
        }
        return httpUriRequest;
    }

    private final HttpUriRequest createHttpUriRequest(MigrationPluginHttpRequest requestConfig) {
        HttpUriRequest httpUriRequest;
        switch (requestConfig.getMethod()) {
            case "GET": {
                httpUriRequest = (HttpUriRequest)new HttpGet(requestConfig.getUri());
                break;
            }
            case "DELETE": {
                httpUriRequest = this.handleDeleteRequest(requestConfig);
                break;
            }
            case "OPTIONS": {
                httpUriRequest = (HttpUriRequest)new HttpOptions(requestConfig.getUri());
                break;
            }
            case "POST": {
                HttpPost httpPost;
                HttpPost $this$createHttpUriRequest_u24lambda_u2417 = httpPost = new HttpPost(requestConfig.getUri());
                boolean bl = false;
                this.injectBody((HttpEntityEnclosingRequest)$this$createHttpUriRequest_u24lambda_u2417, requestConfig);
                httpUriRequest = (HttpUriRequest)httpPost;
                break;
            }
            case "PUT": {
                HttpPut httpPut;
                HttpPut $this$createHttpUriRequest_u24lambda_u2418 = httpPut = new HttpPut(requestConfig.getUri());
                boolean bl = false;
                this.injectBody((HttpEntityEnclosingRequest)$this$createHttpUriRequest_u24lambda_u2418, requestConfig);
                httpUriRequest = (HttpUriRequest)httpPut;
                break;
            }
            case "PATCH": {
                HttpPatch httpPatch;
                HttpPatch $this$createHttpUriRequest_u24lambda_u2419 = httpPatch = new HttpPatch(requestConfig.getUri());
                boolean bl = false;
                this.injectBody((HttpEntityEnclosingRequest)$this$createHttpUriRequest_u24lambda_u2419, requestConfig);
                httpUriRequest = (HttpUriRequest)httpPatch;
                break;
            }
            default: {
                throw ExceptionsKt.protocolError("HTTP Method " + requestConfig.getMethod() + " is not supported.");
            }
        }
        return httpUriRequest;
    }

    @NotNull
    public abstract byte[] getBodyBytes(@Nullable Object var1);

    /*
     * WARNING - void declaration
     */
    public void injectBody(@NotNull HttpEntityEnclosingRequest request, @NotNull MigrationPluginHttpRequest requestConfig) {
        void $this$injectBody_u24lambda_u2420;
        Object content;
        HttpEntityEnclosingRequest httpEntityEnclosingRequest;
        AbstractHttpEntity abstractHttpEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestConfig, (String)"requestConfig");
        if (requestConfig.getBody() == null) {
            return;
        }
        if (requestConfig.getContentType() == null) {
            throw ExceptionsKt.protocolError("Content type is not specified.");
        }
        HttpEntityEnclosingRequest httpEntityEnclosingRequest2 = request;
        Object object = requestConfig.getBody();
        if (object instanceof AbstractHttpEntity) {
            abstractHttpEntity = (AbstractHttpEntity)requestConfig.getBody();
        } else if (object instanceof File) {
            abstractHttpEntity = (AbstractHttpEntity)new FileEntity((File)requestConfig.getBody());
        } else if (object instanceof InputStream) {
            abstractHttpEntity = (AbstractHttpEntity)new InputStreamEntity((InputStream)requestConfig.getBody());
        } else {
            Object object2;
            httpEntityEnclosingRequest = httpEntityEnclosingRequest2;
            try {
                byte[] byArray;
                httpEntityEnclosingRequest2 = httpEntityEnclosingRequest;
                object2 = requestConfig.getContentType();
                if (Intrinsics.areEqual((Object)object2, (Object)"application/json")) {
                    byArray = this.getBodyBytes(requestConfig.getBody());
                } else if (Intrinsics.areEqual((Object)object2, (Object)"application/octet-stream")) {
                    Object object3 = requestConfig.getBody();
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                    byArray = (byte[])object3;
                } else {
                    throw ExceptionsKt.protocolError("Content type " + requestConfig.getContentType() + " is not supported.");
                }
                object2 = byArray;
            }
            catch (IOException iOException) {
                void e;
                HttpEntityEnclosingRequest httpEntityEnclosingRequest3 = httpEntityEnclosingRequest;
                throw ExceptionsKt.protocolError("Failed to inject body", (Throwable)e);
            }
            catch (ClassCastException e) {
                HttpEntityEnclosingRequest httpEntityEnclosingRequest4 = httpEntityEnclosingRequest;
                throw ExceptionsKt.protocolError("Failed to inject body", e);
            }
            content = object2;
            abstractHttpEntity = (AbstractHttpEntity)new ByteArrayEntity((byte[])content);
        }
        content = object = abstractHttpEntity;
        httpEntityEnclosingRequest = httpEntityEnclosingRequest2;
        boolean bl = false;
        $this$injectBody_u24lambda_u2420.setChunked(false);
        $this$injectBody_u24lambda_u2420.setContentType(requestConfig.getContentType());
        httpEntityEnclosingRequest.setEntity((HttpEntity)object);
    }

    @VisibleForTesting
    public AbstractPluginHttpClient() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J4\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/httpclient/AbstractPluginHttpClient$BodyWithHeaders;", "T", "", "body", "headers", "Lorg/springframework/util/MultiValueMap;", "", "(Ljava/lang/Object;Lorg/springframework/util/MultiValueMap;)V", "getBody", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getHeaders", "()Lorg/springframework/util/MultiValueMap;", "component1", "component2", "copy", "(Ljava/lang/Object;Lorg/springframework/util/MultiValueMap;)Lcom/atlassian/jira/migration/httpclient/AbstractPluginHttpClient$BodyWithHeaders;", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class BodyWithHeaders<T> {
        private final T body;
        @NotNull
        private final MultiValueMap<String, String> headers;

        public BodyWithHeaders(T body, @NotNull MultiValueMap<String, String> headers) {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            this.body = body;
            this.headers = headers;
        }

        public final T getBody() {
            return this.body;
        }

        @NotNull
        public final MultiValueMap<String, String> getHeaders() {
            return this.headers;
        }

        public final T component1() {
            return this.body;
        }

        @NotNull
        public final MultiValueMap<String, String> component2() {
            return this.headers;
        }

        @NotNull
        public final BodyWithHeaders<T> copy(T body, @NotNull MultiValueMap<String, String> headers) {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            return new BodyWithHeaders<T>(body, headers);
        }

        public static /* synthetic */ BodyWithHeaders copy$default(BodyWithHeaders bodyWithHeaders, Object object, MultiValueMap multiValueMap, int n, Object object2) {
            if ((n & 1) != 0) {
                object = bodyWithHeaders.body;
            }
            if ((n & 2) != 0) {
                multiValueMap = bodyWithHeaders.headers;
            }
            return bodyWithHeaders.copy(object, multiValueMap);
        }

        @NotNull
        public String toString() {
            return "BodyWithHeaders(body=" + this.body + ", headers=" + this.headers + ')';
        }

        public int hashCode() {
            int result2 = this.body == null ? 0 : this.body.hashCode();
            result2 = result2 * 31 + this.headers.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BodyWithHeaders)) {
                return false;
            }
            BodyWithHeaders bodyWithHeaders = (BodyWithHeaders)other;
            if (!Intrinsics.areEqual(this.body, bodyWithHeaders.body)) {
                return false;
            }
            return Intrinsics.areEqual(this.headers, bodyWithHeaders.headers);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/httpclient/AbstractPluginHttpClient$Companion;", "", "()V", "ATLASSIAN_DNS_TIME_TO_LIVE", "", "ATL_REQUEST_ID_HEADER_NAME", "", "CLIENT_BUILD_MAX_PER_ROUTE", "", "CLIENT_BUILD_MAX_TOTAL", "CONNECTION_REQUEST_TIMEOUT", "CONNECTION_TIMEOUT", "EXPIRES_HEADER_NAME", "HEADER_MAP_INITIAL_CAPACITY", "HTTP_PATCH", "MULTIPART_UPLOAD_DEBUG_REGEX", "SERVER_HEADER_NAME", "SERVER_TIMING_HEADER_NAME", "SOCKET_TIMEOUT", "X_TRACE_ID_HEADER_NAME", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createHttpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "builder", "Lorg/apache/http/impl/client/HttpClientBuilder;", "httpClientBuilder", "retryStrategy", "Lcom/atlassian/jira/migration/httpclient/BackOffHttpRequestRetryHandler;", "serviceUnavailableBackoffRetryStrategy", "Lcom/atlassian/jira/migration/httpclient/ServiceUnavailableBackoffRetryStrategy;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpClientBuilder httpClientBuilder(@NotNull BackOffHttpRequestRetryHandler retryStrategy, @NotNull ServiceUnavailableBackoffRetryStrategy serviceUnavailableBackoffRetryStrategy) {
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager;
            Intrinsics.checkNotNullParameter((Object)((Object)retryStrategy), (String)"retryStrategy");
            Intrinsics.checkNotNullParameter((Object)serviceUnavailableBackoffRetryStrategy, (String)"serviceUnavailableBackoffRetryStrategy");
            PoolingHttpClientConnectionManager $this$httpClientBuilder_u24lambda_u240 = poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(55L, TimeUnit.SECONDS);
            boolean bl = false;
            $this$httpClientBuilder_u24lambda_u240.setDefaultMaxPerRoute(20);
            $this$httpClientBuilder_u24lambda_u240.setMaxTotal(20);
            PoolingHttpClientConnectionManager connectionManager = poolingHttpClientConnectionManager;
            Long l = Long.getLong("jcma.connect.timeout", 20L);
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getLong(...)");
            int connectTimeout = (int)Duration.ofSeconds(((Number)l).longValue()).toMillis();
            Long l2 = Long.getLong("jcma.socket.timeout", 120L);
            Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"getLong(...)");
            int socketTimeout = (int)Duration.ofSeconds(((Number)l2).longValue()).toMillis();
            Long l3 = Long.getLong("jcma.request.timeout", 20L);
            Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getLong(...)");
            int connectionRequestTimeout = (int)Duration.ofSeconds(((Number)l3).longValue()).toMillis();
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).setConnectionRequestTimeout(connectionRequestTimeout).build();
            log.info("Using Retry Policy: " + ((Object)((Object)retryStrategy)).getClass().getSimpleName());
            log.info("Using ServiceUnavailableRetryStrategy: " + serviceUnavailableBackoffRetryStrategy.getClass().getSimpleName());
            HttpClientBuilder httpClientBuilder = HttpClients.custom().evictIdleConnections(1L, TimeUnit.MINUTES).evictExpiredConnections().setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionManagerShared(true).setDefaultRequestConfig(requestConfig).setConnectionBackoffStrategy((ConnectionBackoffStrategy)TooManyRequestsConnectionBackoffStrategy.INSTANCE).setKeepAliveStrategy((ConnectionKeepAliveStrategy)MigrationPluginConnectionKeepAliveStrategy.INSTANCE).setRetryHandler((HttpRequestRetryHandler)retryStrategy).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)serviceUnavailableBackoffRetryStrategy).useSystemProperties();
            Intrinsics.checkNotNullExpressionValue((Object)httpClientBuilder, (String)"useSystemProperties(...)");
            return httpClientBuilder;
        }

        public static /* synthetic */ HttpClientBuilder httpClientBuilder$default(Companion companion, BackOffHttpRequestRetryHandler backOffHttpRequestRetryHandler, ServiceUnavailableBackoffRetryStrategy serviceUnavailableBackoffRetryStrategy, int n, Object object) {
            if ((n & 1) != 0) {
                backOffHttpRequestRetryHandler = BackOffRequestSentEnabledRetryHandler.INSTANCE;
            }
            if ((n & 2) != 0) {
                serviceUnavailableBackoffRetryStrategy = DefaultServiceUnavailableBackoffRetryStrategy.INSTANCE;
            }
            return companion.httpClientBuilder(backOffHttpRequestRetryHandler, serviceUnavailableBackoffRetryStrategy);
        }

        @NotNull
        public final CloseableHttpClient createHttpClient(@NotNull HttpClientBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            CloseableHttpClient closeableHttpClient = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient, (String)"build(...)");
            return closeableHttpClient;
        }

        public static /* synthetic */ CloseableHttpClient createHttpClient$default(Companion companion, HttpClientBuilder httpClientBuilder, int n, Object object) {
            if ((n & 1) != 0) {
                httpClientBuilder = com.atlassian.jira.migration.httpclient.AbstractPluginHttpClient$Companion.httpClientBuilder$default(companion, null, null, 3, null);
            }
            return companion.createHttpClient(httpClientBuilder);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

